/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OD_CONTENTSTREAM_LISTENERSTATE_H_
#define _OD_CONTENTSTREAM_LISTENERSTATE_H_

// Internal includes
#include "OD_ListenerState.h"
#include "OD_ElementStack.h"

// External includes
#include <gsf/gsf.h>

// Internal classes
class OD_Office_Styles;

// AbiWord classes
class PD_Document;

/**
 * Class to handle the content stream.
 */
class OD_ContentStream_ListenerState : public OD_ListenerState {
    
public:

    OD_ContentStream_ListenerState (PD_Document* pDocument,
                                    GsfInfile* pGsfInfile,
                                    OD_Office_Styles* pStyles,
                                    OD_ElementStack& rElementStack);
                                    
    virtual ~OD_ContentStream_ListenerState();
    
    void startElement (const XML_Char* pName, const XML_Char** ppAtts,
                               OD_ListenerStateAction& rAction);
                               
    void endElement (const XML_Char* pName, OD_ListenerStateAction& rAction);
                             
    void charData (const XML_Char* pBuffer, int length);
    
private:

    PD_Document* m_pAbiDocument;
    GsfInfile* m_pGsfInfile;
    OD_Office_Styles* m_pStyles;
    
    OD_ElementStack m_elementStack;
};

#endif //_OD_CONTENTSTREAM_LISTENERSTATE_H_
