/* Copyright (C) 2007 One Laptop Per Child
 * Author: Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef ABI_DEVELOP_HLMANAGER_H
#define ABI_DEVELOP_HLMANAGER_H

#include <map>

#include "xav_Listener.h"
#include "fv_View.h"
#include "LanguageRepository.h"
#include "Highlighter.h"

using std::map;

class HighlightManager
{
public:
	HighlightManager() { }

	void addHighlighter(FL_DocLayout* pDocLayout, const std::string langName)
	{
		UT_DEBUGMSG(("HighlightManager::addHighlighter()\n"));
		UT_return_if_fail(pDocLayout);
		UT_return_if_fail(langName.size() > 0);

		// check if we don't already have a highlighter for this doclayout
		map<FL_DocLayout*, Highlighter*>::iterator pos = m_highlighters.find(pDocLayout);
		if (pos != m_highlighters.end())
		{
			UT_DEBUGMSG(("We already have a highlighter for this doclayout (0x%x), removing it\n", pDocLayout));
			Highlighter* pOldHighlighter = (*pos).second;
			DELETEP(pOldHighlighter);
		}

		const LanguageDefinition* pDef = m_languageRepository.getLanguageDefinitionByName(langName);
		UT_return_if_fail(pDef);

		Highlighter* pHighlighter = new Highlighter(pDocLayout, pDef);
		UT_return_if_fail(pHighlighter);

		m_highlighters.insert(map<FL_DocLayout*, Highlighter*>::value_type(pDocLayout, pHighlighter));
	}

	const map<string, LanguageDefinition*>&	 getAllLanguages()
		{ return m_languageRepository.getAll(); }

private:
	LanguageRepository						m_languageRepository;
	map<FL_DocLayout*, Highlighter*>		m_highlighters;
};


#endif /* ABI_DEVELOP_HLMANAGER_H */
