#include <stdio.h>
#include "stdlib.h"
#include "string.h"
#include "locale.h"
#include "X11/Xlib.h"
#include "X11/keysym.h"
#include "X11/XF86keysym.h"
#include "X11/extensions/XTest.h"

int main(int argc, char **argv) {
        Display *dpy;
	KeyCode keycode;
	int i;

        if (setlocale (LC_ALL, "") == NULL)
                fprintf (stderr, "Warning: could not set default locale.\n");

        dpy = XOpenDisplay (NULL);
        if (!dpy) {
                fprintf (stderr, "Unable to open display '%s'.\n",
                         XDisplayName (NULL));
                return 1;
        }

        if (!XQueryExtension (dpy, "XTEST", &i, &i, &i)) {
                fprintf (stderr, "Extension XTest unavailable on display "
                         "'%s'.\n", XDisplayName (NULL));

                XCloseDisplay (dpy);
                return 1;
        }

	if (argc!=2) {
		fprintf(stderr,"Usage: %s keycode\n",argv[0]);
		return 1;
	}

	keycode = atoi(argv[1]);

	if (keycode!=0) {
		XTestFakeKeyEvent(dpy, keycode, True, 0);
		XTestFakeKeyEvent(dpy, keycode, False, 0);
	}

        XCloseDisplay (dpy);

        return 0;
}
