/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import junit.framework.TestCase;

/**
 */
public class Printer extends TestCase {

    public Printer(String name) {
        super(name);
        System.err.println("constructor print to System.err");
        System.out.println("constructor print to System.out");
    }

    static {
        System.err.println("static print to System.err");
        System.out.println("static print to System.out");
    }

    public void testNoCrash() {
        System.err.println("method print to System.err");
        System.out.println("method print to System.out");
    }

}
