#ifndef __AAPARSER_TYPES_H__
#define __AAPARSER_TYPES_H__

typedef enum _ParseErrorType
{
	ERROR_INVALID_INCLUDE = 1,
	ERROR_LEXER_ERROR,
	ERROR_PARSER_ERROR,
	ERROR_UNKNOWN
} ParseErrorType;

typedef enum _NodeType
{
	ELEMENT_COMMENT = 1,
	ELEMENT_RULE,
	ELEMENT_FUNCTION,
	ELEMENT_VARIABLE_ASSIGNMENT,
	ELEMENT_OPTION,
	ELEMENT_GROUP,
	ELEMENT_FILE,
	ELEMENT_INCLUDE, 
	ELEMENT_CAPABILITY,
	ELEMENT_CONDITIONAL,
	ELEMENT_CONDITIONAL_ELSE,
	ELEMENT_NETWORK,
	ELEMENT_CHANGE_PROFILE,
	ELEMENT_INVALID
} NodeType;

typedef enum _FunctionType
{
	ELEMENT_FUNCTION_WARN = 1,
	ELEMENT_FUNCTION_ERROR,
	ELEMENT_FUNCTION_UNDEF,
	ELEMENT_FUNCTION_INVALID
} FunctionType;


typedef enum _GroupType {
	ELEMENT_GROUP_AUDIT,
	ELEMENT_GROUP_SUBPROFILE,
	ELEMENT_GROUP_TRANSITION_PROFILE,
	ELEMENT_GROUP_INVALID
} GroupType;


typedef enum _OptionType {
	OPTION_VERSION = 1, // mValue should be a string
	OPTION_ENCODING, // mValue should be a string
	OPTION_DISABLED, // mValue should be a bool
	OPTION_AUDIT, // mValue should be a bool
	OPTION_COMPLAIN, // mValue should be a bool
	OPTION_INVALID
} OptionType;


typedef enum _CondExprType {
	ELEMENT_CONDITIONAL_EXPRESSION_BOOLEAN,
	ELEMENT_CONDITIONAL_EXPRESSION_DEFINED_BOOL,
	ELEMENT_CONDITIONAL_EXPRESSION_DEFINED_LIST,
	ELEMENT_CONDITIONAL_EXPRESSION_EXISTS,
	ELEMENT_CONDITIONAL_EXPRESSION_INVALID
} CondExprType;

typedef enum _CondExprLinkType {
	ELEMENT_CONDITIONAL_EXPRESSION_LINK_AND,
	ELEMENT_CONDITIONAL_EXPRESSION_LINK_OR,
	ELEMENT_CONDITIONAL_EXPRESSION_LINK_INVALID
} CondExprLinkType;

#endif

