#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""Provides unit tests for dpkg journal methods."""
# Copyright (C) 2010 Michael Vogt <mvo@ubuntu.com>
#
# Licensed under the GNU General Public License Version 2
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# Licensed under the GNU General Public License Version 2

__author__  = "Michael Vogt <mvo@glatzor.de>"

import sys
sys.path.insert(0, "../..")

import apt
import apt_pkg
import os
import tempfile
import unittest
from aptdaemon.worker import is_dpkg_journal_clean

class DeferredTestCase(unittest.TestCase):
    """Test suite for dpkg journal"""

    def test_journal(self):
        """ test if is_dpkg_journal_clean work correctly """
        tmpdir = tempfile.mkdtemp()
        os.mkdir(os.path.join(tmpdir,"updates"))
        apt_pkg.Config.Set("Dir::State::status", tmpdir+"/status")
        open(os.path.join(tmpdir,"updates","abc"), "w").write("")
        self.assertEquals(is_dpkg_journal_clean(), True)
        open(os.path.join(tmpdir,"updates","a1b"), "w").write("")
        self.assertEquals(is_dpkg_journal_clean(), True)
        open(os.path.join(tmpdir,"updates","00001"), "w").write("")
        self.assertEquals(is_dpkg_journal_clean(), False)

if __name__ == "__main__":
    unittest.main()

# vim: ts=4 et sts=4
