// vs_menu.h  -*-c++-*-
//
//  A nice menu with selectable entries.  (fairly basic atm)

#ifndef VS_MENU_H
#define VS_MENU_H

#include "vscreen_widget.h"
#include "config/keybindings.h"

#include "slotarg.h"

#include <vector>

// Currently, menu-items aren't full widgets--it's simply too much
// baggage (lots of signals and a Curses window) for something that's
// quite simple and special-purpose.
class vs_menu_item
{
  // The text displayed in the menu entry
  std::string title;

  // A string describing the item's function
  std::string description;

  // The keybinding whose definition (in the GLOBAL bindings list) is
  // displayed to the right of the menu entry.
  std::string binding;

  // The key that directly activates this item *while the menu is open*
  chtype hotkey;
public:
  // Infers the hotkey from the title
  vs_menu_item(const std::string &_title, const std::string &_binding,
	       const std::string &_description);

  std::string get_title() {return title;}
  std::string get_binding() {return binding;}
  std::string get_description() {return description;}
  chtype get_hotkey() {return hotkey;}

  SigC::Signal0<void> selected;
};

#define VS_MENU_NOP NULL

// Info for easy static generation of menus

struct vs_menu_info
{
public:
  // VS_MENU_ITEM: a "real" menu-item
  // VS_MENU_END: the last item in this information block
  enum item_types {VS_MENU_ITEM, VS_MENU_SEPARATOR, VS_MENU_END} item_type;

  const char *item_name, *item_binding, *item_description;

  // How to communicate with the outside world..
  Slot0Arg item_slot;

  vs_menu_info(item_types type, const char *name, const char *binding,
	       const char *description, SigC::Slot0<void> slot);

  vs_menu_info(item_types type, const char *name, const char *binding,
	       const char *description, SigC::Slot0<void> *slot);

  vs_menu_info(item_types type);
};

const vs_menu_info VS_MENU_SEPARATOR(vs_menu_info::VS_MENU_SEPARATOR);
const vs_menu_info VS_MENU_END(vs_menu_info::VS_MENU_END);

class vs_menu:public vscreen_widget
{
  typedef std::vector<vs_menu_item *> itemlist;

  // A set of menu items.  NULL indicates a separator.
  // These items are deleted with the menu.
  itemlist items;

  // Where is the cursor?
  itemlist::size_type cursorloc;

  // connected to "shown"
  void appear();

  // connected to "hidden"
  void disappear();

  // (cache the requested width, since it's O(n) to find it)
  int req_width;

protected:
  virtual bool handle_char(chtype ch);
public:
  // Initialize a blank menu.
  vs_menu();

  // Deletes the items it holds!
  ~vs_menu();

  // Initialize a menu from a block of information.  If there is no
  // VS_MENU_END in the block, RANDOM ERRORS WILL OCCUR!!
  vs_menu(int x, int y, int w, vs_menu_info *inf);

  bool get_cursorvisible();
  point get_cursorloc();
  size size_request();
  void append_item(vs_menu_item *newitem);
  void remove_item(vs_menu_item *item);

  virtual bool focus_me();
  virtual void paint();
  virtual void dispatch_mouse(short id, int x, int y, int z, mmask_t bstate);

  // Emitted when an item is highlighted or when the selection "goes away".
  // In the latter case, the argument is NULL.  (happens only when
  // the menu is hidden -- FIXME?)
  SigC::Signal1<void, vs_menu_item *> item_highlighted;

  // FIXME: there should be a less hacky way..
  SigC::Signal0<void> menus_goaway;

  static keybindings *bindings;
  static void init_bindings();
};

#endif
