// vs_stacked.h        -*-c++-*-
//
//  Manages a set of overlapping widgets, displaying them in a consistent
// order (it is possible to change the stacking order)
//
//  The size of the widget is unrelated to the sizes of its components.

#ifndef VS_STACKED_H
#define VS_STACKED_H

#include "vs_passthrough.h"

class vs_stacked:public vs_passthrough
{
  // bleach, but we need somewhere to store the info on what the signals to
  // disconnect are :(
  struct child_info
  {
    vscreen_widget *w;

    SigC::Connection shown_conn, hidden_conn;

    child_info(vscreen_widget *_w,
	       SigC::Connection &_shown_conn,
	       SigC::Connection &_hidden_conn)
      :w(_w), shown_conn(_shown_conn),
       hidden_conn(_hidden_conn)
    {
    }
  };

  typedef std::list<child_info> childlist;

  childlist children;

  int req_w, req_h;

  void layout_me();

  void hide_widget();
protected:
  void paint();
public:
  // The size passed in is used as a preferred size.  (what we get might be
  // larger or smaller)
  vs_stacked(int w=0, int h=0);

  void add_widget(vscreen_widget *w);
  void rem_widget(vscreen_widget *w);
  void raise_widget(vscreen_widget *w);
  void lower_widget(vscreen_widget *w);

  void dispatch_mouse(short id, int x, int y, int z, mmask_t bstate);

  vscreen_widget *vs_stacked::get_focus();

  void show_all();

  size size_request();
};

#endif
