// cmdline_clean.cc
//
//  Copyright 2004 Daniel Burrows

#include "cmdline_clean.h"

#include <aptitude.h>

#include <generic/apt.h>
#include <generic/config_signal.h>

#include <apt-pkg/acquire.h>
#include <apt-pkg/clean.h>
#include <apt-pkg/error.h>
#include <apt-pkg/strutl.h>

#include <iostream>

#include <sys/stat.h>

using namespace std;

int cmdline_clean(int argc, char *argv[], bool simulate)
{
  _error->DumpErrors();

  OpTextProgress progress;

  apt_init(&progress, false);

  if(_error->PendingError())
    {
      _error->DumpErrors();
      return -1;
    }

  // In case we aren't root.
  if(!simulate)
    apt_cache_file->GainLock();
  else
    apt_cache_file->ReleaseLock();

  if(_error->PendingError())
    {
      _error->DumpErrors();
      return -1;
    }

  if(aptcfg)
    {
      if(simulate)
	printf(_("Del %s* %spartial/*\n"),
	       aptcfg->FindDir("Dir::Cache::archives").c_str(),
	       aptcfg->FindDir("Dir::Cache::archives").c_str());
      else
	{
	  pkgAcquire fetcher;
	  fetcher.Clean(aptcfg->FindDir("Dir::Cache::archives"));
	  fetcher.Clean(aptcfg->FindDir("Dir::Cache::archives")+"partial/");
	}
    }

  int rval=_error->PendingError()?0:-1;

  _error->DumpErrors();

  return rval;
}

// Shamelessly stolen from apt-get:
class LogCleaner : public pkgArchiveCleaner
{
  bool simulate;

protected:
  virtual void Erase(const char *File,string Pkg,string Ver,struct stat &St) 
  {
    cout << "Del " << Pkg << " " << Ver << " [" << SizeToStr(St.st_size) << "B]" << endl;
      
    if (!simulate)
      unlink(File);      
  };
public:
  LogCleaner(bool _simulate):simulate(_simulate) { }
};

int cmdline_autoclean(int argc, char *argv[], bool simulate)
{
  _error->DumpErrors();

  OpTextProgress progress;

  apt_init(&progress, false);

  if(_error->PendingError())
    {
      _error->DumpErrors();
      return -1;
    }

  // In case we aren't root.
  if(!simulate)
    apt_cache_file->GainLock();
  else
    apt_cache_file->ReleaseLock();

  if(_error->PendingError())
    {
      _error->DumpErrors();
      return -1;
    }

  LogCleaner cleaner(simulate);
  int rval=0;
  if(!(cleaner.Go(aptcfg->FindDir("Dir::Cache::archives"), *apt_cache_file) &&
       cleaner.Go(aptcfg->FindDir("Dir::Cache::archives")+"partial/",
		  *apt_cache_file)) ||
     _error->PendingError())
    rval=-1;

  _error->DumpErrors();
  return rval;
}

