// defaults.cc
//
//  Copyright 1999 Daniel Burrows
//
//  Defaults for Aptitude.

#include "vscreen/config/keybindings.h"
#include "vscreen/config/colors.h"

#include "mine/cmine.h"

#include "pkg_tree.h"
#include "pkg_node.h"

#include <apt-pkg/init.h> // For the APT version

void init_keybindings()
{
  global_bindings.set("CycleNext", KEY_F(6));
  global_bindings.set("CyclePrev", KEY_F(7));

  global_bindings.set("QuitProgram", "Q"[0]);

  global_bindings.set("UpdatePackageList", "u"[0]);
  global_bindings.set("MarkUpgradable", "U"[0]);
  global_bindings.set("ForgetNewPackages", "f"[0]);
  global_bindings.set("ChangePkgTreeLimit", "l"[0]);
  global_bindings.set("ChangePkgTreeGrouping", "G"[0]);
  global_bindings.set("ChangePkgTreeSorting", "S"[0]);

  global_bindings.set("Install", '+');
  global_bindings.set("Remove", '-');
  global_bindings.set("Hold", '=');
  global_bindings.set("Purge", '_');
  global_bindings.set("Keep", ':');
  global_bindings.set("SetAuto", 'M');
  global_bindings.set("ClearAuto", 'm');
  global_bindings.set("ForbidUpgrade", 'F');
  global_bindings.set("Reinstall", 'L');

  global_bindings.set("Dependencies", "d"[0]);
  global_bindings.set("ReverseDependencies", "r"[0]);
  global_bindings.set("InfoScreen", KEY_ENTER);
  global_bindings.set("Versions", "v"[0]);
  global_bindings.set("Changelog", "C"[0]);

  global_bindings.set("DoInstallRun", "g"[0]);
  global_bindings.set("InstallSingle", "I"[0]);
  global_bindings.set("ChangePkgDisplayFormat", "p"[0]);
  global_bindings.set("ChangePkgStatusFormat", "s"[0]);

  global_bindings.set("ToggleColumnHeaders", "h"[0]);

  global_bindings.set("ShowHideDescription", "D"[0]);

  global_bindings.set("DescriptionUp", "a"[0]);
  global_bindings.set("DescriptionDown", "z"[0]);
  global_bindings.set("DescriptionCycle", "i"[0]);

  global_bindings.set("DpkgReconfigure", "R"[0]);
  global_bindings.set("BugReport", "B"[0]);

  // Hierarchy editor
  global_bindings.set("Commit", "N"[0]);
  global_bindings.set("SaveHier", "S"[0]);
  global_bindings.set("EditHier", "E"[0]);

  global_bindings.set("SearchBroken", "b"[0]);

  pkg_tree::init_bindings();
  pkg_tree_node::init_bindings();
  cmine::init_bindings();
}

void init_colors()
{
  set_color("PkgToHold", COLOR_BLACK, COLOR_WHITE, 0);
  set_color("PkgToRemove", COLOR_BLACK, COLOR_MAGENTA, 0);
  set_color("PkgBroken", COLOR_BLACK, COLOR_RED, 0);
  set_color("PkgToInstall", COLOR_BLACK, COLOR_GREEN, 0);
  set_color("PkgToUpgrade", COLOR_BLACK, COLOR_CYAN, 0);

  set_color("DepBroken", COLOR_BLACK, COLOR_RED, 0);

  set_color("MediaChange", COLOR_YELLOW, COLOR_RED, A_BOLD);
  set_color("Progress", COLOR_BLUE, COLOR_YELLOW, 0);
  set_color("DownloadProgress", COLOR_BLUE, COLOR_YELLOW, 0);
  set_color("DownloadHit", COLOR_BLACK, COLOR_GREEN, 0);

  set_color("Bullet", COLOR_YELLOW, COLOR_BLACK, A_BOLD);
#if APT_PKG_MAJOR >= 3 && APT_PKG_MINOR >= 5
  set_color("TrustWarning", COLOR_RED, COLOR_BLACK, A_BOLD);
#endif
}

void init_defaults()
{
  init_keybindings();
  init_colors();
}
