// vs_label.h          -*-c++-*-
//
//  A very simple text display, sans wordwrap, scrolling, etc.

#ifndef VS_LABEL_H
#define VS_LABEL_H

#include "vscreen_widget.h"

class vs_label:public vscreen_widget
{
  std::string txt;
  int attr;

public:
  vs_label(std::string _txt, int attr);
  vs_label(std::string _txt);

  bool get_cursorvisible();
  point get_cursorloc();

  size size_request();
  void paint();
  void set_text(std::string _txt);
};

class vs_transientlabel:public vs_label
// Displays a transient message -- grabs the input focus and vanishes when a
// key is pressed.
{
protected:
  virtual bool handle_char(chtype ch);
public:
  vs_transientlabel(std::string _msg, int _attr)
    :vs_label(_msg, _attr)
  {
  }

  bool focus_me() {return true;}
};

#endif
