# Copyright (c) 2007-2008 Canonical
#
# AUTHOR:
# Michael Vogt <mvo@ubuntu.com>
# With contributions by Siegfried-A. Gevatter <rainct@ubuntu.com>
#
# This file is part of AptUrl
#
# AptUrl is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published
# by the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
#
# AptUrl is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GDebi; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

class InvalidUrlException(Exception):
    pass

class AptUrl(object):
    " a class that contains the parsed data from an apt url "
    def __init__(self):
        self.package = None
        self.schema = None
        self.keyfile = None
        self.minver = None
        self.repo_url = None
        self.refresh = None
        self.dist = '/'
        self.section = []

def is_format_package_name(string):
    " return True if string would be an acceptable name for a Debian package "
    
    return string.replace("+", "").replace("-", "").replace(".", "").isalnum() \
        and string.islower() and string[0].isalnum() and len(string) > 1

def parse(full_url):
    " parse an apt url and return a list of AptUrl objects "
    # apt:pkg1?k11=v11?k12=v12,pkg2?k21=v21?k22=v22,...
    res = []

    for url in full_url.split(";"):
        if not ":" in url:
            raise InvalidUrlException

        # now parse it

        (schema, packages) = url.split(":", 1)
        packages = packages.split(",")

        for package in packages:
            apt_url = AptUrl()
            apt_url.schema = schema
            # check for schemas of the form: apt+http://
            if schema.startswith("apt+"):
                apt_url.repo_url = schema[len("apt+"):] + ":" + package.split("?",1)[0]
            else:
                if "?" in package:
                    apt_url.package = package.split("?")[0].lstrip("/")
                else:
                    apt_url.package = package.lstrip("/")

            # now parse the ?... bits
            if "?" in package:
                key_value_pairs = package.split("?")[1:]
                for s in key_value_pairs:
                    (key, value) = s.split("=")
                    try:
                        if ' ' in value:
                            raise InvalidUrlException
                        if type(getattr(apt_url, key)) == type([]):
                            getattr(apt_url, key).append(value)
                        else:
                            setattr(apt_url, key, value)
                    except Exception, e:
                        raise InvalidUrlException
            
            # check if the package name is valid
            if not is_format_package_name(apt_url.package):
                pass
            
            res.append(apt_url)
    return res    
