#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test annotation ui
# Copyright  2005 Canonical Ltd
# Original Authors Robert Collins
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "annotate"

begin_test "import revision, no content, no changes -> no output"
mkdir foo
tla import --automatic -d foo jane@example.com--2003/annotate-data--0
cd foo
# cant check fd 2 with current framework
tla annotate > ,,foo-annotate
file_is_empty ,,foo-annotate || test_fail "annotate produced output on a fresh checkout of an empty tree"
end_test

begin_test "patch-1 revision, no content, no changes -> no output"
tla get jane@example.com--2003/annotate-data--0 foo
cd foo
tla commit -s 'empty'
# cant check fd 2 with current framework
tla annotate > ,,foo-annotate
file_is_empty ,,foo-annotate || test_fail "annotate produced output on an empty tree"
end_test

begin_test "import revision, content, no changes -> output"
mkdir foo
echo "lucy loves you" > foo/bar.c
echo "mary doesn't" > foo/quux.c
tla import --automatic -d foo jane@example.com--2003/annotate-data--1
cd foo
# cant check fd 2 with current framework
tla annotate > ,,foo-annotate
file_is_empty ,,foo-annotate && test_fail "annotate produced no output on a fresh checkout of a non empty tree"
file_matches 'ANNOTATIONS FOR \./bar\.c' ,,foo-annotate || test_fail "bar was not mentioned"
file_matches 'jane@example.com--2003/annotate-data--1--base-0: lucy loves you' ,,foo-annotate || test_fail "bar base-0 not present"
file_matches 'ANNOTATIONS FOR \./quux\.c' ,,foo-annotate || test_fail "quux was not mentioned"
file_matches 'jane@example.com--2003/annotate-data--1--base-0: mary doesn'\''t' ,,foo-annotate || test_fail "quux base-0 not present"
end_test

begin_test "patch-1 revision, content, no changes -> output"
tla get jane@example.com--2003/annotate-data--1 foo
echo "lucy loves you" >> foo/bar.c
cd foo
tla commit -s 'add new revision'
# cant check fd 2 with current framework
tla annotate > ,,foo-annotate
file_is_empty ,,foo-annotate && test_fail "annotate produced no output!"
file_matches 'ANNOTATIONS FOR \./bar\.c' ,,foo-annotate || test_fail "bar was not mentioned"
file_matches 'jane@example.com--2003/annotate-data--1--base-0: lucy loves you' ,,foo-annotate || test_fail "bar base-0 not present"
file_matches 'jane@example.com--2003/annotate-data--1--patch-1: lucy loves you' ,,foo-annotate || test_fail "bar patch-1 not present"
file_matches 'ANNOTATIONS FOR \./quux\.c' ,,foo-annotate || test_fail "quux was not mentioned"
file_matches 'jane@example.com--2003/annotate-data--1--base-0: mary doesn'\''t' ,,foo-annotate || test_fail "quux base-0 not present"
file_matches 'jane@example.com--2003/annotate-data--1--patch-1: mary doesn'\''t' ,,foo-annotate && test_fail "quux patch-1 present"
end_test

begin_test "adds after import"
tla get jane@example.com--2003/annotate-data--1 foo
echo "unwyrm wants you" >> foo/baffled.c
cd foo
tla add baffled.c
tla commit -s 'add baffled'
# cant check fd 2 with current framework
tla annotate > ,,foo-annotate
file_is_empty ,,foo-annotate && test_fail "annotate produced no output!"
file_matches 'ANNOTATIONS FOR \./bar\.c' ,,foo-annotate || test_fail "bar was not mentioned"
file_matches 'jane@example.com--2003/annotate-data--1--base-0: lucy loves you' ,,foo-annotate || test_fail "bar base-0 not present"
file_matches 'jane@example.com--2003/annotate-data--1--patch-1: lucy loves you' ,,foo-annotate || test_fail "bar patch-1 not present"
file_matches 'ANNOTATIONS FOR \./quux\.c' ,,foo-annotate || test_fail "quux was not mentioned"
file_matches 'jane@example.com--2003/annotate-data--1--base-0: mary doesn'\''t' ,,foo-annotate || test_fail "quux base-0 not present"
file_matches 'jane@example.com--2003/annotate-data--1--patch-1: mary doesn'\''t' ,,foo-annotate && test_fail "quux patch-1 present"
file_matches 'ANNOTATIONS FOR \./baffled\.c' ,,foo-annotate || test_fail "baffled was not mentioned"
file_matches 'jane@example.com--2003/annotate-data--1--patch-2: unwyrm wants you' ,,foo-annotate || test_fail "baffled patch-2 not present"
end_test

begin_test "adds after import (single file relative annotate)"
tla get jane@example.com--2003/annotate-data--1 foo
cd foo
# cant check fd 2 with current framework
tla annotate bar.c > ,,foo-annotate
file_is_empty ,,foo-annotate && test_fail "annotate produced no output!"
file_matches 'ANNOTATIONS FOR \./bar\.c' ,,foo-annotate || test_fail "bar was not mentioned"
file_matches 'jane@example.com--2003/annotate-data--1--base-0: lucy loves you' ,,foo-annotate || test_fail "bar base-0 not present"
file_matches 'jane@example.com--2003/annotate-data--1--patch-1: lucy loves you' ,,foo-annotate || test_fail "bar patch-1 not present"
end_test

#todo deliberately annotate tagging method should work
#anootate on a symlink should be the last target change
#annotate with a untagged file in a unstagged source tree should do annotate
#annotate iwth a untaged file in a untagged precious shouldn't do annotate
#files with N lines, N-1 newlines.
#files deleted before this rev
#files locally added
#files locally deleted.
#tree with symlink to dir
# files added then removed then the same id readded
# subtrees, specific files

clean_workdir
