#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test version sorting
# Copyright © 2004 Canonical Ltd.
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

make_archive () {
  tla make-archive foo@example.org--2003 $(pwd)/foo-archive
}

version_setup () {
  version=$1
  mkdir ",,$version"
  tla import --automatic -d ",,$version" "foo@example.org--2003/hello-world--mainline--$version"
}

gets_version () {
  version=$1
  tla get "foo@example.org--2003/hello-world--mainline--$version" ",,output" || test_fail "failed to retrieve foo@example.org--2003/hello-world--mainline--$version"
  test $(tla tree-version -d ",,output") = "foo@example.org--2003/hello-world--mainline--$version"
}

clean_archive () {
  rm -rf foo-archive
  tla register-archive -d foo@example.org--2003
}

initial_setup

test_class "version-order"

begin_test "basic numerical order"
make_archive
version_setup 0
version_setup 1
version_setup 2
gets_version 2
clean_archive
end_test

begin_test "dotted single-digit decimals"
make_archive
version_setup 0.1
version_setup 0.2
version_setup 0.3
gets_version 0.3
clean_archive
end_test

begin_test "dotted multi-digit decimals higher than single"
make_archive
version_setup 0.1
version_setup 0.10
version_setup 0.2
gets_version 0.10
clean_archive
end_test

begin_test "letters sort after empty"
make_archive
version_setup 0.1
version_setup 0.1a
gets_version 0.1a
clean_archive
end_test

begin_test "basic alphabetical order"
make_archive
version_setup 0.1a
version_setup 0.1b
gets_version 0.1b
clean_archive
end_test

begin_test "high decimal beats low with a latter"
make_archive
version_setup 0.1
version_setup 0.1a
version_setup 0.10
gets_version 0.10
clean_archive
end_test

begin_test "punctuation sorts after numeric"
make_archive
version_setup 0.1
version_setup 0.1+
gets_version 0.1+
clean_archive
end_test

begin_test "punctuation sorts after letters"
make_archive
version_setup 0.1a
version_setup 0.1+
gets_version 0.1+
clean_archive
end_test

begin_test "punctuation doesn't increase precedence"
make_archive
version_setup 0.1
version_setup 0.1+
version_setup 0.2
gets_version 0.2
clean_archive
end_test

begin_test "plus beats dot"
make_archive
version_setup 0.1.a
version_setup 0.1+a
gets_version 0.1+a
clean_archive
end_test

begin_test "dash beats plus"
make_archive
version_setup 0.1+a
version_setup 0.1-a
gets_version 0.1-a
clean_archive
end_test

begin_test "colon beats dash in basic version"
make_archive
version_setup 0:0.1-a
version_setup 0:0.1:a
gets_version 0:0.1:a
clean_archive
end_test

begin_test "pre-versions (tilde) sort less than nothing"
make_archive
version_setup 0.1
version_setup 0.1~pre1
gets_version 0.1
clean_archive
end_test

begin_test "higher epoch (number before colon) starts sort afresh"
make_archive
version_setup 2:0.1
version_setup 3.0
gets_version 2:0.1
clean_archive
end_test

begin_test "zero epoch and empty epoch have same sort order"
make_archive
version_setup 0:0.1
version_setup 0.2
gets_version 0.2
clean_archive
end_test


clean_workdir

# tag: Scott James Remnant Wed, 20 Oct 2004 19:41:49 +0100 (test-version-order.sh)
#
