/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2007  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

struct hci_command_hdr {
	guint16 opcode;
	guint8  plen;
} __attribute__ ((packed));
#define HCI_COMMAND_HDR_SIZE 3

struct hci_event_hdr {
	guint8  evt;
	guint8  plen;
} __attribute__ ((packed));
#define HCI_EVENT_HDR_SIZE 2

struct hci_acldata_hdr {
	guint16 handle;
	guint16 dlen;
} __attribute__ ((packed));
#define HCI_ACLDATA_HDR_SIZE 4

struct hci_command_complete_evt {
	guint8  num_cmds;
	guint16 opcode;
	guint8  params[0];
} __attribute__ ((packed));

struct hci_command_status_evt {
	guint8  status;
	guint8  num_cmds;
	guint16 opcode;
} __attribute__ ((packed));

gchar *decode_hci(guint type, gpointer data, guint size);
