/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2008  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __BLUETOOTH_DEVICE_STORE_H
#define __BLUETOOTH_DEVICE_STORE_H

#include <glib-object.h>

G_BEGIN_DECLS

#define BLUETOOTH_TYPE_DEVICE_STORE (bluetooth_device_store_get_type())
#define BLUETOOTH_DEVICE_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), \
			BLUETOOTH_TYPE_DEVICE_STORE, BluetoothDeviceStore))
#define BLUETOOTH_DEVICE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), \
			BLUETOOTH_TYPE_DEVICE_STORE, BluetoothDeviceStoreClass))
#define BLUETOOTH_IS_DEVICE_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
						BLUETOOTH_TYPE_DEVICE_STORE))
#define BLUETOOTH_IS_DEVICE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), \
						BLUETOOTH_TYPE_DEVICE_STORE))
#define BLUETOOTH_GET_DEVICE_STORE_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), \
			BLUETOOTH_TYPE_DEVICE_STORE, BluetoothDeviceStoreClass))

typedef struct _BluetoothDeviceStore BluetoothDeviceStore;
typedef struct _BluetoothDeviceStoreClass BluetoothDeviceStoreClass;

struct _BluetoothDeviceStore {
	GObject parent;
};

struct _BluetoothDeviceStoreClass {
	GObjectClass parent_class;
};

GType bluetooth_device_store_get_type(void);

BluetoothDeviceStore *bluetooth_device_store_new(void);

void bluetooth_device_store_add_device(BluetoothDeviceStore *self,
			const gchar *address, guint32 class, gint16 rssi);

void bluetooth_device_store_add_name(BluetoothDeviceStore *self,
				const gchar *address, const gchar *name);

void bluetooth_device_store_del_device(BluetoothDeviceStore *self,
						const gchar *address);

void bluetooth_device_store_invalidate_devices(BluetoothDeviceStore *self);

gint bluetooth_device_store_rssi_compare_func(GtkTreeModel *model,
			GtkTreeIter *a, GtkTreeIter *b, gpointer user_data);

G_END_DECLS

#endif /* __BLUETOOTH_DEVICE_STORE_H */
