/* Generated by re2c 0.9.9 on Sat Aug 27 21:57:59 2005 */
#line 1 "idl.re"
/*=============================================================================
    Boost.Wave: A Standard compliant C++ preprocessor library

    Sample: IDL lexer 

    http://www.boost.org/

    Copyright (c) 2001-2005 Hartmut Kaiser. Distributed under the Boost
    Software License, Version 1.0. (See accompanying file
    LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
=============================================================================*/

#include <ctime>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <boost/config.hpp>

#if defined(BOOST_HAS_UNISTD_H)
#include <unistd.h>
#else
#include <io.h>
#endif 

#include <boost/assert.hpp>
#include <boost/detail/workaround.hpp>

// reuse the token ids and re2c helper functions from the default C++ lexer
#include <boost/wave/token_ids.hpp>
#include <boost/wave/cpplexer/re2clex/aq.hpp>
#include <boost/wave/cpplexer/re2clex/scanner.hpp>

#include "idl_re.hpp"

#if defined(_MSC_VER) && !defined(__COMO__)
#pragma warning (disable: 4101)     // 'foo' : unreferenced local variable
#pragma warning (disable: 4102)     // 'foo' : unreferenced label
#endif

#define BSIZE     196608

#define YYCTYPE   uchar
#define YYCURSOR  cursor
#define YYLIMIT   s->lim
#define YYMARKER  s->ptr
#define YYFILL(n) {cursor = fill(s, cursor);}

//#define RET(i)    {s->cur = cursor; return (i);}
#define RET(i)    \
    { \
        s->line += count_backslash_newlines(s, cursor); \
        s->cur = cursor; \
        return (i); \
    } \
    /**/

///////////////////////////////////////////////////////////////////////////////
namespace boost {
namespace wave {
namespace idllexer {
namespace re2clex {

#define RE2C_ASSERT BOOST_ASSERT

int 
get_one_char(boost::wave::cpplexer::re2clex::Scanner *s)
{
    using namespace boost::wave::cpplexer::re2clex;
    if (s->fd != -1) {
    uchar val;
    
        if (read(s->fd, &val, sizeof(val)))
            return val;
    }
    else if (0 != s->act) {
        RE2C_ASSERT(s->first != 0 && s->last != 0);
        RE2C_ASSERT(s->first <= s->act && s->act <= s->last);
        if (s->act < s->last) 
            return *(s->act)++;
    }
    return -1;
}

std::ptrdiff_t 
rewind_stream (boost::wave::cpplexer::re2clex::Scanner *s, int cnt)
{
    if (s->fd != -1) {
        return lseek(s->fd, cnt, SEEK_CUR);
    }
    else if (0 != s->act) {
        RE2C_ASSERT(s->first != 0 && s->last != 0);
        s->act += cnt;
        RE2C_ASSERT(s->first <= s->act && s->act <= s->last);
        return s->act - s->first;
    }
    return 0;
}

std::size_t 
get_first_eol_offset(boost::wave::cpplexer::re2clex::Scanner* s)
{
    if (!AQ_EMPTY(s->eol_offsets))
    {
        return s->eol_offsets->queue[s->eol_offsets->head];
    }
    else
    {
        return (unsigned int)-1;
    }
}

void 
adjust_eol_offsets(boost::wave::cpplexer::re2clex::Scanner* s, 
    std::size_t adjustment)
{
    boost::wave::cpplexer::re2clex::aq_queue q;
    std::size_t i;
    
    if (!s->eol_offsets)
        s->eol_offsets = boost::wave::cpplexer::re2clex::aq_create();

    q = s->eol_offsets;

    if (AQ_EMPTY(q))
        return;

    i = q->head;
    while (i != q->tail)
    {
        if (adjustment > q->queue[i])
            q->queue[i] = 0;
        else
            q->queue[i] -= adjustment;
        ++i;
        if (i == q->max_size)
            i = 0;
    }
    if (adjustment > q->queue[i])
        q->queue[i] = 0;
    else
        q->queue[i] -= adjustment;
}

int 
count_backslash_newlines(boost::wave::cpplexer::re2clex::Scanner *s, 
    boost::wave::cpplexer::re2clex::uchar *cursor)
{
    using namespace boost::wave::cpplexer::re2clex;

    std::size_t diff, offset;
    int skipped = 0;
    
    /* figure out how many backslash-newlines skipped over unknowingly. */
    diff = cursor - s->bot;
    offset = get_first_eol_offset(s);
    while (offset <= diff && offset != (unsigned int)-1)
    {
        skipped++;
        boost::wave::cpplexer::re2clex::aq_pop(s->eol_offsets);
        offset = get_first_eol_offset(s);
    }
    return skipped;
}

bool is_backslash(
  boost::wave::cpplexer::re2clex::uchar *p, 
  boost::wave::cpplexer::re2clex::uchar *end, int &len)
{
    if (*p == '\\') {
        len = 1;
        return true;
    }
    else if (*p == '?' && *(p+1) == '?' && (p+2 < end && *(p+2) == '/')) {
        len = 3;
        return true;
    }
    return false;
}

boost::wave::cpplexer::re2clex::uchar *
fill(boost::wave::cpplexer::re2clex::Scanner *s, 
    boost::wave::cpplexer::re2clex::uchar *cursor)
{
    using namespace std;    // some systems have memcpy etc. in namespace std
    using namespace boost::wave::cpplexer::re2clex;

    if(!s->eof)
    {
        uchar* p;
        std::ptrdiff_t cnt = s->tok - s->bot;
        if(cnt)
        {
            memcpy(s->bot, s->tok, s->lim - s->tok);
            s->tok = s->bot;
            s->ptr -= cnt;
            cursor -= cnt;
            s->lim -= cnt;
            adjust_eol_offsets(s, cnt);
        }

        if((s->top - s->lim) < BSIZE)
        {
            uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
            if (buf == 0)
            {
                using namespace std;      // some systems have printf in std
                if (0 != s->error_proc)
                    (*s->error_proc)(s, "Out of memory!");
                else 
                    printf("Out of memory!\n");
                    
                /* get the scanner to stop */
                *cursor = 0;
                return cursor;
            }

            memcpy(buf, s->tok, s->lim - s->tok);
            s->tok = buf;
            s->ptr = &buf[s->ptr - s->bot];
            cursor = &buf[cursor - s->bot];
            s->lim = &buf[s->lim - s->bot];
            s->top = &s->lim[BSIZE];
            free(s->bot);
            s->bot = buf;
        }

        if (s->fd != -1) {
            if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE)
            {
                s->eof = &s->lim[cnt]; *(s->eof)++ = '\0';
            }
        }
        else if (s->act != 0) {
            cnt = s->last - s->act;
            if (cnt > BSIZE)
                cnt = BSIZE;
            memcpy(s->lim, s->act, cnt);
            s->act += cnt;
            if (cnt != BSIZE) 
            {
                s->eof = &s->lim[cnt]; *(s->eof)++ = '\0';
            }
        }
        
        /* backslash-newline erasing time */

        /* first scan for backslash-newline and erase them */
        for (p = s->lim; p < s->lim + cnt - 2; ++p)
        {
            int len = 0;
            if (is_backslash(p, s->lim + cnt, len))
            {
                if (*(p+len) == '\n')
                {
                    int offset = len + 1;
                    memmove(p, p + offset, s->lim + cnt - p - offset);
                    cnt -= offset;
                    --p;
                    aq_enqueue(s->eol_offsets, p - s->bot + 1);    
                }
                else if (*(p+len) == '\r')
                {
                    if (*(p+len+1) == '\n')
                    {
                        int offset = len + 2;
                        memmove(p, p + offset, s->lim + cnt - p - offset);
                        cnt -= offset;
                        --p;
                    }
                    else
                    {
                        int offset = len + 1;
                        memmove(p, p + offset, s->lim + cnt - p - offset);
                        cnt -= offset;
                        --p;
                    }
                    aq_enqueue(s->eol_offsets, p - s->bot + 1);    
                }
            }
        }

        /* FIXME: the following code should be fixed to recognize correctly the 
                  trigraph backslash token */

        /* check to see if what we just read ends in a backslash */
        if (cnt >= 2)
        {
            uchar last = s->lim[cnt-1];
            uchar last2 = s->lim[cnt-2];
            /* check \ EOB */
            if (last == '\\')
            {
                int next = get_one_char(s);
                /* check for \ \n or \ \r or \ \r \n straddling the border */
                if (next == '\n')
                {
                    --cnt; /* chop the final \, we've already read the \n. */
                    boost::wave::cpplexer::re2clex::aq_enqueue(s->eol_offsets, 
                        cnt + (s->lim - s->bot));    
                }
                else if (next == '\r')
                {
                    int next2 = get_one_char(s);
                    if (next2 == '\n')
                    {
                        --cnt; /* skip the backslash */
                    }
                    else
                    {
                        /* rewind one, and skip one char */
                        rewind_stream(s, -1);
                        --cnt;
                    }
                    boost::wave::cpplexer::re2clex::aq_enqueue(s->eol_offsets, 
                        cnt + (s->lim - s->bot));    
                }
                else if (next != -1) /* -1 means end of file */
                {
                    /* next was something else, so rewind the stream */
                    lseek(s->fd, -1, SEEK_CUR);
                }
            }
            /* check \ \r EOB */
            else if (last == '\r' && last2 == '\\')
            {
                int next = get_one_char(s);
                if (next == '\n')
                {
                    cnt -= 2; /* skip the \ \r */
                }
                else
                {
                    /* rewind one, and skip two chars */
                    rewind_stream(s, -1);
                    cnt -= 2;
                }
                boost::wave::cpplexer::re2clex::aq_enqueue(s->eol_offsets, 
                    cnt + (s->lim - s->bot));    
            }
            /* check \ \n EOB */
            else if (last == '\n' && last2 == '\\')
            {
                cnt -= 2;
                boost::wave::cpplexer::re2clex::aq_enqueue(s->eol_offsets, 
                    cnt + (s->lim - s->bot));    
            }
        }
        
        s->lim += cnt;
        if (s->eof) /* eof needs adjusting if we erased backslash-newlines */
        {
            s->eof = s->lim;
            *(s->eof)++ = '\0';
        }
    }
    return cursor;
}

boost::wave::token_id  
scan(boost::wave::cpplexer::re2clex::Scanner *s)
{
    using namespace boost::wave::cpplexer::re2clex;

    uchar *cursor = s->tok = s->cur;

#line 387 "idl.re"



#line 377 "idl_re.cpp"
{
  YYCTYPE yych;
  unsigned int yyaccept;
  goto yy0;
  ++YYCURSOR;
yy0:
  if((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
  yych = *YYCURSOR;
  switch(yych){
  case 0x00:  goto yy70;
  case 0x01:
  case 0x02:
  case 0x03:
  case 0x04:
  case 0x05:
  case 0x06:
  case 0x07:
  case 0x08:  case 0x0E:
  case 0x0F:
  case 0x10:
  case 0x11:
  case 0x12:
  case 0x13:
  case 0x14:
  case 0x15:
  case 0x16:
  case 0x17:
  case 0x18:
  case 0x19:
  case 0x1A:
  case 0x1B:
  case 0x1C:
  case 0x1D:
  case 0x1E:
  case 0x1F:  goto yy2;
  case 0x09:  case 0x0B:
  case 0x0C:  case ' ': goto yy65;
  case 0x0A:  goto yy67;
  case 0x0D:  goto yy69;
  case '!': goto yy46;
  case '"': goto yy64;
  case '#': goto yy16;
  case '%': goto yy36;
  case '&': goto yy40;
  case '\'':  goto yy63;
  case '(': goto yy18;
  case ')': goto yy20;
  case '*': goto yy34;
  case '+': goto yy30;
  case ',': goto yy54;
  case '-': goto yy32;
  case '.': goto yy28;
  case '/': goto yy3;
  case '0': goto yy60;
  case '1':
  case '2':
  case '3':
  case '4':
  case '5':
  case '6':
  case '7':
  case '8':
  case '9': goto yy62;
  case ':': goto yy24;
  case ';': goto yy22;
  case '<': goto yy50;
  case '=': goto yy48;
  case '>': goto yy52;
  case '?': goto yy26;
  case 'A':
  case 'B':
  case 'C':
  case 'D':
  case 'E': case 'G':
  case 'H':
  case 'I':
  case 'J':
  case 'K': case 'M':
  case 'N':
  case 'O':
  case 'P':
  case 'Q':
  case 'R':
  case 'S': case 'U':
  case 'V':
  case 'W':
  case 'X':
  case 'Y':
  case 'Z': case '_': case 'a':
  case 'b':
  case 'c':
  case 'd':
  case 'e':
  case 'f':
  case 'g':
  case 'h':
  case 'i':
  case 'j':
  case 'k':
  case 'l':
  case 'm':
  case 'n':
  case 'o':
  case 'p':
  case 'q':
  case 'r':
  case 's':
  case 't':
  case 'u':
  case 'v':
  case 'w':
  case 'x':
  case 'y':
  case 'z': goto yy56;
  case 'F': goto yy7;
  case 'L': goto yy57;
  case 'T': goto yy5;
  case '[': goto yy12;
  case '\\':  goto yy58;
  case ']': goto yy14;
  case '^': goto yy38;
  case '{': goto yy8;
  case '|': goto yy42;
  case '}': goto yy10;
  case '~': goto yy44;
  default:  goto yy72;
  }
yy2:  YYCURSOR = YYMARKER;
  switch(yyaccept){
  case 12:  goto yy353;
  case 11:  goto yy349;
  case 1: goto yy17;
  case 2: goto yy27;
  case 3: goto yy37;
  case 0: goto yy6;
  case 5: goto yy61;
  case 8: goto yy170;
  case 7: goto yy131;
  case 6: goto yy81;
  case 10:  goto yy302;
  case 9: goto yy294;
  case 4: goto yy59;
  }
yy3:  ++YYCURSOR;
  if((yych = *YYCURSOR) == '*') goto yy356;
  if(yych == '/') goto yy354;
  goto yy4;
yy4:
#line 411 "idl.re"
{ RET(T_DIVIDE); }
#line 528 "idl_re.cpp"
yy5:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'R') goto yy350;
  goto yy202;
yy6:
#line 434 "idl.re"
{ RET(T_IDENTIFIER); }
#line 536 "idl_re.cpp"
yy7:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'A') goto yy345;
  goto yy202;
yy8:  ++YYCURSOR;
  goto yy9;
yy9:
#line 396 "idl.re"
{ RET(T_LEFTBRACE); }
#line 546 "idl_re.cpp"
yy10: ++YYCURSOR;
  goto yy11;
yy11:
#line 397 "idl.re"
{ RET(T_RIGHTBRACE); }
#line 552 "idl_re.cpp"
yy12: ++YYCURSOR;
  goto yy13;
yy13:
#line 398 "idl.re"
{ RET(T_LEFTBRACKET); }
#line 558 "idl_re.cpp"
yy14: ++YYCURSOR;
  goto yy15;
yy15:
#line 399 "idl.re"
{ RET(T_RIGHTBRACKET); }
#line 564 "idl_re.cpp"
yy16: yyaccept = 1;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'e'){
    if(yych <= '"'){
      if(yych <= 0x09){
        if(yych >= 0x09)  goto yy239;
        goto yy17;
      } else {
        if(yych == ' ') goto yy239;
        goto yy17;
      }
    } else {
      if(yych <= '.'){
        if(yych <= '#') goto yy343;
        goto yy17;
      } else {
        if(yych <= '/') goto yy239;
        if(yych >= 'd') goto yy239;
        goto yy17;
      }
    }
  } else {
    if(yych <= 'o'){
      if(yych <= 'i'){
        if(yych >= 'i') goto yy239;
        goto yy17;
      } else {
        if(yych == 'l') goto yy239;
        goto yy17;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 'p') goto yy239;
        if(yych >= 'u') goto yy239;
        goto yy17;
      } else {
        if(yych == 'w') goto yy239;
        goto yy17;
      }
    }
  }
yy17:
#line 400 "idl.re"
{ RET(T_POUND); }
#line 609 "idl_re.cpp"
yy18: ++YYCURSOR;
  goto yy19;
yy19:
#line 402 "idl.re"
{ RET(T_LEFTPAREN); }
#line 615 "idl_re.cpp"
yy20: ++YYCURSOR;
  goto yy21;
yy21:
#line 403 "idl.re"
{ RET(T_RIGHTPAREN); }
#line 621 "idl_re.cpp"
yy22: ++YYCURSOR;
  goto yy23;
yy23:
#line 404 "idl.re"
{ RET(T_SEMICOLON); }
#line 627 "idl_re.cpp"
yy24: ++YYCURSOR;
  goto yy25;
yy25:
#line 405 "idl.re"
{ RET(T_COLON); }
#line 633 "idl_re.cpp"
yy26: yyaccept = 2;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == '?') goto yy341;
  goto yy27;
yy27:
#line 406 "idl.re"
{ RET(T_QUESTION_MARK); }
#line 641 "idl_re.cpp"
yy28: ++YYCURSOR;
  if((yych = *YYCURSOR) <= '/') goto yy29;
  if(yych <= '9') goto yy168;
  goto yy29;
yy29:
#line 407 "idl.re"
{ RET(T_DOT); }
#line 649 "idl_re.cpp"
yy30: ++YYCURSOR;
  if((yych = *YYCURSOR) == '+') goto yy339;
  goto yy31;
yy31:
#line 408 "idl.re"
{ RET(T_PLUS); }
#line 656 "idl_re.cpp"
yy32: ++YYCURSOR;
  if((yych = *YYCURSOR) == '-') goto yy337;
  goto yy33;
yy33:
#line 409 "idl.re"
{ RET(T_MINUS); }
#line 663 "idl_re.cpp"
yy34: ++YYCURSOR;
  goto yy35;
yy35:
#line 410 "idl.re"
{ RET(T_STAR); }
#line 669 "idl_re.cpp"
yy36: yyaccept = 3;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == ':') goto yy238;
  goto yy37;
yy37:
#line 412 "idl.re"
{ RET(T_PERCENT); }
#line 677 "idl_re.cpp"
yy38: ++YYCURSOR;
  goto yy39;
yy39:
#line 413 "idl.re"
{ RET(T_XOR); }
#line 683 "idl_re.cpp"
yy40: ++YYCURSOR;
  if((yych = *YYCURSOR) == '&') goto yy236;
  goto yy41;
yy41:
#line 414 "idl.re"
{ RET(T_AND); }
#line 690 "idl_re.cpp"
yy42: ++YYCURSOR;
  if((yych = *YYCURSOR) == '|') goto yy234;
  goto yy43;
yy43:
#line 415 "idl.re"
{ RET(T_OR); }
#line 697 "idl_re.cpp"
yy44: ++YYCURSOR;
  goto yy45;
yy45:
#line 416 "idl.re"
{ RET(T_COMPL); }
#line 703 "idl_re.cpp"
yy46: ++YYCURSOR;
  if((yych = *YYCURSOR) == '=') goto yy232;
  goto yy47;
yy47:
#line 417 "idl.re"
{ RET(T_NOT); }
#line 710 "idl_re.cpp"
yy48: ++YYCURSOR;
  if((yych = *YYCURSOR) == '=') goto yy230;
  goto yy49;
yy49:
#line 418 "idl.re"
{ RET(T_ASSIGN); }
#line 717 "idl_re.cpp"
yy50: ++YYCURSOR;
  if((yych = *YYCURSOR) <= ';') goto yy51;
  if(yych <= '<') goto yy228;
  if(yych <= '=') goto yy226;
  goto yy51;
yy51:
#line 419 "idl.re"
{ RET(T_LESS); }
#line 726 "idl_re.cpp"
yy52: ++YYCURSOR;
  if((yych = *YYCURSOR) <= '<') goto yy53;
  if(yych <= '=') goto yy222;
  if(yych <= '>') goto yy224;
  goto yy53;
yy53:
#line 420 "idl.re"
{ RET(T_GREATER); }
#line 735 "idl_re.cpp"
yy54: ++YYCURSOR;
  goto yy55;
yy55:
#line 431 "idl.re"
{ RET(T_COMMA); }
#line 741 "idl_re.cpp"
yy56: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  goto yy202;
yy57: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= '?'){
    if(yych <= '\''){
      if(yych == '"') goto yy76;
      if(yych <= '&') goto yy6;
      goto yy221;
    } else {
      if(yych <= '/') goto yy6;
      if(yych <= '9') goto yy201;
      if(yych <= '>') goto yy6;
      goto yy204;
    }
  } else {
    if(yych <= '\\'){
      if(yych <= '@') goto yy6;
      if(yych <= 'Z') goto yy201;
      if(yych <= '[') goto yy6;
      goto yy203;
    } else {
      if(yych <= '_'){
        if(yych <= '^') goto yy6;
        goto yy201;
      } else {
        if(yych <= '`') goto yy6;
        if(yych <= 'z') goto yy201;
        goto yy6;
      }
    }
  }
yy58: yyaccept = 4;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'U') goto yy193;
  if(yych == 'u') goto yy192;
  goto yy59;
yy59:
#line 498 "idl.re"
{
        /* if (0 != s->error_proc)
            (*s->error_proc)(s, "Unexpected character: '%c'", *s->tok);
        else
            printf("unexpected character: '%c'\n", *s->tok);
        */
        RET(TOKEN_FROM_ID(*s->tok, UnknownTokenType));
    }
#line 790 "idl_re.cpp"
yy60: yyaccept = 5;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'U'){
    if(yych <= 'C'){
      if(yych <= '/'){
        if(yych == '.') goto yy168;
        goto yy61;
      } else {
        if(yych <= '7') goto yy185;
        if(yych <= '9') goto yy187;
        goto yy61;
      }
    } else {
      if(yych <= 'K'){
        if(yych <= 'D') goto yy164;
        if(yych <= 'E') goto yy171;
        goto yy61;
      } else {
        if(yych <= 'L') goto yy173;
        if(yych >= 'U') goto yy172;
        goto yy61;
      }
    }
  } else {
    if(yych <= 'k'){
      if(yych <= 'c'){
        if(yych == 'X') goto yy189;
        goto yy61;
      } else {
        if(yych <= 'd') goto yy164;
        if(yych <= 'e') goto yy171;
        goto yy61;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 'l') goto yy173;
        if(yych >= 'u') goto yy172;
        goto yy61;
      } else {
        if(yych == 'x') goto yy189;
        goto yy61;
      }
    }
  }
yy61:
#line 437 "idl.re"
{ RET(T_INTLIT); }
#line 838 "idl_re.cpp"
yy62: yyaccept = 5;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'L'){
    if(yych <= '9'){
      if(yych == '.') goto yy168;
      if(yych <= '/') goto yy61;
      goto yy166;
    } else {
      if(yych <= 'D'){
        if(yych <= 'C') goto yy61;
        goto yy164;
      } else {
        if(yych <= 'E') goto yy171;
        if(yych <= 'K') goto yy61;
        goto yy173;
      }
    }
  } else {
    if(yych <= 'e'){
      if(yych <= 'U'){
        if(yych <= 'T') goto yy61;
        goto yy172;
      } else {
        if(yych <= 'c') goto yy61;
        if(yych <= 'd') goto yy164;
        goto yy171;
      }
    } else {
      if(yych <= 'l'){
        if(yych <= 'k') goto yy61;
        goto yy173;
      } else {
        if(yych == 'u') goto yy172;
        goto yy61;
      }
    }
  }
yy63: yyaccept = 4;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 0x0C){
    if(yych == 0x09)  goto yy121;
    if(yych <= 0x0A)  goto yy59;
    goto yy121;
  } else {
    if(yych <= 0x1F)  goto yy59;
    if(yych == '\'')  goto yy59;
    goto yy121;
  }
yy64: yyaccept = 4;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 0x0A){
    if(yych == 0x09)  goto yy77;
    goto yy59;
  } else {
    if(yych <= 0x0C)  goto yy77;
    if(yych <= 0x1F)  goto yy59;
    goto yy77;
  }
yy65: ++YYCURSOR;
  yych = *YYCURSOR;
  goto yy75;
yy66:
#line 476 "idl.re"
{ RET(T_SPACE); }
#line 903 "idl_re.cpp"
yy67: ++YYCURSOR;
  goto yy68;
yy68:
#line 479 "idl.re"
{
        s->line++;
        RET(T_NEWLINE);
    }
#line 912 "idl_re.cpp"
yy69: yych = *++YYCURSOR;
  if(yych == 0x0A)  goto yy73;
  goto yy68;
yy70: ++YYCURSOR;
  goto yy71;
yy71:
#line 485 "idl.re"
{
        if(cursor != s->eof) 
        {
            using namespace std;      // some systems have printf in std
            if (0 != s->error_proc)
                (*s->error_proc)(s, "'\\000' in input stream");
            else
                printf("Error: 0 in file\n");
        }
        RET(T_EOF);
    }
#line 931 "idl_re.cpp"
yy72: yych = *++YYCURSOR;
  goto yy59;
yy73: yych = *++YYCURSOR;
  goto yy68;
yy74: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy75;
yy75: if(yych <= 0x0A){
    if(yych == 0x09)  goto yy74;
    goto yy66;
  } else {
    if(yych <= 0x0C)  goto yy74;
    if(yych == ' ') goto yy74;
    goto yy66;
  }
yy76: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy77;
yy77: if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      goto yy76;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy80;
      if(yych <= '>') goto yy76;
      goto yy78;
    } else {
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy78: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      goto yy76;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy80;
      if(yych <= '>') goto yy76;
      goto yy91;
    } else {
      if(yych != '\\')  goto yy76;
      goto yy79;
    }
  }
yy79: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '`'){
    if(yych <= '7'){
      if(yych <= '&'){
        if(yych == '"') goto yy76;
        goto yy2;
      } else {
        if(yych <= '\'')  goto yy76;
        if(yych <= '/') goto yy2;
        goto yy86;
      }
    } else {
      if(yych <= 'T'){
        if(yych == '?') goto yy84;
        goto yy2;
      } else {
        if(yych <= 'U') goto yy83;
        if(yych == '\\')  goto yy76;
        goto yy2;
      }
    }
  } else {
    if(yych <= 'r'){
      if(yych <= 'f'){
        if(yych <= 'b') goto yy76;
        if(yych <= 'e') goto yy2;
        goto yy76;
      } else {
        if(yych == 'n') goto yy76;
        if(yych <= 'q') goto yy2;
        goto yy76;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 's') goto yy2;
        if(yych <= 't') goto yy76;
        goto yy82;
      } else {
        if(yych <= 'v') goto yy76;
        if(yych == 'x') goto yy85;
        goto yy2;
      }
    }
  }
yy80: ++YYCURSOR;
  goto yy81;
yy81:
#line 449 "idl.re"
{ RET(T_STRINGLIT); }
#line 1044 "idl_re.cpp"
yy82: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy117;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy117;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy117;
    goto yy2;
  }
yy83: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy110;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy110;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy110;
    goto yy2;
  }
yy84: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      goto yy76;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy80;
      if(yych <= '>') goto yy76;
      goto yy90;
    } else {
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy85: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy88;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy88;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy88;
    goto yy2;
  }
yy86: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '"'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '!') goto yy76;
      goto yy80;
    }
  } else {
    if(yych <= '>'){
      if(yych <= '/') goto yy76;
      if(yych >= '8') goto yy76;
      goto yy87;
    } else {
      if(yych <= '?') goto yy78;
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy87: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      goto yy76;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy80;
      if(yych <= '>') goto yy76;
      goto yy78;
    } else {
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy88: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy89;
yy89: if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy88;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy88;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych <= 'f') goto yy88;
        goto yy76;
      }
    }
  }
yy90: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      goto yy76;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy80;
      if(yych <= '>') goto yy76;
      goto yy91;
    } else {
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy91: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy92;
yy92: if(yych <= '"'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '!') goto yy76;
      goto yy80;
    }
  } else {
    if(yych <= '>'){
      if(yych != '/') goto yy76;
      goto yy93;
    } else {
      if(yych <= '?') goto yy91;
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy93: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy94;
yy94: if(yych <= '>'){
    if(yych <= 0x1F){
      if(yych <= 0x09){
        if(yych <= 0x08)  goto yy2;
        goto yy76;
      } else {
        if(yych <= 0x0A)  goto yy2;
        if(yych <= 0x0C)  goto yy76;
        goto yy2;
      }
    } else {
      if(yych <= '"'){
        if(yych <= '!') goto yy76;
        goto yy97;
      } else {
        if(yych <= '/') goto yy76;
        if(yych <= '7') goto yy86;
        goto yy76;
      }
    }
  } else {
    if(yych <= '\\'){
      if(yych <= 'T'){
        if(yych <= '?') goto yy98;
        goto yy76;
      } else {
        if(yych <= 'U') goto yy96;
        if(yych <= '[') goto yy76;
        goto yy93;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 't') goto yy76;
        goto yy95;
      } else {
        if(yych == 'x') goto yy88;
        goto yy76;
      }
    }
  }
yy95: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy107;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy107;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych <= 'f') goto yy107;
        goto yy76;
      }
    }
  }
yy96: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy100;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy100;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych <= 'f') goto yy100;
        goto yy76;
      }
    }
  }
yy97: yyaccept = 6;
  YYMARKER = ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy81;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy81;
      goto yy76;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy80;
      if(yych <= '>') goto yy76;
      goto yy78;
    } else {
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy98: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      goto yy76;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy80;
      if(yych <= '>') goto yy76;
      goto yy99;
    } else {
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy99: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '"'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '!') goto yy76;
      goto yy80;
    }
  } else {
    if(yych <= '>'){
      if(yych == '/') goto yy93;
      goto yy76;
    } else {
      if(yych <= '?') goto yy91;
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy100:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy101;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy101;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych >= 'g') goto yy76;
        goto yy101;
      }
    }
  }
yy101:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy102;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy102;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych >= 'g') goto yy76;
        goto yy102;
      }
    }
  }
yy102:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy103;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy103;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych >= 'g') goto yy76;
        goto yy103;
      }
    }
  }
yy103:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy104;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy104;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych >= 'g') goto yy76;
        goto yy104;
      }
    }
  }
yy104:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy105;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy105;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych >= 'g') goto yy76;
        goto yy105;
      }
    }
  }
yy105:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy106;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy106;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych >= 'g') goto yy76;
        goto yy106;
      }
    }
  }
yy106:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      goto yy76;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy80;
      if(yych <= '>') goto yy76;
      goto yy78;
    } else {
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy107:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy108;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy108;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych >= 'g') goto yy76;
        goto yy108;
      }
    }
  }
yy108:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy76;
      if(yych <= 0x0A)  goto yy2;
      goto yy76;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy76;
      } else {
        if(yych <= '"') goto yy80;
        if(yych <= '/') goto yy76;
        goto yy109;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy78;
      if(yych <= '@') goto yy76;
      goto yy109;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy76;
        goto yy79;
      } else {
        if(yych <= '`') goto yy76;
        if(yych >= 'g') goto yy76;
        goto yy109;
      }
    }
  }
yy109:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy76;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy76;
      if(yych <= 0x1F)  goto yy2;
      goto yy76;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy80;
      if(yych <= '>') goto yy76;
      goto yy78;
    } else {
      if(yych == '\\')  goto yy79;
      goto yy76;
    }
  }
yy110:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy111;
  } else {
    if(yych <= 'F') goto yy111;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy111;
  }
yy111:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy112;
  } else {
    if(yych <= 'F') goto yy112;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy112;
  }
yy112:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy113;
  } else {
    if(yych <= 'F') goto yy113;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy113;
  }
yy113:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy114;
  } else {
    if(yych <= 'F') goto yy114;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy114;
  }
yy114:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy115;
  } else {
    if(yych <= 'F') goto yy115;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy115;
  }
yy115:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy116;
  } else {
    if(yych <= 'F') goto yy116;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy116;
  }
yy116:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy76;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy76;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy76;
    goto yy2;
  }
yy117:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy118;
  } else {
    if(yych <= 'F') goto yy118;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy118;
  }
yy118:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy119;
  } else {
    if(yych <= 'F') goto yy119;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy119;
  }
yy119:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy76;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy76;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy76;
    goto yy2;
  }
yy120:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy121;
yy121:  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      goto yy120;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy130;
      if(yych <= '>') goto yy120;
      goto yy122;
    } else {
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy122:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      goto yy120;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy130;
      if(yych <= '>') goto yy120;
      goto yy135;
    } else {
      if(yych != '\\')  goto yy120;
      goto yy123;
    }
  }
yy123:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '`'){
    if(yych <= '7'){
      if(yych <= '&'){
        if(yych == '"') goto yy120;
        goto yy2;
      } else {
        if(yych <= '\'')  goto yy120;
        if(yych <= '/') goto yy2;
        goto yy128;
      }
    } else {
      if(yych <= 'T'){
        if(yych == '?') goto yy126;
        goto yy2;
      } else {
        if(yych <= 'U') goto yy125;
        if(yych == '\\')  goto yy120;
        goto yy2;
      }
    }
  } else {
    if(yych <= 'r'){
      if(yych <= 'f'){
        if(yych <= 'b') goto yy120;
        if(yych <= 'e') goto yy2;
        goto yy120;
      } else {
        if(yych == 'n') goto yy120;
        if(yych <= 'q') goto yy2;
        goto yy120;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 's') goto yy2;
        if(yych <= 't') goto yy120;
        goto yy124;
      } else {
        if(yych <= 'v') goto yy120;
        if(yych == 'x') goto yy127;
        goto yy2;
      }
    }
  }
yy124:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy161;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy161;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy161;
    goto yy2;
  }
yy125:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy154;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy154;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy154;
    goto yy2;
  }
yy126:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      goto yy120;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy130;
      if(yych <= '>') goto yy120;
      goto yy134;
    } else {
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy127:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy132;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy132;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy132;
    goto yy2;
  }
yy128:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '\''){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '&') goto yy120;
      goto yy130;
    }
  } else {
    if(yych <= '>'){
      if(yych <= '/') goto yy120;
      if(yych >= '8') goto yy120;
      goto yy129;
    } else {
      if(yych <= '?') goto yy122;
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy129:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      goto yy120;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy130;
      if(yych <= '>') goto yy120;
      goto yy122;
    } else {
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy130:  ++YYCURSOR;
  goto yy131;
yy131:
#line 446 "idl.re"
{ RET(T_CHARLIT); }
#line 2062 "idl_re.cpp"
yy132:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy133;
yy133:  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy132;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy132;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych <= 'f') goto yy132;
        goto yy120;
      }
    }
  }
yy134:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      goto yy120;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy130;
      if(yych <= '>') goto yy120;
      goto yy135;
    } else {
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy135:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy136;
yy136:  if(yych <= '\''){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '&') goto yy120;
      goto yy130;
    }
  } else {
    if(yych <= '>'){
      if(yych != '/') goto yy120;
      goto yy137;
    } else {
      if(yych <= '?') goto yy135;
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy137:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy138;
yy138:  if(yych <= '>'){
    if(yych <= 0x1F){
      if(yych <= 0x09){
        if(yych <= 0x08)  goto yy2;
        goto yy120;
      } else {
        if(yych <= 0x0A)  goto yy2;
        if(yych <= 0x0C)  goto yy120;
        goto yy2;
      }
    } else {
      if(yych <= '\''){
        if(yych <= '&') goto yy120;
        goto yy141;
      } else {
        if(yych <= '/') goto yy120;
        if(yych <= '7') goto yy128;
        goto yy120;
      }
    }
  } else {
    if(yych <= '\\'){
      if(yych <= 'T'){
        if(yych <= '?') goto yy142;
        goto yy120;
      } else {
        if(yych <= 'U') goto yy140;
        if(yych <= '[') goto yy120;
        goto yy137;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 't') goto yy120;
        goto yy139;
      } else {
        if(yych == 'x') goto yy132;
        goto yy120;
      }
    }
  }
yy139:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy151;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy151;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych <= 'f') goto yy151;
        goto yy120;
      }
    }
  }
yy140:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy144;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy144;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych <= 'f') goto yy144;
        goto yy120;
      }
    }
  }
yy141:  yyaccept = 7;
  YYMARKER = ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy131;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy131;
      goto yy120;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy130;
      if(yych <= '>') goto yy120;
      goto yy122;
    } else {
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy142:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      goto yy120;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy130;
      if(yych <= '>') goto yy120;
      goto yy143;
    } else {
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy143:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '\''){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '&') goto yy120;
      goto yy130;
    }
  } else {
    if(yych <= '>'){
      if(yych == '/') goto yy137;
      goto yy120;
    } else {
      if(yych <= '?') goto yy135;
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy144:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy145;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy145;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych >= 'g') goto yy120;
        goto yy145;
      }
    }
  }
yy145:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy146;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy146;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych >= 'g') goto yy120;
        goto yy146;
      }
    }
  }
yy146:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy147;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy147;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych >= 'g') goto yy120;
        goto yy147;
      }
    }
  }
yy147:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy148;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy148;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych >= 'g') goto yy120;
        goto yy148;
      }
    }
  }
yy148:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy149;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy149;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych >= 'g') goto yy120;
        goto yy149;
      }
    }
  }
yy149:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy150;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy150;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych >= 'g') goto yy120;
        goto yy150;
      }
    }
  }
yy150:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      goto yy120;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy130;
      if(yych <= '>') goto yy120;
      goto yy122;
    } else {
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy151:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy152;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy152;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych >= 'g') goto yy120;
        goto yy152;
      }
    }
  }
yy152:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy120;
      if(yych <= 0x0A)  goto yy2;
      goto yy120;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy120;
      } else {
        if(yych <= '\'')  goto yy130;
        if(yych <= '/') goto yy120;
        goto yy153;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy122;
      if(yych <= '@') goto yy120;
      goto yy153;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy120;
        goto yy123;
      } else {
        if(yych <= '`') goto yy120;
        if(yych >= 'g') goto yy120;
        goto yy153;
      }
    }
  }
yy153:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy120;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy120;
      if(yych <= 0x1F)  goto yy2;
      goto yy120;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy130;
      if(yych <= '>') goto yy120;
      goto yy122;
    } else {
      if(yych == '\\')  goto yy123;
      goto yy120;
    }
  }
yy154:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy155;
  } else {
    if(yych <= 'F') goto yy155;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy155;
  }
yy155:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy156;
  } else {
    if(yych <= 'F') goto yy156;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy156;
  }
yy156:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy157;
  } else {
    if(yych <= 'F') goto yy157;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy157;
  }
yy157:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy158;
  } else {
    if(yych <= 'F') goto yy158;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy158;
  }
yy158:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy159;
  } else {
    if(yych <= 'F') goto yy159;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy159;
  }
yy159:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy160;
  } else {
    if(yych <= 'F') goto yy160;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy160;
  }
yy160:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy120;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy120;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy120;
    goto yy2;
  }
yy161:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy162;
  } else {
    if(yych <= 'F') goto yy162;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy162;
  }
yy162:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy163;
  } else {
    if(yych <= 'F') goto yy163;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy163;
  }
yy163:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy120;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy120;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy120;
    goto yy2;
  }
yy164:  ++YYCURSOR;
  goto yy165;
yy165:
#line 443 "idl.re"
{ RET(T_FIXEDPOINTLIT); }
#line 2775 "idl_re.cpp"
yy166:  yyaccept = 5;
  YYMARKER = ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
  yych = *YYCURSOR;
  goto yy167;
yy167:  if(yych <= 'L'){
    if(yych <= '9'){
      if(yych == '.') goto yy168;
      if(yych <= '/') goto yy61;
      goto yy166;
    } else {
      if(yych <= 'D'){
        if(yych <= 'C') goto yy61;
        goto yy164;
      } else {
        if(yych <= 'E') goto yy171;
        if(yych <= 'K') goto yy61;
        goto yy173;
      }
    }
  } else {
    if(yych <= 'e'){
      if(yych <= 'U'){
        if(yych <= 'T') goto yy61;
        goto yy172;
      } else {
        if(yych <= 'c') goto yy61;
        if(yych <= 'd') goto yy164;
        goto yy171;
      }
    } else {
      if(yych <= 'l'){
        if(yych <= 'k') goto yy61;
        goto yy173;
      } else {
        if(yych == 'u') goto yy172;
        goto yy61;
      }
    }
  }
yy168:  yyaccept = 8;
  YYMARKER = ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
  yych = *YYCURSOR;
  goto yy169;
yy169:  if(yych <= 'K'){
    if(yych <= 'C'){
      if(yych <= '/') goto yy170;
      if(yych <= '9') goto yy168;
      goto yy170;
    } else {
      if(yych <= 'D') goto yy164;
      if(yych <= 'E') goto yy181;
      if(yych <= 'F') goto yy178;
      goto yy170;
    }
  } else {
    if(yych <= 'e'){
      if(yych <= 'L') goto yy179;
      if(yych <= 'c') goto yy170;
      if(yych <= 'd') goto yy164;
      goto yy181;
    } else {
      if(yych <= 'f') goto yy178;
      if(yych == 'l') goto yy179;
      goto yy170;
    }
  }
yy170:
#line 440 "idl.re"
{ RET(T_FLOATLIT); }
#line 2847 "idl_re.cpp"
yy171:  yych = *++YYCURSOR;
  if(yych <= ','){
    if(yych == '+') goto yy175;
    goto yy2;
  } else {
    if(yych <= '-') goto yy175;
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy176;
    goto yy2;
  }
yy172:  yych = *++YYCURSOR;
  if(yych == 'L') goto yy174;
  if(yych == 'l') goto yy174;
  goto yy61;
yy173:  yych = *++YYCURSOR;
  if(yych == 'U') goto yy174;
  if(yych != 'u') goto yy61;
  goto yy174;
yy174:  yych = *++YYCURSOR;
  goto yy61;
yy175:  yych = *++YYCURSOR;
  if(yych <= '/') goto yy2;
  if(yych >= ':') goto yy2;
  goto yy176;
yy176:  ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  goto yy177;
yy177:  if(yych <= 'K'){
    if(yych <= '9'){
      if(yych <= '/') goto yy170;
      goto yy176;
    } else {
      if(yych != 'F') goto yy170;
      goto yy178;
    }
  } else {
    if(yych <= 'f'){
      if(yych <= 'L') goto yy179;
      if(yych <= 'e') goto yy170;
      goto yy178;
    } else {
      if(yych == 'l') goto yy179;
      goto yy170;
    }
  }
yy178:  yych = *++YYCURSOR;
  if(yych == 'L') goto yy180;
  if(yych == 'l') goto yy180;
  goto yy170;
yy179:  yych = *++YYCURSOR;
  if(yych == 'F') goto yy180;
  if(yych != 'f') goto yy170;
  goto yy180;
yy180:  yych = *++YYCURSOR;
  goto yy170;
yy181:  yych = *++YYCURSOR;
  if(yych <= ','){
    if(yych != '+') goto yy2;
    goto yy182;
  } else {
    if(yych <= '-') goto yy182;
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy183;
    goto yy2;
  }
yy182:  yych = *++YYCURSOR;
  if(yych <= '/') goto yy2;
  if(yych >= ':') goto yy2;
  goto yy183;
yy183:  ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  goto yy184;
yy184:  if(yych <= 'K'){
    if(yych <= '9'){
      if(yych <= '/') goto yy170;
      goto yy183;
    } else {
      if(yych == 'F') goto yy178;
      goto yy170;
    }
  } else {
    if(yych <= 'f'){
      if(yych <= 'L') goto yy179;
      if(yych <= 'e') goto yy170;
      goto yy178;
    } else {
      if(yych == 'l') goto yy179;
      goto yy170;
    }
  }
yy185:  yyaccept = 5;
  YYMARKER = ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
  yych = *YYCURSOR;
  goto yy186;
yy186:  if(yych <= 'L'){
    if(yych <= '9'){
      if(yych <= '.'){
        if(yych <= '-') goto yy61;
        goto yy168;
      } else {
        if(yych <= '/') goto yy61;
        if(yych <= '7') goto yy185;
        goto yy187;
      }
    } else {
      if(yych <= 'D'){
        if(yych <= 'C') goto yy61;
        goto yy164;
      } else {
        if(yych <= 'E') goto yy171;
        if(yych <= 'K') goto yy61;
        goto yy173;
      }
    }
  } else {
    if(yych <= 'e'){
      if(yych <= 'U'){
        if(yych <= 'T') goto yy61;
        goto yy172;
      } else {
        if(yych <= 'c') goto yy61;
        if(yych <= 'd') goto yy164;
        goto yy171;
      }
    } else {
      if(yych <= 'l'){
        if(yych <= 'k') goto yy61;
        goto yy173;
      } else {
        if(yych == 'u') goto yy172;
        goto yy61;
      }
    }
  }
yy187:  ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
  yych = *YYCURSOR;
  goto yy188;
yy188:  if(yych <= 'C'){
    if(yych <= '.'){
      if(yych <= '-') goto yy2;
      goto yy168;
    } else {
      if(yych <= '/') goto yy2;
      if(yych <= '9') goto yy187;
      goto yy2;
    }
  } else {
    if(yych <= 'c'){
      if(yych <= 'D') goto yy164;
      if(yych <= 'E') goto yy171;
      goto yy2;
    } else {
      if(yych <= 'd') goto yy164;
      if(yych <= 'e') goto yy171;
      goto yy2;
    }
  }
yy189:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy190;
  } else {
    if(yych <= 'F') goto yy190;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy190;
  }
yy190:  ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  goto yy191;
yy191:  if(yych <= 'T'){
    if(yych <= '@'){
      if(yych <= '/') goto yy61;
      if(yych <= '9') goto yy190;
      goto yy61;
    } else {
      if(yych <= 'F') goto yy190;
      if(yych == 'L') goto yy173;
      goto yy61;
    }
  } else {
    if(yych <= 'k'){
      if(yych <= 'U') goto yy172;
      if(yych <= '`') goto yy61;
      if(yych <= 'f') goto yy190;
      goto yy61;
    } else {
      if(yych <= 'l') goto yy173;
      if(yych == 'u') goto yy172;
      goto yy61;
    }
  }
yy192:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy218;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy218;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy218;
    goto yy2;
  }
yy193:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy194;
  } else {
    if(yych <= 'F') goto yy194;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy194;
  }
yy194:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy195;
  } else {
    if(yych <= 'F') goto yy195;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy195;
  }
yy195:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy196;
  } else {
    if(yych <= 'F') goto yy196;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy196;
  }
yy196:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy197;
  } else {
    if(yych <= 'F') goto yy197;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy197;
  }
yy197:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy198;
  } else {
    if(yych <= 'F') goto yy198;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy198;
  }
yy198:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy199;
  } else {
    if(yych <= 'F') goto yy199;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy199;
  }
yy199:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy200;
  } else {
    if(yych <= 'F') goto yy200;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy200;
  }
yy200:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy201;
  } else {
    if(yych <= 'F') goto yy201;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy201;
  }
yy201:  yyaccept = 0;
  YYMARKER = ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy202;
yy202:  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy6;
      if(yych <= '9') goto yy201;
      goto yy6;
    } else {
      if(yych <= '?') goto yy204;
      if(yych <= '@') goto yy6;
      goto yy201;
    }
  } else {
    if(yych <= '^'){
      if(yych != '\\')  goto yy6;
      goto yy203;
    } else {
      if(yych == '`') goto yy6;
      if(yych <= 'z') goto yy201;
      goto yy6;
    }
  }
yy203:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych == 'U') goto yy207;
  if(yych == 'u') goto yy206;
  goto yy2;
yy204:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych != '?') goto yy2;
  goto yy205;
yy205:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych == '/') goto yy203;
  goto yy2;
yy206:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy215;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy215;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy215;
    goto yy2;
  }
yy207:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy208;
  } else {
    if(yych <= 'F') goto yy208;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy208;
  }
yy208:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy209;
  } else {
    if(yych <= 'F') goto yy209;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy209;
  }
yy209:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy210;
  } else {
    if(yych <= 'F') goto yy210;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy210;
  }
yy210:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy211;
  } else {
    if(yych <= 'F') goto yy211;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy211;
  }
yy211:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy212;
  } else {
    if(yych <= 'F') goto yy212;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy212;
  }
yy212:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy213;
  } else {
    if(yych <= 'F') goto yy213;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy213;
  }
yy213:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy214;
  } else {
    if(yych <= 'F') goto yy214;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy214;
  }
yy214:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy201;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy201;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy201;
    goto yy2;
  }
yy215:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy216;
  } else {
    if(yych <= 'F') goto yy216;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy216;
  }
yy216:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy217;
  } else {
    if(yych <= 'F') goto yy217;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy217;
  }
yy217:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy201;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy201;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy201;
    goto yy2;
  }
yy218:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy219;
  } else {
    if(yych <= 'F') goto yy219;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy219;
  }
yy219:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy220;
  } else {
    if(yych <= 'F') goto yy220;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy220;
  }
yy220:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy201;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy201;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy201;
    goto yy2;
  }
yy221:  yych = *++YYCURSOR;
  if(yych == '\'')  goto yy2;
  goto yy121;
yy222:  ++YYCURSOR;
  goto yy223;
yy223:
#line 426 "idl.re"
{ RET(T_GREATEREQUAL); }
#line 3383 "idl_re.cpp"
yy224:  ++YYCURSOR;
  goto yy225;
yy225:
#line 422 "idl.re"
{ RET(T_SHIFTRIGHT); }
#line 3389 "idl_re.cpp"
yy226:  ++YYCURSOR;
  goto yy227;
yy227:
#line 425 "idl.re"
{ RET(T_LESSEQUAL); }
#line 3395 "idl_re.cpp"
yy228:  ++YYCURSOR;
  goto yy229;
yy229:
#line 421 "idl.re"
{ RET(T_SHIFTLEFT); }
#line 3401 "idl_re.cpp"
yy230:  ++YYCURSOR;
  goto yy231;
yy231:
#line 423 "idl.re"
{ RET(T_EQUAL); }
#line 3407 "idl_re.cpp"
yy232:  ++YYCURSOR;
  goto yy233;
yy233:
#line 424 "idl.re"
{ RET(T_NOTEQUAL); }
#line 3413 "idl_re.cpp"
yy234:  ++YYCURSOR;
  goto yy235;
yy235:
#line 428 "idl.re"
{ RET(T_OROR); }
#line 3419 "idl_re.cpp"
yy236:  ++YYCURSOR;
  goto yy237;
yy237:
#line 427 "idl.re"
{ RET(T_ANDAND); }
#line 3425 "idl_re.cpp"
yy238:  ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
  yych = *YYCURSOR;
  goto yy239;
yy239:  if(yych <= 'h'){
    if(yych <= '.'){
      if(yych <= 0x09){
        if(yych <= 0x08)  goto yy2;
        goto yy238;
      } else {
        if(yych == ' ') goto yy238;
        goto yy2;
      }
    } else {
      if(yych <= 'c'){
        if(yych >= '0') goto yy2;
        goto yy240;
      } else {
        if(yych <= 'd') goto yy243;
        if(yych <= 'e') goto yy242;
        goto yy2;
      }
    }
  } else {
    if(yych <= 'p'){
      if(yych <= 'k'){
        if(yych <= 'i') goto yy241;
        goto yy2;
      } else {
        if(yych <= 'l') goto yy245;
        if(yych <= 'o') goto yy2;
        goto yy246;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 't') goto yy2;
        goto yy244;
      } else {
        if(yych == 'w') goto yy247;
        goto yy2;
      }
    }
  }
yy240:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych == '*') goto yy330;
  goto yy2;
yy241:  yych = *++YYCURSOR;
  if(yych == 'f') goto yy293;
  if(yych == 'n') goto yy295;
  goto yy2;
yy242:  yych = *++YYCURSOR;
  if(yych <= 'm'){
    if(yych == 'l') goto yy278;
    goto yy2;
  } else {
    if(yych <= 'n') goto yy277;
    if(yych == 'r') goto yy276;
    goto yy2;
  }
yy243:  yych = *++YYCURSOR;
  if(yych == 'e') goto yy270;
  goto yy2;
yy244:  yych = *++YYCURSOR;
  if(yych == 'n') goto yy265;
  goto yy2;
yy245:  yych = *++YYCURSOR;
  if(yych == 'i') goto yy261;
  goto yy2;
yy246:  yych = *++YYCURSOR;
  if(yych == 'r') goto yy255;
  goto yy2;
yy247:  yych = *++YYCURSOR;
  if(yych != 'a') goto yy2;
  goto yy248;
yy248:  yych = *++YYCURSOR;
  if(yych != 'r') goto yy2;
  goto yy249;
yy249:  yych = *++YYCURSOR;
  if(yych != 'n') goto yy2;
  goto yy250;
yy250:  yych = *++YYCURSOR;
  if(yych != 'i') goto yy2;
  goto yy251;
yy251:  yych = *++YYCURSOR;
  if(yych != 'n') goto yy2;
  goto yy252;
yy252:  yych = *++YYCURSOR;
  if(yych != 'g') goto yy2;
  goto yy253;
yy253:  ++YYCURSOR;
  goto yy254;
yy254:
#line 473 "idl.re"
{ RET(T_PP_WARNING); }
#line 3522 "idl_re.cpp"
yy255:  yych = *++YYCURSOR;
  if(yych != 'a') goto yy2;
  goto yy256;
yy256:  yych = *++YYCURSOR;
  if(yych != 'g') goto yy2;
  goto yy257;
yy257:  yych = *++YYCURSOR;
  if(yych != 'm') goto yy2;
  goto yy258;
yy258:  yych = *++YYCURSOR;
  if(yych != 'a') goto yy2;
  goto yy259;
yy259:  ++YYCURSOR;
  goto yy260;
yy260:
#line 471 "idl.re"
{ RET(T_PP_PRAGMA); }
#line 3540 "idl_re.cpp"
yy261:  yych = *++YYCURSOR;
  if(yych != 'n') goto yy2;
  goto yy262;
yy262:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy263;
yy263:  ++YYCURSOR;
  goto yy264;
yy264:
#line 469 "idl.re"
{ RET(T_PP_LINE); }
#line 3552 "idl_re.cpp"
yy265:  yych = *++YYCURSOR;
  if(yych != 'd') goto yy2;
  goto yy266;
yy266:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy267;
yy267:  yych = *++YYCURSOR;
  if(yych != 'f') goto yy2;
  goto yy268;
yy268:  ++YYCURSOR;
  goto yy269;
yy269:
#line 468 "idl.re"
{ RET(T_PP_UNDEF); }
#line 3567 "idl_re.cpp"
yy270:  yych = *++YYCURSOR;
  if(yych != 'f') goto yy2;
  goto yy271;
yy271:  yych = *++YYCURSOR;
  if(yych != 'i') goto yy2;
  goto yy272;
yy272:  yych = *++YYCURSOR;
  if(yych != 'n') goto yy2;
  goto yy273;
yy273:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy274;
yy274:  ++YYCURSOR;
  goto yy275;
yy275:
#line 467 "idl.re"
{ RET(T_PP_DEFINE); }
#line 3585 "idl_re.cpp"
yy276:  yych = *++YYCURSOR;
  if(yych == 'r') goto yy289;
  goto yy2;
yy277:  yych = *++YYCURSOR;
  if(yych == 'd') goto yy285;
  goto yy2;
yy278:  yych = *++YYCURSOR;
  if(yych == 'i') goto yy280;
  if(yych != 's') goto yy2;
  goto yy279;
yy279:  yych = *++YYCURSOR;
  if(yych == 'e') goto yy283;
  goto yy2;
yy280:  yych = *++YYCURSOR;
  if(yych != 'f') goto yy2;
  goto yy281;
yy281:  ++YYCURSOR;
  goto yy282;
yy282:
#line 465 "idl.re"
{ RET(T_PP_ELIF); }
#line 3607 "idl_re.cpp"
yy283:  ++YYCURSOR;
  goto yy284;
yy284:
#line 464 "idl.re"
{ RET(T_PP_ELSE); }
#line 3613 "idl_re.cpp"
yy285:  yych = *++YYCURSOR;
  if(yych != 'i') goto yy2;
  goto yy286;
yy286:  yych = *++YYCURSOR;
  if(yych != 'f') goto yy2;
  goto yy287;
yy287:  ++YYCURSOR;
  goto yy288;
yy288:
#line 466 "idl.re"
{ RET(T_PP_ENDIF); }
#line 3625 "idl_re.cpp"
yy289:  yych = *++YYCURSOR;
  if(yych != 'o') goto yy2;
  goto yy290;
yy290:  yych = *++YYCURSOR;
  if(yych != 'r') goto yy2;
  goto yy291;
yy291:  ++YYCURSOR;
  goto yy292;
yy292:
#line 470 "idl.re"
{ RET(T_PP_ERROR); }
#line 3637 "idl_re.cpp"
yy293:  yyaccept = 9;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'd') goto yy321;
  if(yych == 'n') goto yy322;
  goto yy294;
yy294:
#line 461 "idl.re"
{ RET(T_PP_IF); }
#line 3646 "idl_re.cpp"
yy295:  yych = *++YYCURSOR;
  if(yych != 'c') goto yy2;
  goto yy296;
yy296:  yych = *++YYCURSOR;
  if(yych != 'l') goto yy2;
  goto yy297;
yy297:  yych = *++YYCURSOR;
  if(yych != 'u') goto yy2;
  goto yy298;
yy298:  yych = *++YYCURSOR;
  if(yych != 'd') goto yy2;
  goto yy299;
yy299:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy300;
yy300:  yyaccept = 10;
  YYMARKER = ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  goto yy301;
yy301:  if(yych <= '!'){
    if(yych <= 0x09){
      if(yych >= 0x09)  goto yy300;
      goto yy302;
    } else {
      if(yych == ' ') goto yy300;
      goto yy302;
    }
  } else {
    if(yych <= '/'){
      if(yych <= '"') goto yy304;
      if(yych >= '/') goto yy303;
      goto yy302;
    } else {
      if(yych == '<') goto yy305;
      goto yy302;
    }
  }
yy302:
#line 459 "idl.re"
{ RET(T_PP_INCLUDE); }
#line 3688 "idl_re.cpp"
yy303:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych == '*') goto yy314;
  goto yy2;
yy304:  yych = *++YYCURSOR;
  if(yych == '"') goto yy2;
  goto yy311;
yy305:  yych = *++YYCURSOR;
  if(yych == '>') goto yy2;
  goto yy307;
yy306:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy307;
yy307:  if(yych <= 0x0C){
    if(yych == 0x09)  goto yy306;
    if(yych <= 0x0A)  goto yy2;
    goto yy306;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych != '>') goto yy306;
    goto yy308;
  }
yy308:  ++YYCURSOR;
  goto yy309;
yy309:
#line 453 "idl.re"
{ RET(T_PP_HHEADER); }
#line 3718 "idl_re.cpp"
yy310:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy311;
yy311:  if(yych <= 0x0C){
    if(yych == 0x09)  goto yy310;
    if(yych <= 0x0A)  goto yy2;
    goto yy310;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych != '"') goto yy310;
    goto yy312;
  }
yy312:  ++YYCURSOR;
  goto yy313;
yy313:
#line 456 "idl.re"
{ RET(T_PP_QHEADER); }
#line 3737 "idl_re.cpp"
yy314:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy315;
yy315:  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy314;
    goto yy316;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych == '*') goto yy318;
    goto yy314;
  }
yy316:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy317;
yy317:  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy314;
    goto yy316;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych != '*') goto yy314;
    goto yy318;
  }
yy318:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy319;
yy319:  if(yych <= 0x1F){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy314;
    if(yych >= 0x0E)  goto yy2;
    goto yy320;
  } else {
    if(yych <= '*'){
      if(yych <= ')') goto yy314;
      goto yy318;
    } else {
      if(yych == '/') goto yy300;
      goto yy314;
    }
  }
yy320:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy314;
    goto yy316;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych == '*') goto yy318;
    goto yy314;
  }
yy321:  yych = *++YYCURSOR;
  if(yych == 'e') goto yy327;
  goto yy2;
yy322:  yych = *++YYCURSOR;
  if(yych != 'd') goto yy2;
  goto yy323;
yy323:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy324;
yy324:  yych = *++YYCURSOR;
  if(yych != 'f') goto yy2;
  goto yy325;
yy325:  ++YYCURSOR;
  goto yy326;
yy326:
#line 463 "idl.re"
{ RET(T_PP_IFNDEF); }
#line 3811 "idl_re.cpp"
yy327:  yych = *++YYCURSOR;
  if(yych != 'f') goto yy2;
  goto yy328;
yy328:  ++YYCURSOR;
  goto yy329;
yy329:
#line 462 "idl.re"
{ RET(T_PP_IFDEF); }
#line 3820 "idl_re.cpp"
yy330:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy331;
yy331:  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy330;
    goto yy332;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych == '*') goto yy334;
    goto yy330;
  }
yy332:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy333;
yy333:  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy330;
    goto yy332;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych != '*') goto yy330;
    goto yy334;
  }
yy334:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy335;
yy335:  if(yych <= 0x1F){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy330;
    if(yych >= 0x0E)  goto yy2;
    goto yy336;
  } else {
    if(yych <= '*'){
      if(yych <= ')') goto yy330;
      goto yy334;
    } else {
      if(yych == '/') goto yy238;
      goto yy330;
    }
  }
yy336:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy330;
    goto yy332;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych == '*') goto yy334;
    goto yy330;
  }
yy337:  ++YYCURSOR;
  goto yy338;
yy338:
#line 430 "idl.re"
{ RET(T_MINUSMINUS); }
#line 3882 "idl_re.cpp"
yy339:  ++YYCURSOR;
  goto yy340;
yy340:
#line 429 "idl.re"
{ RET(T_PLUSPLUS); }
#line 3888 "idl_re.cpp"
yy341:  yych = *++YYCURSOR;
  if(yych == '/') goto yy342;
  if(yych == '=') goto yy238;
  goto yy2;
yy342:  yych = *++YYCURSOR;
  if(yych == 'U') goto yy193;
  if(yych == 'u') goto yy192;
  goto yy2;
yy343:  ++YYCURSOR;
  goto yy344;
yy344:
#line 401 "idl.re"
{ RET(T_POUND_POUND); }
#line 3902 "idl_re.cpp"
yy345:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'L') goto yy202;
  goto yy346;
yy346:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'S') goto yy202;
  goto yy347;
yy347:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'E') goto yy202;
  goto yy348;
yy348:  yyaccept = 11;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy349;
      if(yych <= '9') goto yy201;
      goto yy349;
    } else {
      if(yych <= '?') goto yy204;
      if(yych >= 'A') goto yy201;
      goto yy349;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy203;
      goto yy349;
    } else {
      if(yych == '`') goto yy349;
      if(yych <= 'z') goto yy201;
      goto yy349;
    }
  }
yy349:
#line 394 "idl.re"
{ RET(T_FALSE); }
#line 3940 "idl_re.cpp"
yy350:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'U') goto yy202;
  goto yy351;
yy351:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'E') goto yy202;
  goto yy352;
yy352:  yyaccept = 12;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy353;
      if(yych <= '9') goto yy201;
      goto yy353;
    } else {
      if(yych <= '?') goto yy204;
      if(yych >= 'A') goto yy201;
      goto yy353;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy203;
      goto yy353;
    } else {
      if(yych == '`') goto yy353;
      if(yych <= 'z') goto yy201;
      goto yy353;
    }
  }
yy353:
#line 393 "idl.re"
{ RET(T_TRUE); }
#line 3974 "idl_re.cpp"
yy354:  ++YYCURSOR;
  goto yy355;
yy355:
#line 391 "idl.re"
{ goto cppcomment; }
#line 3980 "idl_re.cpp"
yy356:  ++YYCURSOR;
  goto yy357;
yy357:
#line 390 "idl.re"
{ goto ccomment; }
#line 3986 "idl_re.cpp"
}
#line 506 "idl.re"


ccomment:

#line 3993 "idl_re.cpp"
{
  YYCTYPE yych;
  goto yy358;
  ++YYCURSOR;
yy358:
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  if(yych <= 0x0C){
    if(yych <= 0x08){
      if(yych <= 0x00)  goto yy367;
      goto yy360;
    } else {
      if(yych == 0x0A)  goto yy363;
      goto yy366;
    }
  } else {
    if(yych <= 0x1F){
      if(yych <= 0x0D)  goto yy365;
      goto yy360;
    } else {
      if(yych == '*') goto yy361;
      goto yy366;
    }
  }
yy360:yy361:  ++YYCURSOR;
  if((yych = *YYCURSOR) == '/') goto yy370;
  goto yy362;
yy362:
#line 519 "idl.re"
{ goto ccomment; }
#line 4024 "idl_re.cpp"
yy363:  ++YYCURSOR;
  goto yy364;
yy364:
#line 512 "idl.re"
{
        /*if(cursor == s->eof) RET(T_EOF);*/
        /*s->tok = cursor; */
        s->line += count_backslash_newlines(s, cursor) +1;
        goto ccomment;
    }
#line 4035 "idl_re.cpp"
yy365:  yych = *++YYCURSOR;
  if(yych == 0x0A)  goto yy369;
  goto yy364;
yy366:  yych = *++YYCURSOR;
  goto yy362;
yy367:  ++YYCURSOR;
  goto yy368;
yy368:
#line 522 "idl.re"
{
        using namespace std;      // some systems have printf in std
        if(cursor == s->eof) 
        {
            if (s->error_proc)
                (*s->error_proc)(s, "Unterminated comment");
            else
                printf("Error: Unterminated comment\n");
        }
        else
        {
            if (s->error_proc)
                (*s->error_proc)(s, "'\\000' in input stream");
            else
                printf("Error: 0 in file");
        }
        /* adjust cursor such next call returns T_EOF */
        --YYCURSOR;
        /* the comment is unterminated, but nevertheless its a comment */
        RET(T_CCOMMENT);
    }
#line 4066 "idl_re.cpp"
yy369:  yych = *++YYCURSOR;
  goto yy364;
yy370:  ++YYCURSOR;
  goto yy371;
yy371:
#line 510 "idl.re"
{ RET(T_CCOMMENT); }
#line 4074 "idl_re.cpp"
}
#line 544 "idl.re"


cppcomment:

#line 4081 "idl_re.cpp"
{
  YYCTYPE yych;
  goto yy372;
  ++YYCURSOR;
yy372:
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  if(yych <= 0x0A){
    if(yych <= 0x00)  goto yy380;
    if(yych <= 0x08)  goto yy374;
    if(yych <= 0x09)  goto yy378;
    goto yy375;
  } else {
    if(yych <= 0x0C)  goto yy378;
    if(yych <= 0x0D)  goto yy377;
    if(yych >= ' ') goto yy378;
    goto yy374;
  }
yy374:yy375:  ++YYCURSOR;
  goto yy376;
yy376:
#line 549 "idl.re"
{
        /*if(cursor == s->eof) RET(T_EOF); */
        /*s->tok = cursor; */
        s->line++;
        RET(T_CPPCOMMENT);
    }
#line 4110 "idl_re.cpp"
yy377:  yych = *++YYCURSOR;
  if(yych == 0x0A)  goto yy382;
  goto yy376;
yy378:  ++YYCURSOR;
  goto yy379;
yy379:
#line 556 "idl.re"
{ goto cppcomment; }
#line 4119 "idl_re.cpp"
yy380:  ++YYCURSOR;
  goto yy381;
yy381:
#line 559 "idl.re"
{
        using namespace std;      // some systems have printf in std
        if(cursor != s->eof) 
        {
            if (s->error_proc)
                (*s->error_proc)(s, "'\\000' in input stream");
            else
                printf("Error: 0 in file");
        }
        /* adjust cursor such next call returns T_EOF */
        --YYCURSOR;
        /* the comment is unterminated, but nevertheless its a comment */
        RET(T_CPPCOMMENT);
    }
#line 4138 "idl_re.cpp"
yy382:  ++YYCURSOR;
  yych = *YYCURSOR;
  goto yy376;
}
#line 573 "idl.re"


} /* end of scan */

#undef RE2C_ASSERT

///////////////////////////////////////////////////////////////////////////////
}   // namespace re2clex
}   // namespace idllexer
}   // namespace wave
}   // namespace boost
