/*
 * Copyright (C) 2010 Joel Rosdahl
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef COUNTERS_H
#define COUNTERS_H

struct counters {
	unsigned *data;   /* counter value */
	size_t size;      /* logical array size */
	size_t allocated; /* allocated size */
};

struct counters *counters_init(size_t initial_size);
void counters_resize(struct counters *c, size_t new_size);
void counters_free(struct counters *c);

#endif
