#!/bin/bash
# -*- mode: sh; coding: utf-8 -*-
# Copyright © 2006 Peter Eisentraut <petere@debian.org>

. testsuite_functions

# disabled for ubuntu since ant is in universe
if [ ! -e /usr/share/ant/bin/ant -o ! -e /usr/lib/kaffe/bin/jar ]; then
    echo 'skipping ant test since ant or kaffe is not installed' >&2
    return_pass
    exit 0
fi

options $@
setup_workdir

cat <<EOF >$WORKDIR/debian/rules
#!/usr/bin/make -f
include debian/testsuite.mk
include \$(_cdbs_package_root_dir)/1/rules/debhelper.mk.in
include \$(_cdbs_package_root_dir)/1/class/ant.mk.in

DEB_CLASSPATH := /tmp/nothing.jar:\$(DEB_CLASSPATH)
JAVA_HOME_DIRS = /var/tmp/ /usr/lib/kaffe/
EOF
chmod +x $WORKDIR/debian/rules

cp -R ant/* $WORKDIR

build_package
clean_workdir
return_pass
