#!/bin/bash
# -*- mode: sh; coding: utf-8 -*-
# Copyright © 2010 Martin Pitt <martin.pitt@ubuntu.com>

# Test langpack.mk

. testsuite_functions

options $@
setup_workdir

cat <<EOF >$WORKDIR/debian/rules
#!/usr/bin/make -f
include debian/testsuite.mk
include \$(_cdbs_package_root_dir)/1/rules/debhelper.mk.in
include \$(_cdbs_package_root_dir)/1/rules/langpack.mk.in
EOF
chmod +x $WORKDIR/debian/rules

cp -R i18n/* $WORKDIR

build_package

diff -u $WORKDIR/debian/cdbs-testsuite/usr/share/applications/simple.desktop - << EOF || return_fail
[Desktop Entry]
Name=gThumb
Comment=View and organize your images
Categories=GNOME;GTK;Graphics;Viewer;RasterGraphics;2DGraphics;Photography;
Exec=gthumb %U
Icon=gthumb
Type=Application
X-Ubuntu-Gettext-Domain=cdbstest
EOF

diff -u $WORKDIR/debian/cdbs-testsuite/usr/share/applications/leadingspace.desktop - << EOF || return_fail

[Desktop Entry]
Name=gThumb
Comment=View and organize your images
Categories=GNOME;GTK;Graphics;Viewer;RasterGraphics;2DGraphics;Photography;
Exec=gthumb %U
Icon=gthumb
Type=Application
X-Ubuntu-Gettext-Domain=cdbstest
EOF

diff -u $WORKDIR/debian/cdbs-testsuite/usr/share/applications/translated.desktop - << EOF || return_fail
[Desktop Entry]
Name=gThumb
GenericName=Image Viewer
X-GNOME-FullName=gThumb Image Viewer
Comment=View and organize your images
Categories=GNOME;GTK;Graphics;Viewer;RasterGraphics;2DGraphics;Photography;
Exec=gthumb %U
Icon=gthumb
Type=Application
X-Ubuntu-Gettext-Domain=cdbstest
EOF

diff -u $WORKDIR/debian/cdbs-testsuite/usr/share/applications/multisection.desktop - << EOF || return_fail
[Desktop Entry]
Name=gThumb
GenericName=Image Viewer
X-GNOME-FullName=gThumb Image Viewer
Comment=View and organize your images
Categories=GNOME;GTK;Graphics;Viewer;RasterGraphics;2DGraphics;Photography;
Exec=gthumb %U
Icon=gthumb
Type=Application
X-Ubuntu-Gettext-Domain=cdbstest

X-Ayatana-Desktop-Shortcuts=Compose

[Compose Shortcut Group]
Name=Compose New Image
Exec=gthumb foo:
OnlyShowIn=Messaging Menu

EOF

clean_workdir
return_pass

