import { InventoryPageHelper } from '../cluster/inventory.po';

describe('Inventory page', () => {
  const inventory = new InventoryPageHelper();

  beforeEach(() => {
    cy.login();
    Cypress.Cookies.preserveOnce('token');
    inventory.navigateTo();
  });

  it('should have correct devices', () => {
    cy.fixture('orchestrator/inventory.json').then((hosts) => {
      const totalDiskCount = Cypress._.sumBy(hosts, 'devices.length');
      inventory.getTableCount('total').should('be.eq', totalDiskCount);
      for (const host of hosts) {
        inventory.filterTable('Hostname', host['name']);
        inventory.getTableCount('found').should('be.eq', host.devices.length);
      }
    });
  });

  it('should identify device', () => {
    inventory.identify();
  });
});
