/* cheese-main.c generated by valac 0.20.1.54-6d076, the Vala compiler
 * generated from cheese-main.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cheese-camera.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <cheese-config.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <gst/gst.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <cheese-fileutil.h>
#include <cheese-gtk.h>


#define CHEESE_TYPE_MAIN (cheese_main_get_type ())
#define CHEESE_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN, CheeseMain))
#define CHEESE_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN, CheeseMainClass))
#define CHEESE_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN))
#define CHEESE_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN))
#define CHEESE_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN, CheeseMainClass))

typedef struct _CheeseMain CheeseMain;
typedef struct _CheeseMainClass CheeseMainClass;
typedef struct _CheeseMainPrivate CheeseMainPrivate;

#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;

#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _CheeseMain {
	GtkApplication parent_instance;
	CheeseMainPrivate * priv;
};

struct _CheeseMainClass {
	GtkApplicationClass parent_class;
};

struct _CheeseMainPrivate {
	CheeseCamera* camera;
	CheesePreferencesDialog* preferences_dialog;
};


static gpointer cheese_main_parent_class = NULL;
static gboolean cheese_main_wide;
static gboolean cheese_main_wide = FALSE;
static gchar* cheese_main_device;
static gchar* cheese_main_device = NULL;
static gboolean cheese_main_version;
static gboolean cheese_main_version = FALSE;
static gboolean cheese_main_fullscreen;
static gboolean cheese_main_fullscreen = FALSE;
static CheeseMainWindow* cheese_main_main_window;
static CheeseMainWindow* cheese_main_main_window = NULL;

GType cheese_main_get_type (void) G_GNUC_CONST;
GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CHEESE_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_MAIN, CheeseMainPrivate))
enum  {
	CHEESE_MAIN_DUMMY_PROPERTY
};
GType cheese_main_window_get_type (void) G_GNUC_CONST;
static void cheese_main_on_shoot (CheeseMain* self);
static void _cheese_main_on_shoot_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_on_action_radio (CheeseMain* self, GSimpleAction* action, GVariant* parameter);
static void _cheese_main_on_action_radio_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_on_mode_change (CheeseMain* self, GSimpleAction* action, GVariant* value);
static void _cheese_main_on_mode_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self);
static void cheese_main_on_action_toggle (CheeseMain* self, GSimpleAction* action, GVariant* parameter);
static void _cheese_main_on_action_toggle_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_on_fullscreen_change (CheeseMain* self, GSimpleAction* action, GVariant* value);
static void _cheese_main_on_fullscreen_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self);
static void cheese_main_on_effects_change (CheeseMain* self, GSimpleAction* action, GVariant* value);
static void _cheese_main_on_effects_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self);
static void cheese_main_on_preferences (CheeseMain* self);
static void _cheese_main_on_preferences_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_on_about (CheeseMain* self);
static void _cheese_main_on_about_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_on_help (CheeseMain* self);
static void _cheese_main_on_help_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_main_on_quit (CheeseMain* self);
static void _cheese_main_on_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
CheeseMain* cheese_main_new (const gchar* app_id, GApplicationFlags flags);
CheeseMain* cheese_main_construct (GType object_type, const gchar* app_id, GApplicationFlags flags);
void cheese_main_on_app_activate (CheeseMain* self);
CheeseMainWindow* cheese_main_window_new (GtkApplication* application);
CheeseMainWindow* cheese_main_window_construct (GType object_type, GtkApplication* application);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
void cheese_main_window_set_startup_wide_mode (CheeseMainWindow* self);
void cheese_main_window_set_startup_fullscreen_mode (CheeseMainWindow* self);
static gboolean cheese_main_on_webcam_key_pressed (CheeseMain* self, GdkEventKey* event);
static gboolean _cheese_main_on_webcam_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void cheese_main_setup_camera (CheeseMain* self, const gchar* uri);
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera);
static gboolean cheese_main_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status);
ClutterTexture* cheese_main_window_get_video_preview (CheeseMainWindow* self);
static void cheese_main_on_camera_state_flags_changed (CheeseMain* self, GstState new_state);
static void _cheese_main_on_camera_state_flags_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender, GstState new_state, gpointer self);
void cheese_main_window_set_camera (CheeseMainWindow* self, CheeseCamera* camera);
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self);
static void cheese_main_update_mode (CheeseMain* self, CheeseMediaMode mode);
void cheese_main_window_set_current_mode (CheeseMainWindow* self, CheeseMediaMode mode);
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode);
void cheese_main_window_shoot (CheeseMainWindow* self);
void cheese_main_window_set_fullscreen (gboolean fullscreen, CheeseMainWindow* self);
void cheese_main_window_set_effects (gboolean effects, CheeseMainWindow* self);
void cheese_preferences_dialog_show (CheesePreferencesDialog* self);
static void cheese_main_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);
static void _cheese_main_on_app_activate_g_application_activate (GApplication* _sender, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry CHEESE_MAIN_action_entries[8] = {{"shoot", _cheese_main_on_shoot_gsimple_action_activate_callback}, {"mode", _cheese_main_on_action_radio_gsimple_action_activate_callback, "s", "'photo'", _cheese_main_on_mode_change_gsimple_action_change_state_callback}, {"fullscreen", _cheese_main_on_action_toggle_gsimple_action_activate_callback, NULL, "false", _cheese_main_on_fullscreen_change_gsimple_action_change_state_callback}, {"effects", _cheese_main_on_action_toggle_gsimple_action_activate_callback, NULL, "false", _cheese_main_on_effects_change_gsimple_action_change_state_callback}, {"preferences", _cheese_main_on_preferences_gsimple_action_activate_callback}, {"about", _cheese_main_on_about_gsimple_action_activate_callback}, {"help", _cheese_main_on_help_gsimple_action_activate_callback}, {"quit", _cheese_main_on_quit_gsimple_action_activate_callback}};
static const GOptionEntry CHEESE_MAIN_options[5] = {{"wide", 'w', 0, G_OPTION_ARG_NONE, &cheese_main_wide, "Start in wide mode", NULL}, {"device", 'd', 0, G_OPTION_ARG_FILENAME, &cheese_main_device, "Device to use as a camera", "DEVICE"}, {"version", 'v', 0, G_OPTION_ARG_NONE, &cheese_main_version, "Output version information and exit", NULL}, {"fullscreen", 'f', 0, G_OPTION_ARG_NONE, &cheese_main_fullscreen, "Start in fullscreen mode", NULL}, {NULL}};

static void _cheese_main_on_shoot_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_on_shoot (self);
}


static void _cheese_main_on_action_radio_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_on_action_radio (self, action, parameter);
}


static void _cheese_main_on_mode_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self) {
	cheese_main_on_mode_change (self, action, value);
}


static void _cheese_main_on_action_toggle_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_on_action_toggle (self, action, parameter);
}


static void _cheese_main_on_fullscreen_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self) {
	cheese_main_on_fullscreen_change (self, action, value);
}


static void _cheese_main_on_effects_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self) {
	cheese_main_on_effects_change (self, action, value);
}


static void _cheese_main_on_preferences_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_on_preferences (self);
}


static void _cheese_main_on_about_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_on_about (self);
}


static void _cheese_main_on_help_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_on_help (self);
}


static void _cheese_main_on_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_main_on_quit (self);
}


CheeseMain* cheese_main_construct (GType object_type, const gchar* app_id, GApplicationFlags flags) {
	CheeseMain * self = NULL;
	const gchar* _tmp0_ = NULL;
	GApplicationFlags _tmp1_ = 0;
	g_return_val_if_fail (app_id != NULL, NULL);
	_tmp0_ = app_id;
	_tmp1_ = flags;
	self = (CheeseMain*) g_object_new (object_type, "application-id", _tmp0_, "flags", _tmp1_, NULL);
	return self;
}


CheeseMain* cheese_main_new (const gchar* app_id, GApplicationFlags flags) {
	return cheese_main_construct (CHEESE_TYPE_MAIN, app_id, flags);
}


/**
   * Present the existing main window, or create a new one.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _cheese_main_on_webcam_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = cheese_main_on_webcam_key_pressed (self, event);
	return result;
}


void cheese_main_on_app_activate (CheeseMain* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	if (_tmp0_ != NULL) {
		CheeseMainWindow* _tmp1_ = NULL;
		_tmp1_ = cheese_main_main_window;
		gtk_window_present ((GtkWindow*) _tmp1_);
	} else {
		GtkSettings* gtk_settings = NULL;
		GtkSettings* _tmp2_ = NULL;
		GtkSettings* _tmp3_ = NULL;
		GtkSettings* _tmp4_ = NULL;
		CheeseMainWindow* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GtkIconTheme* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GMenu* menu = NULL;
		GMenu* _tmp11_ = NULL;
		GMenu* section = NULL;
		GMenu* _tmp12_ = NULL;
		GMenu* _tmp13_ = NULL;
		GMenu* _tmp14_ = NULL;
		GMenuItem* item = NULL;
		const gchar* _tmp15_ = NULL;
		GMenuItem* _tmp16_ = NULL;
		GMenuItem* _tmp17_ = NULL;
		GMenu* _tmp18_ = NULL;
		GMenuItem* _tmp19_ = NULL;
		GMenu* _tmp20_ = NULL;
		GMenu* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		GMenu* _tmp23_ = NULL;
		GMenu* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		GMenu* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GMenu* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		GMenu* _tmp30_ = NULL;
		GMenu* _tmp31_ = NULL;
		GMenu* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		GMenuItem* _tmp34_ = NULL;
		GMenuItem* _tmp35_ = NULL;
		GMenu* _tmp36_ = NULL;
		GMenuItem* _tmp37_ = NULL;
		GMenu* _tmp38_ = NULL;
		GMenu* _tmp39_ = NULL;
		GMenu* _tmp40_ = NULL;
		GMenu* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		GMenu* _tmp43_ = NULL;
		GMenu* _tmp44_ = NULL;
		GMenu* _tmp45_ = NULL;
		GMenu* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		GMenu* _tmp48_ = NULL;
		GMenu* _tmp49_ = NULL;
		GMenu* _tmp50_ = NULL;
		GMenu* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		GMenuItem* _tmp54_ = NULL;
		GMenuItem* _tmp55_ = NULL;
		GMenu* _tmp56_ = NULL;
		GMenuItem* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		GMenuItem* _tmp59_ = NULL;
		GMenuItem* _tmp60_ = NULL;
		GMenu* _tmp61_ = NULL;
		GMenuItem* _tmp62_ = NULL;
		GMenu* _tmp63_ = NULL;
		CheeseMainWindow* _tmp64_ = NULL;
		CheeseMainWindow* _tmp65_ = NULL;
		gboolean _tmp66_ = FALSE;
		gboolean _tmp68_ = FALSE;
		CheeseMainWindow* _tmp70_ = NULL;
		CheeseMainWindow* _tmp71_ = NULL;
		CheeseMainWindow* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		CheeseCamera* _tmp74_ = NULL;
		CheesePreferencesDialog* _tmp75_ = NULL;
		_tmp2_ = gtk_settings_get_default ();
		_tmp3_ = _g_object_ref0 (_tmp2_);
		gtk_settings = _tmp3_;
		_tmp4_ = gtk_settings;
		if (_tmp4_ != NULL) {
			GtkSettings* _tmp5_ = NULL;
			_tmp5_ = gtk_settings;
			g_object_set (_tmp5_, "gtk-application-prefer-dark-theme", TRUE, NULL);
		}
		_tmp6_ = cheese_main_window_new ((GtkApplication*) self);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (cheese_main_main_window);
		cheese_main_main_window = _tmp6_;
		g_setenv ("PULSE_PROP_media.role", "production", TRUE);
		_tmp7_ = _ ("Cheese");
		g_set_application_name (_tmp7_);
		gtk_window_set_default_icon_name ("cheese");
		_tmp8_ = gtk_icon_theme_get_default ();
		_tmp9_ = g_build_filename (PACKAGE_DATADIR, "icons", NULL);
		_tmp10_ = _tmp9_;
		gtk_icon_theme_append_search_path (_tmp8_, _tmp10_);
		_g_free0 (_tmp10_);
		g_action_map_add_action_entries ((GActionMap*) self, (const GActionEntry*) CHEESE_MAIN_action_entries, G_N_ELEMENTS (CHEESE_MAIN_action_entries), self);
		_tmp11_ = g_menu_new ();
		menu = _tmp11_;
		_tmp12_ = g_menu_new ();
		section = _tmp12_;
		_tmp13_ = menu;
		_tmp14_ = section;
		g_menu_append_section (_tmp13_, NULL, (GMenuModel*) _tmp14_);
		_tmp15_ = _ ("_Shoot");
		_tmp16_ = g_menu_item_new (_tmp15_, "app.shoot");
		item = _tmp16_;
		_tmp17_ = item;
		g_menu_item_set_attribute (_tmp17_, "accel", "s", "space", NULL);
		_tmp18_ = section;
		_tmp19_ = item;
		g_menu_append_item (_tmp18_, _tmp19_);
		_tmp20_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp20_;
		_tmp21_ = menu;
		_tmp22_ = _ ("Mode:");
		_tmp23_ = section;
		g_menu_append_section (_tmp21_, _tmp22_, (GMenuModel*) _tmp23_);
		_tmp24_ = section;
		_tmp25_ = _ ("_Photo");
		g_menu_append (_tmp24_, _tmp25_, "app.mode::photo");
		_tmp26_ = section;
		_tmp27_ = _ ("_Video");
		g_menu_append (_tmp26_, _tmp27_, "app.mode::video");
		_tmp28_ = section;
		_tmp29_ = _ ("_Burst");
		g_menu_append (_tmp28_, _tmp29_, "app.mode::burst");
		_tmp30_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp30_;
		_tmp31_ = menu;
		_tmp32_ = section;
		g_menu_append_section (_tmp31_, NULL, (GMenuModel*) _tmp32_);
		_tmp33_ = _ ("_Fullscreen");
		_tmp34_ = g_menu_item_new (_tmp33_, "app.fullscreen");
		_g_object_unref0 (item);
		item = _tmp34_;
		_tmp35_ = item;
		g_menu_item_set_attribute (_tmp35_, "accel", "s", "F11", NULL);
		_tmp36_ = section;
		_tmp37_ = item;
		g_menu_append_item (_tmp36_, _tmp37_);
		_tmp38_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp38_;
		_tmp39_ = menu;
		_tmp40_ = section;
		g_menu_append_section (_tmp39_, NULL, (GMenuModel*) _tmp40_);
		_tmp41_ = section;
		_tmp42_ = _ ("_Effects");
		g_menu_append (_tmp41_, _tmp42_, "app.effects");
		_tmp43_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp43_;
		_tmp44_ = menu;
		_tmp45_ = section;
		g_menu_append_section (_tmp44_, NULL, (GMenuModel*) _tmp45_);
		_tmp46_ = section;
		_tmp47_ = _ ("P_references");
		g_menu_append (_tmp46_, _tmp47_, "app.preferences");
		_tmp48_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp48_;
		_tmp49_ = menu;
		_tmp50_ = section;
		g_menu_append_section (_tmp49_, NULL, (GMenuModel*) _tmp50_);
		_tmp51_ = section;
		_tmp52_ = _ ("_About");
		g_menu_append (_tmp51_, _tmp52_, "app.about");
		_tmp53_ = _ ("_Help");
		_tmp54_ = g_menu_item_new (_tmp53_, "app.help");
		_g_object_unref0 (item);
		item = _tmp54_;
		_tmp55_ = item;
		g_menu_item_set_attribute (_tmp55_, "accel", "s", "F1", NULL);
		_tmp56_ = section;
		_tmp57_ = item;
		g_menu_append_item (_tmp56_, _tmp57_);
		_tmp58_ = _ ("_Quit");
		_tmp59_ = g_menu_item_new (_tmp58_, "app.quit");
		_g_object_unref0 (item);
		item = _tmp59_;
		_tmp60_ = item;
		g_menu_item_set_attribute (_tmp60_, "accel", "s", "<Primary>q", NULL);
		_tmp61_ = section;
		_tmp62_ = item;
		g_menu_append_item (_tmp61_, _tmp62_);
		_tmp63_ = menu;
		gtk_application_set_app_menu ((GtkApplication*) self, (GMenuModel*) _tmp63_);
		_tmp64_ = cheese_main_main_window;
		cheese_main_window_setup_ui (_tmp64_);
		_tmp65_ = cheese_main_main_window;
		cheese_main_window_start_thumbview_monitors (_tmp65_);
		_tmp66_ = cheese_main_wide;
		if (_tmp66_) {
			CheeseMainWindow* _tmp67_ = NULL;
			_tmp67_ = cheese_main_main_window;
			cheese_main_window_set_startup_wide_mode (_tmp67_);
		}
		_tmp68_ = cheese_main_fullscreen;
		if (_tmp68_) {
			CheeseMainWindow* _tmp69_ = NULL;
			_tmp69_ = cheese_main_main_window;
			cheese_main_window_set_startup_fullscreen_mode (_tmp69_);
		}
		_tmp70_ = cheese_main_main_window;
		gtk_widget_add_events ((GtkWidget*) _tmp70_, (gint) (GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK));
		_tmp71_ = cheese_main_main_window;
		g_signal_connect_object ((GtkWidget*) _tmp71_, "key-press-event", (GCallback) _cheese_main_on_webcam_key_pressed_gtk_widget_key_press_event, self, 0);
		_tmp72_ = cheese_main_main_window;
		gtk_widget_show ((GtkWidget*) _tmp72_);
		_tmp73_ = cheese_main_device;
		cheese_main_setup_camera (self, _tmp73_);
		_tmp74_ = self->priv->camera;
		_tmp75_ = cheese_preferences_dialog_new (_tmp74_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp75_;
		_g_object_unref0 (item);
		_g_object_unref0 (section);
		_g_object_unref0 (menu);
		_g_object_unref0 (gtk_settings);
	}
}


/**
   * Overridden method of GApplication, to handle the arguments locally.
   *
   * @param arguments the command-line arguments
   * @param exit_status the exit status to return to the OS
   * @return true if the arguments were successfully processed, false otherwise
   */
static gboolean cheese_main_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status) {
	CheeseMain * self;
	gint _vala_exit_status = 0;
	gboolean result = FALSE;
	gchar** local_args = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint local_args_length1 = 0;
	gint _local_args_size_ = 0;
	gint n_args = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	GError * _inner_error_ = NULL;
	self = (CheeseMain*) base;
	{
		g_application_register ((GApplication*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = stdout;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "Error: %s\n", _tmp2_);
		_vala_exit_status = 1;
		result = TRUE;
		_g_error_free0 (e);
		if (exit_status) {
			*exit_status = _vala_exit_status;
		}
		return result;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp3_ = *arguments;
	_tmp3__length1 = _vala_array_length (*arguments);
	local_args = _tmp3_;
	local_args_length1 = _tmp3__length1;
	_local_args_size_ = local_args_length1;
	_tmp4_ = local_args;
	_tmp4__length1 = local_args_length1;
	n_args = _tmp4__length1;
	_tmp5_ = n_args;
	if (_tmp5_ <= 1) {
		gst_init (&local_args_length1, &local_args);
		g_application_activate ((GApplication*) self);
		_vala_exit_status = 0;
	} else {
		gboolean _tmp25_ = FALSE;
		gboolean _tmp27_ = FALSE;
		{
			GOptionContext* context = NULL;
			const gchar* _tmp6_ = NULL;
			GOptionContext* _tmp7_ = NULL;
			GOptionContext* _tmp8_ = NULL;
			GOptionContext* _tmp9_ = NULL;
			GOptionContext* _tmp10_ = NULL;
			GOptionContext* _tmp11_ = NULL;
			GOptionGroup* _tmp12_ = NULL;
			GOptionContext* _tmp13_ = NULL;
			GOptionGroup* _tmp14_ = NULL;
			GOptionContext* _tmp15_ = NULL;
			GOptionGroup* _tmp16_ = NULL;
			GOptionContext* _tmp17_ = NULL;
			_tmp6_ = _ ("- Take photos and videos from your webcam");
			_tmp7_ = g_option_context_new (_tmp6_);
			context = _tmp7_;
			_tmp8_ = context;
			g_option_context_set_translation_domain (_tmp8_, GETTEXT_PACKAGE);
			_tmp9_ = context;
			g_option_context_set_help_enabled (_tmp9_, TRUE);
			_tmp10_ = context;
			g_option_context_add_main_entries (_tmp10_, CHEESE_MAIN_options, NULL);
			_tmp11_ = context;
			_tmp12_ = gtk_get_option_group (TRUE);
			g_option_context_add_group (_tmp11_, _tmp12_);
			_tmp13_ = context;
			_tmp14_ = clutter_get_option_group ();
			g_option_context_add_group (_tmp13_, _tmp14_);
			_tmp15_ = context;
			_tmp16_ = gst_init_get_option_group ();
			g_option_context_add_group (_tmp15_, _tmp16_);
			_tmp17_ = context;
			g_option_context_parse (_tmp17_, &local_args_length1, &local_args, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_option_context_free0 (context);
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch12_g_option_error;
				}
				_g_option_context_free0 (context);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_g_option_context_free0 (context);
		}
		goto __finally12;
		__catch12_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp18_ = NULL;
			GError* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			FILE* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			const gchar* _tmp24_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = stdout;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->message;
			fprintf (_tmp18_, "%s\n", _tmp20_);
			_tmp21_ = stdout;
			_tmp22_ = _ ("Run '%s --help' to see a full list of available command line options.\n");
			_tmp23_ = *arguments;
			_tmp23__length1 = _vala_array_length (*arguments);
			_tmp24_ = _tmp23_[0];
			fprintf (_tmp21_, _tmp22_, _tmp24_);
			_vala_exit_status = 1;
			result = TRUE;
			_g_error_free0 (e);
			if (exit_status) {
				*exit_status = _vala_exit_status;
			}
			return result;
		}
		__finally12:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp25_ = cheese_main_version;
		if (_tmp25_) {
			FILE* _tmp26_ = NULL;
			_tmp26_ = stdout;
			fprintf (_tmp26_, "%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
			_vala_exit_status = 1;
			result = TRUE;
			if (exit_status) {
				*exit_status = _vala_exit_status;
			}
			return result;
		}
		_tmp27_ = g_application_get_is_remote ((GApplication*) self);
		if (_tmp27_) {
			FILE* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			_tmp28_ = stdout;
			_tmp29_ = _ ("Another instance of Cheese is currently running\n");
			fprintf (_tmp28_, "%s", _tmp29_);
			_vala_exit_status = 1;
			result = TRUE;
			if (exit_status) {
				*exit_status = _vala_exit_status;
			}
			return result;
		} else {
			gst_init (&local_args_length1, &local_args);
			g_application_activate ((GApplication*) self);
			_vala_exit_status = 0;
		}
	}
	result = TRUE;
	if (exit_status) {
		*exit_status = _vala_exit_status;
	}
	return result;
}


/**
     * Setup the camera listed in GSettings.
     *
     * @param uri the uri of the device node to setup, or null
     */
static void _cheese_main_on_camera_state_flags_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender, GstState new_state, gpointer self) {
	cheese_main_on_camera_state_flags_changed (self, new_state);
}


void cheese_main_setup_camera (CheeseMain* self, const gchar* uri) {
	GSettings* settings = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* device = NULL;
	gdouble value = 0.0;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp6_ = FALSE;
	ClutterTexture* video_preview = NULL;
	CheeseMainWindow* _tmp11_ = NULL;
	ClutterTexture* _tmp12_ = NULL;
	ClutterTexture* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GSettings* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	CheeseCamera* _tmp19_ = NULL;
	GSettings* _tmp34_ = NULL;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	GSettings* _tmp39_ = NULL;
	gdouble _tmp40_ = 0.0;
	gdouble _tmp41_ = 0.0;
	GSettings* _tmp44_ = NULL;
	gdouble _tmp45_ = 0.0;
	gdouble _tmp46_ = 0.0;
	GSettings* _tmp49_ = NULL;
	gdouble _tmp50_ = 0.0;
	gdouble _tmp51_ = 0.0;
	CheeseCamera* _tmp54_ = NULL;
	CheeseMainWindow* _tmp55_ = NULL;
	CheeseCamera* _tmp56_ = NULL;
	CheeseCamera* _tmp57_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.Cheese");
	settings = _tmp0_;
	_tmp2_ = uri;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = uri;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp7_ = uri;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (device);
		device = _tmp8_;
	} else {
		GSettings* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp9_ = settings;
		_tmp10_ = g_settings_get_string (_tmp9_, "camera");
		_g_free0 (device);
		device = _tmp10_;
	}
	_tmp11_ = cheese_main_main_window;
	_tmp12_ = cheese_main_window_get_video_preview (_tmp11_);
	video_preview = _tmp12_;
	_tmp13_ = video_preview;
	_tmp14_ = device;
	_tmp15_ = settings;
	_tmp16_ = g_settings_get_int (_tmp15_, "photo-x-resolution");
	_tmp17_ = settings;
	_tmp18_ = g_settings_get_int (_tmp17_, "photo-y-resolution");
	_tmp19_ = cheese_camera_new (_tmp13_, _tmp14_, _tmp16_, _tmp18_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp19_;
	{
		CheeseCamera* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp20_ = self->priv->camera;
		_tmp21_ = device;
		cheese_camera_setup (_tmp20_, _tmp21_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* err = NULL;
		ClutterTexture* _tmp22_ = NULL;
		GError* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		GSimpleAction* shoot = NULL;
		GAction* _tmp25_ = NULL;
		GSimpleAction* _tmp26_ = NULL;
		GSimpleAction* effects = NULL;
		GAction* _tmp27_ = NULL;
		GSimpleAction* _tmp28_ = NULL;
		GSimpleAction* mode = NULL;
		GAction* _tmp29_ = NULL;
		GSimpleAction* _tmp30_ = NULL;
		GSimpleAction* _tmp31_ = NULL;
		GSimpleAction* _tmp32_ = NULL;
		GSimpleAction* _tmp33_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = video_preview;
		clutter_actor_hide ((ClutterActor*) _tmp22_);
		_tmp23_ = err;
		_tmp24_ = _tmp23_->message;
		g_warning ("cheese-main.vala:256: Error: %s\n", _tmp24_);
		_tmp25_ = g_action_map_lookup_action ((GActionMap*) self, "shoot");
		_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp25_) : NULL);
		shoot = _tmp26_;
		_tmp27_ = g_action_map_lookup_action ((GActionMap*) self, "effects");
		_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp27_) : NULL);
		effects = _tmp28_;
		_tmp29_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
		_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp29_) : NULL);
		mode = _tmp30_;
		_tmp31_ = shoot;
		g_simple_action_set_enabled (_tmp31_, FALSE);
		_tmp32_ = effects;
		g_simple_action_set_enabled (_tmp32_, FALSE);
		_tmp33_ = mode;
		g_simple_action_set_enabled (_tmp33_, FALSE);
		_g_object_unref0 (mode);
		_g_object_unref0 (effects);
		_g_object_unref0 (shoot);
		_g_error_free0 (err);
		_g_object_unref0 (video_preview);
		_g_free0 (device);
		_g_object_unref0 (settings);
		return;
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (video_preview);
		_g_free0 (device);
		_g_object_unref0 (settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp34_ = settings;
	_tmp35_ = g_settings_get_double (_tmp34_, "brightness");
	value = _tmp35_;
	_tmp36_ = value;
	if (_tmp36_ != 0.0) {
		CheeseCamera* _tmp37_ = NULL;
		gdouble _tmp38_ = 0.0;
		_tmp37_ = self->priv->camera;
		_tmp38_ = value;
		cheese_camera_set_balance_property (_tmp37_, "brightness", _tmp38_);
	}
	_tmp39_ = settings;
	_tmp40_ = g_settings_get_double (_tmp39_, "contrast");
	value = _tmp40_;
	_tmp41_ = value;
	if (_tmp41_ != 1.0) {
		CheeseCamera* _tmp42_ = NULL;
		gdouble _tmp43_ = 0.0;
		_tmp42_ = self->priv->camera;
		_tmp43_ = value;
		cheese_camera_set_balance_property (_tmp42_, "contrast", _tmp43_);
	}
	_tmp44_ = settings;
	_tmp45_ = g_settings_get_double (_tmp44_, "hue");
	value = _tmp45_;
	_tmp46_ = value;
	if (_tmp46_ != 0.0) {
		CheeseCamera* _tmp47_ = NULL;
		gdouble _tmp48_ = 0.0;
		_tmp47_ = self->priv->camera;
		_tmp48_ = value;
		cheese_camera_set_balance_property (_tmp47_, "hue", _tmp48_);
	}
	_tmp49_ = settings;
	_tmp50_ = g_settings_get_double (_tmp49_, "saturation");
	value = _tmp50_;
	_tmp51_ = value;
	if (_tmp51_ != 1.0) {
		CheeseCamera* _tmp52_ = NULL;
		gdouble _tmp53_ = 0.0;
		_tmp52_ = self->priv->camera;
		_tmp53_ = value;
		cheese_camera_set_balance_property (_tmp52_, "saturation", _tmp53_);
	}
	_tmp54_ = self->priv->camera;
	g_signal_connect_object (_tmp54_, "state-flags-changed", (GCallback) _cheese_main_on_camera_state_flags_changed_cheese_camera_state_flags_changed, self, 0);
	_tmp55_ = cheese_main_main_window;
	_tmp56_ = self->priv->camera;
	cheese_main_window_set_camera (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->camera;
	cheese_camera_play (_tmp57_);
	_g_object_unref0 (video_preview);
	_g_free0 (device);
	_g_object_unref0 (settings);
}


/**
     * Handle the webcam take photo button being pressed.
     *
     * @param event the Gdk.KeyEvent
     * @return true to stop other handlers being invoked, false to propagate
     * the event further
     */
static gboolean cheese_main_on_webcam_key_pressed (CheeseMain* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey _tmp1_ = {0};
	GdkModifierType _tmp2_ = 0;
	gboolean _tmp21_ = FALSE;
	GdkEventKey _tmp22_ = {0};
	guint _tmp23_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.state;
	if (_tmp2_ != 0) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		GdkEventKey _tmp7_ = {0};
		GdkModifierType _tmp8_ = 0;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp20_ = FALSE;
		_tmp7_ = *event;
		_tmp8_ = _tmp7_.state;
		if ((_tmp8_ & GDK_CONTROL_MASK) != 0) {
			_tmp6_ = TRUE;
		} else {
			GdkEventKey _tmp9_ = {0};
			GdkModifierType _tmp10_ = 0;
			_tmp9_ = *event;
			_tmp10_ = _tmp9_.state;
			_tmp6_ = (_tmp10_ & GDK_MOD1_MASK) != 0;
		}
		_tmp11_ = _tmp6_;
		if (_tmp11_) {
			_tmp5_ = TRUE;
		} else {
			GdkEventKey _tmp12_ = {0};
			GdkModifierType _tmp13_ = 0;
			_tmp12_ = *event;
			_tmp13_ = _tmp12_.state;
			_tmp5_ = (_tmp13_ & GDK_MOD3_MASK) != 0;
		}
		_tmp14_ = _tmp5_;
		if (_tmp14_) {
			_tmp4_ = TRUE;
		} else {
			GdkEventKey _tmp15_ = {0};
			GdkModifierType _tmp16_ = 0;
			_tmp15_ = *event;
			_tmp16_ = _tmp15_.state;
			_tmp4_ = (_tmp16_ & GDK_MOD4_MASK) != 0;
		}
		_tmp17_ = _tmp4_;
		if (_tmp17_) {
			_tmp3_ = TRUE;
		} else {
			GdkEventKey _tmp18_ = {0};
			GdkModifierType _tmp19_ = 0;
			_tmp18_ = *event;
			_tmp19_ = _tmp18_.state;
			_tmp3_ = (_tmp19_ & GDK_MOD5_MASK) != 0;
		}
		_tmp20_ = _tmp3_;
		_tmp0_ = _tmp20_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp21_ = _tmp0_;
	if (_tmp21_) {
		result = FALSE;
		return result;
	}
	_tmp22_ = *event;
	_tmp23_ = _tmp22_.keyval;
	switch (_tmp23_) {
		case GDK_KEY_WebCam:
		{
			cheese_main_on_shoot (self);
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}


/**
     * Handle the camera state changing.
     *
     * @param new_state the new Cheese.Camera state
     */
static void cheese_main_on_camera_state_flags_changed (CheeseMain* self, GstState new_state) {
	GstState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = new_state;
	switch (_tmp0_) {
		case GST_STATE_PLAYING:
		{
			CheeseMainWindow* _tmp1_ = NULL;
			_tmp1_ = cheese_main_main_window;
			cheese_main_window_camera_state_change_playing (_tmp1_);
			break;
		}
		default:
		{
			break;
		}
	}
}


/**
     * Update the current capture mode in the main window and preferences
     * dialog.
     *
     * @param mode the mode to set
     */
static void cheese_main_update_mode (CheeseMain* self, CheeseMediaMode mode) {
	CheeseMainWindow* _tmp0_ = NULL;
	CheeseMediaMode _tmp1_ = 0;
	CheesePreferencesDialog* _tmp2_ = NULL;
	CheeseMediaMode _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_main_main_window;
	_tmp1_ = mode;
	cheese_main_window_set_current_mode (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->preferences_dialog;
	_tmp3_ = mode;
	cheese_preferences_dialog_set_current_mode (_tmp2_, _tmp3_);
}


/**
     * Handle radio actions by setting the new state.
     *
     * @param action the action which was triggered
     * @param parameter the new value to set on the action
     */
static void cheese_main_on_action_radio (CheeseMain* self, GSimpleAction* action, GVariant* parameter) {
	GSimpleAction* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = parameter;
	g_signal_emit_by_name (_tmp0_, "change-state", _tmp1_);
}


/**
     * Handle toggle actions by toggling the current state.
     *
     * @param action the action which was triggered
     * @param parameter unused
     */
static void cheese_main_on_action_toggle (CheeseMain* self, GSimpleAction* action, GVariant* parameter) {
	GVariant* state = NULL;
	GSimpleAction* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = g_action_get_state ((GAction*) _tmp0_);
	state = _tmp1_;
	_tmp2_ = action;
	_tmp3_ = g_variant_get_boolean (state);
	_tmp4_ = g_variant_new_boolean (!_tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_signal_emit_by_name (_tmp2_, "change-state", _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_g_variant_unref0 (state);
}


/**
     * Handle the shoot action being activated.
     */
static void cheese_main_on_shoot (CheeseMain* self) {
	CheeseMainWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_main_main_window;
	cheese_main_window_shoot (_tmp0_);
}


/**
     * Handle the fullscreen state being changed.
     *
     * @param action the action that emitted the signal
     * @param value the state to switch to
     */
static void cheese_main_on_fullscreen_change (CheeseMain* self, GSimpleAction* action, GVariant* value) {
	GVariant* _tmp0_ = NULL;
	gboolean state = FALSE;
	GVariant* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	CheeseMainWindow* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = value;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = value;
	_tmp2_ = g_variant_get_boolean (_tmp1_);
	state = _tmp2_;
	_tmp3_ = cheese_main_main_window;
	cheese_main_window_set_fullscreen (state, _tmp3_);
	_tmp4_ = action;
	_tmp5_ = value;
	g_simple_action_set_state (_tmp4_, _tmp5_);
}


/**
     * Handle the effects state being changed.
     *
     * @param action the action that emitted the signal
     * @param value the state to switch to
     */
static void cheese_main_on_effects_change (CheeseMain* self, GSimpleAction* action, GVariant* value) {
	GVariant* _tmp0_ = NULL;
	gboolean state = FALSE;
	GVariant* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	CheeseMainWindow* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = value;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = value;
	_tmp2_ = g_variant_get_boolean (_tmp1_);
	state = _tmp2_;
	_tmp3_ = cheese_main_main_window;
	cheese_main_window_set_effects (state, _tmp3_);
	_tmp4_ = action;
	_tmp5_ = value;
	g_simple_action_set_state (_tmp4_, _tmp5_);
}


/**
     * Change the media capture mode (photo, video or burst).
     *
     * @param action the action that emitted the signal
     * @param parameter the mode to switch to, or null
     */
static void cheese_main_on_mode_change (CheeseMain* self, GSimpleAction* action, GVariant* value) {
	GVariant* _tmp0_ = NULL;
	gchar* state = NULL;
	GVariant* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = value;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = value;
	_tmp2_ = g_variant_get_string (_tmp1_, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	state = _tmp3_;
	_tmp4_ = state;
	if (g_strcmp0 (_tmp4_, "photo") == 0) {
		cheese_main_update_mode (self, CHEESE_MEDIA_MODE_PHOTO);
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = state;
		if (g_strcmp0 (_tmp5_, "video") == 0) {
			cheese_main_update_mode (self, CHEESE_MEDIA_MODE_VIDEO);
		} else {
			const gchar* _tmp6_ = NULL;
			_tmp6_ = state;
			if (g_strcmp0 (_tmp6_, "burst") == 0) {
				cheese_main_update_mode (self, CHEESE_MEDIA_MODE_BURST);
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp7_ = action;
	_tmp8_ = value;
	g_simple_action_set_state (_tmp7_, _tmp8_);
	_g_free0 (state);
}


/**
     * Show the preferences dialog.
     */
static void cheese_main_on_preferences (CheeseMain* self) {
	CheesePreferencesDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	cheese_preferences_dialog_show (_tmp0_);
}


/**
     * Show the Cheese help contents.
     */
static void cheese_main_on_help (CheeseMain* self) {
	GdkScreen* screen = NULL;
	CheeseMainWindow* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_main_main_window;
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	screen = _tmp2_;
	{
		guint32 _tmp3_ = 0U;
		_tmp3_ = gtk_get_current_event_time ();
		gtk_show_uri (screen, "help:cheese", _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_message ("cheese-main.vala:471: Error opening help: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
}


/**
     * Show the about dialog.
     */
static void cheese_main_on_about (CheeseMain* self) {
	gchar** artists = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** authors = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar** _tmp34_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar** _tmp38_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	CheeseMainWindow* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Andreas Nilsson <andreas@andreasn.se>");
	_tmp1_ = g_strdup ("Josef Vybíral <josef.vybiral@gmail.com>");
	_tmp2_ = g_strdup ("Kalle Persson <kalle@kallepersson.se>");
	_tmp3_ = g_strdup ("Lapo Calamandrei <calamandrei@gmail.com>");
	_tmp4_ = g_strdup ("Or Dvory <gnudles@nana.co.il>");
	_tmp5_ = g_strdup ("Ulisse Perusin <ulisail@yahoo.it>");
	_tmp6_ = g_new0 (gchar*, 7 + 1);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	_tmp6_[6] = NULL;
	artists = _tmp6_;
	artists_length1 = 7;
	_artists_size_ = artists_length1;
	_tmp7_ = g_strdup ("daniel g. siegel <dgsiegel@gnome.org>");
	_tmp8_ = g_strdup ("Jaap A. Haitsma <jaap@haitsma.org>");
	_tmp9_ = g_strdup ("Filippo Argiolas <fargiolas@gnome.org>");
	_tmp10_ = g_strdup ("Yuvaraj Pandian T <yuvipanda@yuvi.in>");
	_tmp11_ = g_strdup ("Luciana Fujii Pontello <luciana@fujii.eti.br>");
	_tmp12_ = g_strdup ("David King <amigadave@amigadave.com>");
	_tmp13_ = g_strdup ("");
	_tmp14_ = g_strdup ("Aidan Delaney <a.j.delaney@brighton.ac.uk>");
	_tmp15_ = g_strdup ("Alex \"weej\" Jones <alex@weej.com>");
	_tmp16_ = g_strdup ("Andrea Cimitan <andrea.cimitan@gmail.com>");
	_tmp17_ = g_strdup ("Baptiste Mille-Mathias <bmm80@free.fr>");
	_tmp18_ = g_strdup ("Cosimo Cecchi <anarki@lilik.it>");
	_tmp19_ = g_strdup ("Diego Escalante Urrelo <dieguito@gmail.com>");
	_tmp20_ = g_strdup ("Felix Kaser <f.kaser@gmx.net>");
	_tmp21_ = g_strdup ("Gintautas Miliauskas <gintas@akl.lt>");
	_tmp22_ = g_strdup ("Hans de Goede <jwrdegoede@fedoraproject.org>");
	_tmp23_ = g_strdup ("James Liggett <jrliggett@cox.net>");
	_tmp24_ = g_strdup ("Luca Ferretti <elle.uca@libero.it>");
	_tmp25_ = g_strdup ("Mirco \"MacSlow\" Müller <macslow@bangang.de>");
	_tmp26_ = g_strdup ("Patryk Zawadzki <patrys@pld-linux.org>");
	_tmp27_ = g_strdup ("Ryan Zeigler <zeiglerr@gmail.com>");
	_tmp28_ = g_strdup ("Sebastian Keller <sebastian-keller@gmx.de>");
	_tmp29_ = g_strdup ("Steve Magoun <steve.magoun@canonical.com>");
	_tmp30_ = g_strdup ("Thomas Perl <thp@thpinfo.com>");
	_tmp31_ = g_strdup ("Tim Philipp Müller <tim@centricular.net>");
	_tmp32_ = g_strdup ("Todd Eisenberger <teisenberger@gmail.com>");
	_tmp33_ = g_strdup ("Tommi Vainikainen <thv@iki.fi>");
	_tmp34_ = g_new0 (gchar*, 28 + 1);
	_tmp34_[0] = _tmp7_;
	_tmp34_[1] = _tmp8_;
	_tmp34_[2] = _tmp9_;
	_tmp34_[3] = _tmp10_;
	_tmp34_[4] = _tmp11_;
	_tmp34_[5] = _tmp12_;
	_tmp34_[6] = _tmp13_;
	_tmp34_[7] = _tmp14_;
	_tmp34_[8] = _tmp15_;
	_tmp34_[9] = _tmp16_;
	_tmp34_[10] = _tmp17_;
	_tmp34_[11] = _tmp18_;
	_tmp34_[12] = _tmp19_;
	_tmp34_[13] = _tmp20_;
	_tmp34_[14] = _tmp21_;
	_tmp34_[15] = _tmp22_;
	_tmp34_[16] = _tmp23_;
	_tmp34_[17] = _tmp24_;
	_tmp34_[18] = _tmp25_;
	_tmp34_[19] = _tmp26_;
	_tmp34_[20] = _tmp27_;
	_tmp34_[21] = _tmp28_;
	_tmp34_[22] = _tmp29_;
	_tmp34_[23] = _tmp30_;
	_tmp34_[24] = _tmp31_;
	_tmp34_[25] = _tmp32_;
	_tmp34_[26] = _tmp33_;
	_tmp34_[27] = NULL;
	authors = _tmp34_;
	authors_length1 = 28;
	_authors_size_ = authors_length1;
	_tmp35_ = g_strdup ("Joshua Henderson <joshhendo@gmail.com>");
	_tmp36_ = g_strdup ("Jaap A. Haitsma <jaap@haitsma.org>");
	_tmp37_ = g_strdup ("Felix Kaser <f.kaser@gmx.net>");
	_tmp38_ = g_new0 (gchar*, 4 + 1);
	_tmp38_[0] = _tmp35_;
	_tmp38_[1] = _tmp36_;
	_tmp38_[2] = _tmp37_;
	_tmp38_[3] = NULL;
	documenters = _tmp38_;
	documenters_length1 = 4;
	_documenters_size_ = documenters_length1;
	_tmp39_ = cheese_main_main_window;
	_tmp40_ = _ ("Take photos and videos with your webcam, with fun graphical effects");
	_tmp41_ = _ ("Cheese");
	_tmp42_ = _ ("translator-credits");
	_tmp43_ = _ ("Cheese Website");
	gtk_show_about_dialog ((GtkWindow*) _tmp39_, "artists", artists, "authors", authors, "comments", _tmp40_, "copyright", "Copyright © 2007 - 2010 daniel g. siegel <dgsiegel@gnome.org>", "documenters", documenters, "license-type", GTK_LICENSE_GPL_2_0, "logo-icon-name", PACKAGE_TARNAME, "program-name", _tmp41_, "translator-credits", _tmp42_, "website", PACKAGE_URL, "website-label", _tmp43_, "version", PACKAGE_VERSION, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
}


/**
     * Destroy the main window, and shutdown the application, when quitting.
     */
static void cheese_main_on_quit (CheeseMain* self) {
	CheeseMainWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_main_main_window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void cheese_main_class_init (CheeseMainClass * klass) {
	cheese_main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseMainPrivate));
	G_APPLICATION_CLASS (klass)->local_command_line = cheese_main_real_local_command_line;
	G_OBJECT_CLASS (klass)->finalize = cheese_main_finalize;
}


static void cheese_main_instance_init (CheeseMain * self) {
	self->priv = CHEESE_MAIN_GET_PRIVATE (self);
}


static void cheese_main_finalize (GObject* obj) {
	CheeseMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_MAIN, CheeseMain);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->preferences_dialog);
	G_OBJECT_CLASS (cheese_main_parent_class)->finalize (obj);
}


GType cheese_main_get_type (void) {
	static volatile gsize cheese_main_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMain), 0, (GInstanceInitFunc) cheese_main_instance_init, NULL };
		GType cheese_main_type_id;
		cheese_main_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "CheeseMain", &g_define_type_info, 0);
		g_once_init_leave (&cheese_main_type_id__volatile, cheese_main_type_id);
	}
	return cheese_main_type_id__volatile;
}


static void _cheese_main_on_app_activate_g_application_activate (GApplication* _sender, gpointer self) {
	cheese_main_on_app_activate (self);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	CheeseMain* app = NULL;
	CheeseMain* _tmp1_ = NULL;
	CheeseMain* _tmp2_ = NULL;
	CheeseMain* _tmp3_ = NULL;
	gint status = 0;
	CheeseMain* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp6_ = 0;
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = cheese_gtk_init (&args_length1, &args);
	if (!_tmp0_) {
		result = EXIT_FAILURE;
		return result;
	}
	_tmp1_ = cheese_main_new ("org.gnome.Cheese", G_APPLICATION_FLAGS_NONE);
	_g_object_unref0 (app);
	app = _tmp1_;
	_tmp2_ = app;
	_tmp3_ = app;
	g_signal_connect_object ((GApplication*) _tmp2_, "activate", (GCallback) _cheese_main_on_app_activate_g_application_activate, _tmp3_, 0);
	_tmp4_ = app;
	_tmp5_ = args;
	_tmp5__length1 = args_length1;
	_tmp6_ = g_application_run ((GApplication*) _tmp4_, _tmp5__length1, _tmp5_);
	status = _tmp6_;
	result = status;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



