//===- TableGen'erated file -------------------------------------*- C++ -*-===//
//
// DAG Instruction Selector for the ARM target
//
// Automatically generated file, do not edit!
//
//===----------------------------------------------------------------------===//

// *** NOTE: This file is #included into the middle of the target
// *** instruction selector class.  These functions are really methods.


// Predicate functions.
inline bool Predicate_adde_dead_carry(SDNode *N) const {
return !N->hasAnyUseOfValue(1);
}
inline bool Predicate_adde_live_carry(SDNode *N) const {
return N->hasAnyUseOfValue(1);
}
inline bool Predicate_atomic_cmp_swap_16(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_atomic_cmp_swap_32(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_atomic_cmp_swap_64(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;

}
inline bool Predicate_atomic_cmp_swap_8(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_atomic_load_add_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_add_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_add_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_add_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_and_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_and_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_and_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_and_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_max_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_max_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_max_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_max_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_min_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_min_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_min_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_min_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_nand_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_nand_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_nand_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_nand_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_or_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_or_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_or_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_or_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_sub_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_sub_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_sub_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_sub_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_umax_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_umax_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_umax_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_umax_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_umin_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_umin_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_umin_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_umin_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_xor_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_xor_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_xor_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_xor_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_swap_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_swap_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_swap_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_swap_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_bf_inv_mask_imm(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  uint32_t v = (uint32_t)N->getZExtValue();
  if (v == 0xffffffff)
    return 0;
  // there can be 1's on either or both "outsides", all the "inside"
  // bits must be 0's
  unsigned int lsb = 0, msb = 31;
  while (v & (1 << msb)) --msb;
  while (v & (1 << lsb)) ++lsb;
  for (unsigned int i = lsb; i <= msb; ++i) {
    if (v & (1 << i))
      return 0;
  }
  return 1;

}
inline bool Predicate_cvtff(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_FF;
    
}
inline bool Predicate_cvtfs(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_FS;
    
}
inline bool Predicate_cvtfu(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_FU;
    
}
inline bool Predicate_cvtsf(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_SF;
    
}
inline bool Predicate_cvtss(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_SS;
    
}
inline bool Predicate_cvtsu(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_SU;
    
}
inline bool Predicate_cvtuf(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_UF;
    
}
inline bool Predicate_cvtus(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_US;
    
}
inline bool Predicate_cvtuu(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_UU;
    
}
inline bool Predicate_extload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::EXTLOAD;

}
inline bool Predicate_extloadf32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_extloadf64(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::f64;

}
inline bool Predicate_extloadi1(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_extloadi16(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_extloadi32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_extloadi8(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_imm0_255(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (uint32_t)N->getZExtValue() < 256;

}
inline bool Predicate_imm0_255_comp(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return ~((uint32_t)N->getZExtValue()) < 256;

}
inline bool Predicate_imm0_255_neg(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (uint32_t)(-N->getZExtValue()) < 255;

}
inline bool Predicate_imm0_31(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (int32_t)N->getZExtValue() < 32;

}
inline bool Predicate_imm0_4095(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (uint32_t)N->getZExtValue() < 4096;

}
inline bool Predicate_imm0_4095_neg(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

 return (uint32_t)(-N->getZExtValue()) < 4096;

}
inline bool Predicate_imm0_65535(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (uint32_t)N->getZExtValue() < 65536;

}
inline bool Predicate_imm0_7(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (uint32_t)N->getZExtValue() < 8;

}
inline bool Predicate_imm0_7_neg(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (uint32_t)-N->getZExtValue() < 8;

}
inline bool Predicate_imm16_31(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (int32_t)N->getZExtValue() >= 16 && (int32_t)N->getZExtValue() < 32;

}
inline bool Predicate_imm1_15(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (int32_t)N->getZExtValue() >= 1 && (int32_t)N->getZExtValue() < 16;

}
inline bool Predicate_imm1_31(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (int32_t)N->getZExtValue() >= 1 && (int32_t)N->getZExtValue() < 32;

}
inline bool Predicate_imm8_255(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return (uint32_t)N->getZExtValue() >= 8 && (uint32_t)N->getZExtValue() < 256;

}
inline bool Predicate_imm8_255_neg(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  unsigned Val = -N->getZExtValue();
  return Val >= 8 && Val < 256;

}
inline bool Predicate_immAllOnesV(SDNode *N) const {

  return ISD::isBuildVectorAllOnes(N);

}
inline bool Predicate_immAllOnesV_bc(SDNode *N) const {

  return ISD::isBuildVectorAllOnes(N);

}
inline bool Predicate_immAllZerosV(SDNode *N) const {

  return ISD::isBuildVectorAllZeros(N);

}
inline bool Predicate_immAllZerosV_bc(SDNode *N) const {

  return ISD::isBuildVectorAllZeros(N);

}
inline bool Predicate_istore(SDNode *N) const {

  return !cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_itruncstore(SDNode *N) const {

  return cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_lo16AllZero(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  // Returns true if all low 16-bits are 0.
  return (((uint32_t)N->getZExtValue()) & 0xFFFFUL) == 0;

}
inline bool Predicate_load(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::NON_EXTLOAD;

}
inline bool Predicate_post_store(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::POST_INC || AM == ISD::POST_DEC;

}
inline bool Predicate_post_truncst(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::POST_INC || AM == ISD::POST_DEC;

}
inline bool Predicate_post_truncstf32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_post_truncsti1(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_post_truncsti16(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_post_truncsti32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_post_truncsti8(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_pre_store(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::PRE_INC || AM == ISD::PRE_DEC;

}
inline bool Predicate_pre_truncst(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::PRE_INC || AM == ISD::PRE_DEC;

}
inline bool Predicate_pre_truncstf32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_pre_truncsti1(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_pre_truncsti16(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_pre_truncsti32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_pre_truncsti8(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_rot_imm(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  int32_t v = (int32_t)N->getZExtValue();
  return v == 8 || v == 16 || v == 24;

}
inline bool Predicate_sext_16_node(SDNode *N) const {

  return CurDAG->ComputeNumSignBits(SDValue(N,0)) >= 17;

}
inline bool Predicate_sextload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::SEXTLOAD;

}
inline bool Predicate_sextloadi1(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_sextloadi16(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_sextloadi32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_sextloadi8(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_so_imm(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

      return ARM_AM::getSOImmVal(N->getZExtValue()) != -1;
    
}
inline bool Predicate_so_imm2part(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

      return ARM_AM::isSOImmTwoPartVal((unsigned)N->getZExtValue());
    
}
inline bool Predicate_so_imm_neg(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

    return ARM_AM::getSOImmVal(-(int)N->getZExtValue()) != -1;
  
}
inline bool Predicate_so_imm_not(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

    return ARM_AM::getSOImmVal(~(int)N->getZExtValue()) != -1;
  
}
inline bool Predicate_so_neg_imm2part(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

      return ARM_AM::isSOImmTwoPartVal(-(int)N->getZExtValue());
    
}
inline bool Predicate_store(SDNode *N) const {

  return !cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_sube_dead_carry(SDNode *N) const {
return !N->hasAnyUseOfValue(1);
}
inline bool Predicate_sube_live_carry(SDNode *N) const {
return N->hasAnyUseOfValue(1);
}
inline bool Predicate_t2_so_imm(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return ARM_AM::getT2SOImmVal((uint32_t)N->getZExtValue()) != -1;

}
inline bool Predicate_t2_so_imm2part(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

      return ARM_AM::isT2SOImmTwoPartVal((unsigned)N->getZExtValue());
    
}
inline bool Predicate_t2_so_imm_neg(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return ARM_AM::getT2SOImmVal(-((int)N->getZExtValue())) != -1;

}
inline bool Predicate_t2_so_imm_not(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return ARM_AM::getT2SOImmVal(~((uint32_t)N->getZExtValue())) != -1;

}
inline bool Predicate_t2_so_neg_imm2part(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

      return ARM_AM::isT2SOImmTwoPartVal(-(int)N->getZExtValue());
    
}
inline bool Predicate_thumb_immshifted(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return ARM_AM::isThumbImmShiftedVal((unsigned)N->getZExtValue());

}
inline bool Predicate_truncstore(SDNode *N) const {

  return cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_truncstoref32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_truncstoref64(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f64;

}
inline bool Predicate_truncstorei16(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_truncstorei32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_truncstorei8(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_unindexedload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getAddressingMode() == ISD::UNINDEXED;

}
inline bool Predicate_unindexedstore(SDNode *N) const {

  return cast<StoreSDNode>(N)->getAddressingMode() == ISD::UNINDEXED;

}
inline bool Predicate_vfp_f32imm(SDNode *inN) const {
  ConstantFPSDNode *N = cast<ConstantFPSDNode>(inN);

      return ARM::getVFPf32Imm(N->getValueAPF()) != -1;
    
}
inline bool Predicate_vfp_f64imm(SDNode *inN) const {
  ConstantFPSDNode *N = cast<ConstantFPSDNode>(inN);

      return ARM::getVFPf64Imm(N->getValueAPF()) != -1;
    
}
inline bool Predicate_vmovImm16(SDNode *N) const {

  return ARM::getVMOVImm(N, 2, *CurDAG).getNode() != 0;

}
inline bool Predicate_vmovImm32(SDNode *N) const {

  return ARM::getVMOVImm(N, 4, *CurDAG).getNode() != 0;

}
inline bool Predicate_vmovImm64(SDNode *N) const {

  return ARM::getVMOVImm(N, 8, *CurDAG).getNode() != 0;

}
inline bool Predicate_vmovImm8(SDNode *N) const {

  return ARM::getVMOVImm(N, 1, *CurDAG).getNode() != 0;

}
inline bool Predicate_vtFP(SDNode *inN) const {
  VTSDNode *N = cast<VTSDNode>(inN);
 return N->getVT().isFloatingPoint(); 
}
inline bool Predicate_vtInt(SDNode *inN) const {
  VTSDNode *N = cast<VTSDNode>(inN);
 return N->getVT().isInteger(); 
}
inline bool Predicate_zextload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::ZEXTLOAD;

}
inline bool Predicate_zextloadi1(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_zextloadi16(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_zextloadi32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_zextloadi8(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

}


// The main instruction selector code.
SDNode *SelectCode(SDNode *N) {
  // Opcodes are emitted as 2 bytes, TARGET_OPCODE handles this.
  #define TARGET_OPCODE(X) X & 255, unsigned(X) >> 8
  static const unsigned char MatcherTable[] = {
          OPC_SwitchOpcode , 94|128,83,  ISD::OR,
            OPC_Scope, 27|128,59, 
              OPC_MoveChild, 0,
              OPC_Scope, 80|128,8, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 8, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::OR,
                OPC_MoveChild, 0,
                OPC_Scope, 12|128,1, 
                  OPC_CheckAndImm, 0|128,126|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 18, 
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  18, 
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  18, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                102|128,3, 
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 95, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                44|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 69, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  69, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                45|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 70, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  70, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                99, 
                  OPC_CheckAndImm, 0|128,126|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                      1, MVT::i32, 3, 0, 1, 2, 
                0, 
              75|128,10, 
                OPC_CheckOpcode, ISD::OR,
                OPC_MoveChild, 0,
                OPC_Scope, 56|128,5, 
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 114, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                86|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 92, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  92, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                87|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 93, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  93, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                88|128,1, 
                  OPC_CheckAndImm, 0|128,126|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 94, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  94, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                0, 
              66|128,7, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 8, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::OR,
                OPC_MoveChild, 0,
                OPC_Scope, 102|128,3, 
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 95, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                44|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 69, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  69, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                45|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 70, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  70, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                99, 
                  OPC_CheckAndImm, 0|128,126|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                      1, MVT::i32, 3, 0, 1, 2, 
                0, 
              75|128,10, 
                OPC_CheckOpcode, ISD::OR,
                OPC_MoveChild, 0,
                OPC_Scope, 56|128,5, 
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 114, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                86|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 92, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  92, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                87|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 93, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  93, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                88|128,1, 
                  OPC_CheckAndImm, 0|128,126|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 94, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  94, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                0, 
              66|128,7, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 8, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::OR,
                OPC_MoveChild, 0,
                OPC_Scope, 102|128,3, 
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 95, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  95, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                44|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 69, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  69, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                45|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 70, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  70, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                99, 
                  OPC_CheckAndImm, 0|128,126|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                      1, MVT::i32, 3, 0, 1, 2, 
                0, 
              75|128,10, 
                OPC_CheckOpcode, ISD::OR,
                OPC_MoveChild, 0,
                OPC_Scope, 56|128,5, 
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 114, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  114, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                86|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 92, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  92, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                87|128,1, 
                  OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 93, 
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  93, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,126|128,3, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                88|128,1, 
                  OPC_CheckAndImm, 0|128,126|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::OR,
                  OPC_MoveChild, 0,
                  OPC_Scope, 94, 
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  94, 
                    OPC_CheckAndImm, 0|128,0|128,0|128,120|128,15, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,7, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 127|128,1, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRL,
                    OPC_MoveChild, 0,
                    OPC_CheckSame, 0,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 8, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REV16), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                0, 
              20|128,1, 
                OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 63,  ISD::SRA,
                  OPC_RecordChild0,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 0,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 22, 
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitConvertToTarget, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHTB), 0,
                        1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                  22, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitConvertToTarget, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHTB), 0,
                        1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                  0, 
                63,  ISD::SRL,
                  OPC_RecordChild0,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 1,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 22, 
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitConvertToTarget, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHTB), 0,
                        1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                  22, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitConvertToTarget, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHTB), 0,
                        1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                  0, 
                0, 
              110|128,1, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_Scope, 26|128,1, 
                  OPC_MoveChild, 0,
                  OPC_SwitchOpcode , 73,  ISD::SRA,
                    OPC_RecordChild0,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckPredicate, 0,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                    OPC_RecordChild0,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_Scope, 22, 
                      OPC_CheckPatternPredicate, 0,
                      OPC_EmitConvertToTarget, 1,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHTB), 0,
                          1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                    22, 
                      OPC_CheckPatternPredicate, 2,
                      OPC_EmitConvertToTarget, 1,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHTB), 0,
                          1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                    0, 
                  73,  ISD::SRL,
                    OPC_RecordChild0,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckPredicate, 1,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                    OPC_RecordChild0,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_Scope, 22, 
                      OPC_CheckPatternPredicate, 2,
                      OPC_EmitConvertToTarget, 1,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHTB), 0,
                          1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                    22, 
                      OPC_CheckPatternPredicate, 0,
                      OPC_EmitConvertToTarget, 1,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHTB), 0,
                          1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                    0, 
                  0, 
                75, 
                  OPC_RecordChild0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 22, 
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitConvertToTarget, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHBT), 0,
                        1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                  22, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitConvertToTarget, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHBT), 0,
                        1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                  0, 
                0, 
              79, 
                OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHBT), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                22, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHBT), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                0, 
              0, 
            50, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORNrs), 0,
                  1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
            115|128,14, 
              OPC_MoveChild, 0,
              OPC_Scope, 48, 
                OPC_CheckOpcode, ISD::XOR,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORNrs), 0,
                    1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
              41, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHBT), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              46, 
                OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 16, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHTB), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              41, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHBT), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              81, 
                OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_Scope, 36, 
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 16, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHTB), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                31, 
                  OPC_CheckAndImm, 127|128,127|128,3, 
                  OPC_RecordChild0,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHBT), 0,
                      1, MVT::i32, 5, 1, 0, 2, 3, 4, 
                0, 
              46, 
                OPC_CheckOpcode, ISD::SRL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 16, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHTB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              41, 
                OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 0, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHBT), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              46, 
                OPC_CheckOpcode, ISD::SRL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckAndImm, 0|128,0|128,124|128,127|128,15, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 16, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHTB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              72, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 0,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHBT), 0,
                      1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                22, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHBT), 0,
                      1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                0, 
              72, 
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 0,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2PKHBT), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                22, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::PKHBT), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                0, 
              36|128,10, 
                OPC_CheckOpcode, ISD::AND,
                OPC_Scope, 9|128,4, 
                  OPC_RecordChild0,
                  OPC_Scope, 98|128,2, 
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::AND,
                    OPC_Scope, 103, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::XOR,
                      OPC_MoveChild, 0,
                      OPC_Scope, 58, 
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_SwitchType , 20,  MVT::v2i32,
                          OPC_CheckPatternPredicate, 3,
                          OPC_EmitInteger, MVT::i32, 14, 
                          OPC_EmitRegister, MVT::i32, 0 ,
                          OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                              1, MVT::v2i32, 5, 1, 0, 2, 3, 4, 
                        20,  MVT::v4i32,
                          OPC_CheckPatternPredicate, 3,
                          OPC_EmitInteger, MVT::i32, 14, 
                          OPC_EmitRegister, MVT::i32, 0 ,
                          OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                              1, MVT::v4i32, 5, 1, 0, 2, 3, 4, 
                        0, 
                      34, 
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 1, 0, 2, 3, 4, 
                      0, 
                    80, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::XOR,
                      OPC_MoveChild, 0,
                      OPC_Scope, 35, 
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 1, 0, 2, 3, 4, 
                      35, 
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 1, 0, 2, 3, 4, 
                      0, 
                    79, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::XOR,
                      OPC_MoveChild, 0,
                      OPC_Scope, 34, 
                        OPC_CheckSame, 0,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 0, 1, 2, 3, 4, 
                      34, 
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 0,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 0, 1, 2, 3, 4, 
                      0, 
                    80, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::XOR,
                      OPC_MoveChild, 0,
                      OPC_Scope, 35, 
                        OPC_CheckSame, 0,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 0, 1, 2, 3, 4, 
                      35, 
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 0,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 0, 1, 2, 3, 4, 
                      0, 
                    0, 
                  32|128,1, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::XOR,
                    OPC_Scope, 76, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::BIT_CONVERT,
                      OPC_CheckPredicate, 2,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::AND,
                      OPC_Scope, 29, 
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 1, 2, 0, 3, 4, 
                      29, 
                        OPC_MoveChild, 0,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 1, 2, 0, 3, 4, 
                      0, 
                    76, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::BIT_CONVERT,
                      OPC_CheckPredicate, 2,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::AND,
                      OPC_Scope, 29, 
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 1, 2, 0, 3, 4, 
                      29, 
                        OPC_MoveChild, 0,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                            1, MVT::v2i32, 5, 1, 2, 0, 3, 4, 
                      0, 
                    0, 
                  0, 
                34|128,1, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::XOR,
                  OPC_Scope, 77, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_CheckPredicate, 2,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::AND,
                    OPC_Scope, 29, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckSame, 0,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v2i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                          1, MVT::v2i32, 5, 0, 2, 1, 3, 4, 
                    29, 
                      OPC_MoveChild, 0,
                      OPC_CheckSame, 0,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v2i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                          1, MVT::v2i32, 5, 0, 2, 1, 3, 4, 
                    0, 
                  77, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_CheckPredicate, 2,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::AND,
                    OPC_Scope, 29, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckSame, 0,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v2i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                          1, MVT::v2i32, 5, 0, 2, 1, 3, 4, 
                    29, 
                      OPC_MoveChild, 0,
                      OPC_CheckSame, 0,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v2i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLd), 0,
                          1, MVT::v2i32, 5, 0, 2, 1, 3, 4, 
                    0, 
                  0, 
                75|128,3, 
                  OPC_RecordChild0,
                  OPC_Scope, 36|128,2, 
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::AND,
                    OPC_Scope, 41, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::XOR,
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::BIT_CONVERT,
                      OPC_CheckPredicate, 2,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckSame, 1,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v4i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                          1, MVT::v4i32, 5, 1, 0, 2, 3, 4, 
                    80, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::XOR,
                      OPC_MoveChild, 0,
                      OPC_Scope, 35, 
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v4i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                            1, MVT::v4i32, 5, 1, 0, 2, 3, 4, 
                      35, 
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v4i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                            1, MVT::v4i32, 5, 1, 0, 2, 3, 4, 
                      0, 
                    79, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::XOR,
                      OPC_MoveChild, 0,
                      OPC_Scope, 34, 
                        OPC_CheckSame, 0,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v4i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                            1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                      34, 
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 0,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v4i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                            1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                      0, 
                    80, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::XOR,
                      OPC_MoveChild, 0,
                      OPC_Scope, 35, 
                        OPC_CheckSame, 0,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v4i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                            1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                      35, 
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_CheckPredicate, 2,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 0,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v4i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                            1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                      0, 
                    0, 
                  32|128,1, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::XOR,
                    OPC_Scope, 76, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::BIT_CONVERT,
                      OPC_CheckPredicate, 2,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::AND,
                      OPC_Scope, 29, 
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v4i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                            1, MVT::v4i32, 5, 1, 2, 0, 3, 4, 
                      29, 
                        OPC_MoveChild, 0,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v4i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                            1, MVT::v4i32, 5, 1, 2, 0, 3, 4, 
                      0, 
                    76, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::BIT_CONVERT,
                      OPC_CheckPredicate, 2,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::AND,
                      OPC_Scope, 29, 
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v4i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                            1, MVT::v4i32, 5, 1, 2, 0, 3, 4, 
                      29, 
                        OPC_MoveChild, 0,
                        OPC_CheckSame, 1,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v4i32,
                        OPC_CheckPatternPredicate, 3,
                        OPC_EmitInteger, MVT::i32, 14, 
                        OPC_EmitRegister, MVT::i32, 0 ,
                        OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                            1, MVT::v4i32, 5, 1, 2, 0, 3, 4, 
                      0, 
                    0, 
                  0, 
                34|128,1, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::XOR,
                  OPC_Scope, 77, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_CheckPredicate, 2,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::AND,
                    OPC_Scope, 29, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckSame, 0,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v4i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                          1, MVT::v4i32, 5, 0, 2, 1, 3, 4, 
                    29, 
                      OPC_MoveChild, 0,
                      OPC_CheckSame, 0,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v4i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                          1, MVT::v4i32, 5, 0, 2, 1, 3, 4, 
                    0, 
                  77, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_CheckPredicate, 2,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::AND,
                    OPC_Scope, 29, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckSame, 0,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v4i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                          1, MVT::v4i32, 5, 0, 2, 1, 3, 4, 
                    29, 
                      OPC_MoveChild, 0,
                      OPC_CheckSame, 0,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v4i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBSLq), 0,
                          1, MVT::v4i32, 5, 0, 2, 1, 3, 4, 
                    0, 
                  0, 
                0, 
              40, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 0, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::MOVTi16), 0,
                    1, MVT::i32, 4, 0, 3, 4, 5, 
              0, 
            32, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::ORRrs), 0,
                  1, MVT::i32, 7, 0, 2, 3, 4, 5, 6, 7, 
            42, 
              OPC_MoveChild, 0,
              OPC_CheckAndImm, 127|128,127|128,3, 
              OPC_RecordChild0,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 3,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 0, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MOVTi16), 0,
                  1, MVT::i32, 4, 0, 3, 4, 5, 
            17|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 54, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::XOR,
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORNri), 0,
                    1, MVT::i32, 5, 0, 2, 3, 4, 5, 
              31, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::ORRrs), 0,
                    1, MVT::i32, 7, 1, 2, 3, 4, 5, 6, 7, 
              54, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::XOR,
                OPC_MoveChild, 0,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORNri), 0,
                    1, MVT::i32, 5, 0, 2, 3, 4, 5, 
              0, 
            110, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 51, 
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORNri), 0,
                    1, MVT::i32, 5, 1, 2, 3, 4, 5, 
              51, 
                OPC_MoveChild, 0,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORNri), 0,
                    1, MVT::i32, 5, 1, 2, 3, 4, 5, 
              0, 
            109, 
              OPC_RecordChild0,
              OPC_Scope, 59, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_Scope, 25, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORRrs), 0,
                      1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
                25, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORRrs), 0,
                      1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
                0, 
              45, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::XOR,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORNrr), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              0, 
            46, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORNrr), 0,
                  1, MVT::i32, 5, 1, 0, 2, 3, 4, 
            92, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 53, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_SwitchType , 19,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VORNd), 0,
                      1, MVT::v2i32, 4, 0, 1, 2, 3, 
                19,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VORNq), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                0, 
              30, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VORNd), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              0, 
            70, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 31, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VORNd), 0,
                    1, MVT::v2i32, 4, 1, 0, 2, 3, 
              31, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VORNd), 0,
                    1, MVT::v2i32, 4, 1, 0, 2, 3, 
              0, 
            35, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_CheckPredicate, 2,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VORNq), 0,
                  1, MVT::v4i32, 4, 0, 1, 2, 3, 
            70, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 31, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VORNq), 0,
                    1, MVT::v4i32, 4, 1, 0, 2, 3, 
              31, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VORNq), 0,
                    1, MVT::v4i32, 4, 1, 0, 2, 3, 
              0, 
            61, 
              OPC_CheckOrImm, 0|128,0|128,124|128,127|128,15, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 24, 
                OPC_CheckPatternPredicate, 4,
                OPC_EmitInteger, MVT::i32, 127|128,127|128,3, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::MOVTi16), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              24, 
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 127|128,127|128,3, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MOVTi16), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              0, 
            93|128,2, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 94|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 30, 
                  OPC_CheckPredicate, 5,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ORRri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                30, 
                  OPC_CheckPredicate, 4,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORRri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                33, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 1, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORNri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                59, 
                  OPC_CheckPredicate, 7,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 2, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::ORRri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 3, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ORRri), 0,
                      1, MVT::i32, 5, 7, 9, 10, 11, 12, 
                59, 
                  OPC_CheckPredicate, 8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 4, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::t2ORRri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 5, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORRri), 0,
                      1, MVT::i32, 5, 7, 9, 10, 11, 12, 
                0, 
              76, 
                OPC_CheckType, MVT::i32,
                OPC_Scope, 23, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ORRrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tORR), 0,
                      1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ORRrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                0, 
              21, 
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VORRd), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              21, 
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VORRq), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              0, 
            0, 
          30|128,71,  ISD::ADD,
            OPC_Scope, 94, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SHL,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SHL,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_Scope, 12, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABB), 0,
                    1, MVT::i32, 5, 1, 2, 0, 3, 4, 
              12, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABB), 0,
                    1, MVT::i32, 5, 2, 1, 0, 3, 4, 
              0, 
            94, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SHL,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SHL,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_Scope, 12, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABB), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              12, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            59|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_Scope, 44, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::ROTR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTABrr_rot), 0,
                    1, MVT::i32, 5, 0, 1, 3, 4, 5, 
              45, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::ROTR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTAHrr_rot), 0,
                    1, MVT::i32, 5, 0, 1, 3, 4, 5, 
              44, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::ROTR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTABrr_rot), 0,
                    1, MVT::i32, 5, 0, 1, 3, 4, 5, 
              45, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::ROTR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTAHrr_rot), 0,
                    1, MVT::i32, 5, 0, 1, 3, 4, 5, 
              0, 
            62|128,1, 
              OPC_MoveChild, 0,
              OPC_Scope, 45, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::ROTR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTABrr_rot), 0,
                    1, MVT::i32, 5, 2, 0, 3, 4, 5, 
              46, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::ROTR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTAHrr_rot), 0,
                    1, MVT::i32, 5, 2, 0, 3, 4, 5, 
              45, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::ROTR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTABrr_rot), 0,
                    1, MVT::i32, 5, 2, 0, 3, 4, 5, 
              46, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::ROTR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTAHrr_rot), 0,
                    1, MVT::i32, 5, 2, 0, 3, 4, 5, 
              0, 
            81|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 10|128,1,  ISD::MUL,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRA,
                OPC_Scope, 57, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::SRA,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                      1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                73, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::SRA,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_Scope, 12, 
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                        1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                  12, 
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                        1, MVT::i32, 5, 2, 1, 0, 3, 4, 
                  0, 
                0, 
              61,  ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::MUL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                    1, MVT::i32, 5, 1, 2, 0, 3, 4, 
              0, 
            0|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_Scope, 58, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              58, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            66, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SHL,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            0|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_Scope, 58, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              58, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            66, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SHL,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            0|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 58, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              58, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            115, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_Scope, 26, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTABrr), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              27, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTAHrr), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              26, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTABrr), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              27, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTAHrr), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              0, 
            118, 
              OPC_MoveChild, 0,
              OPC_Scope, 27, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTABrr), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              28, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTAHrr), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              27, 
                OPC_CheckAndImm, 127|128,1, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTABrr), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              28, 
                OPC_CheckAndImm, 127|128,127|128,3, 
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTAHrr), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              0, 
            48|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 94,  ISD::MUL,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 20, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATT), 0,
                      1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                20, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLATT), 0,
                      1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                20, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATT), 0,
                      1, MVT::i32, 5, 2, 1, 0, 3, 4, 
                0, 
              73,  ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::MUL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 20, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWT), 0,
                      1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                20, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLAWT), 0,
                      1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                0, 
              0, 
            70, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_Scope, 12, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATT), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              12, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATT), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            54, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWT), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            104, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 46, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWT), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              46, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWT), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            54, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLATT), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            70, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_Scope, 12, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLATT), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              12, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLATT), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            54, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLAWT), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            104, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 46, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLAWT), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              46, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLAWT), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            116|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 35|128,1,  ISD::MUL,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 67,  ISD::SIGN_EXTEND_INREG,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckValueType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::SRA,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 20, 
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                        1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                  20, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLABT), 0,
                        1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                  0, 
                88,  ISD::SRA,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckValueType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 20, 
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                        1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                  20, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLATB), 0,
                        1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                  20, 
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                        1, MVT::i32, 5, 2, 1, 0, 3, 4, 
                  0, 
                0, 
              71,  ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::MUL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 20, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                      1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                20, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLAWB), 0,
                      1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                0, 
              0, 
            100, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 44,  ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              44,  ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            52, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            100, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 44,  ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              44,  ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            52, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            100, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 44, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              44, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            52, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLABT), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            100, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 44,  ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLABT), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              44,  ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLABT), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            52, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLATB), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            100, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 44,  ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLATB), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              44,  ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLATB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            52, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLAWB), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            100, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 44, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLAWB), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              44, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLAWB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            126|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 31, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADDrs), 0,
                    1, MVT::i32, 7, 0, 2, 3, 4, 5, 6, 7, 
              10|128,1, 
                OPC_MoveChild, 1,
                OPC_SwitchOpcode , 88,  ISD::MUL,
                  OPC_Scope, 42, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 0,
                    OPC_CheckPredicate, 10,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::SRA,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 16, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                        1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                  42, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SRA,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 16, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckPredicate, 10,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                        1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                  0, 
                42,  ISD::SRA,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::MUL,
                  OPC_RecordChild0,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckPredicate, 10,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                      1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                0, 
              31, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADDrs), 0,
                    1, MVT::i32, 7, 1, 2, 3, 4, 5, 6, 7, 
              46, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::MUL,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                    1, MVT::i32, 5, 2, 1, 0, 3, 4, 
              0, 
            94, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 43, 
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              43, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABT), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            47, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_RecordChild0,
              OPC_MoveChild, 0,
              OPC_CheckPredicate, 10,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            94, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 43, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              43, 
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLATB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            47, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_RecordChild0,
              OPC_MoveChild, 0,
              OPC_CheckPredicate, 10,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                  1, MVT::i32, 5, 2, 1, 0, 3, 4, 
            89, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_RecordChild0,
              OPC_Scope, 38, 
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              38, 
                OPC_MoveChild, 0,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLAWB), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            7|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::ROTR,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_Scope, 54, 
                OPC_CheckValueType, MVT::i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTABrr_rot), 0,
                      1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                22, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTABrr_rot), 0,
                      1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                0, 
              54, 
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTAHrr_rot), 0,
                      1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                22, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTAHrr_rot), 0,
                      1, MVT::i32, 5, 0, 1, 3, 4, 5, 
                0, 
              0, 
            8|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::ROTR,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_Scope, 55, 
                OPC_CheckValueType, MVT::i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTABrr_rot), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                22, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTABrr_rot), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                0, 
              55, 
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTAHrr_rot), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                22, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTAHrr_rot), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                0, 
              0, 
            18|128,2, 
              OPC_RecordChild0,
              OPC_Scope, 49, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::MUL,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABB), 0,
                    1, MVT::i32, 5, 1, 2, 0, 3, 4, 
              30, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADDrs), 0,
                    1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
              60|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::MUL,
                OPC_Scope, 45, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckValueType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckValueType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLABB), 0,
                      1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                6|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_Scope, 62, 
                    OPC_CheckChild0Type, MVT::v4i16,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_SwitchType , 23,  MVT::v4i16,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i16), 0,
                          1, MVT::v4i16, 6, 0, 1, 2, 4, 5, 6, 
                    23,  MVT::v8i16,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv8i16), 0,
                          1, MVT::v8i16, 6, 0, 1, 2, 4, 5, 6, 
                    0, 
                  62, 
                    OPC_CheckChild0Type, MVT::v2i32,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_SwitchType , 23,  MVT::v2i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv2i32), 0,
                          1, MVT::v2i32, 6, 0, 1, 2, 4, 5, 6, 
                    23,  MVT::v4i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i32), 0,
                          1, MVT::v4i32, 6, 0, 1, 2, 4, 5, 6, 
                    0, 
                  0, 
                0, 
              0, 
            50, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABB), 0,
                  1, MVT::i32, 5, 0, 1, 2, 3, 4, 
            31, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADDrs), 0,
                  1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
            50, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMLABB), 0,
                  1, MVT::i32, 5, 0, 1, 2, 3, 4, 
            46, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v4i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i16), 0,
                  1, MVT::v4i16, 6, 0, 3, 1, 4, 5, 6, 
            92, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 42, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i16), 0,
                    1, MVT::v4i16, 6, 3, 0, 1, 4, 5, 6, 
              42, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i16), 0,
                    1, MVT::v4i16, 6, 3, 2, 0, 4, 5, 6, 
              0, 
            46, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v2i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv2i32), 0,
                  1, MVT::v2i32, 6, 0, 3, 1, 4, 5, 6, 
            92, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 42, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2i32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv2i32), 0,
                    1, MVT::v2i32, 6, 3, 0, 1, 4, 5, 6, 
              42, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2i32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv2i32), 0,
                    1, MVT::v2i32, 6, 3, 2, 0, 4, 5, 6, 
              0, 
            46, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v4i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv8i16), 0,
                  1, MVT::v8i16, 6, 0, 3, 1, 4, 5, 6, 
            92, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 42, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv8i16), 0,
                    1, MVT::v8i16, 6, 3, 0, 1, 4, 5, 6, 
              42, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv8i16), 0,
                    1, MVT::v8i16, 6, 3, 2, 0, 4, 5, 6, 
              0, 
            46, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v2i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i32), 0,
                  1, MVT::v4i32, 6, 0, 3, 1, 4, 5, 6, 
            92, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 42, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2i32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i32), 0,
                    1, MVT::v4i32, 6, 3, 0, 1, 4, 5, 6, 
              42, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2i32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i32), 0,
                    1, MVT::v4i32, 6, 3, 2, 0, 4, 5, 6, 
              0, 
            47|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 110, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_Scope, 50, 
                  OPC_CheckChild0Type, MVT::v8i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitNodeXForm, 6, 4,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v4i16, 2, 2, 5, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitNodeXForm, 7, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv8i16), 0,
                      1, MVT::v8i16, 6, 0, 1, 6, 8, 9, 10, 
                50, 
                  OPC_CheckChild0Type, MVT::v4i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitNodeXForm, 8, 4,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v2i32, 2, 2, 5, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitNodeXForm, 9, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i32), 0,
                      1, MVT::v4i32, 6, 0, 1, 6, 8, 9, 10, 
                0, 
              56, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v8i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v8i16,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 6, 4,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v4i16, 2, 1, 5, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 7, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv8i16), 0,
                    1, MVT::v8i16, 6, 0, 3, 6, 8, 9, 10, 
              0, 
            122, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 57, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v8i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v8i16,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 6, 4,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v4i16, 2, 1, 5, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 7, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv8i16), 0,
                    1, MVT::v8i16, 6, 3, 0, 6, 8, 9, 10, 
              57, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v8i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v8i16,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 6, 4,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v4i16, 2, 0, 5, 
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 7, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv8i16), 0,
                    1, MVT::v8i16, 6, 3, 2, 6, 8, 9, 10, 
              0, 
            61, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitNodeXForm, 8, 4,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v2i32, 2, 1, 5, 
              OPC_EmitConvertToTarget, 2,
              OPC_EmitNodeXForm, 9, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i32), 0,
                  1, MVT::v4i32, 6, 0, 3, 6, 8, 9, 10, 
            122, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 57, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4i32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 8, 4,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v2i32, 2, 1, 5, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 9, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i32), 0,
                    1, MVT::v4i32, 6, 3, 0, 6, 8, 9, 10, 
              57, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4i32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 8, 4,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v2i32, 2, 0, 5, 
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 9, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslv4i32), 0,
                    1, MVT::v4i32, 6, 3, 2, 6, 8, 9, 10, 
              0, 
            57|128,6, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 74|128,1,  ARMISD::VSHRs,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_SwitchType , 22,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv8i8), 0,
                      1, MVT::v8i8, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv4i16), 0,
                      1, MVT::v4i16, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv2i32), 0,
                      1, MVT::v2i32, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv1i64), 0,
                      1, MVT::v1i64, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv16i8), 0,
                      1, MVT::v16i8, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv8i16), 0,
                      1, MVT::v8i16, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv2i64), 0,
                      1, MVT::v2i64, 5, 0, 1, 3, 4, 5, 
                0, 
              74|128,1,  ARMISD::VSHRu,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_SwitchType , 22,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv8i8), 0,
                      1, MVT::v8i8, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv4i16), 0,
                      1, MVT::v4i16, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv2i32), 0,
                      1, MVT::v2i32, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv1i64), 0,
                      1, MVT::v1i64, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv16i8), 0,
                      1, MVT::v16i8, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv8i16), 0,
                      1, MVT::v8i16, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv2i64), 0,
                      1, MVT::v2i64, 5, 0, 1, 3, 4, 5, 
                0, 
              74|128,1,  ARMISD::VRSHRs,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_SwitchType , 22,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv8i8), 0,
                      1, MVT::v8i8, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv4i16), 0,
                      1, MVT::v4i16, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv2i32), 0,
                      1, MVT::v2i32, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv1i64), 0,
                      1, MVT::v1i64, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv16i8), 0,
                      1, MVT::v16i8, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv8i16), 0,
                      1, MVT::v8i16, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv2i64), 0,
                      1, MVT::v2i64, 5, 0, 1, 3, 4, 5, 
                0, 
              74|128,1,  ARMISD::VRSHRu,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_SwitchType , 22,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv8i8), 0,
                      1, MVT::v8i8, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv4i16), 0,
                      1, MVT::v4i16, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv2i32), 0,
                      1, MVT::v2i32, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv1i64), 0,
                      1, MVT::v1i64, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv16i8), 0,
                      1, MVT::v16i8, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv8i16), 0,
                      1, MVT::v8i16, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv2i64), 0,
                      1, MVT::v2i64, 5, 0, 1, 3, 4, 5, 
                0, 
              0, 
            60|128,6, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 75|128,1,  ARMISD::VSHRs,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 22,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv8i8), 0,
                      1, MVT::v8i8, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv4i16), 0,
                      1, MVT::v4i16, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv2i32), 0,
                      1, MVT::v2i32, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv1i64), 0,
                      1, MVT::v1i64, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv16i8), 0,
                      1, MVT::v16i8, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv8i16), 0,
                      1, MVT::v8i16, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv4i32), 0,
                      1, MVT::v4i32, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAsv2i64), 0,
                      1, MVT::v2i64, 5, 2, 0, 3, 4, 5, 
                0, 
              75|128,1,  ARMISD::VSHRu,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 22,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv8i8), 0,
                      1, MVT::v8i8, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv4i16), 0,
                      1, MVT::v4i16, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv2i32), 0,
                      1, MVT::v2i32, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv1i64), 0,
                      1, MVT::v1i64, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv16i8), 0,
                      1, MVT::v16i8, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv8i16), 0,
                      1, MVT::v8i16, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv4i32), 0,
                      1, MVT::v4i32, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRAuv2i64), 0,
                      1, MVT::v2i64, 5, 2, 0, 3, 4, 5, 
                0, 
              75|128,1,  ARMISD::VRSHRs,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 22,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv8i8), 0,
                      1, MVT::v8i8, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv4i16), 0,
                      1, MVT::v4i16, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv2i32), 0,
                      1, MVT::v2i32, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv1i64), 0,
                      1, MVT::v1i64, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv16i8), 0,
                      1, MVT::v16i8, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv8i16), 0,
                      1, MVT::v8i16, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv4i32), 0,
                      1, MVT::v4i32, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAsv2i64), 0,
                      1, MVT::v2i64, 5, 2, 0, 3, 4, 5, 
                0, 
              75|128,1,  ARMISD::VRSHRu,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 22,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv8i8), 0,
                      1, MVT::v8i8, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv4i16), 0,
                      1, MVT::v4i16, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv2i32), 0,
                      1, MVT::v2i32, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv1i64), 0,
                      1, MVT::v1i64, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv16i8), 0,
                      1, MVT::v16i8, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv8i16), 0,
                      1, MVT::v8i16, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv4i32), 0,
                      1, MVT::v4i32, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSRAuv2i64), 0,
                      1, MVT::v2i64, 5, 2, 0, 3, 4, 5, 
                0, 
              0, 
            82, 
              OPC_RecordChild0,
              OPC_Scope, 39, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::MUL,
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABB), 0,
                    1, MVT::i32, 5, 1, 2, 0, 3, 4, 
              38, 
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 11,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 10, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBri), 0,
                    1, MVT::i32, 5, 0, 3, 4, 5, 6, 
              0, 
            40, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_RecordChild0,
              OPC_MoveChild, 0,
              OPC_CheckPredicate, 10,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckPredicate, 10,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMLABB), 0,
                  1, MVT::i32, 5, 0, 1, 2, 3, 4, 
            127|128,4, 
              OPC_RecordChild0,
              OPC_Scope, 60|128,4, 
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 30, 
                  OPC_CheckPredicate, 5,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADDri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                33, 
                  OPC_CheckPredicate, 12,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 11, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SUBri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                30, 
                  OPC_CheckPredicate, 13,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tADDi3), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                30, 
                  OPC_CheckPredicate, 14,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tADDi8), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                33, 
                  OPC_CheckPredicate, 15,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 10, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSUBi3), 0,
                      1, MVT::i32, 5, 2, 0, 4, 5, 6, 
                33, 
                  OPC_CheckPredicate, 16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 10, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSUBi8), 0,
                      1, MVT::i32, 5, 2, 0, 4, 5, 6, 
                30, 
                  OPC_CheckPredicate, 4,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADDri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                30, 
                  OPC_CheckPredicate, 17,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADDri12), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                33, 
                  OPC_CheckPredicate, 18,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 12, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                33, 
                  OPC_CheckPredicate, 19,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 10, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBri12), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                59, 
                  OPC_CheckPredicate, 7,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 2, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::ADDri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 3, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADDri), 0,
                      1, MVT::i32, 5, 7, 9, 10, 11, 12, 
                59, 
                  OPC_CheckPredicate, 20,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 13, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::SUBri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 14, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SUBri), 0,
                      1, MVT::i32, 5, 7, 9, 10, 11, 12, 
                59, 
                  OPC_CheckPredicate, 8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 4, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::t2ADDri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 5, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADDri), 0,
                      1, MVT::i32, 5, 7, 9, 10, 11, 12, 
                59, 
                  OPC_CheckPredicate, 21,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 15, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::t2SUBri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 16, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBri), 0,
                      1, MVT::i32, 5, 7, 9, 10, 11, 12, 
                0, 
              61, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_Scope, 25, 
                  OPC_CheckValueType, MVT::i8,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTABrr), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                25, 
                  OPC_CheckValueType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTAHrr), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                0, 
              0, 
            64, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 30,  ISD::MUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::MLA), 0,
                    1, MVT::i32, 6, 0, 1, 2, 3, 4, 5, 
              26,  ISD::MULHS,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMMLA), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              0, 
            62, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_Scope, 25, 
                OPC_CheckValueType, MVT::i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTABrr), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              25, 
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTAHrr), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              0, 
            60, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 26,  ISD::MUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MLA), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              26,  ISD::MULHS,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMMLA), 0,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              0, 
            14|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::MUL,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv8i8), 0,
                    1, MVT::v8i8, 5, 0, 1, 2, 3, 4, 
              20,  MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv4i16), 0,
                    1, MVT::v4i16, 5, 0, 1, 2, 3, 4, 
              20,  MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv2i32), 0,
                    1, MVT::v2i32, 5, 0, 1, 2, 3, 4, 
              20,  MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv16i8), 0,
                    1, MVT::v16i8, 5, 0, 1, 2, 3, 4, 
              20,  MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv8i16), 0,
                    1, MVT::v8i16, 5, 0, 1, 2, 3, 4, 
              20,  MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv4i32), 0,
                    1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
              0, 
            63, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_Scope, 26, 
                OPC_CheckValueType, MVT::i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTABrr), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              26, 
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTAHrr), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              0, 
            63, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 29,  ISD::MUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::MLA), 0,
                    1, MVT::i32, 6, 1, 2, 0, 3, 4, 5, 
              25,  ISD::MULHS,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMMLA), 0,
                    1, MVT::i32, 5, 1, 2, 0, 3, 4, 
              0, 
            63, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_Scope, 26, 
                OPC_CheckValueType, MVT::i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTABrr), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              26, 
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTAHrr), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              0, 
            59, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 25,  ISD::MUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MLA), 0,
                    1, MVT::i32, 5, 1, 2, 0, 3, 4, 
              25,  ISD::MULHS,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMMLA), 0,
                    1, MVT::i32, 5, 1, 2, 0, 3, 4, 
              0, 
            14|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv8i8), 0,
                    1, MVT::v8i8, 5, 2, 0, 1, 3, 4, 
              20,  MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv4i16), 0,
                    1, MVT::v4i16, 5, 2, 0, 1, 3, 4, 
              20,  MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv2i32), 0,
                    1, MVT::v2i32, 5, 2, 0, 1, 3, 4, 
              20,  MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv16i8), 0,
                    1, MVT::v16i8, 5, 2, 0, 1, 3, 4, 
              20,  MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv8i16), 0,
                    1, MVT::v8i16, 5, 2, 0, 1, 3, 4, 
              20,  MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAv4i32), 0,
                    1, MVT::v4i32, 5, 2, 0, 1, 3, 4, 
              0, 
            120|128,1, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_SwitchType , 74,  MVT::i32,
                OPC_Scope, 23, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADDrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tADDrr), 0,
                      1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADDrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                0, 
              19,  MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              19,  MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              19,  MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              19,  MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              19,  MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              19,  MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              19,  MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              19,  MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            0, 
          80|128,11,  ISD::MUL,
            OPC_Scope, 50|128,4, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 65|128,3,  ISD::SRA,
                OPC_Scope, 116, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::SRA,
                  OPC_Scope, 57, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::SHL,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 16, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 16, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_Scope, 11, 
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULBB), 0,
                          1, MVT::i32, 4, 0, 1, 2, 3, 
                    11, 
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULBB), 0,
                          1, MVT::i32, 4, 1, 0, 2, 3, 
                    0, 
                  30, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 16, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULBT), 0,
                        1, MVT::i32, 4, 0, 1, 2, 3, 
                  0, 
                70, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::SRA,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_Scope, 11, 
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULTB), 0,
                        1, MVT::i32, 4, 0, 1, 2, 3, 
                  11, 
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULBT), 0,
                        1, MVT::i32, 4, 1, 0, 2, 3, 
                  0, 
                55, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::SRA,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULTB), 0,
                      1, MVT::i32, 4, 1, 0, 2, 3, 
                73|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 16, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_SwitchOpcode , 93,  ISD::SRA,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 16, 
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_Scope, 19, 
                      OPC_CheckPatternPredicate, 7,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULTT), 0,
                          1, MVT::i32, 4, 0, 1, 2, 3, 
                    19, 
                      OPC_CheckPatternPredicate, 2,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULTT), 0,
                          1, MVT::i32, 4, 0, 1, 2, 3, 
                    19, 
                      OPC_CheckPatternPredicate, 7,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULTT), 0,
                          1, MVT::i32, 4, 1, 0, 2, 3, 
                    19, 
                      OPC_CheckPatternPredicate, 2,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULTT), 0,
                          1, MVT::i32, 4, 1, 0, 2, 3, 
                    0, 
                  91,  ISD::SIGN_EXTEND_INREG,
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckValueType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_Scope, 19, 
                      OPC_CheckPatternPredicate, 7,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULTB), 0,
                          1, MVT::i32, 4, 0, 1, 2, 3, 
                    19, 
                      OPC_CheckPatternPredicate, 2,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULTB), 0,
                          1, MVT::i32, 4, 0, 1, 2, 3, 
                    19, 
                      OPC_CheckPatternPredicate, 7,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULBT), 0,
                          1, MVT::i32, 4, 1, 0, 2, 3, 
                    19, 
                      OPC_CheckPatternPredicate, 2,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULBT), 0,
                          1, MVT::i32, 4, 1, 0, 2, 3, 
                    0, 
                  0, 
                0, 
              104,  ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 19, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULBT), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                19, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULBT), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                19, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULTB), 0,
                      1, MVT::i32, 4, 1, 0, 2, 3, 
                19, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULTB), 0,
                      1, MVT::i32, 4, 1, 0, 2, 3, 
                0, 
              0, 
            40, 
              OPC_RecordChild0,
              OPC_MoveChild, 0,
              OPC_CheckPredicate, 10,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULBT), 0,
                  1, MVT::i32, 4, 0, 1, 2, 3, 
            55, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckPredicate, 10,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_Scope, 11, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULTB), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              11, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULBT), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              0, 
            40, 
              OPC_RecordChild0,
              OPC_MoveChild, 0,
              OPC_CheckPredicate, 10,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SRA,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 16, 
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 7,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULTB), 0,
                  1, MVT::i32, 4, 1, 0, 2, 3, 
            66, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckValueType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 19, 
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULBB), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              19, 
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULBB), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              0, 
            0|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_Scope, 59, 
                OPC_CheckChild0Type, MVT::v4i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_SwitchType , 22,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv4i16), 0,
                      1, MVT::v4i16, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv8i16), 0,
                      1, MVT::v8i16, 5, 0, 1, 3, 4, 5, 
                0, 
              59, 
                OPC_CheckChild0Type, MVT::v2i32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_SwitchType , 22,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv2i32), 0,
                      1, MVT::v2i32, 5, 0, 1, 3, 4, 5, 
                22,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
                0, 
              0, 
            1|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_Scope, 60, 
                OPC_CheckChild0Type, MVT::v4i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 22,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv4i16), 0,
                      1, MVT::v4i16, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv8i16), 0,
                      1, MVT::v8i16, 5, 2, 0, 3, 4, 5, 
                0, 
              60, 
                OPC_CheckChild0Type, MVT::v2i32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 22,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv2i32), 0,
                      1, MVT::v2i32, 5, 2, 0, 3, 4, 5, 
                22,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv4i32), 0,
                      1, MVT::v4i32, 5, 2, 0, 3, 4, 5, 
                0, 
              0, 
            106, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_Scope, 48, 
                OPC_CheckChild0Type, MVT::v8i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v8i16,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 6, 3,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v4i16, 2, 1, 4, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 7, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv8i16), 0,
                    1, MVT::v8i16, 5, 0, 5, 7, 8, 9, 
              48, 
                OPC_CheckChild0Type, MVT::v4i32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4i32,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 8, 3,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v2i32, 2, 1, 4, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 9, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv4i32), 0,
                    1, MVT::v4i32, 5, 0, 5, 7, 8, 9, 
              0, 
            107, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_Scope, 49, 
                OPC_CheckChild0Type, MVT::v8i16,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v8i16,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 6, 3,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v4i16, 2, 0, 4, 
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 7, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv8i16), 0,
                    1, MVT::v8i16, 5, 2, 5, 7, 8, 9, 
              49, 
                OPC_CheckChild0Type, MVT::v4i32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 8, 3,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v2i32, 2, 0, 4, 
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 9, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslv4i32), 0,
                    1, MVT::v4i32, 5, 2, 5, 7, 8, 9, 
              0, 
            111|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 32, 
                OPC_MoveChild, 0,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULBB), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              73|128,1, 
                OPC_RecordChild1,
                OPC_SwitchType , 70,  MVT::i32,
                  OPC_Scope, 23, 
                    OPC_CheckPatternPredicate, 5,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::MUL), 0,
                        1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                  23, 
                    OPC_CheckPatternPredicate, 6,
                    OPC_EmitRegister, MVT::i32, ARM::CPSR,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tMUL), 0,
                        1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                  19, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MUL), 0,
                        1, MVT::i32, 4, 0, 1, 2, 3, 
                  0, 
                19,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULv8i8), 0,
                      1, MVT::v8i8, 4, 0, 1, 2, 3, 
                19,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULv4i16), 0,
                      1, MVT::v4i16, 4, 0, 1, 2, 3, 
                19,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULv2i32), 0,
                      1, MVT::v2i32, 4, 0, 1, 2, 3, 
                19,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULv16i8), 0,
                      1, MVT::v16i8, 4, 0, 1, 2, 3, 
                19,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULv8i16), 0,
                      1, MVT::v8i16, 4, 0, 1, 2, 3, 
                19,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULv4i32), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                0, 
              0, 
            0, 
          120|128,16,  ISD::AND,
            OPC_Scope, 3|128,1, 
              OPC_CheckAndImm, 127|128,1|128,124|128,7, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 59,  ISD::SHL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 8, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitInteger, MVT::i32, 24, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTB16r_rot), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                22, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 24, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTB16r_rot), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                0, 
              59,  ISD::SRL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 8, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitInteger, MVT::i32, 8, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTB16r_rot), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                22, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 8, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTB16r_rot), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                0, 
              0, 
            42, 
              OPC_CheckAndImm, 127|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::ROTR,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 0,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTBr_rot), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            43, 
              OPC_CheckAndImm, 127|128,127|128,3, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::ROTR,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 0,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTHr_rot), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            44, 
              OPC_CheckAndImm, 127|128,1|128,124|128,7, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::ROTR,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 0,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTB16r_rot), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            42, 
              OPC_CheckAndImm, 127|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::ROTR,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTBr_rot), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            43, 
              OPC_CheckAndImm, 127|128,127|128,3, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::ROTR,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTHr_rot), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            44, 
              OPC_CheckAndImm, 127|128,1|128,124|128,7, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::ROTR,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTB16r_rot), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            24, 
              OPC_CheckAndImm, 127|128,1, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTBr), 0,
                  1, MVT::i32, 3, 0, 1, 2, 
            25, 
              OPC_CheckAndImm, 127|128,127|128,3, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTHr), 0,
                  1, MVT::i32, 3, 0, 1, 2, 
            26, 
              OPC_CheckAndImm, 127|128,1|128,124|128,7, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::UXTB16r), 0,
                  1, MVT::i32, 3, 0, 1, 2, 
            24, 
              OPC_CheckAndImm, 127|128,1, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTBr), 0,
                  1, MVT::i32, 3, 0, 1, 2, 
            25, 
              OPC_CheckAndImm, 127|128,127|128,3, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTHr), 0,
                  1, MVT::i32, 3, 0, 1, 2, 
            26, 
              OPC_CheckAndImm, 127|128,1|128,124|128,7, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2UXTB16r), 0,
                  1, MVT::i32, 3, 0, 1, 2, 
            51, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::BICrs), 0,
                  1, MVT::i32, 7, 0, 2, 3, 4, 5, 6, 7, 
            51, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::BICrs), 0,
                  1, MVT::i32, 7, 1, 2, 3, 4, 5, 6, 7, 
            50, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BICrs), 0,
                  1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
            50, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BICrs), 0,
                  1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
            98|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 31, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::ANDrs), 0,
                    1, MVT::i32, 7, 0, 2, 3, 4, 5, 6, 7, 
              103, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::XOR,
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 45, 
                  OPC_CheckPredicate, 5,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::BICri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                45, 
                  OPC_CheckPredicate, 4,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BICri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                0, 
              31, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::ANDrs), 0,
                    1, MVT::i32, 7, 1, 2, 3, 4, 5, 6, 7, 
              54, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::XOR,
                OPC_MoveChild, 0,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::BICri), 0,
                    1, MVT::i32, 5, 0, 2, 3, 4, 5, 
              0, 
            110, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 51, 
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::BICri), 0,
                    1, MVT::i32, 5, 1, 2, 3, 4, 5, 
              51, 
                OPC_MoveChild, 0,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::BICri), 0,
                    1, MVT::i32, 5, 1, 2, 3, 4, 5, 
              0, 
            55, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 4,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BICri), 0,
                  1, MVT::i32, 5, 0, 2, 3, 4, 5, 
            110, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 51, 
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BICri), 0,
                    1, MVT::i32, 5, 1, 2, 3, 4, 5, 
              51, 
                OPC_MoveChild, 0,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BICri), 0,
                    1, MVT::i32, 5, 1, 2, 3, 4, 5, 
              0, 
            32|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 59, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_Scope, 25, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ANDrs), 0,
                      1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
                25, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ANDrs), 0,
                      1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
                0, 
              96, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::XOR,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 23, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::BICrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBIC), 0,
                      1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BICrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                0, 
              0, 
            97, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 23, 
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::BICrr), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              23, 
                OPC_CheckPatternPredicate, 6,
                OPC_EmitRegister, MVT::i32, ARM::CPSR,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBIC), 0,
                    1, MVT::i32, 5, 2, 1, 0, 3, 4, 
              23, 
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BICrr), 0,
                    1, MVT::i32, 5, 1, 0, 2, 3, 4, 
              0, 
            92, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 53, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_SwitchType , 19,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBICd), 0,
                      1, MVT::v2i32, 4, 0, 1, 2, 3, 
                19,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBICq), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                0, 
              30, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBICd), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              0, 
            70, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 31, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBICd), 0,
                    1, MVT::v2i32, 4, 1, 0, 2, 3, 
              31, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBICd), 0,
                    1, MVT::v2i32, 4, 1, 0, 2, 3, 
              0, 
            35, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_CheckPredicate, 2,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBICq), 0,
                  1, MVT::v4i32, 4, 0, 1, 2, 3, 
            70, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 31, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBICq), 0,
                    1, MVT::v4i32, 4, 1, 0, 2, 3, 
              31, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VBICq), 0,
                    1, MVT::v4i32, 4, 1, 0, 2, 3, 
              0, 
            24, 
              OPC_CheckAndImm, 127|128,1, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::tUXTB), 0,
                  1, MVT::i32, 3, 0, 1, 2, 
            25, 
              OPC_CheckAndImm, 127|128,127|128,3, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::tUXTH), 0,
                  1, MVT::i32, 3, 0, 1, 2, 
            61|128,2, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 62|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 30, 
                  OPC_CheckPredicate, 5,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ANDri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                26, 
                  OPC_CheckPredicate, 22,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 4,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::BFC), 0,
                      1, MVT::i32, 4, 0, 2, 3, 4, 
                33, 
                  OPC_CheckPredicate, 23,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 17, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::BICri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                30, 
                  OPC_CheckPredicate, 4,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ANDri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                26, 
                  OPC_CheckPredicate, 22,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BFC), 0,
                      1, MVT::i32, 4, 0, 2, 3, 4, 
                33, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 1, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BICri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                0, 
              76, 
                OPC_CheckType, MVT::i32,
                OPC_Scope, 23, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ANDrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tAND), 0,
                      1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ANDrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                0, 
              21, 
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VANDd), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              21, 
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VANDq), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              0, 
            0, 
          94|128,3,  ISD::SIGN_EXTEND_INREG,
            OPC_Scope, 81|128,2, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 80|128,1,  ISD::OR,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 100,  ISD::SRL,
                  OPC_MoveChild, 0,
                  OPC_CheckAndImm, 0|128,126|128,3, 
                  OPC_RecordChild0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::SHL,
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckValueType, MVT::i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 18, 
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REVSH), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  18, 
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREVSH), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  18, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REVSH), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                100,  ISD::SHL,
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::SRL,
                  OPC_MoveChild, 0,
                  OPC_CheckAndImm, 0|128,126|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckSame, 0,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 8, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckValueType, MVT::i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 18, 
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::REVSH), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  18, 
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tREVSH), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  18, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2REVSH), 0,
                        1, MVT::i32, 3, 0, 1, 2, 
                  0, 
                0, 
              120,  ISD::ROTR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_Scope, 51, 
                  OPC_CheckValueType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 21, 
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTBr_rot), 0,
                        1, MVT::i32, 4, 0, 2, 3, 4, 
                  21, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTBr_rot), 0,
                        1, MVT::i32, 4, 0, 2, 3, 4, 
                  0, 
                51, 
                  OPC_CheckValueType, MVT::i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 21, 
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTHr_rot), 0,
                        1, MVT::i32, 4, 0, 2, 3, 4, 
                  21, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTHr_rot), 0,
                        1, MVT::i32, 4, 0, 2, 3, 4, 
                  0, 
                0, 
              0, 
            7|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_Scope, 64, 
                OPC_CheckValueType, MVT::i8,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 18, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTBr), 0,
                      1, MVT::i32, 3, 0, 1, 2, 
                18, 
                  OPC_CheckPatternPredicate, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSXTB), 0,
                      1, MVT::i32, 3, 0, 1, 2, 
                18, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTBr), 0,
                      1, MVT::i32, 3, 0, 1, 2, 
                0, 
              64, 
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 18, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SXTHr), 0,
                      1, MVT::i32, 3, 0, 1, 2, 
                18, 
                  OPC_CheckPatternPredicate, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSXTH), 0,
                      1, MVT::i32, 3, 0, 1, 2, 
                18, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SXTHr), 0,
                      1, MVT::i32, 3, 0, 1, 2, 
                0, 
              0, 
            0, 
          115|128,4,  ISD::SRA,
            OPC_Scope, 126|128,2, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_Scope, 55, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULWB), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              55, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SHL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULWB), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              66, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 19, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULWT), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                19, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULWT), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                0, 
              66, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRA,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 19, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULWT), 0,
                      1, MVT::i32, 4, 1, 0, 2, 3, 
                19, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULWT), 0,
                      1, MVT::i32, 4, 1, 0, 2, 3, 
                0, 
              64, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 19, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULWB), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                19, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULWB), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                0, 
              64, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SIGN_EXTEND_INREG,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckValueType, MVT::i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 19, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULWB), 0,
                      1, MVT::i32, 4, 1, 0, 2, 3, 
                19, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMULWB), 0,
                      1, MVT::i32, 4, 1, 0, 2, 3, 
                0, 
              0, 
            30, 
              OPC_RecordNode,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::MOVs), 0,
                  1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
            79, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::MUL,
              OPC_RecordChild0,
              OPC_Scope, 35, 
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULWB), 0,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              35, 
                OPC_MoveChild, 0,
                OPC_CheckPredicate, 10,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 16, 
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMULWB), 0,
                    1, MVT::i32, 4, 1, 0, 2, 3, 
              0, 
            0|128,1, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 68, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 30, 
                  OPC_CheckPredicate, 24,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ASRri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                28, 
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tASRri), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                0, 
              54, 
                OPC_CheckChild1Type, MVT::i32,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 23, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tASRrr), 0,
                      1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ASRrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                0, 
              0, 
            0, 
          17|128,1,  ARMISD::BR_JT,
            OPC_RecordNode,
            OPC_Scope, 89, 
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 47,  ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckChild1Type, MVT::i32,
                OPC_CheckPredicate, 25,
                OPC_CheckPredicate, 26,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::TargetJumpTable,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                OPC_EmitMergeInputChains, 2, 0, 1, 
                OPC_EmitConvertToTarget, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::BR_JTm), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 5, 5, 6, 7, 3, 8, 
              34,  ISD::ADD,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::TargetJumpTable,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::BR_JTadd), 0|OPFL_Chain,
                    0, 4, 1, 2, 3, 5, 
              0, 
            51, 
              OPC_RecordChild1,
              OPC_CheckChild1Type, MVT::i32,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::TargetJumpTable,
              OPC_MoveParent,
              OPC_RecordChild3,
              OPC_MoveChild, 3,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_Scope, 16, 
                OPC_CheckPatternPredicate, 5,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::BR_JTr), 0|OPFL_Chain,
                    0, 3, 1, 2, 4, 
              16, 
                OPC_CheckPatternPredicate, 6,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBR_JTr), 0|OPFL_Chain,
                    0, 3, 1, 2, 4, 
              0, 
            0, 
          87|128,17,  ISD::LOAD,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_Scope, 60|128,15, 
              OPC_RecordChild1,
              OPC_CheckChild1Type, MVT::i32,
              OPC_CheckPredicate, 25,
              OPC_Scope, 29, 
                OPC_CheckPredicate, 26,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/3, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICLDR), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 4, 2, 3, 4, 5, 
              62, 
                OPC_CheckPredicate, 27,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 27, 
                  OPC_CheckPredicate, 28,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/3, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICLDRH), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 4, 2, 3, 4, 5, 
                27, 
                  OPC_CheckPredicate, 29,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/3, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICLDRB), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 4, 2, 3, 4, 5, 
                0, 
              119, 
                OPC_CheckPredicate, 30,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 27, 
                  OPC_CheckPredicate, 31,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/3, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICLDRSH), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 4, 2, 3, 4, 5, 
                56, 
                  OPC_CheckPredicate, 32,
                  OPC_Scope, 25, 
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/3, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICLDRSB), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  25, 
                    OPC_CheckPatternPredicate, 6,
                    OPC_CheckComplexPat, /*CP*/4, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRSB), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  0, 
                27, 
                  OPC_CheckPredicate, 31,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/4, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRSH), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 4, 2, 3, 4, 5, 
                0, 
              30, 
                OPC_CheckPredicate, 26,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::LDR), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              64, 
                OPC_CheckPredicate, 27,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 28, 
                  OPC_CheckPredicate, 28,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/5, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::LDRH), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 29,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::LDRB), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              64, 
                OPC_CheckPredicate, 30,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 28, 
                  OPC_CheckPredicate, 31,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/5, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::LDRSH), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/5, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::LDRSB), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              32, 
                OPC_CheckPredicate, 27,
                OPC_CheckPredicate, 33,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::LDRB), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              93, 
                OPC_CheckPredicate, 34,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 28, 
                  OPC_CheckPredicate, 35,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::LDRB), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 36,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::LDRB), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 37,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/5, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::LDRH), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              30, 
                OPC_CheckPredicate, 26,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 6,
                OPC_CheckComplexPat, /*CP*/6, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDR), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              93, 
                OPC_CheckPredicate, 27,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 28, 
                  OPC_CheckPredicate, 29,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/7, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRB), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 28,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/8, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRH), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 33,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/7, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRB), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              93, 
                OPC_CheckPredicate, 34,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 28, 
                  OPC_CheckPredicate, 35,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/7, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRB), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 36,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/7, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRB), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 37,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/8, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRH), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              30, 
                OPC_CheckPredicate, 26,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_CheckComplexPat, /*CP*/9, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRs), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              64, 
                OPC_CheckPredicate, 27,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 28, 
                  OPC_CheckPredicate, 28,
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/9, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRHs), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 29,
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/9, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBs), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              64, 
                OPC_CheckPredicate, 30,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 28, 
                  OPC_CheckPredicate, 31,
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/9, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRSHs), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/9, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRSBs), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              32, 
                OPC_CheckPredicate, 27,
                OPC_CheckPredicate, 33,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_CheckComplexPat, /*CP*/9, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBs), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              93, 
                OPC_CheckPredicate, 34,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 28, 
                  OPC_CheckPredicate, 35,
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/9, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBs), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 36,
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/9, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBs), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                28, 
                  OPC_CheckPredicate, 37,
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/9, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRHs), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              6|128,2, 
                OPC_CheckPredicate, 30,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 47, 
                  OPC_CheckPredicate, 32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/7, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::tLDRB), 0|OPFL_Chain,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::tSXTB), 0|OPFL_MemRefs,
                      1, MVT::i32, 3, 7, 8, 9, 
                  OPC_CompleteMatch, 1, 10, 

                47, 
                  OPC_CheckPredicate, 31,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/8, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::tLDRH), 0|OPFL_Chain,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::tSXTH), 0|OPFL_MemRefs,
                      1, MVT::i32, 3, 7, 8, 9, 
                  OPC_CompleteMatch, 1, 10, 

                79, 
                  OPC_CheckPredicate, 32,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/7, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::tLDRB), 0|OPFL_Chain,
                      1, MVT::i32, 5, 2, 3, 4, 7, 8, 
                  OPC_EmitInteger, MVT::i32, 24, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::tLSLri), 0,
                      1, MVT::i32, 5, 6, 9, 10, 11, 12, 
                  OPC_EmitInteger, MVT::i32, 24, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::tASRri), 0|OPFL_MemRefs,
                      1, MVT::i32, 5, 5, 13, 14, 15, 16, 
                  OPC_CompleteMatch, 1, 17, 

                79, 
                  OPC_CheckPredicate, 31,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/7, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::tLDRH), 0|OPFL_Chain,
                      1, MVT::i32, 5, 2, 3, 4, 7, 8, 
                  OPC_EmitInteger, MVT::i32, 16, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::tLSLri), 0,
                      1, MVT::i32, 5, 6, 9, 10, 11, 12, 
                  OPC_EmitInteger, MVT::i32, 16, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::tASRri), 0|OPFL_MemRefs,
                      1, MVT::i32, 5, 5, 13, 14, 15, 16, 
                  OPC_CompleteMatch, 1, 17, 

                0, 
              62, 
                OPC_CheckPredicate, 34,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 27, 
                  OPC_CheckPredicate, 36,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/3, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICLDRB), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 4, 2, 3, 4, 5, 
                27, 
                  OPC_CheckPredicate, 37,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/3, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICLDRH), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 4, 2, 3, 4, 5, 
                0, 
              85, 
                OPC_CheckPredicate, 26,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 25, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/10, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRspi), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 4, 2, 3, 4, 5, 
                52, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 23, 
                    OPC_CheckComplexPat, /*CP*/11, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRi12), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  23, 
                    OPC_CheckComplexPat, /*CP*/12, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  0, 
                0, 
              116, 
                OPC_CheckPredicate, 27,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 54, 
                  OPC_CheckPredicate, 28,
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 23, 
                    OPC_CheckComplexPat, /*CP*/11, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRHi12), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  23, 
                    OPC_CheckComplexPat, /*CP*/12, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRHi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  0, 
                54, 
                  OPC_CheckPredicate, 29,
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 23, 
                    OPC_CheckComplexPat, /*CP*/11, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBi12), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  23, 
                    OPC_CheckComplexPat, /*CP*/12, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  0, 
                0, 
              116, 
                OPC_CheckPredicate, 30,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 54, 
                  OPC_CheckPredicate, 31,
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 23, 
                    OPC_CheckComplexPat, /*CP*/11, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRSHi12), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  23, 
                    OPC_CheckComplexPat, /*CP*/12, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRSHi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  0, 
                54, 
                  OPC_CheckPredicate, 32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 23, 
                    OPC_CheckComplexPat, /*CP*/11, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRSBi12), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  23, 
                    OPC_CheckComplexPat, /*CP*/12, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRSBi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  0, 
                0, 
              58, 
                OPC_CheckPredicate, 27,
                OPC_CheckPredicate, 33,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_Scope, 23, 
                  OPC_CheckComplexPat, /*CP*/11, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBi12), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 4, 2, 3, 4, 5, 
                23, 
                  OPC_CheckComplexPat, /*CP*/12, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBi8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 4, 2, 3, 4, 5, 
                0, 
              43|128,1, 
                OPC_CheckPredicate, 34,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 54, 
                  OPC_CheckPredicate, 35,
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 23, 
                    OPC_CheckComplexPat, /*CP*/11, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBi12), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  23, 
                    OPC_CheckComplexPat, /*CP*/12, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  0, 
                54, 
                  OPC_CheckPredicate, 36,
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 23, 
                    OPC_CheckComplexPat, /*CP*/11, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBi12), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  23, 
                    OPC_CheckComplexPat, /*CP*/12, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  0, 
                54, 
                  OPC_CheckPredicate, 37,
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 23, 
                    OPC_CheckComplexPat, /*CP*/11, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRHi12), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  23, 
                    OPC_CheckComplexPat, /*CP*/12, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRHi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 4, 2, 3, 4, 5, 
                  0, 
                0, 
              85, 
                OPC_CheckPredicate, 26,
                OPC_SwitchType , 25,  MVT::f64,
                  OPC_CheckPatternPredicate, 8,
                  OPC_CheckComplexPat, /*CP*/13, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLDRD), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::f64, 4, 2, 3, 4, 5, 
                25,  MVT::f32,
                  OPC_CheckPatternPredicate, 8,
                  OPC_CheckComplexPat, /*CP*/13, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLDRS), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::f32, 4, 2, 3, 4, 5, 
                25,  MVT::v2f64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_CheckComplexPat, /*CP*/14, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLDRQ), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2f64, 4, 2, 3, 4, 5, 
                0, 
              0, 
            19|128,2, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ARMISD::Wrapper,
              OPC_RecordChild0,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::TargetConstantPool,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckPredicate, 25,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 48, 
                OPC_CheckPredicate, 26,
                OPC_Scope, 21, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRpci), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 3, 1, 2, 3, 
                21, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRpci), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 3, 1, 2, 3, 
                0, 
              52, 
                OPC_CheckPredicate, 27,
                OPC_Scope, 23, 
                  OPC_CheckPredicate, 28,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRHpci), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 3, 1, 2, 3, 
                23, 
                  OPC_CheckPredicate, 29,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBpci), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 3, 1, 2, 3, 
                0, 
              52, 
                OPC_CheckPredicate, 30,
                OPC_Scope, 23, 
                  OPC_CheckPredicate, 31,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRSHpci), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 3, 1, 2, 3, 
                23, 
                  OPC_CheckPredicate, 32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRSBpci), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 3, 1, 2, 3, 
                0, 
              25, 
                OPC_CheckPredicate, 27,
                OPC_CheckPredicate, 33,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBpci), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 3, 1, 2, 3, 
              76, 
                OPC_CheckPredicate, 34,
                OPC_Scope, 23, 
                  OPC_CheckPredicate, 35,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBpci), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 3, 1, 2, 3, 
                23, 
                  OPC_CheckPredicate, 36,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRBpci), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 3, 1, 2, 3, 
                23, 
                  OPC_CheckPredicate, 37,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRHpci), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 3, 1, 2, 3, 
                0, 
              0, 
            0, 
          83|128,8,  ISD::STORE,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_Scope, 99|128,7, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_RecordChild2,
              OPC_Scope, 115|128,2, 
                OPC_CheckChild2Type, MVT::i32,
                OPC_CheckPredicate, 38,
                OPC_Scope, 27, 
                  OPC_CheckPredicate, 39,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/3, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICSTR), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 1, 3, 4, 5, 6, 
                60, 
                  OPC_CheckPredicate, 40,
                  OPC_Scope, 27, 
                    OPC_CheckPredicate, 41,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/3, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICSTRH), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 1, 3, 4, 5, 6, 
                  27, 
                    OPC_CheckPredicate, 42,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/3, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICSTRB), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 1, 3, 4, 5, 6, 
                  0, 
                28, 
                  OPC_CheckPredicate, 39,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::STR), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 1, 3, 4, 5, 6, 7, 
                62, 
                  OPC_CheckPredicate, 40,
                  OPC_Scope, 28, 
                    OPC_CheckPredicate, 41,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/5, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::STRH), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 1, 3, 4, 5, 6, 7, 
                  28, 
                    OPC_CheckPredicate, 42,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/2, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::STRB), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 1, 3, 4, 5, 6, 7, 
                  0, 
                28, 
                  OPC_CheckPredicate, 39,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/6, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSTR), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 1, 3, 4, 5, 6, 7, 
                62, 
                  OPC_CheckPredicate, 40,
                  OPC_Scope, 28, 
                    OPC_CheckPredicate, 42,
                    OPC_CheckPatternPredicate, 6,
                    OPC_CheckComplexPat, /*CP*/7, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSTRB), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 1, 3, 4, 5, 6, 7, 
                  28, 
                    OPC_CheckPredicate, 41,
                    OPC_CheckPatternPredicate, 6,
                    OPC_CheckComplexPat, /*CP*/8, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSTRH), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 1, 3, 4, 5, 6, 7, 
                  0, 
                28, 
                  OPC_CheckPredicate, 39,
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/9, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRs), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 1, 3, 4, 5, 6, 7, 
                62, 
                  OPC_CheckPredicate, 40,
                  OPC_Scope, 28, 
                    OPC_CheckPredicate, 42,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/9, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRBs), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 1, 3, 4, 5, 6, 7, 
                  28, 
                    OPC_CheckPredicate, 41,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/9, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRHs), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 1, 3, 4, 5, 6, 7, 
                  0, 
                0, 
              78|128,1, 
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::i32,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 64, 
                  OPC_CheckPredicate, 43,
                  OPC_Scope, 29, 
                    OPC_CheckPredicate, 44,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/15, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::STR_PRE), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 1, 2, 4, 5, 6, 7, 
                  29, 
                    OPC_CheckPredicate, 45,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/15, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::STR_POST), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 1, 2, 4, 5, 6, 7, 
                  0, 
                4|128,1, 
                  OPC_CheckPredicate, 46,
                  OPC_Scope, 31, 
                    OPC_CheckPredicate, 47,
                    OPC_CheckPredicate, 48,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/16, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::STRH_PRE), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 1, 2, 4, 5, 6, 7, 
                  31, 
                    OPC_CheckPredicate, 49,
                    OPC_CheckPredicate, 50,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/16, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::STRH_POST), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 1, 2, 4, 5, 6, 7, 
                  31, 
                    OPC_CheckPredicate, 47,
                    OPC_CheckPredicate, 51,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/15, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::STRB_PRE), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 1, 2, 4, 5, 6, 7, 
                  31, 
                    OPC_CheckPredicate, 49,
                    OPC_CheckPredicate, 52,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/15, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::STRB_POST), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 1, 2, 4, 5, 6, 7, 
                  0, 
                0, 
              77|128,1, 
                OPC_CheckChild2Type, MVT::i32,
                OPC_CheckPredicate, 38,
                OPC_Scope, 83, 
                  OPC_CheckPredicate, 39,
                  OPC_Scope, 25, 
                    OPC_CheckPatternPredicate, 6,
                    OPC_CheckComplexPat, /*CP*/10, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSTRspi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 1, 3, 4, 5, 6, 
                  52, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_Scope, 23, 
                      OPC_CheckComplexPat, /*CP*/11, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRi12), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 5, 1, 3, 4, 5, 6, 
                    23, 
                      OPC_CheckComplexPat, /*CP*/12, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRi8), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 5, 1, 3, 4, 5, 6, 
                    0, 
                  0, 
                114, 
                  OPC_CheckPredicate, 40,
                  OPC_Scope, 54, 
                    OPC_CheckPredicate, 42,
                    OPC_CheckPatternPredicate, 2,
                    OPC_Scope, 23, 
                      OPC_CheckComplexPat, /*CP*/11, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRBi12), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 5, 1, 3, 4, 5, 6, 
                    23, 
                      OPC_CheckComplexPat, /*CP*/12, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRBi8), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 5, 1, 3, 4, 5, 6, 
                    0, 
                  54, 
                    OPC_CheckPredicate, 41,
                    OPC_CheckPatternPredicate, 2,
                    OPC_Scope, 23, 
                      OPC_CheckComplexPat, /*CP*/11, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRHi12), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 5, 1, 3, 4, 5, 6, 
                    23, 
                      OPC_CheckComplexPat, /*CP*/12, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRHi8), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 5, 1, 3, 4, 5, 6, 
                    0, 
                  0, 
                0, 
              72|128,1, 
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::i32,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 62, 
                  OPC_CheckPredicate, 43,
                  OPC_Scope, 28, 
                    OPC_CheckPredicate, 44,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/17, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STR_PRE), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 1, 2, 4, 5, 6, 
                  28, 
                    OPC_CheckPredicate, 45,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/17, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STR_POST), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 1, 2, 4, 5, 6, 
                  0, 
                0|128,1, 
                  OPC_CheckPredicate, 46,
                  OPC_Scope, 30, 
                    OPC_CheckPredicate, 47,
                    OPC_CheckPredicate, 48,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/17, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRH_PRE), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 1, 2, 4, 5, 6, 
                  30, 
                    OPC_CheckPredicate, 49,
                    OPC_CheckPredicate, 50,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/17, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRH_POST), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 1, 2, 4, 5, 6, 
                  30, 
                    OPC_CheckPredicate, 47,
                    OPC_CheckPredicate, 51,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/17, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRB_PRE), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 1, 2, 4, 5, 6, 
                  30, 
                    OPC_CheckPredicate, 49,
                    OPC_CheckPredicate, 52,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/17, /*#*/3,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2STRB_POST), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 1, 2, 4, 5, 6, 
                  0, 
                0, 
              0, 
            34, 
              OPC_CheckChild1Type, MVT::f64,
              OPC_RecordChild2,
              OPC_CheckChild2Type, MVT::i32,
              OPC_CheckPredicate, 38,
              OPC_CheckPredicate, 39,
              OPC_CheckPatternPredicate, 8,
              OPC_CheckComplexPat, /*CP*/13, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSTRD), 0|OPFL_Chain|OPFL_MemRefs,
                  0, 5, 1, 3, 4, 5, 6, 
            34, 
              OPC_CheckChild1Type, MVT::f32,
              OPC_RecordChild2,
              OPC_CheckChild2Type, MVT::i32,
              OPC_CheckPredicate, 38,
              OPC_CheckPredicate, 39,
              OPC_CheckPatternPredicate, 8,
              OPC_CheckComplexPat, /*CP*/13, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSTRS), 0|OPFL_Chain|OPFL_MemRefs,
                  0, 5, 1, 3, 4, 5, 6, 
            34, 
              OPC_CheckChild1Type, MVT::v2f64,
              OPC_RecordChild2,
              OPC_CheckChild2Type, MVT::i32,
              OPC_CheckPredicate, 38,
              OPC_CheckPredicate, 39,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/14, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSTRQ), 0|OPFL_Chain|OPFL_MemRefs,
                  0, 5, 1, 3, 4, 5, 6, 
            0, 
          71|128,10,  ARMISD::CMPZ,
            OPC_Scope, 74, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 33,  ISD::AND,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::TSTrs), 0|OPFL_FlagOutput,
                    0, 6, 0, 2, 3, 4, 5, 6, 
              33,  ISD::XOR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::TEQrs), 0|OPFL_FlagOutput,
                    0, 6, 0, 2, 3, 4, 5, 6, 
              0, 
            37, 
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::i32,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SUB,
              OPC_MoveChild, 0,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMNzrs), 0|OPFL_FlagOutput,
                  0, 6, 0, 2, 3, 4, 5, 6, 
            109, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 33,  ISD::AND,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::TSTrs), 0|OPFL_FlagOutput,
                    0, 6, 1, 2, 3, 4, 5, 6, 
              33,  ISD::XOR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::TEQrs), 0|OPFL_FlagOutput,
                    0, 6, 1, 2, 3, 4, 5, 6, 
              33,  ISD::SUB,
                OPC_MoveChild, 0,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMNzrs), 0|OPFL_FlagOutput,
                    0, 6, 1, 2, 3, 4, 5, 6, 
              0, 
            36, 
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::i32,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SUB,
              OPC_MoveChild, 0,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMNzrs), 0|OPFL_FlagOutput,
                  0, 5, 0, 2, 3, 4, 5, 
            104|128,1, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 95,  ISD::AND,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_Scope, 54, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 20, 
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2TSTrs), 0|OPFL_FlagOutput,
                        0, 5, 0, 2, 3, 4, 5, 
                  20, 
                    OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2TSTrs), 0|OPFL_FlagOutput,
                        0, 5, 1, 2, 3, 4, 5, 
                  0, 
                35, 
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 5,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::TSTri), 0|OPFL_FlagOutput,
                      0, 4, 0, 2, 3, 4, 
                0, 
              95,  ISD::XOR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_Scope, 54, 
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 20, 
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2TEQrs), 0|OPFL_FlagOutput,
                        0, 5, 0, 2, 3, 4, 5, 
                  20, 
                    OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2TEQrs), 0|OPFL_FlagOutput,
                        0, 5, 1, 2, 3, 4, 5, 
                  0, 
                35, 
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 5,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::TEQri), 0|OPFL_FlagOutput,
                      0, 4, 0, 2, 3, 4, 
                0, 
              32,  ISD::SUB,
                OPC_MoveChild, 0,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 2,
                OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMNzrs), 0|OPFL_FlagOutput,
                    0, 5, 1, 2, 3, 4, 5, 
              0, 
            97, 
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::i32,
              OPC_Scope, 24, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMPzrs), 0|OPFL_FlagOutput,
                    0, 6, 0, 2, 3, 4, 5, 6, 
              66, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::SUB,
                OPC_MoveChild, 0,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 24, 
                  OPC_CheckPredicate, 5,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMNzri), 0|OPFL_FlagOutput,
                      0, 4, 0, 2, 3, 4, 
                24, 
                  OPC_CheckPredicate, 4,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMNzri), 0|OPFL_FlagOutput,
                      0, 4, 0, 2, 3, 4, 
                0, 
              0, 
            82, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 37,  ISD::AND,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2TSTri), 0|OPFL_FlagOutput,
                    0, 4, 0, 2, 3, 4, 
              37,  ISD::XOR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2TEQri), 0|OPFL_FlagOutput,
                    0, 4, 0, 2, 3, 4, 
              0, 
            27, 
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::i32,
              OPC_RecordChild1,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMPzrs), 0|OPFL_FlagOutput,
                  0, 6, 1, 2, 3, 4, 5, 6, 
            72, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SUB,
              OPC_MoveChild, 0,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_Scope, 27, 
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMNzri), 0|OPFL_FlagOutput,
                    0, 4, 1, 2, 3, 4, 
              27, 
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMNzri), 0|OPFL_FlagOutput,
                    0, 4, 1, 2, 3, 4, 
              0, 
            50, 
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::i32,
              OPC_RecordChild1,
              OPC_CheckPatternPredicate, 2,
              OPC_Scope, 20, 
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMPzrs), 0|OPFL_FlagOutput,
                    0, 5, 0, 2, 3, 4, 5, 
              20, 
                OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMPzrs), 0|OPFL_FlagOutput,
                    0, 5, 1, 2, 3, 4, 5, 
              0, 
            64, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 28,  ISD::AND,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::TSTrr), 0|OPFL_FlagOutput,
                    0, 4, 0, 1, 2, 3, 
              28,  ISD::XOR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::TEQrr), 0|OPFL_FlagOutput,
                    0, 4, 0, 1, 2, 3, 
              0, 
            54, 
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::i32,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SUB,
              OPC_MoveChild, 0,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_Scope, 18, 
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMNzrr), 0|OPFL_FlagOutput,
                    0, 4, 0, 1, 2, 3, 
              18, 
                OPC_CheckPatternPredicate, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tCMNz), 0|OPFL_FlagOutput,
                    0, 4, 0, 1, 2, 3, 
              0, 
            32, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::AND,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 6,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::tTST), 0|OPFL_FlagOutput,
                  0, 4, 0, 1, 2, 3, 
            32, 
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::i32,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SUB,
              OPC_MoveChild, 0,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMNzrr), 0|OPFL_FlagOutput,
                  0, 4, 0, 1, 2, 3, 
            7|128,1, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 28,  ISD::AND,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2TSTrr), 0|OPFL_FlagOutput,
                    0, 4, 0, 1, 2, 3, 
              28,  ISD::XOR,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2TEQrr), 0|OPFL_FlagOutput,
                    0, 4, 0, 1, 2, 3, 
              69,  ISD::SUB,
                OPC_MoveChild, 0,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_Scope, 18, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMNzrr), 0|OPFL_FlagOutput,
                      0, 4, 1, 0, 2, 3, 
                18, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tCMNz), 0|OPFL_FlagOutput,
                      0, 4, 1, 0, 2, 3, 
                18, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMNzrr), 0|OPFL_FlagOutput,
                      0, 4, 1, 0, 2, 3, 
                0, 
              0, 
            69|128,1, 
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::i32,
              OPC_RecordChild1,
              OPC_Scope, 4|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 23, 
                  OPC_CheckPredicate, 5,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMPzri), 0|OPFL_FlagOutput,
                      0, 4, 0, 2, 3, 4, 
                26, 
                  OPC_CheckPredicate, 12,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 11, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMNzri), 0|OPFL_FlagOutput,
                      0, 4, 0, 3, 4, 5, 
                23, 
                  OPC_CheckPredicate, 53,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tCMPzi8), 0|OPFL_FlagOutput,
                      0, 4, 0, 2, 3, 4, 
                23, 
                  OPC_CheckPredicate, 4,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMPzri), 0|OPFL_FlagOutput,
                      0, 4, 0, 2, 3, 4, 
                26, 
                  OPC_CheckPredicate, 18,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 12, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMNzri), 0|OPFL_FlagOutput,
                      0, 4, 0, 3, 4, 5, 
                0, 
              18, 
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMPzrr), 0|OPFL_FlagOutput,
                    0, 4, 0, 1, 2, 3, 
              18, 
                OPC_CheckPatternPredicate, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tCMPzr), 0|OPFL_FlagOutput,
                    0, 4, 0, 1, 2, 3, 
              18, 
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMPzrr), 0|OPFL_FlagOutput,
                    0, 4, 0, 1, 2, 3, 
              0, 
            0, 
          45|128,2,  ISD::INTRINSIC_W_CHAIN,
            OPC_RecordNode,
            OPC_MoveChild, 1,
            OPC_CheckInteger, 32, 
            OPC_MoveParent,
            OPC_RecordChild2,
            OPC_CheckChild2Type, MVT::i32,
            OPC_SwitchType , 27,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLD1d8), 0|OPFL_Chain,
                  1, MVT::v8i8, 6, 2, 3, 4, 5, 6, 7, 
            27,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLD1d16), 0|OPFL_Chain,
                  1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
            27,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLD1d32), 0|OPFL_Chain,
                  1, MVT::v2i32, 6, 2, 3, 4, 5, 6, 7, 
            27,  MVT::v2f32,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLD1df), 0|OPFL_Chain,
                  1, MVT::v2f32, 6, 2, 3, 4, 5, 6, 7, 
            27,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLD1d64), 0|OPFL_Chain,
                  1, MVT::v1i64, 6, 2, 3, 4, 5, 6, 7, 
            27,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLD1q8), 0|OPFL_Chain,
                  1, MVT::v16i8, 6, 2, 3, 4, 5, 6, 7, 
            27,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLD1q16), 0|OPFL_Chain,
                  1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
            27,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLD1q32), 0|OPFL_Chain,
                  1, MVT::v4i32, 6, 2, 3, 4, 5, 6, 7, 
            27,  MVT::v4f32,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLD1qf), 0|OPFL_Chain,
                  1, MVT::v4f32, 6, 2, 3, 4, 5, 6, 7, 
            27,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VLD1q64), 0|OPFL_Chain,
                  1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
            0, 
          56|128,2,  ISD::INTRINSIC_VOID,
            OPC_RecordNode,
            OPC_MoveChild, 1,
            OPC_CheckInteger, 105, 
            OPC_MoveParent,
            OPC_RecordChild2,
            OPC_CheckChild2Type, MVT::i32,
            OPC_RecordChild3,
            OPC_Scope, 29, 
              OPC_CheckChild3Type, MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VST1d8), 0|OPFL_Chain,
                  0, 7, 3, 4, 5, 6, 2, 7, 8, 
            29, 
              OPC_CheckChild3Type, MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VST1d16), 0|OPFL_Chain,
                  0, 7, 3, 4, 5, 6, 2, 7, 8, 
            29, 
              OPC_CheckChild3Type, MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VST1d32), 0|OPFL_Chain,
                  0, 7, 3, 4, 5, 6, 2, 7, 8, 
            29, 
              OPC_CheckChild3Type, MVT::v2f32,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VST1df), 0|OPFL_Chain,
                  0, 7, 3, 4, 5, 6, 2, 7, 8, 
            29, 
              OPC_CheckChild3Type, MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VST1d64), 0|OPFL_Chain,
                  0, 7, 3, 4, 5, 6, 2, 7, 8, 
            29, 
              OPC_CheckChild3Type, MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VST1q8), 0|OPFL_Chain,
                  0, 7, 3, 4, 5, 6, 2, 7, 8, 
            29, 
              OPC_CheckChild3Type, MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VST1q16), 0|OPFL_Chain,
                  0, 7, 3, 4, 5, 6, 2, 7, 8, 
            29, 
              OPC_CheckChild3Type, MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VST1q32), 0|OPFL_Chain,
                  0, 7, 3, 4, 5, 6, 2, 7, 8, 
            29, 
              OPC_CheckChild3Type, MVT::v4f32,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VST1qf), 0|OPFL_Chain,
                  0, 7, 3, 4, 5, 6, 2, 7, 8, 
            29, 
              OPC_CheckChild3Type, MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_CheckComplexPat, /*CP*/18, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VST1q64), 0|OPFL_Chain,
                  0, 7, 3, 4, 5, 6, 2, 7, 8, 
            0, 
          5|128,7,  ISD::XOR,
            OPC_Scope, 55|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 69, 
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 27, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::MVNs), 0,
                      1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
                22, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MVNs), 0,
                      1, MVT::i32, 4, 1, 2, 3, 4, 
                0, 
              61, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_Scope, 26, 
                  OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::EORrs), 0,
                      1, MVT::i32, 7, 0, 2, 3, 4, 5, 6, 7, 
                26, 
                  OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::EORrs), 0,
                      1, MVT::i32, 7, 1, 2, 3, 4, 5, 6, 7, 
                0, 
              47, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MVNi), 0,
                    1, MVT::i32, 4, 1, 2, 3, 4, 
              0, 
            48, 
              OPC_MoveChild, 0,
              OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 4,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitConvertToTarget, 0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MVNi), 0,
                  1, MVT::i32, 4, 1, 2, 3, 4, 
            56|128,2, 
              OPC_RecordChild0,
              OPC_Scope, 59, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_Scope, 25, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2EORrs), 0,
                      1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
                25, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2EORrs), 0,
                      1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
                0, 
              83, 
                OPC_MoveChild, 1,
                OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 18, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MVNr), 0,
                      1, MVT::i32, 3, 0, 1, 2, 
                22, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::MVNr), 0,
                      1, MVT::i32, 4, 0, 1, 2, 3, 
                22, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tMVN), 0,
                      1, MVT::i32, 4, 1, 0, 2, 3, 
                0, 
              69, 
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 30, 
                  OPC_CheckPredicate, 5,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::EORri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                30, 
                  OPC_CheckPredicate, 4,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2EORri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                0, 
              94, 
                OPC_MoveChild, 1,
                OPC_SwitchOpcode , 45,  ISD::BUILD_VECTOR,
                  OPC_CheckPredicate, 54,
                  OPC_MoveParent,
                  OPC_SwitchType , 18,  MVT::v2i32,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMVNd), 0,
                        1, MVT::v2i32, 3, 0, 1, 2, 
                  18,  MVT::v4i32,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMVNq), 0,
                        1, MVT::v4i32, 3, 0, 1, 2, 
                  0, 
                41,  ISD::BIT_CONVERT,
                  OPC_CheckPredicate, 2,
                  OPC_MoveParent,
                  OPC_SwitchType , 16,  MVT::v2i32,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMVNd), 0,
                        1, MVT::v2i32, 3, 0, 1, 2, 
                  16,  MVT::v4i32,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMVNq), 0,
                        1, MVT::v4i32, 3, 0, 1, 2, 
                  0, 
                0, 
              0, 
            96, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 46,  ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 54,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 18,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMVNd), 0,
                      1, MVT::v2i32, 3, 0, 1, 2, 
                18,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMVNq), 0,
                      1, MVT::v4i32, 3, 0, 1, 2, 
                0, 
              42,  ISD::BIT_CONVERT,
                OPC_CheckPredicate, 2,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 16,  MVT::v2i32,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMVNd), 0,
                      1, MVT::v2i32, 3, 0, 1, 2, 
                16,  MVT::v4i32,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMVNq), 0,
                      1, MVT::v4i32, 3, 0, 1, 2, 
                0, 
              0, 
            124|128,1, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 126, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 59, 
                  OPC_CheckPredicate, 7,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 2, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::EORri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 3, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::EORri), 0,
                      1, MVT::i32, 5, 7, 9, 10, 11, 12, 
                59, 
                  OPC_CheckPredicate, 8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 4, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::t2EORri), 0,
                      1, MVT::i32, 5, 0, 3, 4, 5, 6, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 5, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2EORri), 0,
                      1, MVT::i32, 5, 7, 9, 10, 11, 12, 
                0, 
              76, 
                OPC_CheckType, MVT::i32,
                OPC_Scope, 23, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::EORrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tEOR), 0,
                      1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2EORrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                0, 
              21, 
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VEORd), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              21, 
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VEORq), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              0, 
            0, 
          106|128,3,  ISD::ADDE,
            OPC_CaptureFlagInput,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_Scope, 32, 
              OPC_CheckPredicate, 55,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADCrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 7, 0, 2, 3, 4, 5, 6, 7, 
            20, 
              OPC_CheckPredicate, 56,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/1,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADCSSrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            32, 
              OPC_CheckPredicate, 55,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADCrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 7, 1, 2, 3, 4, 5, 6, 7, 
            20, 
              OPC_CheckPredicate, 56,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/0,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADCSSrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 4, 1, 2, 3, 4, 
            31, 
              OPC_CheckPredicate, 55,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADCrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
            31, 
              OPC_CheckPredicate, 56,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADCSrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
            31, 
              OPC_CheckPredicate, 55,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADCrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
            31, 
              OPC_CheckPredicate, 56,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADCSrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
            122, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_Scope, 51, 
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 27, 
                  OPC_CheckPredicate, 55,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADCri), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                15, 
                  OPC_CheckPredicate, 56,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADCSSri), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 2, 0, 2, 
                0, 
              63, 
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 27, 
                  OPC_CheckPredicate, 55,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADCri), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                27, 
                  OPC_CheckPredicate, 56,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADCSri), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                0, 
              0, 
            27, 
              OPC_CheckPredicate, 55,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADCrr), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 5, 0, 1, 2, 3, 4, 
            15, 
              OPC_CheckPredicate, 56,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADCSSrr), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 2, 0, 1, 
            27, 
              OPC_CheckPredicate, 55,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADCrr), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 5, 0, 1, 2, 3, 4, 
            27, 
              OPC_CheckPredicate, 56,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADCSrr), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 5, 0, 1, 2, 3, 4, 
            25, 
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 6,
              OPC_EmitRegister, MVT::i32, ARM::CPSR,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::tADC), 0|OPFL_FlagInput|OPFL_FlagOutput,
                  1, MVT::i32, 5, 2, 0, 1, 3, 4, 
            0, 
          96|128,3,  ISD::SUBE,
            OPC_CaptureFlagInput,
            OPC_RecordChild0,
            OPC_Scope, 96|128,1, 
              OPC_RecordChild1,
              OPC_Scope, 32, 
                OPC_CheckPredicate, 57,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SBCrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 7, 0, 2, 3, 4, 5, 6, 7, 
              20, 
                OPC_CheckPredicate, 58,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SBCSSrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 4, 0, 2, 3, 4, 
              78, 
                OPC_CheckPredicate, 57,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 43, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                  OPC_Scope, 23, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::RSCrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                        1, MVT::i32, 7, 1, 2, 3, 4, 5, 6, 7, 
                  11, 
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::RSCSrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                        1, MVT::i32, 4, 1, 2, 3, 4, 
                  0, 
                27, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SBCrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
                0, 
              31, 
                OPC_CheckPredicate, 58,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SBCSrs), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
              55, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 27, 
                  OPC_CheckPredicate, 57,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SBCri), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                15, 
                  OPC_CheckPredicate, 58,
                  OPC_CheckPatternPredicate, 5,
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::SBCSSri), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 2, 0, 2, 
                0, 
              0, 
            50, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 5,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckPredicate, 57,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_EmitConvertToTarget, 0,
              OPC_Scope, 21, 
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::RSCri), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 5, 1, 2, 3, 4, 5, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::RSCSri), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 2, 1, 2, 
              0, 
            69|128,1, 
              OPC_RecordChild1,
              OPC_Scope, 67, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 27, 
                  OPC_CheckPredicate, 57,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SBCri), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                27, 
                  OPC_CheckPredicate, 58,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SBCSri), 0|OPFL_FlagInput|OPFL_FlagOutput,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                0, 
              27, 
                OPC_CheckPredicate, 57,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SBCrr), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              15, 
                OPC_CheckPredicate, 58,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SBCSSrr), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 2, 0, 1, 
              27, 
                OPC_CheckPredicate, 57,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SBCrr), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              27, 
                OPC_CheckPredicate, 58,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SBCSrr), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 5, 0, 1, 2, 3, 4, 
              25, 
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 6,
                OPC_EmitRegister, MVT::i32, ARM::CPSR,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSBC), 0|OPFL_FlagInput|OPFL_FlagOutput,
                    1, MVT::i32, 5, 2, 0, 1, 3, 4, 
              0, 
            0, 
          118,  ARMISD::PIC_ADD,
            OPC_Scope, 67, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ARMISD::Wrapper,
              OPC_RecordChild0,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::TargetConstantPool,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckPredicate, 25,
              OPC_CheckPredicate, 26,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 16, 
                OPC_CheckPatternPredicate, 6,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLDRpci_pic), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 2, 1, 3, 
              16, 
                OPC_CheckPatternPredicate, 2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LDRpci_pic), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 2, 1, 3, 
              0, 
            47, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 21, 
                OPC_CheckPatternPredicate, 5,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::PICADD), 0,
                    1, MVT::i32, 4, 0, 2, 3, 4, 
              13, 
                OPC_CheckPatternPredicate, 9,
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tPICADD), 0,
                    1, MVT::i32, 2, 0, 2, 
              0, 
            0, 
          50|128,12,  ISD::SUB,
            OPC_Scope, 113|128,4, 
              OPC_RecordChild0,
              OPC_Scope, 117, 
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 58, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_Scope, 26, 
                    OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SUBrs), 0,
                        1, MVT::i32, 7, 0, 2, 3, 4, 5, 6, 7, 
                  26, 
                    OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::RSBrs), 0,
                        1, MVT::i32, 7, 1, 2, 3, 4, 5, 6, 7, 
                  0, 
                52, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 25, 
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBrs), 0,
                        1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
                  21, 
                    OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2RSBrs), 0,
                        1, MVT::i32, 5, 1, 2, 3, 4, 5, 
                  0, 
                0, 
              118|128,3, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::MUL,
                OPC_Scope, 6|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_Scope, 62, 
                    OPC_CheckChild0Type, MVT::v4i16,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_SwitchType , 23,  MVT::v4i16,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv4i16), 0,
                          1, MVT::v4i16, 6, 0, 1, 2, 4, 5, 6, 
                    23,  MVT::v8i16,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv8i16), 0,
                          1, MVT::v8i16, 6, 0, 1, 2, 4, 5, 6, 
                    0, 
                  62, 
                    OPC_CheckChild0Type, MVT::v2i32,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_SwitchType , 23,  MVT::v2i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv2i32), 0,
                          1, MVT::v2i32, 6, 0, 1, 2, 4, 5, 6, 
                    23,  MVT::v4i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 3,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv4i32), 0,
                          1, MVT::v4i32, 6, 0, 1, 2, 4, 5, 6, 
                    0, 
                  0, 
                7|128,1, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_Scope, 63, 
                    OPC_CheckChild0Type, MVT::v4i16,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_SwitchType , 23,  MVT::v4i16,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 2,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv4i16), 0,
                          1, MVT::v4i16, 6, 0, 3, 1, 4, 5, 6, 
                    23,  MVT::v8i16,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 2,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv8i16), 0,
                          1, MVT::v8i16, 6, 0, 3, 1, 4, 5, 6, 
                    0, 
                  63, 
                    OPC_CheckChild0Type, MVT::v2i32,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_SwitchType , 23,  MVT::v2i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 2,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv2i32), 0,
                          1, MVT::v2i32, 6, 0, 3, 1, 4, 5, 6, 
                    23,  MVT::v4i32,
                      OPC_CheckPatternPredicate, 3,
                      OPC_EmitConvertToTarget, 2,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv4i32), 0,
                          1, MVT::v4i32, 6, 0, 3, 1, 4, 5, 6, 
                    0, 
                  0, 
                110, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_Scope, 50, 
                    OPC_CheckChild0Type, MVT::v8i16,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v8i16,
                    OPC_EmitConvertToTarget, 3,
                    OPC_EmitNodeXForm, 6, 4,
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::v4i16, 2, 2, 5, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_EmitNodeXForm, 7, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv8i16), 0,
                        1, MVT::v8i16, 6, 0, 1, 6, 8, 9, 10, 
                  50, 
                    OPC_CheckChild0Type, MVT::v4i32,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v4i32,
                    OPC_EmitConvertToTarget, 3,
                    OPC_EmitNodeXForm, 8, 4,
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::v2i32, 2, 2, 5, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_EmitNodeXForm, 9, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv4i32), 0,
                        1, MVT::v4i32, 6, 0, 1, 6, 8, 9, 10, 
                  0, 
                111, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_Scope, 51, 
                    OPC_CheckChild0Type, MVT::v8i16,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v8i16,
                    OPC_EmitConvertToTarget, 2,
                    OPC_EmitNodeXForm, 6, 4,
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::v4i16, 2, 1, 5, 
                    OPC_EmitConvertToTarget, 2,
                    OPC_EmitNodeXForm, 7, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv8i16), 0,
                        1, MVT::v8i16, 6, 0, 3, 6, 8, 9, 10, 
                  51, 
                    OPC_CheckChild0Type, MVT::v4i32,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v4i32,
                    OPC_EmitConvertToTarget, 2,
                    OPC_EmitNodeXForm, 8, 4,
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::v2i32, 2, 1, 5, 
                    OPC_EmitConvertToTarget, 2,
                    OPC_EmitNodeXForm, 9, 7,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslv4i32), 0,
                        1, MVT::v4i32, 6, 0, 3, 6, 8, 9, 10, 
                  0, 
                0, 
              0, 
            30, 
              OPC_MoveChild, 0,
              OPC_CheckInteger, 0, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 6,
              OPC_EmitRegister, MVT::i32, ARM::CPSR,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::tRSB), 0,
                  1, MVT::i32, 4, 1, 0, 2, 3, 
            49|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 35, 
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SUBri), 0,
                    1, MVT::i32, 5, 0, 2, 3, 4, 5, 
              35, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::RSBri), 0,
                    1, MVT::i32, 5, 1, 2, 3, 4, 5, 
              69, 
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 30, 
                  OPC_CheckPredicate, 4,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                30, 
                  OPC_CheckPredicate, 17,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBri12), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                0, 
              31, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 0,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2RSBri), 0,
                    1, MVT::i32, 4, 1, 2, 3, 4, 
              0, 
            120|128,1, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 126,  ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 59,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 18,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs8d), 0,
                      1, MVT::v8i8, 3, 0, 1, 2, 
                18,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs16d), 0,
                      1, MVT::v4i16, 3, 0, 1, 2, 
                18,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs32d), 0,
                      1, MVT::v2i32, 3, 0, 1, 2, 
                18,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs8q), 0,
                      1, MVT::v16i8, 3, 0, 1, 2, 
                18,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs16q), 0,
                      1, MVT::v8i16, 3, 0, 1, 2, 
                18,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs32q), 0,
                      1, MVT::v4i32, 3, 0, 1, 2, 
                0, 
              114,  ISD::BIT_CONVERT,
                OPC_CheckPredicate, 60,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 16,  MVT::v8i8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs8d), 0,
                      1, MVT::v8i8, 3, 0, 1, 2, 
                16,  MVT::v4i16,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs16d), 0,
                      1, MVT::v4i16, 3, 0, 1, 2, 
                16,  MVT::v2i32,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs32d), 0,
                      1, MVT::v2i32, 3, 0, 1, 2, 
                16,  MVT::v16i8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs8q), 0,
                      1, MVT::v16i8, 3, 0, 1, 2, 
                16,  MVT::v8i16,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs16q), 0,
                      1, MVT::v8i16, 3, 0, 1, 2, 
                16,  MVT::v4i32,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGs32q), 0,
                      1, MVT::v4i32, 3, 0, 1, 2, 
                0, 
              0, 
            111|128,3, 
              OPC_RecordChild0,
              OPC_Scope, 113|128,1, 
                OPC_MoveChild, 1,
                OPC_SwitchOpcode , 55|128,1,  ISD::MUL,
                  OPC_RecordChild0,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_SwitchType , 44,  MVT::i32,
                    OPC_Scope, 20, 
                      OPC_CheckPatternPredicate, 4,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::MLS), 0,
                          1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                    20, 
                      OPC_CheckPatternPredicate, 2,
                      OPC_EmitInteger, MVT::i32, 14, 
                      OPC_EmitRegister, MVT::i32, 0 ,
                      OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MLS), 0,
                          1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                    0, 
                  20,  MVT::v8i8,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSv8i8), 0,
                        1, MVT::v8i8, 5, 0, 1, 2, 3, 4, 
                  20,  MVT::v4i16,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSv4i16), 0,
                        1, MVT::v4i16, 5, 0, 1, 2, 3, 4, 
                  20,  MVT::v2i32,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSv2i32), 0,
                        1, MVT::v2i32, 5, 0, 1, 2, 3, 4, 
                  20,  MVT::v16i8,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSv16i8), 0,
                        1, MVT::v16i8, 5, 0, 1, 2, 3, 4, 
                  20,  MVT::v8i16,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSv8i16), 0,
                        1, MVT::v8i16, 5, 0, 1, 2, 3, 4, 
                  20,  MVT::v4i32,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSv4i32), 0,
                        1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                  0, 
                49,  ISD::MULHS,
                  OPC_RecordChild0,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_Scope, 20, 
                    OPC_CheckPatternPredicate, 0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SMMLS), 0,
                        1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                  20, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SMMLS), 0,
                        1, MVT::i32, 5, 1, 2, 0, 3, 4, 
                  0, 
                0, 
              119|128,1, 
                OPC_RecordChild1,
                OPC_SwitchType , 74,  MVT::i32,
                  OPC_Scope, 23, 
                    OPC_CheckPatternPredicate, 5,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SUBrr), 0,
                        1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                  23, 
                    OPC_CheckPatternPredicate, 6,
                    OPC_EmitRegister, MVT::i32, ARM::CPSR,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSUBrr), 0,
                        1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                  23, 
                    OPC_CheckPatternPredicate, 2,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBrr), 0,
                        1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                  0, 
                19,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBv8i8), 0,
                      1, MVT::v8i8, 4, 0, 1, 2, 3, 
                19,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBv4i16), 0,
                      1, MVT::v4i16, 4, 0, 1, 2, 3, 
                19,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBv2i32), 0,
                      1, MVT::v2i32, 4, 0, 1, 2, 3, 
                19,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBv16i8), 0,
                      1, MVT::v16i8, 4, 0, 1, 2, 3, 
                19,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBv8i16), 0,
                      1, MVT::v8i16, 4, 0, 1, 2, 3, 
                19,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBv4i32), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                19,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBv1i64), 0,
                      1, MVT::v1i64, 4, 0, 1, 2, 3, 
                19,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBv2i64), 0,
                      1, MVT::v2i64, 4, 0, 1, 2, 3, 
                0, 
              0, 
            0, 
          114|128,2,  ISD::ADDC,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_Scope, 104, 
              OPC_CheckType, MVT::i32,
              OPC_Scope, 50, 
                OPC_CheckPatternPredicate, 5,
                OPC_Scope, 22, 
                  OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADDSrs), 0|OPFL_FlagOutput,
                      1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
                22, 
                  OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADDSrs), 0|OPFL_FlagOutput,
                      1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
                0, 
              48, 
                OPC_CheckPatternPredicate, 2,
                OPC_Scope, 21, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADDSrs), 0|OPFL_FlagOutput,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                21, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADDSrs), 0|OPFL_FlagOutput,
                      1, MVT::i32, 5, 1, 2, 3, 4, 5, 
                0, 
              0, 
            62|128,1, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_Scope, 26, 
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADDSri), 0|OPFL_FlagOutput,
                    1, MVT::i32, 4, 0, 2, 3, 4, 
              30, 
                OPC_CheckPredicate, 13,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 6,
                OPC_EmitRegister, MVT::i32, ARM::CPSR,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tADDi3), 0|OPFL_FlagOutput,
                    1, MVT::i32, 5, 2, 0, 3, 4, 5, 
              30, 
                OPC_CheckPredicate, 14,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 6,
                OPC_EmitRegister, MVT::i32, ARM::CPSR,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tADDi8), 0|OPFL_FlagOutput,
                    1, MVT::i32, 5, 2, 0, 3, 4, 5, 
              33, 
                OPC_CheckPredicate, 15,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 6,
                OPC_EmitRegister, MVT::i32, ARM::CPSR,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 10, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSUBi3), 0|OPFL_FlagOutput,
                    1, MVT::i32, 5, 2, 0, 4, 5, 6, 
              33, 
                OPC_CheckPredicate, 16,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 6,
                OPC_EmitRegister, MVT::i32, ARM::CPSR,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 10, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSUBi8), 0|OPFL_FlagOutput,
                    1, MVT::i32, 5, 2, 0, 4, 5, 6, 
              26, 
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADDSri), 0|OPFL_FlagOutput,
                    1, MVT::i32, 4, 0, 2, 3, 4, 
              0, 
            68, 
              OPC_CheckType, MVT::i32,
              OPC_Scope, 19, 
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADDSrr), 0|OPFL_FlagOutput,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              23, 
                OPC_CheckPatternPredicate, 6,
                OPC_EmitRegister, MVT::i32, ARM::CPSR,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tADDrr), 0|OPFL_FlagOutput,
                    1, MVT::i32, 5, 2, 0, 1, 3, 4, 
              19, 
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2ADDSrr), 0|OPFL_FlagOutput,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              0, 
            0, 
          46|128,2,  ISD::SUBC,
            OPC_RecordChild0,
            OPC_Scope, 7|128,1, 
              OPC_RecordChild1,
              OPC_Scope, 100, 
                OPC_CheckType, MVT::i32,
                OPC_Scope, 50, 
                  OPC_CheckPatternPredicate, 5,
                  OPC_Scope, 22, 
                    OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::SUBSrs), 0|OPFL_FlagOutput,
                        1, MVT::i32, 6, 0, 2, 3, 4, 5, 6, 
                  22, 
                    OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::RSBSrs), 0|OPFL_FlagOutput,
                        1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
                  0, 
                44, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_Scope, 21, 
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBSrs), 0|OPFL_FlagOutput,
                        1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                  17, 
                    OPC_CheckComplexPat, /*CP*/0, /*#*/0,
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2RSBSrs), 0|OPFL_FlagOutput,
                        1, MVT::i32, 4, 1, 2, 3, 4, 
                  0, 
                0, 
              30, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SUBSri), 0|OPFL_FlagOutput,
                    1, MVT::i32, 4, 0, 2, 3, 4, 
              0, 
            31, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 5,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_EmitConvertToTarget, 0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::RSBSri), 0|OPFL_FlagOutput,
                  1, MVT::i32, 4, 1, 2, 3, 4, 
            31, 
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 4,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBSri), 0|OPFL_FlagOutput,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            27, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckPredicate, 4,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 2,
              OPC_EmitConvertToTarget, 0,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2RSBSri), 0|OPFL_FlagOutput,
                  1, MVT::i32, 3, 1, 2, 3, 
            69, 
              OPC_RecordChild1,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 19, 
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::SUBSrr), 0|OPFL_FlagOutput,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              23, 
                OPC_CheckPatternPredicate, 6,
                OPC_EmitRegister, MVT::i32, ARM::CPSR,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tSUBrr), 0|OPFL_FlagOutput,
                    1, MVT::i32, 5, 2, 0, 1, 3, 4, 
              19, 
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2SUBSrr), 0|OPFL_FlagOutput,
                    1, MVT::i32, 4, 0, 1, 2, 3, 
              0, 
            0, 
          61|128,1,  ARMISD::CMP,
            OPC_RecordChild0,
            OPC_CheckChild0Type, MVT::i32,
            OPC_RecordChild1,
            OPC_Scope, 23, 
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMPrs), 0|OPFL_FlagOutput,
                  0, 6, 0, 2, 3, 4, 5, 6, 
            22, 
              OPC_CheckPatternPredicate, 2,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMPrs), 0|OPFL_FlagOutput,
                  0, 5, 0, 2, 3, 4, 5, 
            78, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_Scope, 23, 
                OPC_CheckPredicate, 5,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 5,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMPri), 0|OPFL_FlagOutput,
                    0, 4, 0, 2, 3, 4, 
              23, 
                OPC_CheckPredicate, 53,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 6,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tCMPi8), 0|OPFL_FlagOutput,
                    0, 4, 0, 2, 3, 4, 
              23, 
                OPC_CheckPredicate, 4,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMPri), 0|OPFL_FlagOutput,
                    0, 4, 0, 2, 3, 4, 
              0, 
            18, 
              OPC_CheckPatternPredicate, 5,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::CMPrr), 0|OPFL_FlagOutput,
                  0, 4, 0, 1, 2, 3, 
            18, 
              OPC_CheckPatternPredicate, 6,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::tCMPr), 0|OPFL_FlagOutput,
                  0, 4, 0, 1, 2, 3, 
            18, 
              OPC_CheckPatternPredicate, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2CMPrr), 0|OPFL_FlagOutput,
                  0, 4, 0, 1, 2, 3, 
            0, 
          47|128,111,  ISD::INTRINSIC_WO_CHAIN,
            OPC_MoveChild, 0,
            OPC_Scope, 37|128,5, 
              OPC_CheckInteger, 68, 
              OPC_MoveParent,
              OPC_Scope, 47|128,1, 
                OPC_RecordChild1,
                OPC_Scope, 42, 
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv4i16), 0,
                      1, MVT::v4i16, 5, 0, 1, 3, 4, 5, 
                42, 
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv2i32), 0,
                      1, MVT::v2i32, 5, 0, 1, 3, 4, 5, 
                42, 
                  OPC_CheckChild1Type, MVT::v8i16,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv8i16), 0,
                      1, MVT::v8i16, 5, 0, 1, 3, 4, 5, 
                42, 
                  OPC_CheckChild1Type, MVT::v4i32,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
                0, 
              21|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_Scope, 70, 
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_SwitchType , 28,  MVT::v4i16,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckChild2Type, MVT::v4i16,
                    OPC_CheckType, MVT::v4i16,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv4i16), 0,
                        1, MVT::v4i16, 5, 2, 0, 3, 4, 5, 
                  28,  MVT::v8i16,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckChild2Type, MVT::v8i16,
                    OPC_CheckType, MVT::v8i16,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv8i16), 0,
                        1, MVT::v8i16, 5, 2, 0, 3, 4, 5, 
                  0, 
                70, 
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_SwitchType , 28,  MVT::v2i32,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckChild2Type, MVT::v2i32,
                    OPC_CheckType, MVT::v2i32,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv2i32), 0,
                        1, MVT::v2i32, 5, 2, 0, 3, 4, 5, 
                  28,  MVT::v4i32,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckChild2Type, MVT::v4i32,
                    OPC_CheckType, MVT::v4i32,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv4i32), 0,
                        1, MVT::v4i32, 5, 2, 0, 3, 4, 5, 
                  0, 
                0, 
              119, 
                OPC_RecordChild1,
                OPC_Scope, 57, 
                  OPC_CheckChild1Type, MVT::v8i16,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v8i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitNodeXForm, 6, 3,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v4i16, 2, 1, 4, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitNodeXForm, 7, 6,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv8i16), 0,
                      1, MVT::v8i16, 5, 0, 5, 7, 8, 9, 
                57, 
                  OPC_CheckChild1Type, MVT::v4i32,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitNodeXForm, 8, 3,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v2i32, 2, 1, 4, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitNodeXForm, 9, 6,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv4i32), 0,
                      1, MVT::v4i32, 5, 0, 5, 7, 8, 9, 
                0, 
              115, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_Scope, 53, 
                  OPC_CheckChild0Type, MVT::v8i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v8i16,
                  OPC_CheckType, MVT::v8i16,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 6, 3,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v4i16, 2, 0, 4, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 7, 6,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv8i16), 0,
                      1, MVT::v8i16, 5, 2, 5, 7, 8, 9, 
                53, 
                  OPC_CheckChild0Type, MVT::v4i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i32,
                  OPC_CheckType, MVT::v4i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 8, 3,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v2i32, 2, 0, 4, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 9, 6,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHslv4i32), 0,
                      1, MVT::v4i32, 5, 2, 5, 7, 8, 9, 
                0, 
              107, 
                OPC_RecordChild1,
                OPC_SwitchType , 24,  MVT::v4i16,
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHv4i16), 0,
                      1, MVT::v4i16, 4, 0, 1, 2, 3, 
                24,  MVT::v2i32,
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHv2i32), 0,
                      1, MVT::v2i32, 4, 0, 1, 2, 3, 
                24,  MVT::v8i16,
                  OPC_CheckChild1Type, MVT::v8i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHv8i16), 0,
                      1, MVT::v8i16, 4, 0, 1, 2, 3, 
                24,  MVT::v4i32,
                  OPC_CheckChild1Type, MVT::v4i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULHv4i32), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                0, 
              0, 
            37|128,5, 
              OPC_CheckInteger, 74, 
              OPC_MoveParent,
              OPC_Scope, 47|128,1, 
                OPC_RecordChild1,
                OPC_Scope, 42, 
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv4i16), 0,
                      1, MVT::v4i16, 5, 0, 1, 3, 4, 5, 
                42, 
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv2i32), 0,
                      1, MVT::v2i32, 5, 0, 1, 3, 4, 5, 
                42, 
                  OPC_CheckChild1Type, MVT::v8i16,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv8i16), 0,
                      1, MVT::v8i16, 5, 0, 1, 3, 4, 5, 
                42, 
                  OPC_CheckChild1Type, MVT::v4i32,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
                0, 
              21|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_Scope, 70, 
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_SwitchType , 28,  MVT::v4i16,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckChild2Type, MVT::v4i16,
                    OPC_CheckType, MVT::v4i16,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv4i16), 0,
                        1, MVT::v4i16, 5, 2, 0, 3, 4, 5, 
                  28,  MVT::v8i16,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckChild2Type, MVT::v8i16,
                    OPC_CheckType, MVT::v8i16,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv8i16), 0,
                        1, MVT::v8i16, 5, 2, 0, 3, 4, 5, 
                  0, 
                70, 
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_SwitchType , 28,  MVT::v2i32,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckChild2Type, MVT::v2i32,
                    OPC_CheckType, MVT::v2i32,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv2i32), 0,
                        1, MVT::v2i32, 5, 2, 0, 3, 4, 5, 
                  28,  MVT::v4i32,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckChild2Type, MVT::v4i32,
                    OPC_CheckType, MVT::v4i32,
                    OPC_CheckPatternPredicate, 3,
                    OPC_EmitConvertToTarget, 1,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv4i32), 0,
                        1, MVT::v4i32, 5, 2, 0, 3, 4, 5, 
                  0, 
                0, 
              119, 
                OPC_RecordChild1,
                OPC_Scope, 57, 
                  OPC_CheckChild1Type, MVT::v8i16,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v8i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitNodeXForm, 6, 3,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v4i16, 2, 1, 4, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitNodeXForm, 7, 6,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv8i16), 0,
                      1, MVT::v8i16, 5, 0, 5, 7, 8, 9, 
                57, 
                  OPC_CheckChild1Type, MVT::v4i32,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitNodeXForm, 8, 3,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v2i32, 2, 1, 4, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitNodeXForm, 9, 6,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv4i32), 0,
                      1, MVT::v4i32, 5, 0, 5, 7, 8, 9, 
                0, 
              115, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_Scope, 53, 
                  OPC_CheckChild0Type, MVT::v8i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v8i16,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v8i16,
                  OPC_CheckType, MVT::v8i16,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 6, 3,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v4i16, 2, 0, 4, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 7, 6,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv8i16), 0,
                      1, MVT::v8i16, 5, 2, 5, 7, 8, 9, 
                53, 
                  OPC_CheckChild0Type, MVT::v4i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i32,
                  OPC_CheckType, MVT::v4i32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 8, 3,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v2i32, 2, 0, 4, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 9, 6,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHslv4i32), 0,
                      1, MVT::v4i32, 5, 2, 5, 7, 8, 9, 
                0, 
              107, 
                OPC_RecordChild1,
                OPC_SwitchType , 24,  MVT::v4i16,
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHv4i16), 0,
                      1, MVT::v4i16, 4, 0, 1, 2, 3, 
                24,  MVT::v2i32,
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHv2i32), 0,
                      1, MVT::v2i32, 4, 0, 1, 2, 3, 
                24,  MVT::v8i16,
                  OPC_CheckChild1Type, MVT::v8i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHv8i16), 0,
                      1, MVT::v8i16, 4, 0, 1, 2, 3, 
                24,  MVT::v4i32,
                  OPC_CheckChild1Type, MVT::v4i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRDMULHv4i32), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                0, 
              0, 
            7|128,2, 
              OPC_CheckInteger, 51, 
              OPC_MoveParent,
              OPC_Scope, 89, 
                OPC_RecordChild1,
                OPC_Scope, 42, 
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLslsv4i16), 0,
                      1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
                42, 
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLslsv2i32), 0,
                      1, MVT::v2i64, 5, 0, 1, 3, 4, 5, 
                0, 
              85, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_Scope, 38, 
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLslsv4i16), 0,
                      1, MVT::v4i32, 5, 2, 0, 3, 4, 5, 
                38, 
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLslsv2i32), 0,
                      1, MVT::v2i64, 5, 2, 0, 3, 4, 5, 
                0, 
              81, 
                OPC_RecordChild1,
                OPC_SwitchType , 24,  MVT::v4i32,
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLsv4i32), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                24,  MVT::v2i64,
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLsv2i64), 0,
                      1, MVT::v2i64, 4, 0, 1, 2, 3, 
                24,  MVT::v8i16,
                  OPC_CheckChild1Type, MVT::v8i8,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLsv8i16), 0,
                      1, MVT::v8i16, 4, 0, 1, 2, 3, 
                0, 
              0, 
            7|128,2, 
              OPC_CheckInteger, 52, 
              OPC_MoveParent,
              OPC_Scope, 89, 
                OPC_RecordChild1,
                OPC_Scope, 42, 
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLsluv4i16), 0,
                      1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
                42, 
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLsluv2i32), 0,
                      1, MVT::v2i64, 5, 0, 1, 3, 4, 5, 
                0, 
              85, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_Scope, 38, 
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLsluv4i16), 0,
                      1, MVT::v4i32, 5, 2, 0, 3, 4, 5, 
                38, 
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLsluv2i32), 0,
                      1, MVT::v2i64, 5, 2, 0, 3, 4, 5, 
                0, 
              81, 
                OPC_RecordChild1,
                OPC_SwitchType , 24,  MVT::v4i32,
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLuv4i32), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                24,  MVT::v2i64,
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLuv2i64), 0,
                      1, MVT::v2i64, 4, 0, 1, 2, 3, 
                24,  MVT::v8i16,
                  OPC_CheckChild1Type, MVT::v8i8,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLuv8i16), 0,
                      1, MVT::v8i16, 4, 0, 1, 2, 3, 
                0, 
              0, 
            109|128,1, 
              OPC_CheckInteger, 69, 
              OPC_MoveParent,
              OPC_Scope, 89, 
                OPC_RecordChild1,
                OPC_Scope, 42, 
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULLslv4i16), 0,
                      1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
                42, 
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULLslv2i32), 0,
                      1, MVT::v2i64, 5, 0, 1, 3, 4, 5, 
                0, 
              85, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_Scope, 38, 
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULLslv4i16), 0,
                      1, MVT::v4i32, 5, 2, 0, 3, 4, 5, 
                38, 
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULLslv2i32), 0,
                      1, MVT::v2i64, 5, 2, 0, 3, 4, 5, 
                0, 
              55, 
                OPC_RecordChild1,
                OPC_SwitchType , 24,  MVT::v4i32,
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULLv4i32), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                24,  MVT::v2i64,
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMULLv2i64), 0,
                      1, MVT::v2i64, 4, 0, 1, 2, 3, 
                0, 
              0, 
            116|128,2, 
              OPC_CheckInteger, 43, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 75, 
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALslsv4i16), 0,
                      1, MVT::v4i32, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALsv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALslsv2i32), 0,
                      1, MVT::v2i64, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALsv2i64), 0,
                      1, MVT::v2i64, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALslsv4i16), 0,
                      1, MVT::v4i32, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALsv4i32), 0,
                      1, MVT::v4i32, 5, 1, 0, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALslsv2i32), 0,
                      1, MVT::v2i64, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALsv2i64), 0,
                      1, MVT::v2i64, 5, 1, 0, 2, 3, 4, 
                0, 
              30, 
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALsv8i16), 0,
                    1, MVT::v8i16, 5, 0, 1, 2, 3, 4, 
              30, 
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALsv8i16), 0,
                    1, MVT::v8i16, 5, 1, 0, 2, 3, 4, 
              0, 
            116|128,2, 
              OPC_CheckInteger, 44, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 75, 
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALsluv4i16), 0,
                      1, MVT::v4i32, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALuv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALsluv2i32), 0,
                      1, MVT::v2i64, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALuv2i64), 0,
                      1, MVT::v2i64, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALsluv4i16), 0,
                      1, MVT::v4i32, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALuv4i32), 0,
                      1, MVT::v4i32, 5, 1, 0, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALsluv2i32), 0,
                      1, MVT::v2i64, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALuv2i64), 0,
                      1, MVT::v2i64, 5, 1, 0, 2, 3, 4, 
                0, 
              30, 
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALuv8i16), 0,
                    1, MVT::v8i16, 5, 0, 1, 2, 3, 4, 
              30, 
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLALuv8i16), 0,
                    1, MVT::v8i16, 5, 1, 0, 2, 3, 4, 
              0, 
            54|128,2, 
              OPC_CheckInteger, 66, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 75, 
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLALslv4i16), 0,
                      1, MVT::v4i32, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLALv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLALslv2i32), 0,
                      1, MVT::v2i64, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLALv2i64), 0,
                      1, MVT::v2i64, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLALslv4i16), 0,
                      1, MVT::v4i32, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLALv4i32), 0,
                      1, MVT::v4i32, 5, 1, 0, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLALslv2i32), 0,
                      1, MVT::v2i64, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLALv2i64), 0,
                      1, MVT::v2i64, 5, 1, 0, 2, 3, 4, 
                0, 
              0, 
            116|128,2, 
              OPC_CheckInteger, 45, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 75, 
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLslsv4i16), 0,
                      1, MVT::v4i32, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLsv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLslsv2i32), 0,
                      1, MVT::v2i64, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLsv2i64), 0,
                      1, MVT::v2i64, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLslsv4i16), 0,
                      1, MVT::v4i32, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLsv4i32), 0,
                      1, MVT::v4i32, 5, 1, 0, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLslsv2i32), 0,
                      1, MVT::v2i64, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLsv2i64), 0,
                      1, MVT::v2i64, 5, 1, 0, 2, 3, 4, 
                0, 
              30, 
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLsv8i16), 0,
                    1, MVT::v8i16, 5, 0, 1, 2, 3, 4, 
              30, 
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLsv8i16), 0,
                    1, MVT::v8i16, 5, 1, 0, 2, 3, 4, 
              0, 
            116|128,2, 
              OPC_CheckInteger, 46, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 75, 
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLsluv4i16), 0,
                      1, MVT::v4i32, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLuv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLsluv2i32), 0,
                      1, MVT::v2i64, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLuv2i64), 0,
                      1, MVT::v2i64, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLsluv4i16), 0,
                      1, MVT::v4i32, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLuv4i32), 0,
                      1, MVT::v4i32, 5, 1, 0, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLsluv2i32), 0,
                      1, MVT::v2i64, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLuv2i64), 0,
                      1, MVT::v2i64, 5, 1, 0, 2, 3, 4, 
                0, 
              30, 
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLuv8i16), 0,
                    1, MVT::v8i16, 5, 0, 1, 2, 3, 4, 
              30, 
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSLuv8i16), 0,
                    1, MVT::v8i16, 5, 1, 0, 2, 3, 4, 
              0, 
            54|128,2, 
              OPC_CheckInteger, 67, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 75, 
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLSLslv4i16), 0,
                      1, MVT::v4i32, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLSLv4i32), 0,
                      1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLSLslv2i32), 0,
                      1, MVT::v2i64, 6, 0, 1, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLSLv2i64), 0,
                      1, MVT::v2i64, 5, 0, 1, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLSLslv4i16), 0,
                      1, MVT::v4i32, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v4i16,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLSLv4i32), 0,
                      1, MVT::v4i32, 5, 1, 0, 2, 3, 4, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_Scope, 41, 
                  OPC_MoveChild, 3,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLSLslv2i32), 0,
                      1, MVT::v2i64, 6, 1, 0, 2, 4, 5, 6, 
                25, 
                  OPC_RecordChild3,
                  OPC_CheckChild3Type, MVT::v2i32,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQDMLSLv2i64), 0,
                      1, MVT::v2i64, 5, 1, 0, 2, 3, 4, 
                0, 
              0, 
            70, 
              OPC_CheckInteger, 24, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 31, 
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCVTf2xsd), 0,
                    1, MVT::v2i32, 4, 0, 2, 3, 4, 
              31, 
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCVTf2xsq), 0,
                    1, MVT::v4i32, 4, 0, 2, 3, 4, 
              0, 
            70, 
              OPC_CheckInteger, 25, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 31, 
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCVTf2xud), 0,
                    1, MVT::v2i32, 4, 0, 2, 3, 4, 
              31, 
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCVTf2xuq), 0,
                    1, MVT::v4i32, 4, 0, 2, 3, 4, 
              0, 
            70, 
              OPC_CheckInteger, 26, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 31, 
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCVTxs2fd), 0,
                    1, MVT::v2f32, 4, 0, 2, 3, 4, 
              31, 
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCVTxs2fq), 0,
                    1, MVT::v4f32, 4, 0, 2, 3, 4, 
              0, 
            70, 
              OPC_CheckInteger, 27, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 31, 
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCVTxu2fd), 0,
                    1, MVT::v2f32, 4, 0, 2, 3, 4, 
              31, 
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCVTxu2fq), 0,
                    1, MVT::v4f32, 4, 0, 2, 3, 4, 
              0, 
            84, 
              OPC_CheckInteger, 17, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDLsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDLsv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDLsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 18, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDLuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDLuv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDLuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              0, 
            40|128,1, 
              OPC_CheckInteger, 19, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 52,  MVT::v8i16,
                OPC_Scope, 24, 
                  OPC_CheckChild1Type, MVT::v8i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWsv8i16), 0,
                      1, MVT::v8i16, 4, 0, 1, 2, 3, 
                24, 
                  OPC_CheckChild1Type, MVT::v8i8,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWsv8i16), 0,
                      1, MVT::v8i16, 4, 1, 0, 2, 3, 
                0, 
              52,  MVT::v4i32,
                OPC_Scope, 24, 
                  OPC_CheckChild1Type, MVT::v4i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWsv4i32), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                24, 
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWsv4i32), 0,
                      1, MVT::v4i32, 4, 1, 0, 2, 3, 
                0, 
              52,  MVT::v2i64,
                OPC_Scope, 24, 
                  OPC_CheckChild1Type, MVT::v2i64,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWsv2i64), 0,
                      1, MVT::v2i64, 4, 0, 1, 2, 3, 
                24, 
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWsv2i64), 0,
                      1, MVT::v2i64, 4, 1, 0, 2, 3, 
                0, 
              0, 
            40|128,1, 
              OPC_CheckInteger, 20, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 52,  MVT::v8i16,
                OPC_Scope, 24, 
                  OPC_CheckChild1Type, MVT::v8i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWuv8i16), 0,
                      1, MVT::v8i16, 4, 0, 1, 2, 3, 
                24, 
                  OPC_CheckChild1Type, MVT::v8i8,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWuv8i16), 0,
                      1, MVT::v8i16, 4, 1, 0, 2, 3, 
                0, 
              52,  MVT::v4i32,
                OPC_Scope, 24, 
                  OPC_CheckChild1Type, MVT::v4i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWuv4i32), 0,
                      1, MVT::v4i32, 4, 0, 1, 2, 3, 
                24, 
                  OPC_CheckChild1Type, MVT::v4i16,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWuv4i32), 0,
                      1, MVT::v4i32, 4, 1, 0, 2, 3, 
                0, 
              52,  MVT::v2i64,
                OPC_Scope, 24, 
                  OPC_CheckChild1Type, MVT::v2i64,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWuv2i64), 0,
                      1, MVT::v2i64, 4, 0, 1, 2, 3, 
                24, 
                  OPC_CheckChild1Type, MVT::v2i32,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::v2i64,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDWuv2i64), 0,
                      1, MVT::v2i64, 4, 1, 0, 2, 3, 
                0, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 28, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 29, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHADDuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 91, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 92, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRHADDuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 64, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDsv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDsv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 65, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDuv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQADDuv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 16, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDHNv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDHNv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDHNv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 88, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRADDHNv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRADDHNv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRADDHNv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              0, 
            58, 
              OPC_CheckInteger, 53, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULpd), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULpq), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              0, 
            30, 
              OPC_CheckInteger, 50, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckChild1Type, MVT::v8i8,
              OPC_RecordChild2,
              OPC_CheckChild2Type, MVT::v8i8,
              OPC_CheckType, MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULLp), 0,
                  1, MVT::v8i16, 4, 0, 1, 2, 3, 
            84, 
              OPC_CheckInteger, 113, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBLsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBLsv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBLsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 114, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBLuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBLuv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBLuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 115, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBWsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBWsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBWsv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 116, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBWuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBWuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBWuv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 30, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 31, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VHSUBuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 86, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBsv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBsv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 87, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBuv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSUBuv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 112, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBHNv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBHNv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBHNv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 98, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSUBHNv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSUBHNv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSUBHNv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              0, 
            24, 
              OPC_CheckInteger, 12, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VACGEd), 0,
                  1, MVT::v2i32, 4, 0, 1, 2, 3, 
            24, 
              OPC_CheckInteger, 13, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VACGEq), 0,
                  1, MVT::v4i32, 4, 0, 1, 2, 3, 
            24, 
              OPC_CheckInteger, 14, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VACGTd), 0,
                  1, MVT::v2i32, 4, 0, 1, 2, 3, 
            24, 
              OPC_CheckInteger, 15, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VACGTq), 0,
                  1, MVT::v4i32, 4, 0, 1, 2, 3, 
            86|128,1, 
              OPC_CheckInteger, 9, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDfd), 0,
                    1, MVT::v2f32, 4, 0, 1, 2, 3, 
              24,  MVT::v4f32,
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDfq), 0,
                    1, MVT::v4f32, 4, 0, 1, 2, 3, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 10, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 7, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDLsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDLsv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDLsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 8, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDLuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDLuv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABDLuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              0, 
            58|128,1, 
              OPC_CheckInteger, 5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 28,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAsv8i8), 0,
                    1, MVT::v8i8, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAsv4i16), 0,
                    1, MVT::v4i16, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAsv2i32), 0,
                    1, MVT::v2i32, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAsv16i8), 0,
                    1, MVT::v16i8, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAsv8i16), 0,
                    1, MVT::v8i16, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAsv4i32), 0,
                    1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
              0, 
            58|128,1, 
              OPC_CheckInteger, 6, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 28,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAuv8i8), 0,
                    1, MVT::v8i8, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAuv4i16), 0,
                    1, MVT::v4i16, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAuv2i32), 0,
                    1, MVT::v2i32, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAuv16i8), 0,
                    1, MVT::v16i8, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAuv8i16), 0,
                    1, MVT::v8i16, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABAuv4i32), 0,
                    1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
              0, 
            96, 
              OPC_CheckInteger, 3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 28,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABALsv4i32), 0,
                    1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABALsv2i64), 0,
                    1, MVT::v2i64, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABALsv8i16), 0,
                    1, MVT::v8i16, 5, 0, 1, 2, 3, 4, 
              0, 
            96, 
              OPC_CheckInteger, 4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 28,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABALuv4i32), 0,
                    1, MVT::v4i32, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABALuv2i64), 0,
                    1, MVT::v2i64, 5, 0, 1, 2, 3, 4, 
              28,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_RecordChild3,
                OPC_CheckChild3Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABALuv8i16), 0,
                    1, MVT::v8i16, 5, 0, 1, 2, 3, 4, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 39, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXfd), 0,
                    1, MVT::v2f32, 4, 0, 1, 2, 3, 
              24,  MVT::v4f32,
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXfq), 0,
                    1, MVT::v4f32, 4, 0, 1, 2, 3, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 40, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMAXuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 41, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINfd), 0,
                    1, MVT::v2f32, 4, 0, 1, 2, 3, 
              24,  MVT::v4f32,
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINfq), 0,
                    1, MVT::v4f32, 4, 0, 1, 2, 3, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 42, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMINuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              0, 
            110, 
              OPC_CheckInteger, 56, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDi8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDi16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDi32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDf), 0,
                    1, MVT::v2f32, 4, 0, 1, 2, 3, 
              0, 
            10|128,1, 
              OPC_CheckInteger, 57, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLsv8i8), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLsv4i16), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              20,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLsv2i32), 0,
                    1, MVT::v1i64, 3, 0, 1, 2, 
              20,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLsv16i8), 0,
                    1, MVT::v8i16, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLsv8i16), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              20,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLsv4i32), 0,
                    1, MVT::v2i64, 3, 0, 1, 2, 
              0, 
            10|128,1, 
              OPC_CheckInteger, 58, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLuv8i8), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLuv4i16), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              20,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLuv2i32), 0,
                    1, MVT::v1i64, 3, 0, 1, 2, 
              20,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLuv16i8), 0,
                    1, MVT::v8i16, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLuv8i16), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              20,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADDLuv4i32), 0,
                    1, MVT::v2i64, 3, 0, 1, 2, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 54, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALsv8i8), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALsv4i16), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALsv2i32), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALsv16i8), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALsv8i16), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALsv4i32), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            34|128,1, 
              OPC_CheckInteger, 55, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALuv8i8), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALuv4i16), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALuv2i32), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALuv16i8), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALuv8i16), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPADALuv4i32), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            110, 
              OPC_CheckInteger, 59, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMAXs8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMAXs16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMAXs32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMAXf), 0,
                    1, MVT::v2f32, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 60, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMAXu8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMAXu16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMAXu32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              0, 
            110, 
              OPC_CheckInteger, 61, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMINs8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMINs16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMINs32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMINf), 0,
                    1, MVT::v2f32, 4, 0, 1, 2, 3, 
              0, 
            84, 
              OPC_CheckInteger, 62, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMINu8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMINu16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VPMINu32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              0, 
            94, 
              OPC_CheckInteger, 89, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRECPEd), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRECPEq), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              20,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRECPEfd), 0,
                    1, MVT::v2f32, 3, 0, 1, 2, 
              20,  MVT::v4f32,
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRECPEfq), 0,
                    1, MVT::v4f32, 3, 0, 1, 2, 
              0, 
            58, 
              OPC_CheckInteger, 90, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRECPSfd), 0,
                    1, MVT::v2f32, 4, 0, 1, 2, 3, 
              24,  MVT::v4f32,
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRECPSfq), 0,
                    1, MVT::v4f32, 4, 0, 1, 2, 3, 
              0, 
            94, 
              OPC_CheckInteger, 96, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSQRTEd), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSQRTEq), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              20,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSQRTEfd), 0,
                    1, MVT::v2f32, 3, 0, 1, 2, 
              20,  MVT::v4f32,
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSQRTEfq), 0,
                    1, MVT::v4f32, 3, 0, 1, 2, 
              0, 
            58, 
              OPC_CheckInteger, 97, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSQRTSfd), 0,
                    1, MVT::v2f32, 4, 0, 1, 2, 3, 
              24,  MVT::v4f32,
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSQRTSfq), 0,
                    1, MVT::v4f32, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 103, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLsv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLsv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 104, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLuv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLuv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 94, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLsv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLsv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 95, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLuv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHLuv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 83, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 85, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 78, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLsv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLsv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLsv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLsv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLsv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLsv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLsv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLsv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            86|128,1, 
              OPC_CheckInteger, 79, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 24,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLuv4i16), 0,
                    1, MVT::v4i16, 4, 0, 1, 2, 3, 
              24,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLuv2i32), 0,
                    1, MVT::v2i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLuv8i16), 0,
                    1, MVT::v8i16, 4, 0, 1, 2, 3, 
              24,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLuv4i32), 0,
                    1, MVT::v4i32, 4, 0, 1, 2, 3, 
              24,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLuv8i8), 0,
                    1, MVT::v8i8, 4, 0, 1, 2, 3, 
              24,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLuv16i8), 0,
                    1, MVT::v16i8, 4, 0, 1, 2, 3, 
              24,  MVT::v1i64,
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v1i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLuv1i64), 0,
                    1, MVT::v1i64, 4, 0, 1, 2, 3, 
              24,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckChild2Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHLuv2i64), 0,
                    1, MVT::v2i64, 4, 0, 1, 2, 3, 
              0, 
            54|128,1, 
              OPC_CheckInteger, 11, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABSv8i8), 0,
                    1, MVT::v8i8, 3, 0, 1, 2, 
              20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABSv4i16), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABSv2i32), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              20,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABSv16i8), 0,
                    1, MVT::v16i8, 3, 0, 1, 2, 
              20,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABSv8i16), 0,
                    1, MVT::v8i16, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABSv4i32), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              20,  MVT::v2f32,
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABSfd), 0,
                    1, MVT::v2f32, 3, 0, 1, 2, 
              20,  MVT::v4f32,
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VABSfq), 0,
                    1, MVT::v4f32, 3, 0, 1, 2, 
              0, 
            10|128,1, 
              OPC_CheckInteger, 63, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQABSv8i8), 0,
                    1, MVT::v8i8, 3, 0, 1, 2, 
              20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQABSv4i16), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQABSv2i32), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              20,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQABSv16i8), 0,
                    1, MVT::v16i8, 3, 0, 1, 2, 
              20,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQABSv8i16), 0,
                    1, MVT::v8i16, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQABSv4i32), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              0, 
            10|128,1, 
              OPC_CheckInteger, 73, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQNEGv8i8), 0,
                    1, MVT::v8i8, 3, 0, 1, 2, 
              20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQNEGv4i16), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQNEGv2i32), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              20,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQNEGv16i8), 0,
                    1, MVT::v16i8, 3, 0, 1, 2, 
              20,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQNEGv8i16), 0,
                    1, MVT::v8i16, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQNEGv4i32), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              0, 
            10|128,1, 
              OPC_CheckInteger, 21, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLSv8i8), 0,
                    1, MVT::v8i8, 3, 0, 1, 2, 
              20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLSv4i16), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLSv2i32), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              20,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLSv16i8), 0,
                    1, MVT::v16i8, 3, 0, 1, 2, 
              20,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLSv8i16), 0,
                    1, MVT::v8i16, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLSv4i32), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              0, 
            10|128,1, 
              OPC_CheckInteger, 22, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLZv8i8), 0,
                    1, MVT::v8i8, 3, 0, 1, 2, 
              20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLZv4i16), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLZv2i32), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              20,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLZv16i8), 0,
                    1, MVT::v16i8, 3, 0, 1, 2, 
              20,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLZv8i16), 0,
                    1, MVT::v8i16, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCLZv4i32), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              0, 
            50, 
              OPC_CheckInteger, 23, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCNTd), 0,
                    1, MVT::v8i8, 3, 0, 1, 2, 
              20,  MVT::v16i8,
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VCNTq), 0,
                    1, MVT::v16i8, 3, 0, 1, 2, 
              0, 
            72, 
              OPC_CheckInteger, 49, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMOVNv8i8), 0,
                    1, MVT::v8i8, 3, 0, 1, 2, 
              20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMOVNv4i16), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMOVNv2i32), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              0, 
            72, 
              OPC_CheckInteger, 70, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQMOVNsv8i8), 0,
                    1, MVT::v8i8, 3, 0, 1, 2, 
              20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQMOVNsv4i16), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQMOVNsv2i32), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              0, 
            72, 
              OPC_CheckInteger, 72, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQMOVNuv8i8), 0,
                    1, MVT::v8i8, 3, 0, 1, 2, 
              20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQMOVNuv4i16), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQMOVNuv2i32), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              0, 
            72, 
              OPC_CheckInteger, 71, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i8,
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQMOVNsuv8i8), 0,
                    1, MVT::v8i8, 3, 0, 1, 2, 
              20,  MVT::v4i16,
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQMOVNsuv4i16), 0,
                    1, MVT::v4i16, 3, 0, 1, 2, 
              20,  MVT::v2i32,
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQMOVNsuv2i32), 0,
                    1, MVT::v2i32, 3, 0, 1, 2, 
              0, 
            72, 
              OPC_CheckInteger, 47, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMOVLsv8i16), 0,
                    1, MVT::v8i16, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMOVLsv4i32), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              20,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMOVLsv2i64), 0,
                    1, MVT::v2i64, 3, 0, 1, 2, 
              0, 
            72, 
              OPC_CheckInteger, 48, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v8i16,
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMOVLuv8i16), 0,
                    1, MVT::v8i16, 3, 0, 1, 2, 
              20,  MVT::v4i32,
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMOVLuv4i32), 0,
                    1, MVT::v4i32, 3, 0, 1, 2, 
              20,  MVT::v2i64,
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMOVLuv2i64), 0,
                    1, MVT::v2i64, 3, 0, 1, 2, 
              0, 
            24, 
              OPC_CheckInteger, 117, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VTBL1), 0,
                  1, MVT::v8i8, 4, 0, 1, 2, 3, 
            26, 
              OPC_CheckInteger, 118, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VTBL2), 0,
                  1, MVT::v8i8, 5, 0, 1, 2, 3, 4, 
            28, 
              OPC_CheckInteger, 119, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_RecordChild4,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VTBL3), 0,
                  1, MVT::v8i8, 6, 0, 1, 2, 3, 4, 5, 
            30, 
              OPC_CheckInteger, 120, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_RecordChild4,
              OPC_RecordChild5,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VTBL4), 0,
                  1, MVT::v8i8, 7, 0, 1, 2, 3, 4, 5, 6, 
            26, 
              OPC_CheckInteger, 121, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VTBX1), 0,
                  1, MVT::v8i8, 5, 0, 1, 2, 3, 4, 
            28, 
              OPC_CheckInteger, 122, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_RecordChild4,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VTBX2), 0,
                  1, MVT::v8i8, 6, 0, 1, 2, 3, 4, 5, 
            30, 
              OPC_CheckInteger, 123, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_RecordChild4,
              OPC_RecordChild5,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VTBX3), 0,
                  1, MVT::v8i8, 7, 0, 1, 2, 3, 4, 5, 6, 
            32, 
              OPC_CheckInteger, 124, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_RecordChild4,
              OPC_RecordChild5,
              OPC_RecordChild6,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VTBX4), 0,
                  1, MVT::v8i8, 8, 0, 1, 2, 3, 4, 5, 6, 7, 
            0, 
          35|128,1,  ISD::SHL,
            OPC_Scope, 30, 
              OPC_RecordNode,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::MOVs), 0,
                  1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
            0|128,1, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 68, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 30, 
                  OPC_CheckPredicate, 24,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LSLri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                28, 
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLSLri), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                0, 
              54, 
                OPC_CheckChild1Type, MVT::i32,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 23, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLSLrr), 0,
                      1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LSLrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                0, 
              0, 
            0, 
          35|128,1,  ISD::SRL,
            OPC_Scope, 30, 
              OPC_RecordNode,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::MOVs), 0,
                  1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
            0|128,1, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 68, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 30, 
                  OPC_CheckPredicate, 24,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LSRri), 0,
                      1, MVT::i32, 5, 0, 2, 3, 4, 5, 
                28, 
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLSRri), 0,
                      1, MVT::i32, 5, 2, 0, 3, 4, 5, 
                0, 
              54, 
                OPC_CheckChild1Type, MVT::i32,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 23, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLSRrr), 0,
                      1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LSRrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                0, 
              0, 
            0, 
          2|128,1,  ISD::ROTR,
            OPC_Scope, 30, 
              OPC_RecordNode,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 5,
              OPC_CheckComplexPat, /*CP*/1, /*#*/0,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::MOVs), 0,
                  1, MVT::i32, 6, 1, 2, 3, 4, 5, 6, 
            96, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 24,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckPatternPredicate, 2,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2RORri), 0,
                    1, MVT::i32, 5, 0, 2, 3, 4, 5, 
              54, 
                OPC_CheckChild1Type, MVT::i32,
                OPC_CheckType, MVT::i32,
                OPC_Scope, 23, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_EmitRegister, MVT::i32, ARM::CPSR,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tROR), 0,
                      1, MVT::i32, 5, 2, 0, 1, 3, 4, 
                23, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2RORrr), 0,
                      1, MVT::i32, 5, 0, 1, 2, 3, 4, 
                0, 
              0, 
            0, 
          69|128,8,  ISD::FADD,
            OPC_Scope, 118, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_Scope, 68, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_SwitchType , 23,  MVT::v2f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfd), 0,
                      1, MVT::v2f32, 6, 0, 1, 2, 4, 5, 6, 
                23,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfq), 0,
                      1, MVT::v4f32, 6, 0, 1, 2, 4, 5, 6, 
                0, 
              41, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfd), 0,
                    1, MVT::v2f32, 6, 0, 3, 1, 4, 5, 6, 
              0, 
            92, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_Scope, 42, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfd), 0,
                    1, MVT::v2f32, 6, 3, 0, 1, 4, 5, 6, 
              42, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfd), 0,
                    1, MVT::v2f32, 6, 3, 2, 0, 4, 5, 6, 
              0, 
            46, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v2f32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfq), 0,
                  1, MVT::v4f32, 6, 0, 3, 1, 4, 5, 6, 
            92, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_Scope, 42, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfq), 0,
                    1, MVT::v4f32, 6, 3, 0, 1, 4, 5, 6, 
              42, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfq), 0,
                    1, MVT::v4f32, 6, 3, 2, 0, 4, 5, 6, 
              0, 
            121, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_Scope, 56, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4f32,
                OPC_EmitConvertToTarget, 3,
                OPC_EmitNodeXForm, 8, 4,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v2f32, 2, 2, 5, 
                OPC_EmitConvertToTarget, 3,
                OPC_EmitNodeXForm, 9, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfq), 0,
                    1, MVT::v4f32, 6, 0, 1, 6, 8, 9, 10, 
              56, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4f32,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 8, 4,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v2f32, 2, 1, 5, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 9, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfq), 0,
                    1, MVT::v4f32, 6, 0, 3, 6, 8, 9, 10, 
              0, 
            53|128,1, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 118,  ISD::FMUL,
                OPC_Scope, 57, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4f32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v4f32,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitNodeXForm, 8, 4,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v2f32, 2, 1, 5, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitNodeXForm, 9, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfq), 0,
                      1, MVT::v4f32, 6, 3, 0, 6, 8, 9, 10, 
                57, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ARMISD::VDUPLANE,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v4f32,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v4f32,
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 8, 4,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::v2f32, 2, 0, 5, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 9, 7,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAslfq), 0,
                      1, MVT::v4f32, 6, 3, 2, 6, 8, 9, 10, 
                0, 
              55,  ISD::FNEG,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::FMUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 20,  MVT::f64,
                  OPC_CheckPatternPredicate, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSD), 0,
                      1, MVT::f64, 5, 2, 0, 1, 3, 4, 
                20,  MVT::f32,
                  OPC_CheckPatternPredicate, 10,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSS), 0,
                      1, MVT::f32, 5, 2, 0, 1, 3, 4, 
                0, 
              0, 
            59, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::FNEG,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_SwitchType , 20,  MVT::f64,
                OPC_CheckPatternPredicate, 8,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSD), 0,
                    1, MVT::f64, 5, 0, 1, 2, 3, 4, 
              20,  MVT::f32,
                OPC_CheckPatternPredicate, 10,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSS), 0,
                    1, MVT::f32, 5, 0, 1, 2, 3, 4, 
              0, 
            54, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::f64,
                OPC_CheckPatternPredicate, 8,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAD), 0,
                    1, MVT::f64, 5, 2, 0, 1, 3, 4, 
              20,  MVT::f32,
                OPC_CheckPatternPredicate, 10,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAS), 0,
                    1, MVT::f32, 5, 2, 0, 1, 3, 4, 
              0, 
            98, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_SwitchType , 20,  MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAfd), 0,
                    1, MVT::v2f32, 5, 0, 1, 2, 3, 4, 
              20,  MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAfq), 0,
                    1, MVT::v4f32, 5, 0, 1, 2, 3, 4, 
              20,  MVT::f64,
                OPC_CheckPatternPredicate, 8,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAD), 0,
                    1, MVT::f64, 5, 0, 1, 2, 3, 4, 
              20,  MVT::f32,
                OPC_CheckPatternPredicate, 10,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAS), 0,
                    1, MVT::f32, 5, 0, 1, 2, 3, 4, 
              0, 
            54, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 20,  MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAfd), 0,
                    1, MVT::v2f32, 5, 2, 0, 1, 3, 4, 
              20,  MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLAfq), 0,
                    1, MVT::v4f32, 5, 2, 0, 1, 3, 4, 
              0, 
            35|128,1, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_SwitchType , 19,  MVT::f64,
                OPC_CheckPatternPredicate, 8,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDD), 0,
                    1, MVT::f64, 4, 0, 1, 2, 3, 
              94,  MVT::f32,
                OPC_Scope, 19, 
                  OPC_CheckPatternPredicate, 10,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDS), 0,
                      1, MVT::f32, 4, 0, 1, 2, 3, 
                71, 
                  OPC_CheckPatternPredicate, 11,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::IMPLICIT_DEF), 0,
                      1, MVT::v2f32, 0, 
                  OPC_EmitInteger, MVT::i32, 1, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                      1, MVT::f64, 3, 2, 0, 3, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::IMPLICIT_DEF), 0,
                      1, MVT::v2f32, 0, 
                  OPC_EmitInteger, MVT::i32, 1, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                      1, MVT::f64, 3, 5, 1, 6, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::VADDfd_sfp), 0,
                      1, MVT::f64, 4, 4, 7, 8, 9, 
                  OPC_EmitInteger, MVT::i32, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::f32, 2, 10, 11, 
                0, 
              19,  MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDfd), 0,
                    1, MVT::v2f32, 4, 0, 1, 2, 3, 
              19,  MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VADDfq), 0,
                    1, MVT::v4f32, 4, 0, 1, 2, 3, 
              0, 
            0, 
          4|128,5,  ISD::FSUB,
            OPC_Scope, 3|128,2, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_Scope, 68, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_SwitchType , 23,  MVT::v2f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslfd), 0,
                      1, MVT::v2f32, 6, 0, 1, 2, 4, 5, 6, 
                23,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslfq), 0,
                      1, MVT::v4f32, 6, 0, 1, 2, 4, 5, 6, 
                0, 
              68, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_SwitchType , 23,  MVT::v2f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslfd), 0,
                      1, MVT::v2f32, 6, 0, 3, 1, 4, 5, 6, 
                23,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslfq), 0,
                      1, MVT::v4f32, 6, 0, 3, 1, 4, 5, 6, 
                0, 
              56, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4f32,
                OPC_EmitConvertToTarget, 3,
                OPC_EmitNodeXForm, 8, 4,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v2f32, 2, 2, 5, 
                OPC_EmitConvertToTarget, 3,
                OPC_EmitNodeXForm, 9, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslfq), 0,
                    1, MVT::v4f32, 6, 0, 1, 6, 8, 9, 10, 
              56, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4f32,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 8, 4,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v2f32, 2, 1, 5, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 9, 7,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSslfq), 0,
                    1, MVT::v4f32, 6, 0, 3, 6, 8, 9, 10, 
              0, 
            113, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 55,  ISD::FNEG,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::FMUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 20,  MVT::f64,
                  OPC_CheckPatternPredicate, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNMLAD), 0,
                      1, MVT::f64, 5, 2, 0, 1, 3, 4, 
                20,  MVT::f32,
                  OPC_CheckPatternPredicate, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNMLAS), 0,
                      1, MVT::f32, 5, 2, 0, 1, 3, 4, 
                0, 
              50,  ISD::FMUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 20,  MVT::f64,
                  OPC_CheckPatternPredicate, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNMLSD), 0,
                      1, MVT::f64, 5, 2, 0, 1, 3, 4, 
                20,  MVT::f32,
                  OPC_CheckPatternPredicate, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNMLSS), 0,
                      1, MVT::f32, 5, 2, 0, 1, 3, 4, 
                0, 
              0, 
            9|128,2, 
              OPC_RecordChild0,
              OPC_Scope, 97, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::FMUL,
                OPC_RecordChild0,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_SwitchType , 20,  MVT::f64,
                  OPC_CheckPatternPredicate, 12,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSD), 0,
                      1, MVT::f64, 5, 0, 1, 2, 3, 4, 
                20,  MVT::f32,
                  OPC_CheckPatternPredicate, 12,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSS), 0,
                      1, MVT::f32, 5, 0, 1, 2, 3, 4, 
                20,  MVT::v2f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSfd), 0,
                      1, MVT::v2f32, 5, 0, 1, 2, 3, 4, 
                20,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMLSfq), 0,
                      1, MVT::v4f32, 5, 0, 1, 2, 3, 4, 
                0, 
              34|128,1, 
                OPC_RecordChild1,
                OPC_SwitchType , 19,  MVT::f64,
                  OPC_CheckPatternPredicate, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBD), 0,
                      1, MVT::f64, 4, 0, 1, 2, 3, 
                94,  MVT::f32,
                  OPC_Scope, 19, 
                    OPC_CheckPatternPredicate, 10,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBS), 0,
                        1, MVT::f32, 4, 0, 1, 2, 3, 
                  71, 
                    OPC_CheckPatternPredicate, 11,
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::IMPLICIT_DEF), 0,
                        1, MVT::v2f32, 0, 
                    OPC_EmitInteger, MVT::i32, 1, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                        1, MVT::f64, 3, 2, 0, 3, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::IMPLICIT_DEF), 0,
                        1, MVT::v2f32, 0, 
                    OPC_EmitInteger, MVT::i32, 1, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                        1, MVT::f64, 3, 5, 1, 6, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_EmitNode, TARGET_OPCODE(ARM::VSUBfd_sfp), 0,
                        1, MVT::f64, 4, 4, 7, 8, 9, 
                    OPC_EmitInteger, MVT::i32, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::f32, 2, 10, 11, 
                  0, 
                19,  MVT::v2f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBfd), 0,
                      1, MVT::v2f32, 4, 0, 1, 2, 3, 
                19,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSUBfq), 0,
                      1, MVT::v4f32, 4, 0, 1, 2, 3, 
                0, 
              0, 
            0, 
          61,  ISD::CALLSEQ_END,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_SwitchOpcode , 26,  ISD::TargetConstant,
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::TargetConstant,
              OPC_MoveParent,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADJCALLSTACKUP), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput,
                  0, 4, 1, 2, 3, 4, 
            24,  ISD::Constant,
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 6,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitConvertToTarget, 2,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::tADJCALLSTACKUP), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput,
                  0, 2, 3, 4, 
            0, 
          82,  ARMISD::WrapperJT,
            OPC_RecordChild0,
            OPC_MoveChild, 0,
            OPC_CheckOpcode, ISD::TargetJumpTable,
            OPC_MoveParent,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_CheckType, MVT::i32,
            OPC_Scope, 21, 
              OPC_CheckPatternPredicate, 5,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::LEApcrelJT), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            21, 
              OPC_CheckPatternPredicate, 6,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLEApcrelJT), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            21, 
              OPC_CheckPatternPredicate, 2,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LEApcrelJT), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            0, 
          34,  ARMISD::BR2_JT,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_CheckChild1Type, MVT::i32,
            OPC_RecordChild2,
            OPC_RecordChild3,
            OPC_MoveChild, 3,
            OPC_CheckOpcode, ISD::TargetJumpTable,
            OPC_MoveParent,
            OPC_RecordChild4,
            OPC_MoveChild, 4,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_CheckPatternPredicate, 2,
            OPC_EmitMergeInputChains, 1, 0, 
            OPC_EmitConvertToTarget, 4,
            OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2BR_JT), 0|OPFL_Chain,
                0, 4, 1, 2, 3, 5, 
          3|128,4,  ISD::FMUL,
            OPC_Scope, 65, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v2f32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_SwitchType , 22,  MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslfd), 0,
                    1, MVT::v2f32, 5, 0, 1, 3, 4, 5, 
              22,  MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslfq), 0,
                    1, MVT::v4f32, 5, 0, 1, 3, 4, 5, 
              0, 
            65, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v2f32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_SwitchType , 22,  MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslfd), 0,
                    1, MVT::v2f32, 5, 2, 0, 3, 4, 5, 
              22,  MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslfq), 0,
                    1, MVT::v4f32, 5, 2, 0, 3, 4, 5, 
              0, 
            54, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ARMISD::VDUPLANE,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v4f32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitNodeXForm, 8, 3,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v2f32, 2, 1, 4, 
              OPC_EmitConvertToTarget, 2,
              OPC_EmitNodeXForm, 9, 6,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslfq), 0,
                  1, MVT::v4f32, 5, 0, 5, 7, 8, 9, 
            105, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 50,  ARMISD::VDUPLANE,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4f32,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4f32,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 8, 3,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v2f32, 2, 0, 4, 
                OPC_EmitConvertToTarget, 1,
                OPC_EmitNodeXForm, 9, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULslfq), 0,
                    1, MVT::v4f32, 5, 2, 5, 7, 8, 9, 
              47,  ISD::FNEG,
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 19,  MVT::f64,
                  OPC_CheckPatternPredicate, 13,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNMULD), 0,
                      1, MVT::f64, 4, 0, 1, 2, 3, 
                19,  MVT::f32,
                  OPC_CheckPatternPredicate, 13,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNMULS), 0,
                      1, MVT::f32, 4, 0, 1, 2, 3, 
                0, 
              0, 
            90|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 50, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::FNEG,
                OPC_RecordChild0,
                OPC_MoveParent,
                OPC_SwitchType , 19,  MVT::f64,
                  OPC_CheckPatternPredicate, 13,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNMULD), 0,
                      1, MVT::f64, 4, 1, 0, 2, 3, 
                19,  MVT::f32,
                  OPC_CheckPatternPredicate, 13,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNMULS), 0,
                      1, MVT::f32, 4, 1, 0, 2, 3, 
                0, 
              34|128,1, 
                OPC_RecordChild1,
                OPC_SwitchType , 19,  MVT::f64,
                  OPC_CheckPatternPredicate, 8,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULD), 0,
                      1, MVT::f64, 4, 0, 1, 2, 3, 
                94,  MVT::f32,
                  OPC_Scope, 19, 
                    OPC_CheckPatternPredicate, 10,
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULS), 0,
                        1, MVT::f32, 4, 0, 1, 2, 3, 
                  71, 
                    OPC_CheckPatternPredicate, 11,
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::IMPLICIT_DEF), 0,
                        1, MVT::v2f32, 0, 
                    OPC_EmitInteger, MVT::i32, 1, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                        1, MVT::f64, 3, 2, 0, 3, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::IMPLICIT_DEF), 0,
                        1, MVT::v2f32, 0, 
                    OPC_EmitInteger, MVT::i32, 1, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                        1, MVT::f64, 3, 5, 1, 6, 
                    OPC_EmitInteger, MVT::i32, 14, 
                    OPC_EmitRegister, MVT::i32, 0 ,
                    OPC_EmitNode, TARGET_OPCODE(ARM::VMULfd_sfp), 0,
                        1, MVT::f64, 4, 4, 7, 8, 9, 
                    OPC_EmitInteger, MVT::i32, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::f32, 2, 10, 11, 
                  0, 
                19,  MVT::v2f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULfd), 0,
                      1, MVT::v2f32, 4, 0, 1, 2, 3, 
                19,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VMULfq), 0,
                      1, MVT::v4f32, 4, 0, 1, 2, 3, 
                0, 
              0, 
            0, 
          44,  ISD::CALLSEQ_START,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_SwitchOpcode , 19,  ISD::TargetConstant,
              OPC_MoveParent,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::ADJCALLSTACKDOWN), 0|OPFL_Chain|OPFL_FlagOutput,
                  0, 3, 1, 2, 3, 
            15,  ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 6,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::tADJCALLSTACKDOWN), 0|OPFL_Chain|OPFL_FlagOutput,
                  0, 1, 2, 
            0, 
          53|128,1,  ARMISD::CALL,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_Scope, 118, 
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 55,  ISD::TargetGlobalAddress,
                OPC_MoveParent,
                OPC_Scope, 12, 
                  OPC_CheckPatternPredicate, 14,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::BL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                12, 
                  OPC_CheckPatternPredicate, 15,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::BLr9), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                12, 
                  OPC_CheckPatternPredicate, 16,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBLXi), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                12, 
                  OPC_CheckPatternPredicate, 17,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBLXi_r9), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                0, 
              55,  ISD::TargetExternalSymbol,
                OPC_MoveParent,
                OPC_Scope, 12, 
                  OPC_CheckPatternPredicate, 14,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::BL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                12, 
                  OPC_CheckPatternPredicate, 15,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::BLr9), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                12, 
                  OPC_CheckPatternPredicate, 16,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBLXi), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                12, 
                  OPC_CheckPatternPredicate, 17,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBLXi_r9), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                0, 
              0, 
            56, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_Scope, 12, 
                OPC_CheckPatternPredicate, 18,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::BLX), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              12, 
                OPC_CheckPatternPredicate, 19,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::BLXr9), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              12, 
                OPC_CheckPatternPredicate, 16,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBLXr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              12, 
                OPC_CheckPatternPredicate, 17,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBLXr_r9), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              0, 
            0, 
          52,  ARMISD::CALL_PRED,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::TargetGlobalAddress,
            OPC_MoveParent,
            OPC_Scope, 20, 
              OPC_CheckPatternPredicate, 14,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::BL_pred), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                  0, 3, 1, 2, 3, 
            20, 
              OPC_CheckPatternPredicate, 15,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::BLr9_pred), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                  0, 3, 1, 2, 3, 
            0, 
          43|128,1,  ARMISD::Wrapper,
            OPC_RecordChild0,
            OPC_MoveChild, 0,
            OPC_SwitchOpcode , 100,  ISD::TargetGlobalAddress,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 18, 
                OPC_CheckPatternPredicate, 20,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::LEApcrel), 0,
                    1, MVT::i32, 3, 0, 1, 2, 
              18, 
                OPC_CheckPatternPredicate, 21,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::MOVi32imm), 0,
                    1, MVT::i32, 3, 0, 1, 2, 
              18, 
                OPC_CheckPatternPredicate, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLEApcrel), 0,
                    1, MVT::i32, 3, 0, 1, 2, 
              18, 
                OPC_CheckPatternPredicate, 22,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LEApcrel), 0,
                    1, MVT::i32, 3, 0, 1, 2, 
              18, 
                OPC_CheckPatternPredicate, 23,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2MOVi32imm), 0,
                    1, MVT::i32, 3, 0, 1, 2, 
              0, 
            62,  ISD::TargetConstantPool,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_Scope, 18, 
                OPC_CheckPatternPredicate, 5,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::LEApcrel), 0,
                    1, MVT::i32, 3, 0, 1, 2, 
              18, 
                OPC_CheckPatternPredicate, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tLEApcrel), 0,
                    1, MVT::i32, 3, 0, 1, 2, 
              18, 
                OPC_CheckPatternPredicate, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::t2LEApcrel), 0,
                    1, MVT::i32, 3, 0, 1, 2, 
              0, 
            0, 
          103,  ARMISD::tCALL,
            OPC_RecordNode,
            OPC_CaptureFlagInput,
            OPC_RecordChild1,
            OPC_Scope, 66, 
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 29,  ISD::TargetGlobalAddress,
                OPC_MoveParent,
                OPC_Scope, 12, 
                  OPC_CheckPatternPredicate, 24,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                12, 
                  OPC_CheckPatternPredicate, 25,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBLr9), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                0, 
              29,  ISD::TargetExternalSymbol,
                OPC_MoveParent,
                OPC_Scope, 12, 
                  OPC_CheckPatternPredicate, 24,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                12, 
                  OPC_CheckPatternPredicate, 25,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBLr9), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                      0, 1, 1, 
                0, 
              0, 
            30, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_Scope, 12, 
                OPC_CheckPatternPredicate, 16,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBLXr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              12, 
                OPC_CheckPatternPredicate, 17,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::tBLXr_r9), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_Variadic1,
                    0, 1, 1, 
              0, 
            0, 
          65|128,1,  ISD::FNEG,
            OPC_Scope, 51, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::FMUL,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_SwitchType , 19,  MVT::f64,
                OPC_CheckPatternPredicate, 8,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNMULD), 0,
                    1, MVT::f64, 4, 0, 1, 2, 3, 
              19,  MVT::f32,
                OPC_CheckPatternPredicate, 8,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNMULS), 0,
                    1, MVT::f32, 4, 0, 1, 2, 3, 
              0, 
            9|128,1, 
              OPC_RecordChild0,
              OPC_SwitchType , 18,  MVT::f64,
                OPC_CheckPatternPredicate, 8,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGD), 0,
                    1, MVT::f64, 3, 0, 1, 2, 
              72,  MVT::f32,
                OPC_Scope, 18, 
                  OPC_CheckPatternPredicate, 10,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGS), 0,
                      1, MVT::f32, 3, 0, 1, 2, 
                50, 
                  OPC_CheckPatternPredicate, 11,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::IMPLICIT_DEF), 0,
                      1, MVT::v2f32, 0, 
                  OPC_EmitInteger, MVT::i32, 1, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                      1, MVT::f64, 3, 1, 0, 2, 
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_EmitNode, TARGET_OPCODE(ARM::VNEGfd_sfp), 0,
                      1, MVT::f64, 3, 3, 4, 5, 
                  OPC_EmitInteger, MVT::i32, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::f32, 2, 6, 7, 
                0, 
              18,  MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGfd), 0,
                    1, MVT::v2f32, 3, 0, 1, 2, 
              18,  MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VNEGf32q), 0,
                    1, MVT::v4f32, 3, 0, 1, 2, 
              0, 
            0, 
          65|128,1,  ARMISD::VSHL,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_SwitchType , 21,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLiv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            21,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLiv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            21,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLiv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            21,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLiv1i64), 0,
                  1, MVT::v1i64, 4, 0, 2, 3, 4, 
            21,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLiv16i8), 0,
                  1, MVT::v16i8, 4, 0, 2, 3, 4, 
            21,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLiv8i16), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            21,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLiv4i32), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            21,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLiv2i64), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          65|128,1,  ARMISD::VSHRs,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_SwitchType , 21,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRsv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            21,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRsv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            21,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRsv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            21,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRsv1i64), 0,
                  1, MVT::v1i64, 4, 0, 2, 3, 4, 
            21,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRsv16i8), 0,
                  1, MVT::v16i8, 4, 0, 2, 3, 4, 
            21,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRsv8i16), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            21,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRsv4i32), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            21,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRsv2i64), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          65|128,1,  ARMISD::VSHRu,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_SwitchType , 21,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRuv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            21,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRuv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            21,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRuv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            21,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRuv1i64), 0,
                  1, MVT::v1i64, 4, 0, 2, 3, 4, 
            21,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRuv16i8), 0,
                  1, MVT::v16i8, 4, 0, 2, 3, 4, 
            21,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRuv8i16), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            21,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRuv4i32), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            21,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRuv2i64), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VSHLLs,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i8,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLLsv8i16), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLLsv4i32), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLLsv2i64), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VSHLLu,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i8,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLLuv8i16), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLLuv4i32), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLLuv2i64), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VSHLLi,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i8,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLLi8), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLLi16), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHLLi32), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VSHRN,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRNv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRNv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i64,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSHRNv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            0, 
          65|128,1,  ARMISD::VRSHRs,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_SwitchType , 21,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRsv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            21,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRsv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            21,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRsv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            21,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRsv1i64), 0,
                  1, MVT::v1i64, 4, 0, 2, 3, 4, 
            21,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRsv16i8), 0,
                  1, MVT::v16i8, 4, 0, 2, 3, 4, 
            21,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRsv8i16), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            21,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRsv4i32), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            21,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRsv2i64), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          65|128,1,  ARMISD::VRSHRu,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_SwitchType , 21,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRuv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            21,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRuv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            21,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRuv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            21,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRuv1i64), 0,
                  1, MVT::v1i64, 4, 0, 2, 3, 4, 
            21,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRuv16i8), 0,
                  1, MVT::v16i8, 4, 0, 2, 3, 4, 
            21,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRuv8i16), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            21,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRuv4i32), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            21,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRuv2i64), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VRSHRN,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRNv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRNv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i64,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VRSHRNv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            0, 
          65|128,1,  ARMISD::VQSHLs,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_SwitchType , 21,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsiv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            21,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsiv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            21,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsiv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            21,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsiv1i64), 0,
                  1, MVT::v1i64, 4, 0, 2, 3, 4, 
            21,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsiv16i8), 0,
                  1, MVT::v16i8, 4, 0, 2, 3, 4, 
            21,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsiv8i16), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            21,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsiv4i32), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            21,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsiv2i64), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          65|128,1,  ARMISD::VQSHLu,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_SwitchType , 21,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuiv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            21,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuiv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            21,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuiv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            21,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuiv1i64), 0,
                  1, MVT::v1i64, 4, 0, 2, 3, 4, 
            21,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuiv16i8), 0,
                  1, MVT::v16i8, 4, 0, 2, 3, 4, 
            21,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuiv8i16), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            21,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuiv4i32), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            21,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLuiv2i64), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          65|128,1,  ARMISD::VQSHLsu,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_MoveChild, 1,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_SwitchType , 21,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsuv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            21,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsuv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            21,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsuv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            21,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsuv1i64), 0,
                  1, MVT::v1i64, 4, 0, 2, 3, 4, 
            21,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsuv16i8), 0,
                  1, MVT::v16i8, 4, 0, 2, 3, 4, 
            21,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsuv8i16), 0,
                  1, MVT::v8i16, 4, 0, 2, 3, 4, 
            21,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsuv4i32), 0,
                  1, MVT::v4i32, 4, 0, 2, 3, 4, 
            21,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHLsuv2i64), 0,
                  1, MVT::v2i64, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VQSHRNs,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHRNsv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHRNsv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i64,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHRNsv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VQSHRNu,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHRNuv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHRNuv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i64,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHRNuv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VQSHRNsu,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHRUNv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHRUNv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i64,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQSHRUNv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VQRSHRNs,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHRNsv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHRNsv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i64,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHRNsv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VQRSHRNu,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHRNuv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHRNuv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i64,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHRNuv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            0, 
          99,  ARMISD::VQRSHRNsu,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHRUNv8i8), 0,
                  1, MVT::v8i8, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHRUNv4i16), 0,
                  1, MVT::v4i16, 4, 0, 2, 3, 4, 
            31, 
              OPC_CheckChild0Type, MVT::v2i64,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VQRSHRUNv2i32), 0,
                  1, MVT::v2i32, 4, 0, 2, 3, 4, 
            0, 
          74|128,1,  ARMISD::VSLI,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_MoveChild, 2,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_SwitchType , 22,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSLIv8i8), 0,
                  1, MVT::v8i8, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSLIv4i16), 0,
                  1, MVT::v4i16, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSLIv2i32), 0,
                  1, MVT::v2i32, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSLIv1i64), 0,
                  1, MVT::v1i64, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSLIv16i8), 0,
                  1, MVT::v16i8, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSLIv8i16), 0,
                  1, MVT::v8i16, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSLIv4i32), 0,
                  1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSLIv2i64), 0,
                  1, MVT::v2i64, 5, 0, 1, 3, 4, 5, 
            0, 
          74|128,1,  ARMISD::VSRI,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_RecordChild2,
            OPC_MoveChild, 2,
            OPC_CheckOpcode, ISD::Constant,
            OPC_MoveParent,
            OPC_SwitchType , 22,  MVT::v8i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRIv8i8), 0,
                  1, MVT::v8i8, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v4i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRIv4i16), 0,
                  1, MVT::v4i16, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v2i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRIv2i32), 0,
                  1, MVT::v2i32, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v1i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRIv1i64), 0,
                  1, MVT::v1i64, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v16i8,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRIv16i8), 0,
                  1, MVT::v16i8, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v8i16,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRIv8i16), 0,
                  1, MVT::v8i16, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v4i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRIv4i32), 0,
                  1, MVT::v4i32, 5, 0, 1, 3, 4, 5, 
            22,  MVT::v2i64,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSRIv2i64), 0,
                  1, MVT::v2i64, 5, 0, 1, 3, 4, 5, 
            0, 
          25|128,1,  ARMISD::VGETLANEs,
            OPC_RecordChild0,
            OPC_Scope, 29, 
              OPC_CheckChild0Type, MVT::v8i8,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VGETLNs8), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            29, 
              OPC_CheckChild0Type, MVT::v4i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VGETLNs16), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            44, 
              OPC_CheckChild0Type, MVT::v16i8,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 18, 2,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v8i8, 2, 0, 3, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 19, 5,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VGETLNs8), 0,
                  1, MVT::i32, 4, 4, 6, 7, 8, 
            44, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 6, 2,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v4i16, 2, 0, 3, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 7, 5,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VGETLNs16), 0,
                  1, MVT::i32, 4, 4, 6, 7, 8, 
            0, 
          25|128,1,  ARMISD::VGETLANEu,
            OPC_RecordChild0,
            OPC_Scope, 29, 
              OPC_CheckChild0Type, MVT::v8i8,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VGETLNu8), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            29, 
              OPC_CheckChild0Type, MVT::v4i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VGETLNu16), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            44, 
              OPC_CheckChild0Type, MVT::v16i8,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 18, 2,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v8i8, 2, 0, 3, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 19, 5,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VGETLNu8), 0,
                  1, MVT::i32, 4, 4, 6, 7, 8, 
            44, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 6, 2,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v4i16, 2, 0, 3, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 7, 5,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VGETLNu16), 0,
                  1, MVT::i32, 4, 4, 6, 7, 8, 
            0, 
          53|128,1,  ISD::EXTRACT_VECTOR_ELT,
            OPC_RecordChild0,
            OPC_Scope, 31, 
              OPC_CheckChild0Type, MVT::v2i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_CheckPatternPredicate, 3,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VGETLNi32), 0,
                  1, MVT::i32, 4, 0, 2, 3, 4, 
            24, 
              OPC_CheckChild0Type, MVT::v2f64,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::f64,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 20, 2,
              OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::f64, 2, 0, 3, 
            46, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::i32,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 8, 2,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v2i32, 2, 0, 3, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 9, 5,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VGETLNi32), 0,
                  1, MVT::i32, 4, 4, 6, 7, 8, 
            36, 
              OPC_CheckChild0Type, MVT::v2f32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::f32,
              OPC_EmitInteger, MVT::i32, ARM::DPR_VFP2RegClassID,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                  1, MVT::v2f32, 2, 0, 2, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 21, 4,
              OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::f32, 2, 3, 5, 
            36, 
              OPC_CheckChild0Type, MVT::v4f32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::f32,
              OPC_EmitInteger, MVT::i32, ARM::QPR_VFP2RegClassID,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                  1, MVT::v4f32, 2, 0, 2, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 21, 4,
              OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::f32, 2, 3, 5, 
            0, 
          95|128,2,  ISD::INSERT_VECTOR_ELT,
            OPC_RecordChild0,
            OPC_RecordChild1,
            OPC_Scope, 58, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_SwitchType , 22,  MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSETLNi8), 0,
                    1, MVT::v8i8, 5, 0, 1, 3, 4, 5, 
              22,  MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSETLNi16), 0,
                    1, MVT::v4i16, 5, 0, 1, 3, 4, 5, 
              0, 
            107, 
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_SwitchType , 22,  MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VSETLNi32), 0,
                    1, MVT::v2i32, 5, 0, 1, 3, 4, 5, 
              15,  MVT::v2f64,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 20, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                    1, MVT::v2f64, 3, 0, 1, 4, 
              27,  MVT::v2f32,
                OPC_EmitInteger, MVT::i32, ARM::DPR_VFP2RegClassID,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                    1, MVT::v2f32, 2, 0, 3, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 21, 5,
                OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                    1, MVT::v2f32, 3, 4, 1, 6, 
              27,  MVT::v4f32,
                OPC_EmitInteger, MVT::i32, ARM::QPR_VFP2RegClassID,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                    1, MVT::v4f32, 2, 0, 3, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 21, 5,
                OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                    1, MVT::v4f32, 3, 4, 1, 6, 
              0, 
            118, 
              OPC_CheckChild1Type, MVT::i32,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_SwitchType , 52,  MVT::v16i8,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 18, 3,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v8i8, 2, 0, 4, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 19, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitNode, TARGET_OPCODE(ARM::VSETLNi8), 0,
                    1, MVT::f64, 5, 5, 1, 7, 8, 9, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 18, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                    1, MVT::v16i8, 3, 0, 10, 12, 
              52,  MVT::v8i16,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 6, 3,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::v4i16, 2, 0, 4, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 7, 6,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_EmitNode, TARGET_OPCODE(ARM::VSETLNi16), 0,
                    1, MVT::f64, 5, 5, 1, 7, 8, 9, 
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 6, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                    1, MVT::v8i16, 3, 0, 10, 12, 
              0, 
            60, 
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_EmitConvertToTarget, 2,
              OPC_EmitNodeXForm, 8, 3,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v2i32, 2, 0, 4, 
              OPC_EmitConvertToTarget, 2,
              OPC_EmitNodeXForm, 9, 6,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_EmitNode, TARGET_OPCODE(ARM::VSETLNi32), 0,
                  1, MVT::f64, 5, 5, 1, 7, 8, 9, 
              OPC_EmitConvertToTarget, 2,
              OPC_EmitNodeXForm, 8, 11,
              OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                  1, MVT::v4i32, 3, 0, 10, 12, 
            0, 
          102|128,1,  ARMISD::VDUP,
            OPC_Scope, 52, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::i32,
              OPC_CheckType, MVT::f32,
              OPC_MoveParent,
              OPC_SwitchType , 18,  MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPfd), 0,
                    1, MVT::v2f32, 3, 0, 1, 2, 
              18,  MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPfq), 0,
                    1, MVT::v4f32, 3, 0, 1, 2, 
              0, 
            45|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 124, 
                OPC_CheckChild0Type, MVT::i32,
                OPC_SwitchType , 18,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUP8d), 0,
                      1, MVT::v8i8, 3, 0, 1, 2, 
                18,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUP16d), 0,
                      1, MVT::v4i16, 3, 0, 1, 2, 
                18,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUP32d), 0,
                      1, MVT::v2i32, 3, 0, 1, 2, 
                18,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUP8q), 0,
                      1, MVT::v16i8, 3, 0, 1, 2, 
                18,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUP16q), 0,
                      1, MVT::v8i16, 3, 0, 1, 2, 
                18,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUP32q), 0,
                      1, MVT::v4i32, 3, 0, 1, 2, 
                0, 
              44, 
                OPC_CheckChild0Type, MVT::f32,
                OPC_SwitchType , 18,  MVT::v2f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPfdf), 0,
                      1, MVT::v2f32, 3, 0, 1, 2, 
                18,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 14, 
                  OPC_EmitRegister, MVT::i32, 0 ,
                  OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPfqf), 0,
                      1, MVT::v4f32, 3, 0, 1, 2, 
                0, 
              0, 
            0, 
          115|128,3,  ARMISD::VDUPLANE,
            OPC_RecordChild0,
            OPC_Scope, 56, 
              OPC_CheckChild0Type, MVT::v8i8,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_SwitchType , 21,  MVT::v8i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPLN8d), 0,
                    1, MVT::v8i8, 4, 0, 2, 3, 4, 
              21,  MVT::v16i8,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPLN8q), 0,
                    1, MVT::v16i8, 4, 0, 2, 3, 4, 
              0, 
            56, 
              OPC_CheckChild0Type, MVT::v4i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_SwitchType , 21,  MVT::v4i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPLN16d), 0,
                    1, MVT::v4i16, 4, 0, 2, 3, 4, 
              21,  MVT::v8i16,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPLN16q), 0,
                    1, MVT::v8i16, 4, 0, 2, 3, 4, 
              0, 
            56, 
              OPC_CheckChild0Type, MVT::v2i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_SwitchType , 21,  MVT::v2i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPLN32d), 0,
                    1, MVT::v2i32, 4, 0, 2, 3, 4, 
              21,  MVT::v4i32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPLN32q), 0,
                    1, MVT::v4i32, 4, 0, 2, 3, 4, 
              0, 
            56, 
              OPC_CheckChild0Type, MVT::v2f32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_SwitchType , 21,  MVT::v2f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPLNfd), 0,
                    1, MVT::v2f32, 4, 0, 2, 3, 4, 
              21,  MVT::v4f32,
                OPC_CheckPatternPredicate, 3,
                OPC_EmitConvertToTarget, 1,
                OPC_EmitInteger, MVT::i32, 14, 
                OPC_EmitRegister, MVT::i32, 0 ,
                OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPLNfq), 0,
                    1, MVT::v4f32, 4, 0, 2, 3, 4, 
              0, 
            46, 
              OPC_CheckChild0Type, MVT::v16i8,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v16i8,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 18, 2,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v8i8, 2, 0, 3, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 19, 5,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPLN8q), 0,
                  1, MVT::v16i8, 4, 4, 6, 7, 8, 
            46, 
              OPC_CheckChild0Type, MVT::v8i16,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 6, 2,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v4i16, 2, 0, 3, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 7, 5,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegister, MVT::i32, 0 ,
              OPC_MorphNodeTo, TARGET_OPCODE(ARM::VDUPLN16q), 0,
                  1, MVT::v8i16, 4, 4, 6, 7, 8, 
            46, 
              OPC_CheckChild0Type, MVT::v4i32,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 8, 2,
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::v2i32, 2, 0, 3, 
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 9, 5,
              OPC_EmitInteger, MVT::i32, 14, 
              OPC_EmitRegis