#!/usr/bin/env python

# These tests access the network.

import unittest, string
from unittest import TestCase

import ClientCookie
from ClientCookie import build_opener, install_opener, urlopen
from ClientCookie import CookieJar, HTTPCookieProcessor, \
     HTTPHandler, HTTPRefreshProcessor, \
     HTTPEquivProcessor, \
     HTTPRedirectDebugProcessor, HTTPResponseDebugProcessor

try: True
except NameError:
    True = 1
    False = 0

class FunctionalTests(TestCase):
    def test_clientcookie(self):
        # XXX set up test page on SF or python.org
        # this test page depends on cookies, and an http-equiv refresh
        cj = CookieJar()
        handlers = [
            HTTPCookieProcessor(cj),
            HTTPRefreshProcessor(max_time=None, honor_time=False),
            HTTPEquivProcessor(),

#            HTTPHandler(True),
#            HTTPRedirectDebugProcessor(),
#            HTTPResponseDebugProcessor(),
            ]

        o = apply(build_opener, handlers)
        install_opener(o)
        r = urlopen("http://boards.ign.com/help/cookie_test.asp")
        data = r.read()
        self.assert_(string.find(data, "Your browser supports cookies!") >= 0)
        self.assert_(len(cj) == 1)

        # test response.seek() (added by HTTPEquivProcessor)
        r.seek(0)
        samedata = r.read()
        self.assert_(samedata == data)

##     def test_cacheftp(self):
##         from urllib2 import CacheFTPHandler, build_opener
##         o = build_opener(CacheFTPHandler())
##         r = o.open("ftp://ftp.python.org/pub/www.python.org/robots.txt")
##         data1 = r.read()
##         r.close()
##         r = o.open("ftp://ftp.python.org/pub/www.python.org/2.3.2/announce.txt")
##         data2 = r.read()
##         r.close()
##         self.assert_(data1 != data2)


if __name__ == "__main__":
    unittest.main()
