/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef __CTK_TYPES_H__
#define __CTK_TYPES_H__

#include <glib-object.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS


#define CTK_TYPE_PADDING               (ctk_padding_get_type ())
GType ctk_padding_get_type (void) G_GNUC_CONST;

typedef struct _CtkPadding     CtkPadding;

struct _CtkPadding
{
  gfloat top;
  gfloat right;
  gfloat bottom;
  gfloat left;
};

typedef enum
{
  CTK_ORIENTATION_HORIZONTAL = 0,
  CTK_ORIENTATION_VERTICAL
} CtkOrientation;

typedef enum
{
  CTK_STATE_NORMAL=0,
  CTK_STATE_ACTIVE,
  CTK_STATE_PRELIGHT,
  CTK_STATE_SELECTED,
  CTK_STATE_INSENSITIVE,

  CTK_N_STATES
} CtkActorState;

GType ctk_padding_get_type (void) G_GNUC_CONST;

G_END_DECLS

#endif /* __CTK_TYPES_H__ */
