.\"
.\" "$Id: lp.man 10042 2011-10-03 17:32:43Z mike $"
.\"
.\"   lp man page for CUPS.
.\"
.\"   Copyright 2007-2011 by Apple Inc.
.\"   Copyright 1997-2006 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Apple Inc. and are protected by Federal copyright
.\"   law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\"   which should have been included with this file.  If this file is
.\"   file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH lp 1 "CUPS" "3 October 2011" "Apple Inc."
.SH NAME
lp - print files
.SH SYNOPSIS
.B lp
[ -E ] [ -U
.I username
] [ -c ] [ -d
.I destination[/instance]
] [ -h
.I hostname[:port]
] [ -m ] [ -n
.I num-copies
] [ -o
.I option[=value]
] [ -q
.I priority
] [ -s ] [ -t
.I title
] [ -H
.I handling
] [ -P
.I page-list
] [ -- ] [
.I file(s)
]
.br
.B lp
[ -E ] [ -U
.I username
] [ -c ] [ -h
.I hostname[:port]
] [ -i
.I job-id
] [ -n
.I num-copies
] [ -o
.I option[=value]
] [ -q
.I priority
] [ -t
.I title
] [ -H
.I handling
] [ -P
.I page-list
]
.SH DESCRIPTION
\fIlp\fR submits files for printing or alters a pending job. Use
a filename of "-" to force printing from the standard input.
.SH THE DEFAULT DESTINATION
CUPS provides many ways to set the default destination. The "LPDEST" and
"PRINTER" environment variables are consulted first. If neither are set,
the current default set using the \fIlpoptions(1)\fR command is used,
followed by the default set using the \fIlpadmin(8)\fR command.
.SH OPTIONS
The following options are recognized by \fIlp\fR:
.TP 5
--
.br
Marks the end of options; use this to print a file whose name
begins with a dash (-).
.TP 5
-E
.br
Forces encryption when connecting to the server.
.TP 5
-U username
.br
Specifies the username to use when connecting to the server.
.TP 5
-c
.br
This option is provided for backwards-compatibility only. On
systems that support it, this option forces the print file to be
copied to the spool directory before printing. In CUPS, print
files are always sent to the scheduler via IPP which has the
same effect.
.TP 5
-d destination
.br
Prints files to the named printer.
.TP 5
-h hostname[:port]
.br
Chooses an alternate server.
.TP 5
-i job-id
.br
Specifies an existing job to modify.
.TP 5
-m
.br
Sends an email when the job is completed.
.TP 5
-n copies
.br
Sets the number of copies to print from 1 to 100.
.TP 5
-o "name=value [name=value ...]"
.br
Sets one or more job options.
.TP 5
-q priority
.br
Sets the job priority from 1 (lowest) to 100 (highest). The
default priority is 50.
.TP 5
-s
.br
Do not report the resulting job IDs (silent mode.)
.TP 5
-t "name"
.br
Sets the job name.
.TP 5
-H hh:mm
.TP 5
-H hold
.TP 5
-H immediate
.TP 5
-H restart
.TP 5
-H resume
.br
Specifies when the job should be printed. A value of \fIimmediate\fR will print
the file immediately, a value of \fIhold\fR will hold the job indefinitely, and
a UTC time value (HH:MM) will hold the job until the specified UTC (not local)
time. Use a value of \fIresume\fR with the \fI-i\fR option to resume a held job.
Use a value of \fIrestart\fR with the \fI-i\fR option to restart
a completed job.
.TP 5
-P page-list
.br
Specifies which pages to print in the document. The list can
contain a list of numbers and ranges (#-#) separated by commas
(e.g. 1,3-5,16). The page numbers refer to the output pages and
not the document's original pages - options like "number-up" can
affect the numbering of the pages.
.SH COMMON JOB OPTIONS
Aside from the printer-specific options reported by the
\fIlpoptions(1)\fR command, the following generic options are
available:
.TP 5
-o media=size
.br
Sets the page size to \fIsize\fR. Most printers support at least
the size names "a4", "letter", and "legal".
.TP 5
-o landscape
.TP 5
-o orientation-requested=4
.br
Prints the job in landscape (rotated 90 degrees).
.TP 5
-o sides=one-sided
.TP 5
-o sides=two-sided-long-edge
.TP 5
-o sides=two-sided-short-edge
.br
Prints on one or two sides of the paper. The value
"two-sided-long-edge" is normally used when printing portrait
(unrotated) pages, while "two-sided-short-edge" is used for
landscape pages.
.TP 5
-o fitplot
.br
Scales the print file to fit on the page.
.TP 5
-o number-up=2
.TP 5
-o number-up=4
.TP 5
-o number-up=6
.TP 5
-o number-up=9
.TP 5
-o number-up=16
.br
Prints multiple document pages on each output page.
.TP 5
-o scaling=number
.br
Scales image files to use up to \fInumber\fR percent of the page.
Values greater than 100 cause the image file to be printed across
multiple pages.
.TP 5
-o cpi=N
.br
Sets the number of characters per inch to use when printing a
text file. The default is 10.
.TP 5
-o lpi=N
.br
Sets the number of lines per inch to use when printing a text
file. The default is 6.
.TP 5
-o page-bottom=N
.TP 5
-o page-left=N
.TP 5
-o page-right=N
.TP 5
-o page-top=N
.br
Sets the page margins when printing text files. The values are in
points - there are 72 points to the inch.
.SH EXAMPLES
Print a double-sided legal document to a printer called "foo":
.nf
    lp -d foo -o media=legal -o sides=two-sided-long-edge filename
.fi
.LP
Print an image across 4 pages:
.nf
    lp -d bar -o scaling=200 filename
.fi
.LP
Print a text file with 12 characters per inch, 8 lines per inch, and
a 1 inch left margin:
.nf
    lp -d bar -o cpi=12 -o lpi=8 -o page-left=72 filename
.fi
.SH COMPATIBILITY
Unlike the System V printing system, CUPS allows printer names to
contain any printable character except SPACE, TAB, "/", or "#".
Also, printer and class names are \fInot\fR case-sensitive.
.LP
The "q" option accepts a different range of values than the
Solaris lp command, matching the IPP job priority values (1-100,
100 is highest priority) instead of the Solaris values (0-39, 0
is highest priority).
.SH SEE ALSO
\fIcancel(1)\fR, \fIlpadmin(8)\fR, \fIlpmove(8)\fR, \fIlpoptions(1)\fR,
\fIlpstat(1)\fR,
.br
http://localhost:631/help
.SH COPYRIGHT
Copyright 2007-2011 by Apple Inc.
.\"
.\" End of "$Id: lp.man 10042 2011-10-03 17:32:43Z mike $".
.\"
