.\"
.\" "$Id: ppdcfile.man 10791 2013-01-10 16:58:21Z mike $"
.\"
.\"   ppdcfile man page for CUPS.
.\"
.\"   Copyright 2007-2013 by Apple Inc.
.\"   Copyright 1997-2007 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Apple Inc. and are protected by Federal copyright
.\"   law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\"   which should have been included with this file.  If this file is
.\"   file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH ppdcfile 5 "CUPS" "3 December 2012" "Apple Inc."
.SH NAME
ppdcfile \- cups ppd compiler source file format
.SH DESCRIPTION
The CUPS PPD compiler reads meta files that contain descriptions
of one or more PPD files to be generated by \fIppdc\fR. This man
page provides a quick reference to the supported keywords and
should be used in conjunction with the online help for CUPS.
.PP
The source file format is plain ASCII text that can be edited
using your favorite text editor. Comments are supported using
the C (/* ... */) and C++ (// ...) comment mechanisms.
.PP
Printer driver information can be grouped and shared using
curly braces ({ ... }); PPD files are written when a close
brace or end-of-file is seen and a PCFileName directive has been
defined.
.PP
Directives may be placed anywhere on a line and are followed by
one or more values. The following is a list of the available
directives and the values they accept:
.TP 5
\fB#define\fR name value
.TP 5
\fB#elif\fR {name | value}
.TP 5
\fB#else\fR
.TP 5
\fB#endif\fR
.TP 5
\fB#font\fR name encoding "version" charset status
.TP 5
\fB#if\fR {name | value}
.TP 5
\fB#include\fR <filename>
.TP 5
\fB#include\fR "filename"
.TP 5
\fB#media\fR name width length
.TP 5
\fB#media\fR "name/text" width length
.TP 5
\fB#po\fR locale "filename.po"
.TP 5
\fBAttribute\fR name "" value
.TP 5
\fBAttribute\fR name keyword value
.TP 5
\fBAttribute\fR name "keyword/text" value
.TP 5
\fBChoice\fR name "code"
.TP 5
\fBChoice\fR "name/text" "code"
.TP 5
\fBColorDevice\fR boolean-value
.TP 5
\fBColorModel\fR name colorspace colororder compression
.TP 5
\fBColorModel\fR "name/text" colorspace colororder compression
.TP 5
\fBColorProfile\fR resolution/mediatype gamma density matrix
.TP 5
\fBCopyright\fR "text"
.TP 5
\fBCustomMedia\fR name width length left bottom right top "size-code" "region-code"
.TP 5
\fBCustomMedia\fR "name/text" width length left bottom right top "size-code" "region-code"
.TP 5
\fBCutter\fR boolean-value
.TP 5
\fBDarkness\fR temperature name
.TP 5
\fBDarkness\fR temperature "name/text"
.TP 5
\fBDriverType\fR type
.TP 5
\fBDuplex\fR type
.TP 5
\fBFilter\fR mime-type cost program
.TP 5
\fBFinishing\fR name
.TP 5
\fBFinishing\fR "name/text"
.TP 5
\fBFont\fR *
.TP 5
\fBFont\fR name encoding "version" charset status
.TP 5
\fBGroup\fR name
.TP 5
\fBGroup\fR "name/text"
.TP 5
\fBHWMargins\fR left bottom right top
.TP 5
\fBInputSlot\fR position name
.TP 5
\fBInputSlot\fR position "name/text"
.TP 5
\fBInstallable\fR name
.TP 5
\fBInstallable\fR "name/text"
.TP 5
\fBLocAttribute\fR name "keyword/text" value
.TP 5
\fBManualCopies\fR boolean-value
.TP 5
\fBManufacturer\fR "name"
.TP 5
\fBMaxSize\fR width length
.TP 5
\fBMediaSize\fR name
.TP 5
\fBMediaType\fR type name
.TP 5
\fBMediaType\fR type "name/text"
.TP 5
\fBMinSize\fR width length
.TP 5
\fBModelName\fR "name"
.TP 5
\fBModelNumber\fR number
.TP 5
\fBOption\fR name type section order
.TP 5
\fBOption\fR "name/text" type section order
.TP 5
\fBPCFileName\fR "filename.ppd"
.TP 5
\fBResolution\fR colorspace bits-per-color row-count row-feed row-step name
.TP 5
\fBResolution\fR colorspace bits-per-color row-count row-feed row-step "name/text"
.TP 5
\fBSimpleColorProfile\fR resolution/mediatype density yellow-density red-density gamma red-adjust green-adjust blue-adjust
.TP 5
\fBThroughput\fR pages-per-minute
.TP 5
\fBUIConstraints\fR "*Option1 *Option2"
.TP 5
\fBUIConstraints\fR "*Option1 Choice1 *Option2"
.TP 5
\fBUIConstraints\fR "*Option1 *Option2 Choice2"
.TP 5
\fBUIConstraints\fR "*Option1 Choice1 *Option2 Choice2"
.TP 5
\fBVariablePaperSize\fR boolean-value
.TP 5
\fBVersion\fR number
.SH SEE ALSO
ppdc(1), ppdhtml(1), ppdi(1), ppdmerge(1), ppdpo(1)
.br
http://localhost:631/help
.SH COPYRIGHT
Copyright 2007-2013 by Apple Inc.
.\"
.\" End of "$Id: ppdcfile.man 10791 2013-01-10 16:58:21Z mike $".
.\"
