/* gcs.cpp
 * gc creator functions
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001, 2002  Matthew Hiller
 */

#include <gdk/gdk.h>

GdkGC *
colorhelper (GdkWindow * window, gchar * fgcolor, gchar * bgcolor)
{
  GdkColor thecolor;
  GdkGC *ret;

  gdk_color_parse (fgcolor, &thecolor);
  gdk_colormap_alloc_color (gdk_colormap_get_system (),
			    &thecolor, TRUE, TRUE);
  ret = gdk_gc_new (window);
  gdk_gc_set_foreground (ret, &thecolor);

  if (bgcolor)
    {
      gdk_color_parse (bgcolor, &thecolor);
      gdk_colormap_alloc_color (gdk_colormap_get_system (),
				&thecolor, TRUE, TRUE);
      gdk_gc_set_background (ret, &thecolor);
    }
  return ret;
}

GdkGC *blackgc;
GdkGC *graygc;
GdkGC *greengc;
GdkGC *redgc;
GdkGC *bluegc;

#define autocolor(color) color##gc = colorhelper (window, #color, "white")

void
gcs_init (GdkWindow * window)
{
  autocolor (black);
  autocolor (gray);
  autocolor (green);
  autocolor (red);
  autocolor (blue);
}

GdkGC *
gcs_blackgc ()
{
  return blackgc;
}

GdkGC *
gcs_graygc ()
{
  return graygc;
}

GdkGC *
gcs_greengc ()
{
  return greengc;
}

GdkGC *
gcs_redgc ()
{
  return redgc;
}

GdkGC *
gcs_bluegc ()
{
  return bluegc;
}
