/* view.cpp
 * Functions to create a new view of the main window
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2003-2005  Adam Tee
 */
#include "view.h"
#include "lyparserfuncs.h"
#include "dialogs.h"
#include <stdlib.h>

#if GTK_MAJOR_VERSION > 1
#include <gtk/gtkaccelgroup.h>
#endif

#define INITIAL_WIDTH 1000
#define INITIAL_HEIGHT 500

extern GList *displays;
/* when invoked (via signal delete_event or file->quit), terminates
 * the application.  */

void
closeit (GtkWidget * widget, gpointer data)
{

  gtk_main_quit ();
}

void
close_application (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  struct scoreinfo *si = (struct scoreinfo *) data;
  if (si->haschanged)
    {
	if (confirmbox (si)) {
	    closeit(widget, si);
	}
    }
  else
    {
      closeit (widget, data);
    }
}
void
closewrapper (GtkAction *action,gpointer data)
{
  GList *display = NULL;
  struct scoreinfo *si;
  if (g_list_length (displays) > 1)
  {
      for (display = displays; display != NULL; display = g_list_next(display))
      {
	  si = (struct scoreinfo *) display->data;
	  if (si->haschanged)
	  {
	      if(confirmbox (si)) {
		  close_view(NULL, si);
	      }
	  }
	  else
	  {
	      close_view (NULL, data);
	  }
      }
  }

  si = (struct scoreinfo *) data;
  if (si->haschanged)
  {
      if (confirmbox (si)) {
	  closeit(NULL, data);
      }
  }
  else
  {
      closeit (NULL, data);
  }
}

void
createview (GtkAction *action,gpointer data)
{
  newview ();
}

void
openinnew (GtkAction *action,gpointer data)
{
  struct scoreinfo *si = (struct scoreinfo *) g_list_last (displays)->data;
  newview ();
  if (si->haschanged)
    {
	if (confirmbox (si)) {
	    file_open(NULL, si);
	}
    }
  else
    {
      file_open (NULL, si);
    }
}

void
close_view (GtkWidget * widget, gpointer data)
{
  displays = g_list_remove (displays, data);
  gtk_widget_destroy (((struct scoreinfo *) data)->window);
  g_free ((struct scoreinfo *) data);
}

void
closeview (GtkAction *action,gpointer data)
{
  struct scoreinfo *si = (struct scoreinfo *) data;
  if (g_list_length (displays) == 1)
  {
      if (confirmbox(si)) {
	  deletescore(NULL, si);
      }
  }
  else if (si->haschanged)
    {
	if (confirmbox (si)) {
	    close_view(NULL, si);
	}
    }
  else
    {
      close_view (NULL, data);
    }
}


GtkActionEntry menu_entries[] = {
  { "FileMenu", NULL, N_("_File") },
  { "New", GTK_STOCK_NEW, N_("New"), "<control>a", "Create a new file",
    G_CALLBACK(file_newwrapper)},
  { "NewWindow", NULL, N_("New Window"), NULL, "Create a new window",
    G_CALLBACK(createview)},
  { "Open", GTK_STOCK_OPEN, N_("Open"), "<control>o", "Open a file",
    G_CALLBACK(file_openwrapper)},
  { "OpenNewWindow", NULL, N_("Open in New Window"), NULL, 
   "Open in a New Window", G_CALLBACK(openinnew)}, 
  { "OpenTemplate", NULL, N_("Open Template"), NULL, "Open Score Template",
   G_CALLBACK(file_open_template_wrapper)},
  { "Save", GTK_STOCK_SAVE, N_("Save"), "<control>s", "Save File", 
    G_CALLBACK(file_savewrapper) },
  { "SaveAs", GTK_STOCK_SAVE_AS, N_("Save As"), NULL, "Save File As..",
    G_CALLBACK(file_saveaswrapper)},
  { "Print", GTK_STOCK_PRINT, N_("Print"), "<control>p", "Print Score",
    G_CALLBACK(print)},
  { "Close", GTK_STOCK_CLOSE, N_("Close"), "<control>w", "Close View",
    G_CALLBACK(closeview)},
  { "Quit" , GTK_STOCK_QUIT, N_("Quit"), "<control>q", "Quit Denemo",
    G_CALLBACK(closewrapper)},
  { "EditMenu", NULL, N_("_Edit") },
  { "Undo", GTK_STOCK_UNDO, N_("Undo"), "<control>z", "Undo", 
    G_CALLBACK(undowrapper)},
  { "Redo", GTK_STOCK_REDO, N_("Redo"), "<control>y", "Redo",
    G_CALLBACK(redowrapper)},
  { "Copy", GTK_STOCK_COPY, N_("Copy"), "<control>c", "Copy",
    G_CALLBACK(copywrapper)},
  { "Cut", GTK_STOCK_CUT, N_("Cut"), "<control>x", "Cut", 
    G_CALLBACK(cutwrapper)},
  { "Paste", GTK_STOCK_PASTE, N_("Paste"), "<control>v", "Paste",
    G_CALLBACK(pastewrapper)},
  { "SaveSelection", NULL, N_("Save Selection"), NULL, "Save Selection",
    G_CALLBACK(saveselwrapper)},
  { "Preferences", GTK_STOCK_PREFERENCES ,N_("Preferences"), NULL, 
    "Preferences", G_CALLBACK(preferences_change)},
  { "Keyboard", NULL, N_("Keyboard"), NULL, "Keyboard Mapping",
    G_CALLBACK(configure_keyboard_dialog)},
  { "LoadPlugins", NULL, N_("Load Plugins"), NULL, "Load Plugins",
    G_CALLBACK(load_plugin)},
  { "UnloadPlugins", NULL, N_("Unload Plugins"), NULL, "Unload Plugins",
    G_CALLBACK(unloadplugins)},
  { "ListPlugins", NULL, N_("List Plugins"), NULL, "List Plugins",
    G_CALLBACK(list_loaded_plugins)},
  { "ListAvailPlugins", NULL, N_("List Available Plugins"), NULL, 
    "List Available Plugins", G_CALLBACK(list_available_plugins)},
  { "EntryMenu", NULL, N_("Entry") },
  { "Insert", NULL, N_("Insert"), NULL, "Insert Mode", 
    G_CALLBACK(insert_mode)},
  { "Replace", NULL, N_("Replace"), NULL, "Replace Mode", 
    G_CALLBACK(replace_mode)},
  { "Default", NULL, N_("Default"), NULL, "Default Mode", 
    G_CALLBACK(default_mode)},
  { "StaffMenu", NULL, N_("Staff") },
  { "AddBefore", NULL, N_("Add Before Current Staff"), NULL, NULL, 
    G_CALLBACK(newstaff)},
  { "AddAfter", NULL, N_("Add After Current Staff"), NULL, NULL,
    G_CALLBACK(newstaff)},
  { "AddInitial", NULL, N_("Add in Initial Position"), NULL, NULL,
    G_CALLBACK(newstaff)},
  { "AddLast", NULL, N_("Add in Last Position"), NULL, NULL,
    G_CALLBACK(newstaff)},
  { "DeleteBefore", NULL, N_("Delete Staff Before"), NULL, NULL,
    G_CALLBACK(delete_staff_before)},
  { "Delete", NULL, N_("Delete Staff"), NULL, NULL,
    G_CALLBACK(delete_staff_current)},
  { "DeleteAfter", NULL, N_("Delete Staff After"), NULL, NULL,
    G_CALLBACK(delete_staff_after)},
  { "AddVoice", NULL, N_("Add _Voice to Current Staff"), NULL,NULL,
    G_CALLBACK(newstaff)},
  { "AddLyric", NULL, N_("Add Lyric Staff"), NULL, NULL,
    G_CALLBACK(newstaff)},
  { "AddFiguredBass", NULL, N_("Add Figured Bass Staff"), NULL, NULL,
    G_CALLBACK(newstaff)},
  { "StaffProperties", NULL, N_("Staff Properties"), NULL, NULL,
    G_CALLBACK(staff_properties_change)},
  { "AttributesMenu", NULL, N_("Attributes") },
  { "SetHeaders", NULL, N_("Set Headers"), NULL, NULL, 
    G_CALLBACK(header_change)},
  { "Clef", NULL, N_("Clef")},
  { "InitialClef", NULL, N_("Set Initial Clef"), NULL, NULL,
    G_CALLBACK(clef_change_initial)},
  { "InsertClef", NULL, N_("Insert Clef"), NULL, NULL,
    G_CALLBACK(clef_change_insert)},
  { "Key", NULL, N_("Key")},
  { "InitialKey", NULL, N_("Set Initial Key"), NULL, NULL,
    G_CALLBACK(key_change_initial)},
  { "InsertKey", NULL, N_("Insert Key"), NULL, NULL,
    G_CALLBACK(key_change_insert)},
  { "TimeSig", NULL, N_("Time Signature")},
  { "InitialTimeSig", NULL, N_("Set Initial Time Signature"), NULL, NULL,
    G_CALLBACK(timesig_change_initial)},
  { "InsertTimeSig", NULL, N_("Insert Time Signature"), NULL, NULL,
    G_CALLBACK(timesig_change_insert)},
  { "OtherMenu", NULL, N_("Other") },
  { "ChangeNotehead", NULL, N_("Change Notehead"), NULL, NULL,
    G_CALLBACK(set_notehead)},
  { "InsertStem", NULL, N_("Insert Stem Directive"), NULL, NULL,
    G_CALLBACK(stem_directive_insert)},
  { "InsertLyric", NULL, N_("Insert Lyric"), NULL, NULL, 
    G_CALLBACK(lyric_insert)},
  { "EditLyric", NULL, N_("Edit Lyric"), NULL, NULL,
    G_CALLBACK(lyric_insert)},
  { "EditFiguredBass", NULL, N_("Edit Figured Bass"), NULL, NULL,
    G_CALLBACK(figure_insert)},
  { "InsertDynamic", NULL, N_("Insert Dynamic"), NULL, NULL,
    G_CALLBACK(insert_dynamic)},
  { "InsertLilyDirective", NULL, N_("Insert Lilypond Directive"), NULL, NULL,
    G_CALLBACK(lily_directive)},
  { "InsertArticulation", NULL, N_("Insert Articulation")},
  { "General", NULL, N_("General"), NULL, NULL,
    G_CALLBACK(insert_articulation_general)},
  { "String", NULL, N_("String"), NULL, NULL,
    G_CALLBACK(insert_articulation_string)},
  { "Organ", NULL, N_("Organ"), NULL, NULL,
    G_CALLBACK(insert_articulation_organ)},
  { "InsertBarline", NULL, N_("Insert Barline"), NULL, NULL,
    G_CALLBACK(insert_barline)},
  { "DisplayMenu", NULL, N_("Display") },
  { "MeasureWidth", NULL, N_("Change Measure Width"), NULL, NULL,
    G_CALLBACK(score_mwidth_change)},
  { "StaffSpacing", NULL, N_("Change Staff Spacing"), NULL, NULL,
     G_CALLBACK(score_staffspace_change)},
  { "NavigationMenu", NULL, N_("Navigation") },
   { "GoToMeasure", NULL, N_("Go To Measure"), NULL, NULL,
    G_CALLBACK(tomeasurenum)},
  { "GoToBeginning", GTK_STOCK_GOTO_FIRST, N_("Go To Beginning"), "Home", NULL,
    G_CALLBACK(tohome)},
  { "GoToEnd", GTK_STOCK_GOTO_LAST, N_("Go To End"), "End" , NULL,
    G_CALLBACK(toend)},
  { "GoToNextScore", NULL, N_("Go To Next Score"), NULL, NULL,
    G_CALLBACK(tonextscore)},
  { "PlaybackMenu", NULL, N_("Playback") },
  { "Play", /*GTK_STOCK_MEDIA_PLAY*/ NULL, N_("Play"), NULL, NULL,
    G_CALLBACK(playback)},
  { "PlayCSound", NULL, N_("Play CSound"), NULL, NULL,
    G_CALLBACK(csoundplayback)},
  { "Properties", GTK_STOCK_PROPERTIES, N_("Playback Properties"), NULL, NULL,
    G_CALLBACK(playback_properties_change)},
  { "HelpMenu", NULL, N_("Help") },
  { "About", NULL, N_("About"), NULL, NULL,
    G_CALLBACK(about)}
};


GtkItemFactoryEntry menu_items[] = {
  {N_("/_File"), "<control>a", NULL, 0, "<Branch>"}
  ,
  {N_("/File/_New"), "<control>n", GTK_SIGNAL_FUNC (file_newwrapper), 0, NULL}
  ,
 
  {N_("/File/New _Window"), NULL, GTK_SIGNAL_FUNC (createview), 0, NULL}
  ,
  {N_("/File/_Open"), "<control>o", GTK_SIGNAL_FUNC(file_openwrapper), 0, NULL}
  ,
  {N_("/File/Open in New Window"), NULL, GTK_SIGNAL_FUNC(openinnew), 0, NULL}
  , 
  {N_("/File/Open Template"), NULL, GTK_SIGNAL_FUNC(file_open_template_wrapper), 0, NULL},
  {N_("/File/_Save"), "<control>s", GTK_SIGNAL_FUNC(file_savewrapper), 0, NULL}
  ,
  {N_("/File/Save _As"), NULL, GTK_SIGNAL_FUNC (file_saveaswrapper), 0, NULL}
  ,
  {N_("/File/sep1"), NULL, NULL, 0, "<Separator>"}
  ,
  {N_("/File/_Print"), "<control>p", GTK_SIGNAL_FUNC (print), 0, NULL}
  ,
  {N_("/File/_Close"), "<control>w", GTK_SIGNAL_FUNC (closeview), 0, NULL}
  ,
  {N_("/File/_Quit"), "<control>q", GTK_SIGNAL_FUNC (closewrapper), 0, NULL}
  ,
  {N_("/_Edit"), NULL, NULL, 0, "<Branch>"}
  ,
  {N_("/Edit/Undo"), "<control>z", GTK_SIGNAL_FUNC(undowrapper),0, NULL}
  ,
  {N_("/Edit/Redo"), "control>y", GTK_SIGNAL_FUNC(redowrapper),0,NULL},
  {N_("/Edit/_Copy"), "<control>c", GTK_SIGNAL_FUNC (copywrapper), 0, NULL}
  ,
  {N_("/Edit/C_ut"), "<control>x", GTK_SIGNAL_FUNC (cutwrapper), 0, NULL}
  ,
  {N_("/Edit/_Paste"), "<control>v", GTK_SIGNAL_FUNC (pastewrapper), 0, NULL}
  ,
  {N_("/Edit/Save Selection"), NULL, GTK_SIGNAL_FUNC (saveselwrapper), 0, NULL}
  ,
  {N_("/Edit/sep1"), NULL, NULL, 0, "<Separator>"}
  ,
  {N_("/Edit/P_references"), NULL, GTK_SIGNAL_FUNC (preferences_change), 0,
   NULL}
  ,
  {N_("/Edit/_Keyboard"), NULL, GTK_SIGNAL_FUNC (configure_keyboard_dialog),
   0,
   NULL}
  ,
  {N_("/Edit/Load Plugins"), NULL, GTK_SIGNAL_FUNC (load_plugin), 0, NULL}
  ,
  {N_("/Edit/Unload Plugins"), NULL, GTK_SIGNAL_FUNC (unloadplugins), 0, NULL}
  ,
  {N_("/Edit/List Available Plugins"), NULL, 
   GTK_SIGNAL_FUNC(list_available_plugins), 0, NULL},
  {N_("/Edit/List Loaded Plugins"), NULL, GTK_SIGNAL_FUNC (list_loaded_plugins), 0, NULL}
  ,
  {N_("/Entry Mode"), NULL,NULL,0, "<Branch>"},
  {N_("/Entry Mode/Insert"), "i", GTK_SIGNAL_FUNC(insert_mode),0, NULL},
  {N_("/Entry Mode/Replace"), "r",GTK_SIGNAL_FUNC(replace_mode),0,NULL},
  {N_("/Entry Mode/Default"), "Esc", GTK_SIGNAL_FUNC(default_mode),0,NULL},
  {N_("/_Staff"), NULL, NULL, 0, "<Branch>"}
  ,
  {N_("/Staff/Add New Staff _Before Current Staff"), NULL,
   GTK_SIGNAL_FUNC (newstaff), BEFORE, NULL}
  ,
  {N_("/Staff/Add New Staff _After Current Staff"), NULL,
   GTK_SIGNAL_FUNC (newstaff), AFTER, NULL}
  ,
  {N_("/Staff/Add New Staff in _Initial Position"), NULL,
   GTK_SIGNAL_FUNC (newstaff), FIRST, NULL}
  ,
  {N_("/Staff/Add New Staff in _Last Position"), NULL,
   GTK_SIGNAL_FUNC (newstaff), LAST, NULL}
  ,
  {N_("/Staff/Delete Staff Before Current Staff"), NULL, 
   GTK_SIGNAL_FUNC(delete_staff), BEFORE,NULL},
  {N_("/Staff/Delete Staff"), NULL, GTK_SIGNAL_FUNC(delete_staff), 0, NULL},
  {N_("/Staff/Delete Staff After Current Staff"), NULL, 
   GTK_SIGNAL_FUNC(delete_staff), AFTER,NULL},
  {N_("/Staff/sep1"), NULL, NULL, 0, "<Separator>"}
  ,
  {N_("/Staff/Add _Voice to Current Staff"), NULL,
   GTK_SIGNAL_FUNC (newstaff), NEWVOICE, NULL}
  ,
  {N_("/Staff/Add Lyric Staff"), NULL, GTK_SIGNAL_FUNC (newstaff),
   LYRICSTAFF, NULL}
  ,
  {N_("/Staff/Add Figured Bass Staff"), NULL, GTK_SIGNAL_FUNC (newstaff),
   FIGURESTAFF, NULL}
  ,
  {N_("/Staff/sep2"), NULL, NULL, 0, "<Separator>"}
  ,
  {N_("/Staff/Staff _Properties"), NULL,
   GTK_SIGNAL_FUNC (staff_properties_change), 0, NULL}
  ,
  {N_("/_Attributes"), NULL, NULL, 0, "<Branch>"},
  {N_("/Attributes/Set _Headers"), NULL, GTK_SIGNAL_FUNC (header_change), 0, NULL}
  ,
  {N_("/Attributes/sep3"), NULL, NULL, 0, "<Separator>"}
  ,
  {N_("/Attributes/_Clef"), NULL, NULL, 0, "<Branch>"},
  {N_("/Attributes/Clef/Set _Initial Clef"), NULL, GTK_SIGNAL_FUNC(clef_change),
   CHANGEINITIAL, NULL},
  {N_("/Attributes/Clef/Insert Clef _Change"), NULL, GTK_SIGNAL_FUNC(clef_change),
   INSERT, NULL},
  {N_("/Attributes/_Key"), NULL, NULL, 0, "<Branch>"},
  {N_("/Attributes/Key/Set _Initial Key Signature"), NULL,
   GTK_SIGNAL_FUNC(key_change), CHANGEINITIAL, NULL},
  {N_("/Attributes/Key/Insert Key Signature _Change"), NULL,
   GTK_SIGNAL_FUNC(key_change),
   INSERT, NULL},
  {N_("/Attributes/_Time"), NULL, NULL, 0, "<Branch>"},
  {N_("/Attributes/Time/Set _Initial Time Signature"), NULL,
   GTK_SIGNAL_FUNC(timesig_change), CHANGEINITIAL, NULL},
  {N_("/Attributes/Time/Insert Time Signature _Change"), NULL,
   GTK_SIGNAL_FUNC(timesig_change), INSERT, NULL},
  {N_("/_Other"), NULL, NULL, 0, "<Branch>"}
  ,
  {N_("/Other/Change _Notehead"), NULL,
   GTK_SIGNAL_FUNC (set_notehead), 0, NULL}
  ,
  {N_("/Other/Insert _Stemming Directive"), NULL,
   GTK_SIGNAL_FUNC (stem_directive_insert), 0, NULL}
  ,
  {N_("/Other/Insert _Lyric"), NULL, GTK_SIGNAL_FUNC (lyric_insert), 0, NULL}
  ,
  {N_("/Other/Edit Lyric"), NULL, GTK_SIGNAL_FUNC (lyric_insert), 0, NULL}
  ,
  {N_("/Other/Edit _FiguredBass"), NULL, GTK_SIGNAL_FUNC (figure_insert),
   0, NULL}
  ,
  {N_("/Other/Insert _Dynamic"), NULL,
   GTK_SIGNAL_FUNC (insert_dynamic), 0, NULL}
  ,
  {N_("/Other/Insert Lily Directive"), NULL, GTK_SIGNAL_FUNC (lily_directive),
   0, NULL}
  ,
  {N_("/Other/Insert _Articulation"), NULL, NULL, 0, "<Branch>"}
  ,
  {N_("/Other/Insert _Articulation/General"), NULL,
   GTK_SIGNAL_FUNC (insert_articulation), GENERAL, NULL}
  ,
  {N_("/Other/Insert _Articulation/String"), NULL,
   GTK_SIGNAL_FUNC (insert_articulation), STRING, NULL}
  ,
  {N_("/Other/Insert _Articulation/Organ"), NULL,
   GTK_SIGNAL_FUNC (insert_articulation), ORGAN, NULL}
  ,
  {N_("/Other/Insert_Barline"), NULL, GTK_SIGNAL_FUNC (insert_barline),
   0, NULL}
  ,
  {N_("/_Display"), NULL, NULL, 0, "<Branch>"}
  ,
  {N_("/_Display/Change _Measure Width"), NULL,
   GTK_SIGNAL_FUNC (score_mwidth_change), 0, NULL}
  ,
  {N_("/_Display/Change _Space between Staffs"), NULL,
   GTK_SIGNAL_FUNC (score_staffspace_change), 0, NULL}
  ,
  {N_("/_Navigation"), NULL, NULL, 0, "<Branch>"}
  ,
  {N_("/Navigation/Go _To Measure"), NULL, GTK_SIGNAL_FUNC (tomeasurenum),
   0, NULL}
  ,
  {N_("/Navigation/To _Beginning of Score"), NULL, GTK_SIGNAL_FUNC (tohome),
   0, NULL}
  ,
  {N_("/Navigation/To _End of Score"), NULL, GTK_SIGNAL_FUNC (toend), 0, NULL}
  ,
  {N_("/Navigation/To _Next Score"), NULL, GTK_SIGNAL_FUNC (tonextscore),
   0, NULL}
  ,
  {N_("/_Playback"), NULL, NULL, 0, "<Branch>"}
  ,
  {N_("/Playback/_Play"), NULL, GTK_SIGNAL_FUNC (playback), 0, NULL}
  ,
  {N_("/Playback/Play _CSound"), NULL, GTK_SIGNAL_FUNC (csoundplayback), 0,
   NULL}
  ,
  {N_("/Playback/P_roperties"), NULL,
   GTK_SIGNAL_FUNC (playback_properties_change), 0, NULL}
  ,
  {N_("/_Help"), NULL, NULL, 0, "<LastBranch>"}
  ,
  /*  {N_("/Help/List _Keybindings"), NULL, keybindings, 0, NULL}, */
  {N_("/_Help/_About"), NULL, GTK_SIGNAL_FUNC (about), 0, NULL}
};

gint n_menu_items = G_N_ELEMENTS(menu_items);

void
newview ()
{
  struct scoreinfo *si =
    (struct scoreinfo *) g_malloc0 (sizeof (struct scoreinfo));
  struct prefinfo *prefs;
  GtkWidget *main_vbox, *menubar, *score_and_scroll_hbox, *toolbar;
  GtkItemFactory *item_factory;
  GtkActionGroup *action_group;
  GtkUIManager *ui_manager;
  GtkAccelGroup *accel_group;
  GError *error;
  /* Initialize preferences */
  prefs = initprefs ();
  /* Initialize the staff structure */
  init_score (si);
  si->prefs = prefs;
  newstaff (si, INITIAL);
  si->pixmap = NULL;

  /* Initialize the GUI */

  si->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
#if GTK_MAJOR_VERSION > 1
   gtk_window_set_resizable(GTK_WINDOW(si->window),TRUE);
#else
  gtk_window_set_policy (GTK_WINDOW (si->window), TRUE, TRUE, FALSE);
#endif
  main_vbox = gtk_vbox_new (FALSE, 1);
  gtk_container_border_width (GTK_CONTAINER (main_vbox), 1);
  gtk_container_add (GTK_CONTAINER (si->window), main_vbox);
  gtk_widget_show (main_vbox);

  /* This part is taken more-or-less directly from the gtk+ tutorial */
  accel_group = gtk_accel_group_new ();
  action_group = gtk_action_group_new("MenuActions");
  gtk_action_group_add_actions(action_group, menu_entries, 
			       G_N_ELEMENTS(menu_entries), si);

  ui_manager = gtk_ui_manager_new();
  gtk_ui_manager_insert_action_group (ui_manager, action_group, 0);
  accel_group =  gtk_ui_manager_get_accel_group(ui_manager);
  error = NULL;
  //item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
  //			       accel_group);
  //gtk_item_factory_create_items (item_factory, n_menu_items, menu_items, si);
  /* This also sets si as the  callback data for all the functions in the 
   * menubar, which is precisely what we want. */
#if GTK_MAJOR_VERSION > 1
  gtk_window_add_accel_group (GTK_WINDOW (si->window), accel_group);
  if(!gtk_ui_manager_add_ui_from_file(ui_manager, SYSCONFDIR "denemoui.xml", 
												  &error))
    {
      g_message("building menu failed: %s", error->message);
      g_error_free(error);
      exit(EXIT_FAILURE);
    }
#else
  gtk_accel_group_attach (accel_group, GTK_OBJECT (si->window));
#endif
  //menubar = gtk_item_factory_get_widget (item_factory, "<main>");
  menubar = gtk_ui_manager_get_widget(ui_manager, "/MainMenu");
  si->menubar = menubar;
  toolbar = gtk_ui_manager_get_widget(ui_manager, "/ToolBar");
  gtk_box_pack_start (GTK_BOX (main_vbox), menubar, FALSE, TRUE, 0);
  gtk_widget_show (menubar);
  
  gtk_box_pack_start (GTK_BOX (main_vbox), toolbar, FALSE, TRUE, 0);
  gtk_widget_show (toolbar);
  

  score_and_scroll_hbox = gtk_hbox_new (FALSE, 1);
  gtk_box_pack_start (GTK_BOX (main_vbox), score_and_scroll_hbox, TRUE, TRUE,
		      0);
  gtk_widget_show (score_and_scroll_hbox);

  si->scorearea = gtk_drawing_area_new ();
#if GTK_MAJOR_VERSION > 1
  gtk_window_set_default_size (GTK_WINDOW (si->window), INITIAL_WIDTH,
			       INITIAL_HEIGHT);
#else
  gtk_drawing_area_size (GTK_DRAWING_AREA (si->scorearea),
			 INITIAL_WIDTH, INITIAL_HEIGHT);
#endif
  gtk_box_pack_start (GTK_BOX (score_and_scroll_hbox), si->scorearea, TRUE,
		      TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (si->scorearea), "expose_event",
		      GTK_SIGNAL_FUNC (scorearea_expose_event), si);
  gtk_signal_connect (GTK_OBJECT (si->scorearea), "configure_event",
		      GTK_SIGNAL_FUNC (scorearea_configure_event), si);
  gtk_signal_connect (GTK_OBJECT (si->scorearea), "button_release_event",
		      GTK_SIGNAL_FUNC (scorearea_button_release), si);
  gtk_widget_set_events (si->scorearea, (GDK_EXPOSURE_MASK
					 | GDK_LEAVE_NOTIFY_MASK
					 | GDK_BUTTON_PRESS_MASK
					 | GDK_BUTTON_RELEASE_MASK));
  gtk_widget_show (si->scorearea);

  si->vadjustment = gtk_adjustment_new (1.0, 1.0, 2.0, 1.0, 4.0, 1.0);
  gtk_signal_connect (GTK_OBJECT (si->vadjustment), "value_changed",
		      GTK_SIGNAL_FUNC (vertical_scroll), si);
  si->vscrollbar = gtk_vscrollbar_new (GTK_ADJUSTMENT (si->vadjustment));
  gtk_box_pack_start (GTK_BOX (score_and_scroll_hbox), si->vscrollbar, FALSE,
		      TRUE, 0);
  gtk_widget_show (si->vscrollbar);
  
  si->hadjustment = gtk_adjustment_new (1.0, 1.0, 2.0, 1.0, 4.0, 1.0);
  
  gtk_signal_connect (GTK_OBJECT (si->hadjustment), "value_changed",
		      GTK_SIGNAL_FUNC (horizontal_scroll), si);
  si->hscrollbar = gtk_hscrollbar_new (GTK_ADJUSTMENT (si->hadjustment));
  gtk_box_pack_start (GTK_BOX (main_vbox), si->hscrollbar, FALSE, TRUE, 0);
  gtk_widget_show (si->hscrollbar);
  si->statusbar = gtk_statusbar_new();
  gtk_box_pack_start(GTK_BOX(main_vbox),si->statusbar, FALSE,FALSE,0);
  gtk_widget_show(si->statusbar);
  si->status_context_id = 
    gtk_statusbar_get_context_id(GTK_STATUSBAR(si->statusbar), "Denemo");
  gtk_statusbar_push(GTK_STATUSBAR(si->statusbar), si->status_context_id,
		      "Denemo");
  gtk_signal_connect (GTK_OBJECT (si->window), "delete_event",
		      (GtkSignalFunc) close_application, si);
  gtk_signal_connect (GTK_OBJECT (si->window), "key_press_event",
		      (GtkSignalFunc) scorearea_keypress_event, si);

  gtk_widget_show (si->window);

  /* Now that the window's shown, initialize the gcs */
  gcs_init (si->window->window);

  /* Similarly, the keymap should be initialized after the
     only once si->window is shown, as it may pop up an advisory
     dialog. */
  si->prefs->the_keymap = init_keymap ();
  displays = g_list_append (displays, si);
  g_print ("No of Displays %d\n", g_list_length (displays));
  if(si->prefs->autosave)
    g_timeout_add(si->prefs->autosave_timeout * 1000 * 60,
		  (GSourceFunc)auto_save_document_timeout,
		  si);
}
