/**
 * csoundplayback.cpp
 *
 * CSound playback functions, 
 * runs csound with -g -W flags (creates wav file)
 * for Denemo, a GTK Frontend to GNU Lilypond
 *
 * (c) 2002-2005 Adam Tee 
 */

#include "csoundplayback.h"
#include "exportcsound.h"
#include "prefops.h"
#include "utils.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifdef HAVE_WAIT_H
#include <wait.h>
#endif
#include <errno.h>

/**
 * Local function prototypes
 */
void selorcfile (GtkWidget * widget, gpointer data);
void chooseorcfile (GtkWidget * widget, gpointer data);


struct callbackdata
{
  GtkWidget *entry;
  GtkWidget *csoundpath;
  GtkWidget *rt;
  struct scoreinfo *si;
};

static GString *orcfilename;

void
csoundplayback (GtkAction * action, gpointer callback_data)
{
  GtkWidget *dialog;
  GtkWidget *entry;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *csoundentry;
  GtkWidget *rt;
  GtkWidget *button;
  static struct callbackdata cbdata;
  struct scoreinfo *si = (struct scoreinfo *) callback_data;


  dialog = gtk_dialog_new_with_buttons (_("CSound Playback"), NULL,
					(GtkDialogFlags) (GTK_DIALOG_MODAL |
							  GTK_DIALOG_DESTROY_WITH_PARENT),
					GTK_STOCK_OK, GTK_RESPONSE_OK,
					GTK_STOCK_CANCEL, GTK_STOCK_CANCEL,
					NULL);


  table = gtk_table_new (3, 3, TRUE);
  label = gtk_label_new (_("Orchestra File"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  gtk_widget_show (label);

  entry = gtk_entry_new ();
  if (orcfilename)
    gtk_entry_set_text (GTK_ENTRY (entry), orcfilename->str);
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 0, 1);
  gtk_widget_show (entry);


  button = gtk_button_new_with_label (_("Choose File"));
  gtk_table_attach_defaults (GTK_TABLE (table), button, 2, 3, 0, 1);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (chooseorcfile), (gpointer) si);
  gtk_widget_show (button);


  label = gtk_label_new (_("CSound Path"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  gtk_widget_show (label);

  csoundentry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (csoundentry), "csound -dm6");
  gtk_table_attach_defaults (GTK_TABLE (table), csoundentry, 1, 2, 1, 2);
  gtk_widget_show (csoundentry);


  label = gtk_label_new (_("RealTime playback"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  gtk_widget_show (label);

  rt = gtk_check_button_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), rt, 1, 2, 2, 3);
  gtk_widget_show (rt);


  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), table, TRUE, TRUE,
		      0);
  gtk_widget_show (table);

  cbdata.entry = entry;
  cbdata.si = si;
  cbdata.csoundpath = csoundentry;
  cbdata.rt = rt;

  gtk_widget_grab_focus (entry);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
    csoundplay (&cbdata);

  gtk_widget_destroy (dialog);
}


void
csoundplay (gpointer data)
{
  static GString *filename;
  static GString *passtosystem;
  static GString *outputfile;


  pid_t pid;
  struct callbackdata *cbdata = (struct callbackdata *) data;
  struct scoreinfo *si = (struct scoreinfo *) cbdata->si;
  gchar *orcname = (gchar *) gtk_entry_get_text (GTK_ENTRY (cbdata->entry));
  gchar *csound =
    (gchar *) gtk_entry_get_text (GTK_ENTRY (cbdata->csoundpath));
  gboolean realtime =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cbdata->rt));

  if (!filename)
    {
      filename = g_string_new (locatedotdenemo ());
      g_string_append (filename, "/denemocsoundplayback");
      if (realtime)
	outputfile = g_string_new ("devaudio");
      else
	{
	  outputfile = g_string_new (locatedotdenemo ());
	  g_string_append (outputfile, "/denemocsoundplayback.wav");
	}
      passtosystem = g_string_new (NULL);
      orcfilename = g_string_new (NULL);
    }

  g_string_assign (orcfilename, orcname);


#ifdef G_OS_WIN32
  pid = -1;
#else
  pid = fork ();
#endif

  if (pid == -1)
    {
      fprintf (stderr, "%s: Failed to fork()\n", strerror (errno));
      return;
    }
  else if (pid == 0)
    {
      int status = 0;
      exportcsound (filename->str, si, si->start, si->end);

      g_string_assign (passtosystem, csound);
      g_string_append (passtosystem, " ");
      g_string_append (passtosystem, orcfilename->str);
      g_string_append (passtosystem, " ");
      g_string_append (passtosystem, filename->str);
      g_string_append (passtosystem, " -o ");
      g_string_append (passtosystem, outputfile->str);

      status = system (passtosystem->str);

      if (!status)
	{

	  g_string_assign (passtosystem, si->prefs->audioplayer->str);
	  g_string_append (passtosystem, " ");
	  g_string_append (passtosystem, outputfile->str);

	  system (passtosystem->str);
	}
      _exit (0);
    }

}

typedef struct callbackdata1
{
  GtkWidget *fs;
  struct scoreinfo *si;
} callbackdata1;

void
chooseorcfile (GtkWidget * widget, gpointer data)
{
  GtkWidget *fs;
  callbackdata1 cbdata;
  fs = gtk_file_selection_new (_("Choose CSound Orchestra File"));

  cbdata.si = (struct scoreinfo *) data;
  cbdata.fs = fs;
  g_signal_connect (GTK_OBJECT
		    (GTK_FILE_SELECTION (fs)->ok_button),
		    "clicked", G_CALLBACK (selorcfile), &cbdata);

  /* Ensure that the dialog box is destroyed when the user clicks a button. */

  g_signal_connect_swapped (GTK_OBJECT
			    (GTK_FILE_SELECTION (fs)->ok_button),
			    "clicked", G_CALLBACK (gtk_widget_destroy),
			    (gpointer) fs);

  g_signal_connect_swapped (GTK_OBJECT
			    (GTK_FILE_SELECTION (fs)->cancel_button),
			    "clicked", G_CALLBACK (gtk_widget_destroy),
			    (gpointer) fs);

  gtk_window_set_modal (GTK_WINDOW (fs), TRUE);
  gtk_window_set_position (GTK_WINDOW (fs), GTK_WIN_POS_MOUSE);
  gtk_widget_show (fs);

}

void
selorcfile (GtkWidget * widget, gpointer data)
{
  callbackdata1 *cbdata = (callbackdata1 *) data;
  g_print ("Got here %p", cbdata->fs);
  gchar *filename =
    (gchar *)
    gtk_file_selection_get_filename (GTK_FILE_SELECTION (cbdata->fs));
  g_print ("%s\n", filename);
  if (!orcfilename)
    orcfilename = g_string_new (filename);
  else
    g_string_assign (orcfilename, filename);


  g_print ("Do nothing");
}
