/* drawfigure.cpp 
 *
 * function to display Figured Bass figures on score
 * for Denemo, a gtk+ frontend to GNU Lilypond 
 * 
 * (c) 2003-2005 Richard Shann <richard.shann@virgin.net>
 */

#include "utils.h"
#include <denemo/denemo.h>
#include <string.h>

void
draw_figure (GdkPixmap * pixmap, GdkGC * gc, GdkFont * font,
	     gint xx, gint y, mudelaobject * theobj)
{
  static GdkFont *figurefont = NULL;
  gchar *text = NULL;
  gint length = 0;
  chord *ch;
  if (theobj->type == FIGURE)
    {
      g_warning ("FIGURE type found and not handled");
    }
  else if (theobj->type == CHORD)
    {
      ch = (chord *) theobj->object;
      if (ch->is_figure)
	{
	  text = ((GString *) (ch->figure))->str;
	  length = ((GString *) (ch->figure))->len;
	}
      else
	{
	  mudelaobject *mud = (mudelaobject *) ((GList *) (ch->figure))->data;
	  chord *mych = (chord *) mud->object;
	  GString *mygstr = (GString *) mych->figure;
	  text = mygstr->str;
	  length = mygstr->len;
	}

    }
#ifdef DEBUG
  g_print ("%s, %d\n", text, length);
#endif

  if (!figurefont)
    {
      figurefont = gdk_fontset_load
	("-*-helvetica-medium-r-normal-*-12-*-*-*-*-*-iso8859-*");
      if (figurefont)
	figurefont = font;
    }
  gdk_draw_text (pixmap, figurefont, gc, xx, y, text, length);

}
