/* exportpdf.cpp
 * Export pdf using lilypond
 *
 * (c) 2000, 2001, 2002 Adam Tee
 */

#include <unistd.h>
#include "config.h"
#include <denemo/denemo.h>
#include "exportpdf.h"
#include "exportmudela.h"
#include "file.h"

void export_pdf_action (GtkAction *action, struct scoreinfo *si)
{

  GtkWidget *file_selection;

  file_selection = gtk_file_chooser_dialog_new(_("Export PDF"),
					       GTK_WINDOW(si->window),
					       GTK_FILE_CHOOSER_ACTION_SAVE,
					       GTK_STOCK_CANCEL, 
					       GTK_RESPONSE_REJECT,
                                               GTK_STOCK_SAVE,
					       GTK_RESPONSE_ACCEPT,
					       NULL);

  gtk_widget_show_all(file_selection);
  gboolean close = FALSE;
  do {

    if (gtk_dialog_run(GTK_DIALOG(file_selection)) == GTK_RESPONSE_ACCEPT)
      {
	gchar* filename =
	  gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(file_selection));

	if (replace_existing_file_dialog(filename, GTK_WINDOW(si->window)))
	  {
	    export_pdf (filename, si);
	    close = TRUE;
	  }
	g_free(filename);
      }
    else
      {
	close = TRUE;
      }

  } while(!close);

  gtk_widget_destroy(file_selection);
}

void
export_pdf (const gchar* filename, struct scoreinfo *si)
{

  
  gchar* tmpfile;
  GError* err = NULL;

  // not 100% secure
  gint fd = g_file_open_tmp("denemo-XXXXXX", &tmpfile, &err);
  if (err != NULL)
    {
      // TODO: improve error reporting
      g_warning("%s", err->message);
      g_error_free(err);
      return;
    }

  close(fd);
  remove(tmpfile);
  gchar* mudelafile = g_strconcat(tmpfile, ".ly", NULL);
  exportmudela (mudelafile, si, si->start, si->end);

  gchar* argv[] = {
    si->prefs->lilypath->str,
    "--pdf",
    "-o",
    tmpfile,
    mudelafile,
    NULL
  };

  gint exit_status;
  g_spawn_sync(NULL, /* dir */
	       argv,
	       NULL, /* env */
	       G_SPAWN_SEARCH_PATH,
	       NULL, /* child setup func */
               NULL, /* user data */
	       NULL, /* stdout */
	       NULL, /* stderr */
	       &exit_status,
	       &err);

  if (err != NULL)
    {
      g_warning("%s", err->message);
      g_error_free(err);
    }

  gchar* pdffile = g_strconcat(tmpfile, ".pdf", NULL);
  if (rename(pdffile, filename) != 0)
    {
      g_warning("Failed to rename %s to %s", pdffile, filename);
    }

  remove(mudelafile);
  gchar* dvifile = g_strconcat(tmpfile, ".dvi", NULL);
  remove(dvifile);
  gchar* psfile = g_strconcat(tmpfile, ".ps", NULL);
  remove(psfile);
  gchar* midifile = g_strconcat(tmpfile, ".midi", NULL);
  remove(midifile);

  g_free(dvifile);
  g_free(psfile);
  g_free(pdffile);
  g_free(tmpfile);
  g_free(mudelafile);
  g_free(midifile);
}

