/* hairpin.cpp
 *
 * Functions for drawing hairpins
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000-2005 Adam Tee, Matthew Hiller
 */

#include <denemo/denemo.h>
#include "utils.h"		/* Includes <gdk.h> */

GSList *
push_hairpin_stack (GSList * hairpin_stack, gint x)
{
  hairpin_stack = g_slist_prepend (hairpin_stack, GINT_TO_POINTER (x));
  return hairpin_stack;
}

gint
top_hairpin_stack (GSList * hairpin_stack)
{
  if (hairpin_stack)
    return GPOINTER_TO_INT (hairpin_stack->data);
  else
    return -1;
}

GSList *
pop_hairpin_stack (GSList * hairpin_stack)
{
  if (hairpin_stack)
    {
      GSList *head = hairpin_stack;

      hairpin_stack = g_slist_remove_link (hairpin_stack, head);
      g_slist_free_1 (head);
      return hairpin_stack;
    }
  else
    return NULL;
}

void
draw_hairpin (GdkPixmap * pixmap, GdkGC * gc, GSList ** hairpin_stack,
	      gint x2, gint y, gint dir)
{
  gint x1 = top_hairpin_stack (*hairpin_stack);
    			          
  if (x1 > -1)
    {
      *hairpin_stack = pop_hairpin_stack (*hairpin_stack);
      if (x1 == x2)
	x2 += 5;
      if (dir)
	{
	  gdk_draw_line (pixmap, gc, x1, y - 15, x2, y - 20);
	  gdk_draw_line (pixmap, gc, x1, y - 15, x2, y - 10);
	}
      else
	{
	  gdk_draw_line (pixmap, gc, x1, y - 20, x2, y - 15);
	  gdk_draw_line (pixmap, gc, x1, y - 10, x2, y - 15);
	}
    }
}
