/*importmidi.cpp
 * midi file import functions
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2003-2005 AJAnderson
 *
 */

#include <denemo/denemo.h>
#include "importmidi.h"
#include "utils.h"
#include "commandfuncs.h"
#include "objops.h"
#include "measureops.h"
#include "chordops.h"
#include "scoreops.h"
#include "staffops.h"
#include "contexts.h"
#include "dialogs.h"
#include "processstaffname.h"
#include "moveviewport.h"
#include <stdlib.h>
#include <math.h>
#include <string.h>
int PPQN;
struct scoreinfo *si2;
GList *notestack = NULL;
int bartime;
int barlength;
int lastoff = 0;
int trackplus = 0;
int breaker = 0;

gint
importMidi (gchar * filename, struct scoreinfo *si)
{
  gint ret = 0;			// (-1 on failure)
  int data = 0;
  FILE *fp = 0;
  int tracks = 0;

  lastoff = 0;
  trackplus = 0;
  breaker = 0;

  si2 = si;
  /*free_score (si2);
     si2->currentstaffnum = 0; */

  /*go easy, start with monophonic files */

  if (fopen (filename, "r") != 0)
    fp = fopen (filename, "r");

  /*scan to first track */
  while (1)
    {
      data = readBytes (fp, 1);
      if (data == 0x4d)
	{
	  data = readBytes (fp, 3);
	  if (data == 0x546864)
	    {
	      tracks = readheader (fp);
	    };
	  if (data == 0x54726b)
	    {
	      printf ("\nReading Track");
	      if (breaker == 0)
		{
		  readtrack (fp);
		}
	      tracks--;
	    };
	};
      if (tracks == 0)
	break;
    };

  fclose (fp);
  gtk_widget_draw (si2->scorearea, NULL);

  ret = 1;
  return ret;
}

int
readVariable (FILE * fp)
{
  /*so all are 7bit numbers, and all have bit 8 high except the last */
  int total = 0;
  int last = 0;
  do
    {
      last = fgetc (fp);
      total = (total << 7) + (last & 0x7f);
    }
  while ((last >> 7) != 0);
  return total;
}

int
readBytes (FILE * fp, int numb)
{
  int read = 0;
  while (numb > 0)
    {
      read = (read << 8) + (int) fgetc (fp);
      numb--;
    }
  return read;
}

int
readheader (FILE * fp)
{
  int discard;
  printf ("\nHeader length confirmed as %d Bytes", readBytes (fp, 4));
  printf ("\nMidi format is %d", readBytes (fp, 2));
  discard = readBytes (fp, 2);
  printf ("\nNo. of Tracks is %d", discard);
  PPQN = readBytes (fp, 2);
  printf ("\nPPQN is %d", PPQN);
  return discard;
}


void
readtrack (FILE * fp)
{
  int stat;
  int data1;
  int data2;
  int tlength;
  int time = 0;			/*track time */
  int dtime;			/*delta time, distance to next event */
  int event = 0;
  FILE *scanner;
  //staff *thestaffstruct;
  //measurenode *themeasures = NULL;      /* Initial set of measures in staff */
  //gint numstaffs = g_list_length (si2->thescore);
  //gint i, n, addat=1;

  tlength = readBytes (fp, 4);
  scanner = fp;

  /*if(trackplus !=0)
     {


     thestaffstruct = (staff *)g_malloc (sizeof (staff));
     n = g_list_length (firstmeasurenode (si2->currentstaff));
     thestaffstruct->sclef = ((staff *)si2->currentstaff)->sclef;
     thestaffstruct->skey = ((staff *)si2->currentstaff)->skey;
     thestaffstruct->skey_isminor = ((staff *)si2->currentstaff)->skey_isminor;
     memcpy (thestaffstruct->skeyaccs, ((staff *)si2->currentstaff)->skeyaccs, SEVENGINTS);
     thestaffstruct->stime1 = ((staff *)si2->currentstaff)->stime1;
     thestaffstruct->stime2 = ((staff *)si2->currentstaff)->stime2;
     thestaffstruct->no_of_lines = 5;
     thestaffstruct->transposition = 0;
     thestaffstruct->pos_in_half_lines = 0;
     thestaffstruct->space_above = 0;
     thestaffstruct->space_below = 0;

     thestaffstruct->voicenumber = 1;


     for (i = 0; i < n; i++)
     {
     themeasures = g_list_append (themeasures, NULL);
     };


     thestaffstruct->measures = themeasures;
     thestaffstruct->denemo_name = g_string_new (NULL);
     thestaffstruct->lily_name = g_string_new (NULL);
     g_string_sprintf (thestaffstruct->denemo_name, _("staff %d"),
     numstaffs + 1);
     set_lily_name (thestaffstruct->denemo_name, thestaffstruct->lily_name);

     thestaffstruct->midi_instrument = g_string_new ("acoustic grand");

     addat = si2->currentstaffnum + 1;  

     si2->thescore = g_list_insert (si2->thescore, thestaffstruct, addat - 1);
     si2->currentstaff = g_list_nth (si2->thescore, si2->currentstaffnum - 1);
     setcurrentprimarystaff (si2);
     find_leftmost_staffcontext (thestaffstruct, si2);


     //staff_properties_change (si2, addat, NULL);
     set_bottom_staff (si2);      
     update_vscrollbar (si2);

     }   */

  while (tlength != 0)
    {
      dtime = readVariable (fp);
      time = time + dtime;
      tlength--;
      if (dtime > 127)
	tlength--;		/* 2 digit variable */
      if (dtime > 16383)
	tlength--;		/*  3 digit variable */
      if (dtime > 2097151)
	tlength--;		/*  3 digit variable */
      /* leap of faith, all channels in track ar same */
      stat = readBytes (fp, 1);
      tlength--;
      if (stat == 0xff)
	{
	  /*next Byte is command */
	  data1 = readBytes (fp, 1);
	  //printf("\nMeta %d",data1);
	  /*next Byte is length */
	  data2 = readBytes (fp, 1);
	  //printf("\nLength %d",data2);
	  /*pretend to read it */
	  switch (data1)
	    {
	    case 88:
	      {
		/*time signature */
		dotimesig (fp);
		tlength = tlength - 6;
		break;
	      }
	    case 89:
	      {
		/*key signature */
		dokeysig (fp);
		tlength = tlength - 4;
		break;
	      }
	    default:
	      {
		/*read off surplus */
		data1 = readBytes (fp, data2);
		tlength = tlength - (data2 + 2);
		break;
	      }
	    }
	}
      else
	{
	  if (stat < 128)
	    {
	      /*running status event is same as before */
	      data1 = stat;
	    }
	  else
	    {
	      event = stat;
	      data1 = readBytes (fp, 1);
	      tlength--;
	    };

	  //printf("\nEvent %d",event);

	  switch (event >> 4)
	    {
	    case 8:		/*note off */
	      {
		data2 = readBytes (fp, 1);
		tlength--;
		donoteoff (data1, time);
		break;
	      }
	    case 9:		/*note on */
	      {
		breaker = 1;
		data2 = readBytes (fp, 1);
		tlength--;
		donoteon (data1, data2, time);
		break;
	      }
	    default:
	      {
		data2 = readBytes (fp, 1);
		tlength--;
		//printf("\nMidi event %d, data1 %d data2 %d", event, data1, data2);
		break;
	      }
	    case 11:		/*midi  controller eg. volume, pan */
	      {
		data2 = readBytes (fp, 1);
		//printf("\nMIDI Controller %d, value %d",data1,data2);
		tlength--;
		break;
	      }
	    case 12:		/*change instrument, ignore */
	      {
		//printf("\nChange to Instrument% d",data1);
		break;
	      }

	    };
	}
    }
  trackplus++;
}

void
dotimesig (FILE * fp)
{
  /*only does initial TS */
  staff *curstaffstruct = (staff *) si2->currentstaff->data;

  curstaffstruct->stime1 = readBytes (fp, 1);
  curstaffstruct->stime2 = (gint) pow (2, (readBytes (fp, 1)));

  si2->haschanged = TRUE;

  barlength = PPQN * 4 * curstaffstruct->stime1 / curstaffstruct->stime2;

  readBytes (fp, 2);		/*skip last two characters */
}

void
dokeysig (FILE * fp)
{
  /*assume major */
  int key = 0;
  key = readBytes (fp, 1);	/*read in sharps */
  if (key == 0)
    {
      key = 0 - (readBytes (fp, 1));	/*get flat key num, see keysigdialog.cpp */
    }
  else
    {
      readBytes (fp, 1);
      key = key;
    }


  staff *curstaffstruct = (staff *) si2->currentstaff->data;
  curstaffstruct->skey = key;
  curstaffstruct->skey_isminor = 0;
  initkeyaccs (curstaffstruct->skeyaccs, key);

  si2->haschanged = TRUE;
}

void
donoteon (int pitchon, int attack, int timeon)
{
  if (attack == 0)
    {
      donoteoff (pitchon, timeon);
    }
  else
    {
      /* add a note to the stack */
      stacknote *addon = new stacknote (pitchon, timeon);
      notestack = g_list_append (notestack, addon);
    }
}

void
donoteoff (int pitchoff, int timeoff)
{
  int duration = 0;
  int starttime = 0;
  int rest = 0;


  /*find corresponding pitch on stack */
  GList *pulloff =
    g_list_find_custom (notestack, GINT_TO_POINTER ((gint) pitchoff),
			comparenote);
  /*make  a note */

  /*check for rests */
  starttime = (((stacknote *) pulloff->data)->time);
  if (starttime != lastoff)
    {
      /*add a rest before note */
      rest = starttime - lastoff;
      addnote (200, rest, 0);
      lastoff = starttime;
    }

  duration = timeoff - starttime;
  addnote (pitchoff, duration, 0);

  /*delete pointer */
  notestack = g_list_remove (notestack, pulloff);
  delete ((stacknote *) pulloff->data);
  lastoff = timeoff;
}

gint
comparenote (gconstpointer a, gconstpointer b)
{
  stacknote *checknote = (stacknote *) a;
  int checkpitch = GPOINTER_TO_INT (b);

  if (checknote->pitch == checkpitch)
    {
      return 0;
    }				/* Identical */
  else
    {
      return 1;
    }				/* Not identical */
}


void
addnote (int pitchadd, int endnote, int notie)
{
  mudelaobject *mudela_obj_new;
  int leftover = 0;
  int dotted = 0;
  int tied = 0;
  int dsq = 0;
  int notetype = 2;
  enharmonic enote = enharmonic (0);

  if (notie == 0)
    {
      if (bartime >= barlength)	/*(bartime == barlength) not entirely functional */
	{
	  if (!si2->currentmeasure->next)
	    /* Add a measure and make it currentmeasure */
	    si2->currentmeasure =
	      addmeasures (si2, si2->currentmeasurenum, 1);
	  else
	    si2->currentmeasure = si2->currentmeasure->next;
	  /* Now the stuff that needs to be done for each case */
	  si2->currentmeasurenum++;
	  si2->currentobject = NULL;
	  si2->cursor_x = 0;
	  memcpy (si2->cursoraccs, si2->nextmeasureaccs, SEVENGINTS);
	  memcpy (si2->curmeasureaccs, si2->nextmeasureaccs, SEVENGINTS);
	  si2->curmeasureclef = si2->cursorclef;
	  bartime = 0;
	}

      bartime = bartime + endnote;
      if (bartime > barlength)
	{
	  leftover = bartime - barlength;	/*tied over bar line */
	  endnote = endnote - leftover;
	}
    }

  /*convert length to 2 = crotchet, 3 = quaver etc...... */
  dsq = (8 * endnote) / PPQN;
  switch (dsq)
    {
    case 1:			/*demi-semi-quaver */
      {
	notetype = 5;
	break;
      }
    case 2:			/*semi-quaver */
      {
	notetype = 4;
	break;
      }
    case 3:			/*dotted semi-quaver */
      {
	notetype = 4;
	tied = PPQN / 8;
	break;
      }
    case 4:			/*quaver */
      {
	notetype = 3;
	break;
      }
    case 5:			/*quaver tied demi */
      {
	notetype = 3;
	tied = PPQN / 8;
	break;
      }
    case 6:			/*quaver */
      {
	notetype = 3;
	tied = PPQN / 4;
	break;
      }
    case 7:			/*quaver */
      {
	notetype = 3;
	tied = 3 * PPQN / 8;
	break;
      }
    case 8:			/*crotchet */
      {
	notetype = 2;
	break;
      }
    case 9:			/*crotchet */
      {
	notetype = 2;
	tied = PPQN / 8;
	break;
      }
    case 10:			/*crotchet */
      {
	notetype = 2;
	tied = PPQN / 4;
	break;
      }
    case 11:			/*crotchet */
      {
	notetype = 2;
	tied = PPQN * 3 / 8;
	break;
      }
    case 12:			/*crotchet */
      {
	notetype = 2;
	tied = PPQN / 2;
	break;
      }
    case 13:			/*crotchet */
      {
	notetype = 2;
	tied = 5 * PPQN / 8;
	break;
      }
    case 14:			/*crotchet */
      {
	notetype = 2;
	tied = 3 * PPQN / 4;
	break;
      }
    case 15:			/*crotchet */
      {
	notetype = 2;
	tied = 7 * PPQN / 8;
	break;
      }
    case 16:			/*minim */
      {
	notetype = 1;
	break;
      }
    case 30:
      {
	notetype = 1;
	tied = 7 * PPQN / 4;
	break;
      }
    case 32:			/*semi-breve */
      {
	notetype = 0;
	break;
      }
      /*default:
         {
         notetype = 2;
         tied = endnote - PPQN;
         break;
         }  */
    }



  /* Now actually create the chord */
  mudela_obj_new = newchord (notetype, 0);
  if (pitchadd != 200)
    {
      enote = enharmonic (pitchadd);
      addtone (mudela_obj_new, enote.pitch, enote.enshift, si2->cursorclef);
      //si2->mode = INPUTNORMAL;
    }
  else
    {
      si2->mode = INPUTREST;
    }

  object_insert (si2, mudela_obj_new);



  if (dotted != 0)
    {
      /*add dots */
    }

  if (tied != 0)
    {
      addnote (pitchadd, tied, 1);
    }


  if (leftover != 0)		/*notes tied over bar-line */
    {
      addnote (pitchadd, leftover, 0);
    };
}


enharmonic::enharmonic (int input)
{
  pitch = (input / 12) - 5;
  enshift = input % 12;
  switch (enshift)
    {
    case 0:
      {
	pitch = pitch * 7;
	enshift = 0;
	break;
      }
    case 1:
      {
	pitch = pitch * 7;
	enshift = 1;
	break;
      }
    case 2:
      {
	pitch = 1 + pitch * 7;
	enshift = 0;
	break;
      }
    case 3:
      {
	pitch = 2 + pitch * 7;
	enshift = -1;
	break;
      }
    case 4:
      {
	pitch = 2 + pitch * 7;
	enshift = 0;
	break;
      }
    case 5:
      {
	pitch = 3 + pitch * 7;
	enshift = 0;
	break;
      }
    case 6:
      {
	pitch = 3 + pitch * 7;
	enshift = 1;
	break;
      }
    case 7:
      {
	pitch = 4 + pitch * 7;
	enshift = 0;
	break;
      }
    case 8:
      {
	pitch = 5 + pitch * 7;
	enshift = -1;
	break;
      }
    case 9:
      {
	pitch = 5 + pitch * 7;
	enshift = 0;
	break;
      }
    case 10:
      {
	pitch = 6 + pitch * 7;
	enshift = -1;
	break;
      }
    case 11:
      {
	pitch = 6 + pitch * 7;
	enshift = 0;
	break;
      }
    };
}
