/* objops.cpp
 * functions that do operations to mudela objects
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999-2005 Matthew Hiller
 */

#include <denemo/denemo.h>
#include "chordops.h"
#include "utils.h"
#include <string.h>

void
freeobject (mudelaobject * mudobj)
{
  if (mudobj)
    switch (mudobj->type)
      {
      case CHORD:
	freechord (mudobj);	/* Which also frees mudobj itself */
	break;
      default:
	g_free (mudobj);
	break;
      }
}

mudelaobject *
newtimesigobj (gint time1, gint time2)
{
  mudelaobject *ret;
  timesig *newtimesig = (timesig *) g_malloc (sizeof (timesig));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = TIMESIG;
  newtimesig->time1 = time1;
  newtimesig->time2 = time2;
  ret->object = newtimesig;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

mudelaobject *
newclefobj (enum clefs type)
{
  mudelaobject *ret;
  clef *newclef = (clef *) g_malloc (sizeof (clef));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = CLEF;
  ret->isinvisible = FALSE;
  newclef->type = type;
  ret->object = newclef;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

/* This function initializes the accidental-context array associated with
 * a key signature or a staff to that appropriate for _number_ */

void
initkeyaccs (gint * accs, gint number)
{
  int index;

  memset (accs, 0, SEVENGINTS);
  if (number > 0)
    for (index = 3; number; number--, index = (index + 4) % 7)
      accs[index] = 1;
  else if (number < 0)
    for (index = 6; number; number++, index = (index + 3) % 7)
      accs[index] = -1;
}

mudelaobject *
newkeyobj (gint number, gboolean isminor)
{
  mudelaobject *ret;
  keysig *newkeysig = (keysig *) g_malloc (sizeof (keysig));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = KEYSIG;
  ret->isinvisible = FALSE;
  newkeysig->number = number;
  newkeysig->isminor = isminor;
  initkeyaccs (newkeysig->accs, number);

  ret->object = newkeysig;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

mudelaobject *
newmeasurebreakobject ()
{
  mudelaobject *ret;

  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = MEASUREBREAK;
  return ret;
}

mudelaobject *
clone_object (mudelaobject * orig)
{
  mudelaobject *ret;

  switch (orig->type)
    {
    case CHORD:
      ret = clone_chord (orig);
      break;
    default:
      ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
      memcpy (ret, orig, sizeof (mudelaobject));
      break;
    }
  return ret;
}

mudelaobject *
stem_directive_new (enum stemdirections type)
{
  mudelaobject *ret;
  stemdirective *newstemdir =
    (stemdirective *) g_malloc (sizeof (stemdirective));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = STEMDIRECTIVE;
  ret->isinvisible = FALSE;
  newstemdir->type = type;
  ret->object = newstemdir;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

mudelaobject *
lily_directive_new (gchar * type)
{
  mudelaobject *ret;
  lilydirective *newlily =
    (lilydirective *) g_malloc (sizeof (lilydirective));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = LILYDIRECTIVE;
  newlily->directive = g_string_new (type);
  ret->object = newlily;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

mudelaobject *
dynamic_new (gchar * type)
{
  mudelaobject *ret;
  dynamic *newdyn = (dynamic *) g_malloc (sizeof (dynamic));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = DYNAMIC;
  ret->isinvisible = FALSE;
  newdyn->type = g_string_new (type);
  ret->object = newdyn;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}


mudelaobject *
lyric_new (gchar * type, gint position, gboolean syllable)
{
  mudelaobject *ret;
  lyric *newlyric = (lyric *) g_malloc (sizeof (lyric));
  ret = (mudelaobject *) g_malloc (sizeof (mudelaobject));
  ret->type = LYRIC;
  ret->isinvisible = FALSE;


  newlyric->lyrics = g_string_new (type);
  newlyric->position = position;
  newlyric->is_syllable = syllable;
  ret->object = newlyric;
  set_basic_numticks (ret);
  setpixelmin (ret);
  return ret;
}

mudelaobject *
newobj (enum objtype type)
{
  mudelaobject *ret = (mudelaobject *) g_malloc0 (sizeof (mudelaobject));;
  ret->type = type;
  set_basic_numticks (ret);
  setpixelmin (ret);		/* these do nothing at present - but if we introduce
				   a show markers option then we will want to allot some space
				 */
  return ret;
}
