"""Tests for Desktop CouchDB"""

import os, tempfile, atexit, shutil
from desktopcouch import read_pidfile
from desktopcouch.start_local_couchdb import start_couchdb
from desktopcouch.stop_local_couchdb import stop_couchdb
from desktopcouch import local_files

import gobject
gobject.set_application_name("desktopcouch testing")

import gnomekeyring


class TestSecret(object):

    def __init__(self, secret):
        self.secret = secret


class TestKeyring(object):
    """A gnomekeyring replacement that isolates us from the users keyring."""

    def __init__(self, appear_absent=False):
        self.appear_absent = appear_absent
        self.items = {}

    def _get_key(self, attributes):
        return "".join([str(a) for a in sorted(attributes.items())])

    def find_items_sync(self, type, attributes):
        key = self._get_key(attributes)
        if type in self.items and key in self.items[type]:
            return [TestSecret(self.items[type][key])]
        raise gnomekeyring.NoMatchError

    def item_create_sync(self, keyring, type, display_name, attributes, secret,
            update_if_exists):
        assert keyring is None, "Mock not coded to have multiple keyrings"
        assert update_if_exists is True, "Mock not coded to create duplicate items"
        if self.appear_absent:
            raise gnomekeyring.NoKeyringDaemonError
        self.items.setdefault(type, {})
        key = self._get_key(attributes)
        self.items[type][key] = secret
        return "Mock keyring doesn't have item ids"


def create_new_test_environment():

    basedir = tempfile.mkdtemp()
    if not os.path.exists(basedir):
        os.mkdir(basedir)

    cache = os.path.join(basedir, 'cache')
    data = os.path.join(basedir, 'data')
    config = os.path.join(basedir, 'config')
    new_context = local_files.Context(cache, data, config, keyring=TestKeyring())
    new_context.couchdb_log_level = 'debug'

    # Add etc folder to config
    SOURCE_TREE_ETC_FOLDER = os.path.realpath(
      os.path.join(os.path.split(__file__)[0], "..", "..", "config")
    )
    if os.path.isdir(SOURCE_TREE_ETC_FOLDER):
        os.environ["XDG_CONFIG_DIRS"] = SOURCE_TREE_ETC_FOLDER

    def stop_test_couch(temp_dir, ctx):
        stop_couchdb(ctx)
        shutil.rmtree(temp_dir)

    start_couchdb(ctx=new_context)
    atexit.register(stop_test_couch, basedir, new_context)

    return new_context


# TODO: Remove these after you're sure nothing we care about uses these env.
os.environ['XDG_CACHE_HOME'] = "/cachehome"
os.environ['XDG_DATA_HOME'] = "/datahome"
os.environ['XDG_CONFIG_HOME'] = "/confighome"
os.environ['XDG_DATA_DIRS'] = ''

test_context = create_new_test_environment()
