/*
   (c) Copyright 2000-2002  convergence integrated media GmbH.
   (c) Copyright 2002-2005  convergence GmbH.

   All rights reserved.

   Written by Denis Oliver Kropp <dok@directfb.org>,
              Andreas Hundt <andi@fischlustig.de>,
              Sven Neumann <neo@directfb.org>,
              Ville Syrjl <syrjala@sci.fi> and
              Claudio Ciccani <klan@users.sf.net>.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __NVIDIA_H__
#define __NVIDIA_H__

#include <dfb_types.h>

#include <core/state.h>
#include <core/screens.h>
#include <core/layers.h>

#include "nvidia_regs.h"


/*
 * Objects' Identifiers
 */
enum {
     OBJ_DMA            = 0x00800000,
     OBJ_SURFACES2D     = 0x00800001,
     OBJ_SURFACES3D     = 0x00800002,
     OBJ_CLIP           = 0x00800003,
     OBJ_BETA1          = 0x00800004,
     OBJ_BETA4          = 0x00800005,
     OBJ_RECTANGLE      = 0x00800010,
     OBJ_TRIANGLE       = 0x00800011,
     OBJ_LINE           = 0x00800012,
     OBJ_SCREENBLT      = 0x00800013,
     OBJ_IMAGEBLT       = 0x00800014,
     OBJ_SCALEDIMAGE    = 0x00800015,
     OBJ_STRETCHEDIMAGE = 0x00800016,
     OBJ_TEXTRIANGLE    = 0x00800017
};

/*
 * Objects' offsets into context table [PRAMIN + (address)*16]
 */
enum {
     ADDR_DMA            = 0x1160,
     ADDR_SURFACES2D     = 0x1162,
     ADDR_SURFACES3D     = 0x1163,
     ADDR_CLIP           = 0x1164,
     ADDR_BETA1          = 0x1165,
     ADDR_BETA4          = 0x1166,
     ADDR_RECTANGLE      = 0x1167,
     ADDR_TRIANGLE       = 0x1168,
     ADDR_LINE           = 0x1169,
     ADDR_SCREENBLT      = 0x116A,
     ADDR_IMAGEBLT       = 0x116B,
     ADDR_SCALEDIMAGE    = 0x116C,
     ADDR_STRETCHEDIMAGE = 0x116D,
     ADDR_TEXTRIANGLE    = 0x116E
};

#define SMF_DRAWING_COLOR  (SMF_COLOR << 16)
#define SMF_BLITTING_COLOR (SMF_COLOR << 17)
#define SMF_SOURCE_TEXTURE (SMF_SOURCE << 1) 

typedef struct {
     StateModificationFlags  set;
     
     __u32                   fb_offset;
     __u32                   fb_size;
     __u32                   fb_mask;
     
     DFBSurfacePixelFormat   dst_format;
     __u32                   dst_offset;
     __u32                   dst_pitch;
     bool                    dst_422;

     DFBSurfacePixelFormat   src_format;
     __u32                   src_offset;
     __u8                   *src_address;
     __u32                   src_pitch;
     __u32                   src_width;
     __u32                   src_height;
     bool                    src_system;
     bool                    src_interlaced;

     DFBRectangle            clip;

     __u32                   color2d;
     __u32                   color3d;
     
     DFBSurfaceDrawingFlags  drawingflags;
     DFBSurfaceBlittingFlags blittingflags;
     
     /* NVRectangle/NVTriangle/NVLine registers */
     __u32                   drawing_operation; // SetOperation
     
     /* NVScaledImage registers */
     __u32                   scaler_operation;  // SetOperation
     __u32                   scaler_format;     // SetColorFormat
     __u32                   scaler_filter;     // SetImageInFormat
     
     /* NVImageBlt/NVStretchedImage registers */
     __u32                   system_operation;  // SetOperation
     __u32                   system_format;     // SetColorFormat

     /* Remember value of NVBeta1 & NVBeta4 */
     bool                    beta1_set;
     __u32                   beta1_val;
     bool                    beta4_set;
     __u32                   beta4_val;

     /* 3D stuff */
     bool                    enabled_3d;       // 3d engine enabled
     __u32                   buf_offset[2];    // reserved buffers
     SurfaceBuffer          *src_texture;      // current source for TextureTriangles
     __u32                   max_texture_size;
     
     struct {
          bool               modified;
          __u32              colorkey;
          __u32              offset;
          __u32              format;
          __u32              filter;
          __u32              blend;
          __u32              control;
          __u32              fog;
     } state3d[2]; // 0 => drawing | 1 => blitting

     /* Remember subchannels configuration */
     __u32                   subchannel_object[8];
     
     /* Chipsets informations */
     __u32                   chip;
     __u32                   arch;

     /* for fifo/performance monitoring */
     unsigned int            fifo_space;
     unsigned int            waitfifo_sum;
     unsigned int            waitfifo_calls;
     unsigned int            fifo_waitcycles;
     unsigned int            idle_waitcycles;
     unsigned int            fifo_cache_hits;
} NVidiaDeviceData;


enum {
     NV_ARCH_04 = 0x04,
     NV_ARCH_05 = 0x05,
     NV_ARCH_10 = 0x10,
     NV_ARCH_20 = 0x20,
     NV_ARCH_30 = 0x30
};

typedef struct {
     GraphicsDevice         *device;
     NVidiaDeviceData       *device_data;

     volatile __u8          *mmio_base;
     NVFifoChannel          *Fifo;
     
     NVSurfaces2D           *Surfaces2D;
     NVSurfaces3D           *Surfaces3D;
     NVClip                 *Clip;
     NVBeta1                *Beta1;
     NVBeta4                *Beta4;
     NVRectangle            *Rectangle;
     NVTriangle             *Triangle;
     NVLine                 *Line;
     NVScreenBlt            *ScreenBlt;
     NVImageBlt             *ImageBlt;
     NVScaledImage          *ScaledImage;
     NVStretchedImage       *StretchedImage;
     NVTexturedTriangleDx5  *TexTriangle;
} NVidiaDriverData;


extern ScreenFuncs        nvidiaPrimaryScreenFuncs;
extern ScreenFuncs        OldPrimaryScreenFuncs;
extern void              *OldPrimaryScreenDriverData;

extern DisplayLayerFuncs  nvidiaPrimaryLayerFuncs;
extern DisplayLayerFuncs  OldPrimaryLayerFuncs;
extern void              *OldPrimaryLayerDriverData;

extern DisplayLayerFuncs  nvidiaOverlayFuncs;


#endif /* __NVIDIA_H__ */
