from ctypes import *

# some fundamental datatypes 
RRCrtc = c_long
RROutput = c_long
RRMode = c_long
Connection = c_ushort
SubpixelOrder = c_ushort
Time = c_ulong
Rotation = c_ushort
Status = c_int

# load the libs
xlib = cdll.LoadLibrary("libX11.so")
rr = cdll.LoadLibrary("libXrandr.so")

# open display
dpy = xlib.XOpenDisplay(":0")

# quety ext
a = c_int()
b = c_int()
res = rr.XRRQueryExtension(dpy, byref(a), byref(b))
print "Has ext: ", res

# check version
major = c_int()
minor = c_int()
res = rr.XRRQueryVersion(dpy, byref(major), byref(minor))
print "Sucess:",res, "  major:",major, "  minor:",minor

# get screen range
screen = xlib.XDefaultScreen(dpy)
win = xlib.XDefaultRootWindow(dpy, screen)
minWidth = c_int()
minHeight = c_int()
maxWidth = c_int()
maxHeight = c_int()
rr.XRRGetScreenSizeRange(dpy, win, byref(minWidth), byref(minHeight),
                         byref(maxWidth), byref(maxHeight))
print "minW: ", minWidth
print "minH: ", minHeight
print "maxW: ", maxWidth
print "maxH: ", maxHeight

# query resources

class XRRModeInfo(Structure):
    _fields_ = [
    	("id", RRMode), # XID is c_long
    	("width", c_int),
    	("height", c_int),
    	("dotClock", c_long),
    	("hSyncStart", c_int),
    	("hSyncEnd", c_int),
    	("hTotal", c_int),
    	("hSkew", c_int),
    	("vSyncStart", c_int),
    	("vSyncEnd", c_int),
    	("vTotal", c_int),
    	("name", c_char_p),
    	("nameLength", c_int),
    	("modeFlags", c_long),
]
    
class XRRScreenResources(Structure):
    _fields_ = [
        ("timestamp", Time),
        ("configTimestamp", Time),
        ("ncrtc", c_int),
        ("crtcs", POINTER(RRCrtc*100)),
        ("noutput", c_int),
        ("outputs", POINTER(RROutput*100)),
        ("nmode", c_int),
        ("modes", POINTER(XRRModeInfo*100)), # number needs just to be big
]

# XRRGetScreenResources
gsr = rr.XRRGetScreenResources
gsr.restype = POINTER(XRRScreenResources)
rp = gsr(dpy, win)
print "nr crts: ",rp.contents.ncrtc
print "nr modes: ", rp.contents.nmode

#print sizeof(XRRScreenResources)
print "modes:" 
for i in range(rp.contents.nmode):
    #print rp.contents.modes.contents[i]
    print rp.contents.modes.contents[i].name
    print rp.contents.modes.contents[i].width
    print rp.contents.modes.contents[i].height
    print

# XRRGetScreenInfo should not be used acording to the
# c-header but I get a undefined symbol error when using XRRScreenConfig
class XRRScreenConfiguration(Structure):
    " private to Xrandr "
    pass

gsi = rr.XRRGetScreenInfo
gsi.restype = POINTER(XRRScreenConfiguration)
xrrscreenconfiguration = gsi(dpy, win)
#print xrrscreenconfiguration
rr.XRRFreeScreenConfigInfo(xrrscreenconfiguration)

rate = rr.XRRConfigCurrentRate(xrrscreenconfiguration)
print "Current refresh rate: ",rate

# XRRRootToScreen
screen = rr.XRRRootToScreen(dpy, win)
print "Root window is on screen: ", screen

# XRRGetOutputInfo
class XRROutputInfo(Structure):
    _fields_ = [
        ("timestamp", Time),
        ("crtc", RRCrtc),
        ("name", c_char_p),
        ("nameLen", c_int),
        ("mm_width", c_ulong),
        ("mm_height", c_ulong),
        ("connection", Connection),
        ("subpixel_order", SubpixelOrder),
        ("ncrtc", c_int),
        ("crtcs", POINTER(RRCrtc*100)),
        ("nclone", c_int),
        ("clones", POINTER(RROutput*100)),
        ("nmode", c_int),
        ("npreferred", c_int),
        ("modes", POINTER(RRMode*100))
    ]

print
print "Calling XRRGetOutputInfo for available outputs:"
for i in range(rp.contents.ncrtc):
    goi = rr.XRRGetOutputInfo
    goi.restype = POINTER(XRROutputInfo)
    xrroutputinfo = goi(dpy, rp, rp.contents.outputs.contents[i])
    print "outputinfo name: ", xrroutputinfo.contents.name
    print "outputinfo width/height: ", xrroutputinfo.contents.mm_width, xrroutputinfo.contents.mm_height
    for i in range(xrroutputinfo.contents.nmode):
        for j in range(rp.contents.nmode):
            if rp.contents.modes.contents[j].id == xrroutputinfo.contents.modes.contents[i]:
                mode_refresh = rp.contents.modes.contents[j].dotClock / (rp.contents.modes.contents[j].hTotal * rp.contents.modes.contents[j].vTotal)
                print "Output mode: ", rp.contents.modes.contents[j].name, mode_refresh,
                if xrroutputinfo.contents.npreferred == j:
                    print " (preferred)"
                else:
                    print
    rr.XRRFreeOutputInfo(xrroutputinfo)


#FIXME: make this work somehow, the screen size changes
#       with the resolution
#print
#fb_width = 800
#fb_height = 600
#dpi = 25.4 * rr.XDisplayHeight (dpy, screen) / rr.XDisplayHeightMM(dpy, screen)
#fb_width_mm = 25.4 * fb_width / dpi
#fb_height_mm = 25.4 * fb_height /dpi
#print "dpi: ",dpi
#print "new width: ", fb_width
#print "new height: ", fb_height
#print "fb_width_mm: ",fb_width_mm
#print "fb_height_mm: ",fb_height_mm
#rr.XRRSetScreenSize(dpy, win, int(fb_width_mm), int(fb_height_mm))


# misc
print
config_timestamp = Time()
timestamp = rr.XRRTimes(dpy, screen, byref(config_timestamp))
print "current config_timestamp: ", config_timestamp

current_rotation = Rotation()
rotation = rr.XRRRotations(dpy, screen, byref(current_rotation))
print "current rotation: ", current_rotation

# XRRScreensize
class XRRScreenSize(Structure):
    _fields_ = [
        ("width", c_int),
        ("height", c_int),
        ("mwidth", c_int),
        ("mheight", c_int)
    ]

nsizes = c_int()
xrs = rr.XRRSizes
xrs.restype = POINTER(XRRScreenSize*100)
screensizes = xrs(dpy, screen, byref(nsizes))
print "XRRScreenSize: ", nsizes
# no idea why this is needed, but when I use nsizes.value in range() it crashes
the_sizes = nsizes.value
for i in range(the_sizes):
    print "%s: %s x %s (%s x %s) " % (i, screensizes.contents[i].width,
                                  screensizes.contents[i].height,
                                  screensizes.contents[i].mwidth,
                                  screensizes.contents[i].mheight)


# SetScreenConfigAndRate
size_index = 0
status = rr.XRRSetScreenConfigAndRate(dpy, xrrscreenconfiguration, win,
                                      size_index, rotation, rate, timestamp)
print status
