/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Extensions;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.ColumnScanEmitter;
import com.nwalsh.saxon.ColumnUpdateEmitter;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;

public class Table {
    private static int pixelsPerInch = 96;
    private static int nominalWidth = 6 * pixelsPerInch;
    private static String tableWidth = "100%";
    private static boolean foStylesheet = false;
    protected static Hashtable unitHash = null;

    protected static void initializeHash() {
        unitHash = new Hashtable();
        unitHash.put("in", new Float(pixelsPerInch));
        unitHash.put("cm", new Float((double)pixelsPerInch / 2.54));
        unitHash.put("mm", new Float((double)pixelsPerInch / 25.4));
        unitHash.put("pc", new Float(pixelsPerInch / 72 * 12));
        unitHash.put("pt", new Float(pixelsPerInch / 72));
        unitHash.put("px", new Float(1.0f));
    }

    public static void setPixelsPerInch(int value) {
        if (value > 0) {
            pixelsPerInch = value;
            Table.initializeHash();
        }
    }

    public int getPixelsPerInch() {
        return pixelsPerInch;
    }

    public static int convertLength(String length) {
        int sign = 1;
        String digits = "";
        String units = "";
        char[] lench = length.toCharArray();
        float flength = 0.0f;
        boolean done = false;
        int pos = 0;
        float factor = 1.0f;
        int pixels = 0;
        if (unitHash == null) {
            Table.initializeHash();
        }
        if (lench[pos] == '+' || lench[pos] == '-') {
            if (lench[pos] == '-') {
                sign = -1;
            }
            ++pos;
        }
        while (!done) {
            if (pos >= lench.length) {
                done = true;
                continue;
            }
            if ((lench[pos] > '9' || lench[pos] < '0') && lench[pos] != '.') {
                done = true;
                units = length.substring(pos);
                continue;
            }
            digits = digits + lench[pos++];
        }
        try {
            flength = Float.parseFloat(digits);
        }
        catch (NumberFormatException e) {
            System.out.println(digits + " is not a number; 1 used instead.");
            flength = 1.0f;
        }
        Float f = null;
        if (!units.equals("")) {
            f = (Float)unitHash.get(units);
            if (f == null) {
                System.out.println(units + " is not a known unit; 1 used instead.");
                factor = 1.0f;
            } else {
                factor = f.floatValue();
            }
        } else {
            factor = 1.0f;
        }
        f = new Float(flength * factor);
        pixels = f.intValue() * sign;
        return pixels;
    }

    protected static String getVariable(Context context, String varName) throws TransformerException {
        Value variable = null;
        String varString = null;
        try {
            variable = Extensions.evaluate((Context)context, (String)("$" + varName));
            varString = variable.asString();
            return varString;
        }
        catch (IllegalArgumentException e) {
            System.out.println("Undefined variable: " + varName);
            return "";
        }
    }

    private static void setupColumnWidths(Context context) {
        nominalWidth = 6 * pixelsPerInch;
        tableWidth = "100%";
        String varString = null;
        try {
            varString = Table.getVariable(context, "stylesheet.result.type");
            foStylesheet = varString.equals("fo");
            varString = Table.getVariable(context, "nominal.table.width");
            nominalWidth = Table.convertLength(varString);
            tableWidth = varString = Table.getVariable(context, "table.width");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static NodeSetValue adjustColumnWidths(Context context, NodeSetValue rtf_ns) {
        FragmentValue rtf = (FragmentValue)rtf_ns;
        Table.setupColumnWidths(context);
        try {
            int count;
            int pixels;
            Controller controller = context.getController();
            NamePool namePool = controller.getNamePool();
            ColumnScanEmitter csEmitter = new ColumnScanEmitter(namePool);
            rtf.replay((Emitter)csEmitter);
            int numColumns = csEmitter.columnCount();
            String[] widths = csEmitter.columnWidths();
            float relTotal = 0.0f;
            float[] relParts = new float[numColumns];
            float absTotal = 0.0f;
            float[] absParts = new float[numColumns];
            int count2 = 0;
            while (count2 < numColumns) {
                String width = widths[count2];
                int pos = width.indexOf("*");
                if (pos >= 0) {
                    String relPart = width.substring(0, pos);
                    String absPart = width.substring(pos + 1);
                    try {
                        float rel = Float.parseFloat(relPart);
                        relTotal += rel;
                        relParts[count2] = rel;
                    }
                    catch (NumberFormatException e) {
                        System.out.println(relPart + " is not a valid relative unit.");
                    }
                    pixels = 0;
                    if (absPart != null && !absPart.equals("")) {
                        pixels = Table.convertLength(absPart);
                    }
                    absTotal += (float)pixels;
                    absParts[count2] = pixels;
                } else {
                    relParts[count2] = 0.0f;
                    int pixels2 = 0;
                    if (width != null && !width.equals("")) {
                        pixels2 = Table.convertLength(width);
                    }
                    absTotal += (float)pixels2;
                    absParts[count2] = pixels2;
                }
                ++count2;
            }
            if (relTotal == 0.0f) {
                count = 0;
                while (count < numColumns) {
                    Float f = new Float(absParts[count]);
                    if (foStylesheet) {
                        int pixels3 = f.intValue();
                        float inches = (float)pixels3 / (float)pixelsPerInch;
                        widths[count] = inches + "in";
                    } else {
                        widths[count] = Integer.toString(f.intValue());
                    }
                    ++count;
                }
            } else if (absTotal == 0.0f) {
                count = 0;
                while (count < numColumns) {
                    float rel = relParts[count] / relTotal * 100.0f;
                    Float f = new Float(rel);
                    widths[count] = Integer.toString(f.intValue());
                    ++count;
                }
                widths = Table.correctRoundingError(widths);
            } else {
                int pixelWidth = nominalWidth;
                if (tableWidth.indexOf("%") <= 0) {
                    pixelWidth = Table.convertLength(tableWidth);
                }
                if ((float)pixelWidth <= absTotal) {
                    System.out.println("Table is wider than table width.");
                } else {
                    pixelWidth = (int)((float)pixelWidth - absTotal);
                }
                absTotal = 0.0f;
                int count3 = 0;
                while (count3 < numColumns) {
                    float rel = relParts[count3] / relTotal * (float)pixelWidth;
                    relParts[count3] = rel + absParts[count3];
                    absTotal += rel + absParts[count3];
                    ++count3;
                }
                if (tableWidth.indexOf("%") <= 0) {
                    int count4 = 0;
                    while (count4 < numColumns) {
                        Float f = new Float(relParts[count4]);
                        if (foStylesheet) {
                            pixels = f.intValue();
                            float inches = (float)pixels / (float)pixelsPerInch;
                            widths[count4] = inches + "in";
                        } else {
                            widths[count4] = Integer.toString(f.intValue());
                        }
                        ++count4;
                    }
                } else {
                    int count5 = 0;
                    while (count5 < numColumns) {
                        float rel = relParts[count5] / absTotal * 100.0f;
                        Float f = new Float(rel);
                        widths[count5] = Integer.toString(f.intValue());
                        ++count5;
                    }
                    widths = Table.correctRoundingError(widths);
                }
            }
            ColumnUpdateEmitter cuEmitter = new ColumnUpdateEmitter(controller, namePool, widths);
            rtf.replay((Emitter)cuEmitter);
            return cuEmitter.getResultTreeFragment();
        }
        catch (TransformerException e) {
            System.out.println("Transformer Exception in adjustColumnWidths");
            return rtf;
        }
    }

    protected static String[] correctRoundingError(String[] widths) {
        int totalWidth = 0;
        int count = 0;
        while (count < widths.length) {
            try {
                int width = Integer.parseInt(widths[count]);
                totalWidth += width;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            ++count;
        }
        float totalError = 100 - totalWidth;
        float columnError = totalError / (float)widths.length;
        float error = 0.0f;
        int count2 = 0;
        while (count2 < widths.length) {
            try {
                int width = Integer.parseInt(widths[count2]);
                error += columnError;
                if ((double)error >= 1.0) {
                    int adj = (int)Math.round(Math.floor(error));
                    error -= (float)Math.floor(error);
                    widths[count2] = Integer.toString(width += adj) + "%";
                } else {
                    widths[count2] = Integer.toString(width) + "%";
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            ++count2;
        }
        return widths;
    }
}

