/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.xalan;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import org.apache.xalan.extensions.ExpressionContext;

public class ImageIntrinsics
implements ImageObserver {
    boolean imageLoaded = false;
    boolean imageFailed = false;
    Image image = null;
    int width = -1;
    int depth = -1;

    public ImageIntrinsics(ExpressionContext context, String imageFn) {
        this.image = Toolkit.getDefaultToolkit().getImage(imageFn);
        this.width = this.image.getWidth(this);
        while (!(this.imageFailed || this.width != -1 && this.depth != -1)) {
            try {
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.width = this.image.getWidth(this);
            this.depth = this.image.getHeight(this);
        }
        if (this.imageFailed) {
            BufferedReader ir = null;
            String line = null;
            int lineLimit = 100;
            try {
                ir = new BufferedReader(new FileReader(new File(imageFn)));
                line = ir.readLine();
                if (line != null && line.startsWith("%PDF-")) {
                    while (lineLimit > 0 && line != null) {
                        --lineLimit;
                        if (line.startsWith("/CropBox [")) {
                            if ((line = line.substring(10)).indexOf("]") >= 0) {
                                line = line.substring(0, line.indexOf("]"));
                            }
                            this.parseBox(line);
                            lineLimit = 0;
                        }
                        line = ir.readLine();
                    }
                } else if (line != null && line.startsWith("%!") && line.indexOf(" EPSF-") > 0) {
                    while (lineLimit > 0 && line != null) {
                        --lineLimit;
                        if (line.startsWith("%%BoundingBox: ")) {
                            line = line.substring(15);
                            this.parseBox(line);
                            lineLimit = 0;
                        }
                        line = ir.readLine();
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public int getWidth(ExpressionContext context, int defaultWidth) {
        if (this.width >= 0) {
            return this.width;
        }
        return defaultWidth;
    }

    public int getDepth(ExpressionContext context, int defaultDepth) {
        if (this.depth >= 0) {
            return this.depth;
        }
        return defaultDepth;
    }

    private void parseBox(String line) {
        int[] corners = new int[4];
        int count = 0;
        StringTokenizer st = new StringTokenizer(line);
        while (count < 4 && st.hasMoreTokens()) {
            try {
                corners[count++] = Integer.parseInt(st.nextToken());
            }
            catch (Exception e) {}
        }
        this.width = corners[2] - corners[0];
        this.depth = corners[3] - corners[1];
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x40) == 64) {
            this.imageFailed = true;
            return false;
        }
        int flags = 32;
        return (infoflags & flags) != flags;
    }
}

