#!/usr/bin/perl
# vim:sw=4 sta et showmatch

# docbook2X.pl - script to invoke man page, Texinfo conversion

# Copyright (C) 2003 Steve Cheng <stevecheng@users.sourceforge.net>

use strict;

# Configuration variables from config.pl
use vars qw($CONVERSION_TYPE
            $DOCBOOK2X_VERSION

            $DEFAULT_UTF8TRANS_PROGRAM
            $DEFAULT_UTF8TRANS_ROFFMAP
            $DEFAULT_ICONV_PROGRAM
            $DEFAULT_DB2X_XSLTPROC_PROGRAM
            $DEFAULT_DB2X_MANXML_PROGRAM
            $DEFAULT_DB2X_TEXIXML_PROGRAM
            $DEFAULT_UTF8TRANS_TEXIMAP);
# The last variables are to silence variable-not-used warnings


my @xsltproc_opts;
my @xml_opts;
my $CONVERSION_TYPE;

if(!defined $CONVERSION_TYPE) {
    if($0 =~ /man$/) {
        $CONVERSION_TYPE = 'man';
    } else {
        $CONVERSION_TYPE = 'texi';
    }
}

while(my $opt = shift @ARGV)
{
    if($opt eq "--help") {
        print_help();
        exit(0);
    } 
    elsif($opt =~ "--version") {
        print_version();
        exit(0);
    } 
    elsif($opt =~ /^--(.+links|list-files|to-stdout|info)$/) {
        push @xml_opts, $opt;
    }
    elsif($opt =~ /^--(encoding|utf8trans-|iconv-)/) {
        push @xml_opts, $opt;
        push @xml_opts, shift(@ARGV) if $opt !~ /=/;
    }
    elsif($opt =~ /^--output/) {
        # This option is ineffectual.
        shift @ARGV if $opt !~ /=/;     # Get rid of filename argument also
    }
    elsif($opt eq "-o") {
        # Same as --output.
        shift @ARGV;
    }
    else {
        push @xsltproc_opts, $opt;
    }
}

if(!grep /^-s|--stylesheet/, @xsltproc_opts) {
    unshift @xsltproc_opts, ('-s', $CONVERSION_TYPE);
}

unshift @xsltproc_opts, $DEFAULT_DB2X_XSLTPROC_PROGRAM;

if($CONVERSION_TYPE eq 'texi') {
    unshift @xml_opts, $DEFAULT_DB2X_TEXIXML_PROGRAM;
} elsif($CONVERSION_TYPE eq 'man') {
    unshift @xml_opts, $DEFAULT_DB2X_MANXML_PROGRAM;
} 

exec(
    shell_quote(@xsltproc_opts) . 
    ' | ' . 
    shell_quote(@xml_opts));
     

sub shell_quote
{
    join(' ', map { my $u = $_;
                    $u =~ s#([\$`"\\\n])#\\$1#g;
                    '"' . $u . '"' } @_);
}





sub print_help {
    print "Usage: $0 [OPTION]... XML-FILE\n";

    if($CONVERSION_TYPE eq 'texi') {
        print "Convert DocBook XML documents to Texinfo\n";
    } elsif($CONVERSION_TYPE eq 'man') {
        print "Convert DocBook XML documents to man pages\n";
    }
    print "See db2x_xsltproc(1), db2x_${CONVERSION_TYPE}xml(1), and docbook2X documentation\n";
    print "for the description of the options to this program, and on how it works.\n";
}

sub print_version
{
    print "$0 (part of docbook2X ${DOCBOOK2X_VERSION})\n";
    print <<'end';
$Revision: 1.5 $ $Date: 2003/06/22 14:37:30 $
<URL:http://docbook2x.sourceforge.net/>

Copyright (C) 2003 Steve Cheng
This is free software; see the source for copying conditions.  There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
end
}

