.\" dpkg manual page - start-stop-daemon(8)
.\"
.\" Copyright © 1999 Klee Dienes <klee@mit.edu>
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000-2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2002-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2008-2016, 2018 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH start\-stop\-daemon 8 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
start\-stop\-daemon \- start and stop system daemon programs
.
.SH SYNOPSIS
.B start\-stop\-daemon
.RI [ option "...] " command
.
.SH DESCRIPTION
.B start\-stop\-daemon
is used to control the creation and termination of system-level processes.
Using one of the matching options, \fBstart\-stop\-daemon\fP
can be configured to find existing instances of a running process.
.PP
Note: unless
.B \-\-pid
or
.B \-\-pidfile
are specified,
.B start\-stop\-daemon
behaves similar to
.BR killall (1).
.B start\-stop\-daemon
will scan the process table looking for any processes which
match the process name, parent pid, uid, and/or gid (if specified). Any
matching process will prevent
.BR \-\-start
from starting the daemon. All matching processes will be sent the TERM
signal (or the one specified via \fB\-\-signal\fP or \fB\-\-retry\fP) if
.BR \-\-stop
is specified. For daemons which have long-lived children
which need to live through a
.BR \-\-stop ,
you must specify a pidfile.
.
.SH COMMANDS
.TP
.BR \-S ", " \-\-start " [" \-\- "] \fIarguments\fP"
Check for the existence of a specified process.
If such a process exists,
.B start\-stop\-daemon
does nothing, and exits with error status 1 (0 if
.BR \-\-oknodo
is specified).
If such a process does not exist, it starts an
instance, using either the executable specified by
.B \-\-exec
or, if specified, by
.BR \-\-startas .
Any arguments given after
.BR \-\-
on the command line are passed unmodified to the program being
started.
.TP
.BR \-K ", " \-\-stop
Checks for the existence of a specified process.
If such a process exists,
.B start\-stop\-daemon
sends it the signal specified by
.BR \-\-signal ,
and exits with error status 0.
If such a process does not exist,
.B start\-stop\-daemon
exits with error status 1
(0 if
.BR \-\-oknodo
is specified). If
.B \-\-retry
is specified, then
.B start\-stop\-daemon
will check that the process(es) have terminated.
.TP
.BR \-T ", " \-\-status
Check for the existence of a specified process, and returns an exit status
code, according to the LSB Init Script Actions (since version 1.16.1).
.TP
.BR \-H ", " \-\-help
Show usage information and exit.
.TP
.BR \-V ", " \-\-version
Show the program version and exit.
.
.SH OPTIONS
.SS Matching options
.TP
.BR \-\-pid " \fIpid\fP"
Check for a process with the specified \fIpid\fP (since version 1.17.6).
The \fIpid\fP must be a number greater than 0.
.TP
.BR \-\-ppid " \fIppid\fP"
Check for a process with the specified parent pid \fIppid\fP
(since version 1.17.7).
The \fIppid\fP must be a number greater than 0.
.TP
.BR \-p ", " \-\-pidfile " \fIpid-file\fP"
Check whether a process has created the file \fIpid-file\fP.
.IP
Note: using this matching option alone might cause unintended processes to
be acted on, if the old process terminated without being able to remove the
\fIpid-file\fP.
.IP
\fBWarning:\fP using this match option with a world-writable pidfile or using
it alone with a daemon that writes the pidfile as an unprivileged (non-root)
user will be refused with an error (since version 1.19.3) as this is a
security risk, because either any user can write to it, or if the daemon
gets compromised, the contents of the pidfile cannot be trusted, and then
a privileged runner (such as an init script executed as root) would end up
acting on any system process.
Using \fI/dev/null\fP is exempt from these checks.
.TP
.BR \-x ", " \-\-exec " \fIexecutable\fP"
Check for processes that are instances of this \fIexecutable\fP. The
\fIexecutable\fP argument should be an absolute pathname. Note: this might
not work as intended with interpreted scripts, as the executable will point
to the interpreter. Take into account processes running from inside a chroot
will also be matched, so other match restrictions might be needed.
.TP
.BR \-n ", " \-\-name " \fIprocess-name\fP"
Check for processes with the name \fIprocess-name\fP. The \fIprocess-name\fP
is usually the process filename, but it could have been changed by the
process itself. Note: on most systems this information is retrieved from
the process comm name from the kernel, which tends to have a relatively
short length limit (assuming more than 15 characters is non-portable).
.TP
.BR \-u ", " \-\-user " \fIusername\fP|\fIuid\fP
Check for processes owned by the user specified by \fIusername\fP or
\fIuid\fP. Note: using this matching option alone will cause all processes
matching the user to be acted on.
.
.SS Generic options
.TP
.BR \-g ", " \-\-group " \fIgroup\fP|\fIgid\fP"
Change to \fIgroup\fP or \fIgid\fP when starting the process.
.TP
.BR \-s ", " \-\-signal " \fIsignal\fP"
With
.BR \-\-stop ,
specifies the signal to send to processes being stopped (default TERM).
.TP
.BR \-R ", " \-\-retry " \fItimeout\fP|\fIschedule\fP"
With
.BR \-\-stop ,
specifies that
.B start\-stop\-daemon
is to check whether the process(es)
do finish. It will check repeatedly whether any matching processes
are running, until none are. If the processes do not exit it will
then take further action as determined by the schedule.

If
.I timeout
is specified instead of
.IR schedule ,
then the schedule
.IB signal / timeout /KILL/ timeout
is used, where
.I signal
is the signal specified with
.BR \-\-signal .

.I schedule
is a list of at least two items separated by slashes
.RB ( / );
each item may be
.BI \- signal-number
or [\fB\-\fP]\fIsignal-name\fP,
which means to send that signal,
or
.IR timeout ,
which means to wait that many seconds for processes to
exit,
or
.BR forever ,
which means to repeat the rest of the schedule forever if
necessary.

If the end of the schedule is reached and
.BR forever
is not specified, then
.B start\-stop\-daemon
exits with error status 2.
If a schedule is specified, then any signal specified
with
.B \-\-signal
is ignored.
.TP
.BR \-a ", " \-\-startas " \fIpathname\fP"
With
.BR \-\-start ,
start the process specified by
.IR pathname .
If not specified, defaults to the argument given to
.BR \-\-exec .
.TP
.BR \-t ", " \-\-test
Print actions that would be taken and set appropriate return value,
but take no action.
.TP
.BR \-o ", " \-\-oknodo
Return exit status 0 instead of 1 if no actions are (would be) taken.
.TP
.BR \-q ", " \-\-quiet
Do not print informational messages; only display error messages.
.TP
.BR \-c ", " \-\-chuid " \fIusername\fR|\fIuid\fP[\fB:\fP\fIgroup\fR|\fIgid\fP]"
Change to this username/uid before starting the process. You can also
specify a group by appending a
.BR : ,
then the group or gid in the same way
as you would for the \fBchown\fP(1) command (\fIuser\fP\fB:\fP\fIgroup\fP).
If a user is specified without a group, the primary GID for that user is used.
When using this option
you must realize that the primary and supplemental groups are set as well,
even if the
.B \-\-group
option is not specified. The
.B \-\-group
option is only for
groups that the user isn't normally a member of (like adding per process
group membership for generic users like
.BR nobody ).
.TP
.BR \-r ", " \-\-chroot " \fIroot\fP"
Chdir and chroot to
.I root
before starting the process. Please note that the pidfile is also written
after the chroot.
.TP
.BR \-d ", " \-\-chdir " \fIpath\fP"
Chdir to
.I path
before starting the process. This is done after the chroot if the
\fB\-r\fP|\fB\-\-chroot\fP option is set. When not specified,
.B start\-stop\-daemon
will chdir to the root directory before starting the process.
.TP
.BR \-b ", " \-\-background
Typically used with programs that don't detach on their own. This option
will force
.B start\-stop\-daemon
to fork before starting the process, and force it into the background.
.B Warning: start\-stop\-daemon
cannot check the exit status if the process fails to execute for
.B any
reason. This is a last resort, and is only meant for programs that either
make no sense forking on their own, or where it's not feasible to add the
code for them to do this themselves.
.TP
.BR \-\-notify\-await
Wait for the background process to send a readiness notification before
considering the service started (since version 1.19.3).
This implements parts of the systemd readiness procotol, as specified
in the \fBsd_notify\fP(3) man page.
The following variables are supported:
.RS
.TP
.B READY=1
The program is ready to give service, so we can exit safely.
.TP
.BI EXTEND_TIMEOUT_USEC= number
The program requests to extend the timeout by \fInumber\fP microseconds.
This will reset the current timeout to the specified value.
.TP
.BI ERRNO= number
The program is exiting with an error.
Do the same and print the user-friendly string for the \fBerrno\fP value.
.RE
.
.TP
.BI \-\-notify\-timeout timeout
Set a timeout for the \fB\-\-notify\-await\fP option (since version 1.19.3).
When the timeout is reached, \fBstart\-stop\-daemon\fP will exit with an
error code, and no readiness notification will be awaited.
The default is \fB60\fP seconds.
.TP
.BR \-C ", " \-\-no\-close
Do not close any file descriptor when forcing the daemon into the background
(since version 1.16.5).
Used for debugging purposes to see the process output, or to redirect file
descriptors to log the process output.
Only relevant when using \fB\-\-background\fP.
.TP
.BR \-N ", " \-\-nicelevel " \fIint\fP"
This alters the priority of the process before starting it.
.TP
.BR \-P ", " \-\-procsched " \fIpolicy\fP\fB:\fP\fIpriority\fP"
This alters the process scheduler policy and priority of the process before
starting it (since version 1.15.0).
The priority can be optionally specified by appending a \fB:\fP
followed by the value. The default \fIpriority\fP is 0. The currently
supported policy values are \fBother\fP, \fBfifo\fP and \fBrr\fP.
.TP
.BR \-I ", " \-\-iosched " \fIclass\fP\fB:\fP\fIpriority\fP"
This alters the IO scheduler class and priority of the process before starting
it (since version 1.15.0).
The priority can be optionally specified by appending a \fB:\fP followed
by the value. The default \fIpriority\fP is 4, unless \fIclass\fP is \fBidle\fP,
then \fIpriority\fP will always be 7. The currently supported values for
\fIclass\fP are \fBidle\fP, \fBbest-effort\fP and \fBreal-time\fP.
.TP
.BR \-k ", " \-\-umask " \fImask\fP"
This sets the umask of the process before starting it (since version 1.13.22).
.TP
.BR \-m ", " \-\-make\-pidfile
Used when starting a program that does not create its own pid file. This
option will make
.B start\-stop\-daemon
create the file referenced with
.B \-\-pidfile
and place the pid into it just before executing the process. Note, the
file will only be removed when stopping the program if
\fB\-\-remove\-pidfile\fP is used.
.B Note:
This feature may not work in all cases. Most notably when the program
being executed forks from its main process. Because of this, it is usually
only useful when combined with the
.B \-\-background
option.
.TP
.B \-\-remove\-pidfile
Used when stopping a program that does not remove its own pid file
(since version 1.17.19).
This option will make
.B start\-stop\-daemon
remove the file referenced with
.B \-\-pidfile
after terminating the process.
.TP
.BR \-v ", " \-\-verbose
Print verbose informational messages.
.
.SH EXIT STATUS
.TP
.B 0
The requested action was performed. If
.B \-\-oknodo
was specified, it's also possible that nothing had to be done.
This can happen when
.B \-\-start
was specified and a matching process was already running, or when
.B \-\-stop
was specified and there were no matching processes.
.TP
.B 1
If
.B \-\-oknodo
was not specified and nothing was done.
.TP
.B 2
If
.B \-\-stop
and
.B \-\-retry
were specified, but the end of the schedule was reached and the processes were
still running.
.TP
.B 3
Any other error.
.PP
When using the \fB\-\-status\fP command, the following status codes are
returned:
.TP
.B 0
Program is running.
.TP
.B 1
Program is not running and the pid file exists.
.TP
.B 3
Program is not running.
.TP
.B 4
Unable to determine program status.
.
.SH EXAMPLE
Start the \fBfood\fP daemon, unless one is already running (a process named
food, running as user food, with pid in food.pid):
.IP
.nf
start\-stop\-daemon \-\-start \-\-oknodo \-\-user food \-\-name food \\
	\-\-pidfile /run/food.pid \-\-startas /usr/sbin/food \\
	\-\-chuid food \-\- \-\-daemon
.fi
.PP
Send \fBSIGTERM\fP to \fBfood\fP and wait up to 5 seconds for it to stop:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \\
	\-\-pidfile /run/food.pid \-\-retry 5
.fi
.PP
Demonstration of a custom schedule for stopping \fBfood\fP:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \\
	\-\-pidfile /run/food.pid \-\-retry=TERM/30/KILL/5
.fi
