#! /usr/bin/perl
#
#  wl: wordlist control management utility

# fixme: --dirfile option
# fixme: sort entries
# fixme: send to FSF ?

$version= '1.3.4'; # This line modified by Makefile
sub version {
        print STDERR <<END;
wl $version.  Copyright (C) 1996, Erick Branderhorst.  This is free
software; see the GNU General Public Licence version 2 or later for
copying conditions.  There is NO warranty.
END
}

sub usage {
    print STDERR <<END;
usage: wl [--version] [--help] [--stamp] [--check] filename
END
}

$infodir='/usr/info';
$maxwidth=79;
$align=27;
$calign=29;

$header_re='(^#.*$)*'
$

undef $menuentry;
undef $quiet;
undef $nowrite;
undef $keepold;
undef $description;
undef $sectionre;
undef $sectiontitle;
$0 =~ m|[^/]+$|; $name= $&;

while ($ARGV[0] =~ m/^--/) {
    $_= shift(@ARGV);
    last if $eq eq '--';
    if ($_ eq '--version') {
        &version; exit 0;
    } elsif ($_ eq '--quiet') {
        $quiet=1;
    } elsif ($_ eq '--test') {
        $nowrite=1;
    } elsif ($_ eq '--keep-old') {
        $keepold=1;
    } elsif ($_ eq '--remove') {
        $remove=1;
    } elsif ($_ eq '--help') {
        &usage; exit 0;
    } elsif ($_ eq '--debug') {
        open(DEBUG,">&STDERR") || exit 1;
    } elsif ($_ eq '--section') {
        if (@ARGV < 2) {
            print STDERR "$name: --section needs two more args\n";
            &usage; exit 1;
        }
        $sectionre= shift(@ARGV);
        $sectiontitle= shift(@ARGV);
    } elsif (m/^--maxwidth=([0-9]+)$/) {
        $maxwidth= $1;
    } elsif (m/^--align=([0-9]+)$/) {
        $align= $1;
    } elsif (m/^--calign=([0-9]+)$/) {
        $calign= $1;
    } elsif (m/^--infodir=/) {
        $infodir=$';
    } elsif (m/^--menuentry=/) {
        $menuentry=$';
    } elsif (m/^--description=/) {
        $description=$';
    } else {
        print STDERR "$name: unknown option \`$_'\n"; &usage; exit 1;
    }
}

if (!@ARGV) { &version; print STDERR "\n"; &usage; exit 1; }

$filename= shift(@ARGV);
if (@ARGV) { print STDERR "$name: too many arguments\n"; &usage; exit 1; }

if ($remove) {
    print STDERR "$name: --section ignored with --remove\n" if length($sectiontitle);
    print STDERR "$name: --description ignored with --remove\n" if length($description);
}

print STDERR "$name: test mode - dir file will not be updated\n"
    if $nowrite && !$quiet;

umask(umask(0777) & ~0444);

$filename =~ m|[^/]+$|; $basename= $&; $basename =~ s/(\.info)?(\.gz)?$//;
print DEBUG <<END;
 infodir=\`$infodir'  filename=\`$filename'  maxwidth=\`$maxwidth'
 menuentry=\`$menuentry'  basename=\`$basename'
 description=\`$description' remove=$remove
END

if (!$remove) {

    if (!-f $filename && -f "$filename.gz" || $filename =~ s/\.gz$//) {
        $filename= "gzip -d <$filename.gz |";  $pipeit= 1;
    } else {
        $filename= "< $filename";
    }

    if (!length($description)) {
        


$debug=0;
$mimedb="/var/lib/mime/mime-db";
$mailcap="/etc/mailcap";
$action{view}			= "view";
$action{compose}		= "compose";
$action{composetyped}	= "compose";
$action{edit}			= "edit";
$action{print}			= "print";
$action{"x11-bitmap"}	= "x11-bitmap";



###############################################################################



#
# Subrutine to 'uniq' a sorted list
#
sub uniq {
	local($last) = "";
	local(@new)  = ();
	foreach $val (@_) {
		if ($val ne $last) {
			$last = $val;
			push(@new,$val);
		}
	}
	return @new;
}


#
# Subroutine to output a string and move to next column
#
sub OutputColumn {
	my($string,$size) = @_;
	my $i;

#	$string = substr($string,0,$size-1);
	print $string;
	for ($i=length($string); $i < $size; $i++) {
		print " ";
	}
}



#
# Subroutine to reformat text for the screen
#
sub Reformat {
	my($string,$size) = @_;
	my(@letters,$index,$count,$length);
	$size = 80 unless $size;

	@letters = split(//,$string);
	$length  = @letters;

	$index = 0;
	$count = 0;
	while ($index < $length) {
		$count = $size - 1;
		if ($count < $length - $index) {
			$count-- while (@letters[$index + $count] ne ' ');
		}
		print substr($string,$index,$count) . "\n";
		$index += $count + 1;
	}
}



###############################################################################



#
# Subroutine to change type information
#
sub Change {
	my($content,$field,$value) = @_;

	if ($D{$content} =~ m/$field=(.*?)\t/) {
		print "Resolving redefined '$field'...\n" if $debug;
		return if ($1 eq $value);

		print "\nThis package recommends changing the value of '$field'\n";
		print "in the 'mailcap' file.\n\n";
		print "  old:  $1\n";
		print "  new:  $value\n\n";
		print "Do you wish to accept the new value? (y/n) -->";
		my $resp = <STDIN>;
		print "\n";

		return if ($resp =~ m/[Nn]/);
	}

	$D{$content}  =~ s|$field=.*?\t||g;
	$D{$content} .= "$field=$value\t";
}



#
# Subroutine to choose an ordering
#
sub Order {
	my($content,$command,$package,$value,$index) = @_;
	my $action = $action{$command};
	my @list = split(/\t/,$O{"$content,$action"});
	my $size = @list;
	my @lines;
	my $i,$pkg,$idx,$other,$resp;

	unless ($size) {
		$O{"$content,$action"} .= "$package($index)\t";
		print "- Added new action '$action' for MIME type '$content' ($value)\n";
		return;
	}

	$max = ($size>9 ? 9 : $size) + 1;

	do {
		print "\nNew action '$action' for MIME type '$content'...\n";
		print "-->\tpackage=$package\t$value\n";
		Reformat("Note: $A{comment}") if $A{comment};
		print "\n";
		for ($i=1; $i < $max; $i++) {
			($pkg,$idx) = ($list[$i-1] =~ m/(.*?)\((\d+)\)/);
			$other =  $P{$pkg};
			@lines =  split(/\n/,$other);
			$other =  $lines[$idx];
			$other =~ s|content=.*?\t||;
			$other =~ s|action=.*?\t||;
			print "$i)\t$other\n";
		}
		print "\nPlace at what priority? (1-$max) -->";
		$resp = <STDIN>;
		print "\n";
		$resp = int($resp);
	} while ($resp < 1 || $resp > $max);

	$O{"$content,$action"} = "";
	for ($i=1; $i <= $size; $i++) {
		$O{"$content,$action"} .= "$package($index)\t" if ($i == $resp);
		$O{"$content,$action"} .= "$list[$i-1]\t";
	}
	$O{"$content,$action"} .= "$package($index)\t" if ($i == $resp);
}



#
# Subroutine to insert an ability for a package
#
sub Insert {
	my($pkg,$typ,$act,$prg,$tst,$flg) = @_;
	my $value = "$act=$prg";
	my $flags;
	my $index;
	my @list;

	die "$0: Semicolons are not allowed in commands, use || or &&\n" if $value =~ m/;/;

	$value .= "; test=$tst" if $tst;
	$value .= "; $flg" if $flg;

	if ($P{$pkg} =~ m/package=\Q$pkg\E\tcontent=\Q$typ\E\t\Q$value\E\n/) {
		print "- Ignoring already installed content '$typ' with value '$value'\n" if $debug;
		return;
	}

	my(@index)= ($P{$pkg} =~ m/\n/g);
	$index    = @index;
	$P{$pkg} .= "package=$pkg\tcontent=$typ\t$value\n";

	print "Adding new action '$act' for package '$pkg' at index #$index\n" if $debug;
	Order($typ,$act,$pkg,$value,$index);
}



#
# Subroutine to generate mailcap entries
#
sub GenMailcap {
	my($path) = @_;
	my(@list);
	my(@content);
	my($action);

	@list = %O;
	foreach (@list) {
		my($idx) = shift @list;
		my($val) = shift @list;
		my($content,$action) = ($idx =~ m/^(.*),(.*)$/);
		push @content,$content;
	}
	@content = uniq(sort(@content));

	foreach $content (@content) {
		my $flags;
		if ($D{$content} =~ m/description=(.*?)\t/)		{ $flags .= "; description=$1";		}
		if ($D{$content} =~ m/textualnewlines=(.*?)\t/)	{ $flags .= "; textualnewlines=1";	}
		if ($D{$content} =~ m/nametemplate=(.*?)\t/)	{ $flags .= "; nametemplate=$1";	}

		if ($O{"$content,x11-bitmap"} =~ m/(.*?)\((\d+)\)\t/) {
			$P{$1} =~ m/x11-bitmap=(.*?)\n/s;
			$flags .= "; x11-bitmap=$1";
		}

		print "* * * Printing content '$content'... ($flags)\n" if $debug;
		foreach $action ("view","compose","edit","print") {
			print "  * * Printing action '$action'...\n" if $debug;
			my $order = $O{"$content,$action"};
			foreach (split(/\t/,$order)) {
				my($pkg,$idx) = m/(.*?)\((\d+)\)/;
				my @values = split(/\n/,$P{$pkg});
				my $value  = $values[$idx];
				$value =~ s|package=.*?\tcontent=.*?\t||;
				print "    * Printing package '$_'... ($value)\n" if $debug;
				if ($value =~ /^view=/) {
					$value =~ s|view=||;
					print $path "$content; $value$flags\n";
				} else {
					print $path "$content; echo \"No viewer for type '$content'\"; $value$flags\n";
				}
			}
		}
	}
}



###############################################################################



#
# "Remove" subroutine
#
sub Remove {
	my $pkg = $A{package};
	my @list;

	@list = %O;
	while (@list) {
		my $order = shift @list;
		my $names = shift @list;

		$O{$order} =~ s|$pkg\(\d+\)\t||g;
		unless ($O{$order}) {
			my($content,$action) = ($order =~ m/(.*),(.*)/);
			print "- There is now nothing as '$2' for MIME type '$1'\n";
		}
	}

	undef $P{$pkg};
	$changed=1;
}



#
# "Install" subroutine
#
sub Install {
	my @list = %A;
	while (@list) {
		my $arg = shift @list;
		my $val = shift @list;

		if ($arg =~ m/^(description|textualnewlines|nametemplate)$/ && $val) {
			Change($A{content},$arg,$val);
		}
	}

	Insert($A{package},$A{content},"x11-bitmap",$A{"x11-bitmap"}) if $A{"x11-bitmap"};

	my $flags = "";
	$flags .= "; needsterminal"		if $A{needsterminal}	=~ m/[Tt]/;
	$flags .= "; copiousoutput"		if $A{copiousoutput}	=~ m/[Tt]/;
	$flags .= "; textualnewlines"	if $A{textualnewlines}	=~ m/[Tt]/;
	$flags  =~s|^; ||;

	@list = %A;
	while (@list) {
		my $arg = shift @list;
		my $val = shift @list;

		if ($arg =~ m/^(view|compose|composetyped|edit|print)$/ && $val) {
			Insert($A{package},$A{content},$arg,$val,$A{test},$flags);
			$changed=1;
		}
	}
}



#
# "List" subroutine
#
sub List {
	my @list = %O;

	while (@list) {
		my $order = shift @list;
		my $value = shift @list;
		my($content,$action) = ($order =~ m/(.*),(.*)/);

		next if $A{content} && $content !~ m/^$A{content}/;
		next if $A{package} && $value !~ m/$A{package}\(/;

		print "\n$content: ";
		$D{$content} =~ m/description=(.*?)\t/;
		print " \"$1\"" if $1;
		print " ($action)\n";

#		my $header = 0;
		foreach (split(/\t/,$value)) {
			my($package,$index) = (m/(.*)\((\d+)\)/);
			my @pkgdata = split(/\n/,$P{$package});
			next if $A{package} && $A{package} ne $package;

#			if ($header) {
#				OutputColumn("",20);
#			} else {
				OutputColumn($package,20);
#				$header=1;
#			}

#			print "\nExtracting from line: $pkgdata[$index]\n" if $debug;
			my($command) = ($pkgdata[$index] =~ m/$action.*?=([^;]*)/);
			my($test)    = ($pkgdata[$index] =~ m/(test=[^\t]*)/);
			OutputColumn($command,40);
			print " $test\n";
		}
	}

	print "\n";
}



###############################################################################



#
# Valid parameters
#
$A{install}			= -1;
$A{remove}			= -1;
$A{list}			= -1;
$A{package}			= '@';
$A{content}			= '@';
$A{comment}			= '@';
$A{test}			= '@';
$A{needsterminal}	= '@';
$A{copiousoutput}	= '@';
$A{description}		= '@';
$A{textualnewlines}	= '@';
$A{"x11-bitmap"}	= '@';
$A{nametemplate}	= '@';
$A{view}			= '@';
$A{compose}			= '@';
$A{composetyped}	= '@';
$A{edit}			= '@';
$A{print}			= '@';



#
# Parameter parsing
#
foreach (@ARGV) {
	my($p,$v);

	s/[\n\t ]+/ /g;

	if (/^--(.*?)=(.*)$/) {
		$p=$1; $v=$2;
	} elsif (/^--([^=]*)$/) {
		$p=$1; $v=1;
	} else {
		die "$0: Bad parameter '$_'\n";
	}
	die "$0: Unknown option '--$p'\n" unless $A{$p};
	die "$0: Redefined option '--$p'\n" if ($A{$p} ne '@' && $A{$p} != -1);

	print "Setting '$p' = '$v'\n" if $debug;
	$A{$p} = $v;
}



#
# Remove any undefined parameters and do simple sanity check
#
@list = %A;
while (@list) {
	my($parm) = shift @list;
	my($valu) = shift @list;
	undef $A{$parm} if $valu == -1;
	undef $A{$parm} if $valu eq '@';
	die "$0: Missing mandatory option '--$parm'\n" if $valu eq '*';
}

die "$0: '--install' and '--remove' are mutually exclusive options\n" if $A{install} && $A{remove};
die "$0: install requires '--package' and '--content'\n" if $A{install} && (! $A{package} || ! $A{content});
die "$0: remove requires '--package'\n" if $A{remove} && ! $A{package};
die "$0: No action given!\n" unless $A{install} || $A{remove} || $A{list};



#
# Load database
#
if (-f $mimedb) {
	open(PATH,"<$mimedb") || die "$0: Could not read database '$mimedb' -- $!\n";
	while (<PATH>) {
		if (m/^content=(.*?)\taction=(.*?)\t(.*)\n$/) {
			my($idx) = "$1,$2";
			die "$0: Database corruption! (multiple 'content=$1, action=$2' lines)\n" if $O{$idx};
			$O{$idx}  = $3;
		} elsif (m/^content=(.*?)\t(.*)\n$/) {
			die "$0: Database corruption! (multiple 'content=$1;<data>' lines)\n" if $D{$1};
			$D{$1} = $2;
		} elsif (m/^package=(.*?)\t/) {
			$P{$1} .= $_;
		} else {
			chop;
			die "$0: Database corruption! (unknown line '$_')\n";
		}
	}
	close PATH;
}



#
# Do actions specified by user
#
$changed=0;
Remove	if $A{remove};
Install	if $A{install};
List	if $A{list};

exit 0 unless $changed;	# stop here if no changes were made


#
# Generate new mailcap file if necessary
#
$state = 0;
undef @above;
undef @user;
undef @below;
open(PATH,"<$mailcap") || die "$0: Could not read '$mailcap' -- $!\n";

while (<PATH>) {
	if ($state == 0) {
		push @above,$_;
	}
	$state=2 if ($state == 1 && /^\# ----- .* Ends /);
	if ($state == 1) {
		push @user,$_;
	}
	$state=1 if ($state == 0 && /^\# ----- .* Begins /);
	if ($state == 2) {
		push @below,$_;
	}
	$state=3 if ($state == 2);
}

close PATH;

open(PATH,">$mailcap") || die "$0: Could not write '$mailcap' -- $!\n";
print PATH @above;
print PATH @user;
print PATH @below;
print PATH "\n###############################################################################\n\n";
GenMailcap(PATH);
close PATH;



#
# Write data back to the database
#
open (PATH,">$mimedb") || die "$0: Could not write database '$mimedb' -- $!\n";

@list = %O;
while (@list) {
	my $idx = shift @list;
	my $val = shift @list;
	$idx =~ m/(.*?),(.*)/;
	print PATH "content=$1\taction=$action{$2}\t$val\n" if $val;
}

@list = %D;
while (@list) {
	my $idx = shift @list;
	my $val = shift @list;
	print PATH "content=$idx\t$val\n";
}

@list = %P;
while (@list) {
	my $idx = shift @list;
	my $val = shift @list;
	print PATH $val;
}

close PATH;
