# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'

import pygtk
pygtk.require('2.0')
import gtk

from elisa.base_components.context import Context
from elisa.core import common

class GtkContext(Context):

    def initialize(self):
        Context.initialize(self)
        self._context_handle = None
        window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.viewport_handle = window
        window.connect("delete_event", self._delete_event)

    def _delete_event(self, widget, event, data=None):
        common.application.stop()

    def context_handle__set(self, context_handle):
        if isinstance(context_handle, gtk.Widget):
            self._context_handle = context_handle
            self.viewport_handle.add(context_handle)
            self.viewport_handle.resize(350,800)
            self.viewport_handle.show_all()
        else:
            raise TypeError("%r should be a gtk.Widget" % context_handle)

    def context_handle__get(self):
        return self._context_handle
