# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


import pygtk
pygtk.require('2.0')
import gtk

from elisa.core import plugin_registry
TreeViewClass = plugin_registry.get_component_class('base:tree_view')

class GtkTreeView(TreeViewClass):
    """
    This class implements gtk tree view support
    """

    supported_controllers = ('base:tree_controller', 'poblenou:tree_controller')

    def __init__(self):
        TreeViewClass.__init__(self)
        self.treeview = None
        self._create_gtk_tree()

    def _create_gtk_tree(self):
        treestore = gtk.TreeStore(str)
        self.treeview = gtk.TreeView(treestore)
        self.context_handle = self.treeview
        tvcolumn = gtk.TreeViewColumn('Column 0')
        self.treeview.append_column(tvcolumn)
        cell = gtk.CellRendererText()
        #self.cell1.set_property('cell-background', 'pink')
        tvcolumn.pack_start(cell, True)
        tvcolumn.add_attribute(cell, 'text', 0)
        self.treeview.set_search_column(0)

        tree_selection = self.treeview.get_selection()
        tree_selection.set_mode(gtk.SELECTION_SINGLE)
        self.treeview.connect("cursor-changed", self._gtk_selection_changed)


    def controller_changed(self, old_controller, new_controller):
        TreeViewClass.controller_changed(self, old_controller, new_controller)
        self.select_from_view(self)


    def child_view_creating(self, view, controller, position):
        TreeViewClass.child_view_creating(self, view, controller, position)
        view.create_node(controller, position)
        

    def get_path(self):
        return []
    
    def select_from_view(self, view):
        path = tuple( view.get_path() )
        if path == ():
            path = (0,)
        selection = self.treeview.get_selection()
        selection.select_path( path )

    def get_view_from_path(self, path):
        v = self
        for i in path:
            v = v[i]
        return v
    
    def attribute_set(self, origin, key, old_value, new_value):
        if key == 'current_index':
            self.select_from_view(self[new_value])
        if key == 'selected':
            if new_value == True:
                index = self.controller.current_index
                self.root.select_from_view(self[index])

    def _gtk_selection_changed(self, treeview):
        treemodel, iter = self.treeview.get_selection().get_selected()
        path = treemodel.get_path(iter)
        selected_view  =  self.get_view_from_path(path)
        selected_view.parent.controller.current_index = path[-1]
        selected_view.parent.controller.selected = True
