# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


from elisa.core import common
from elisa.core import player
from elisa.core.input_event import *

plugin_registry = common.application.plugin_registry
ListController = plugin_registry.get_component_class('raval:list_controller')

class ContextController(ListController):
    """
    DOCME
    """
 
    supported_models = ('raval:context_model',)

    def focused_changed(self, old_focused, new_focused):
        if new_focused:
            self.current_index = 0
        else:
            self.current_index = -1

    def previous_item(self, step=1):
        if self.current_index == 0:
            self.parent.focus()
        else:
            super(ContextController, self).previous_item(step=step)
            
    def handle_input(self, input_event):
        if input_event.action == EventAction.GO_LEFT:
            self.previous_item()
            return True
        
        elif input_event.action == EventAction.GO_RIGHT:
            self.next_item()
            return True
        
        elif input_event.action == EventAction.GO_DOWN:
            self.current_index = -1
            self.parent.focus()
            return True
        
        elif input_event.action == EventAction.OK:
            self.fire_activate_action(self.current_index, input_event.origin)
            return True

    def fire_activate_action(self, index, origin):
        if index > -1 and len(self.model) > 0:
            model = self.model[index]
            action = model.activate_action
            if callable(action):
                action(self, origin)
