# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.core import common
from elisa.core.input_event import *

from pgm.widgets import const

plugin_registry = common.application.plugin_registry
ListController = plugin_registry.get_component_class('raval:list_controller')

class MainMenuController(ListController):

    def handle_input(self, input_event):
        if input_event.action == EventAction.GO_RIGHT:
            if len(self.model) > 0:
                self.current_index = (self.current_index + 1) % len(self.model)
            return True

        elif input_event.action == EventAction.GO_LEFT:
            if len(self.model) > 0:
                self.current_index = (self.current_index - 1) % len(self.model)
            return True

        elif input_event.action in (EventAction.GO_UP, EventAction.GO_DOWN):
            # Ensure, that it is not doing anything
            return True
        
        else:
            return ListController.handle_input(self, input_event)
