# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'


from elisa.core.input_event import *
# the controller
from elisa.base_components.controller import Controller

from elisa.core.utils.signal import Signal

class PopupController(Controller):

    def __init__(self):
        super(PopupController, self).__init__()

    def initialize(self):
        super(PopupController, self).initialize()
        self.signal = Signal('popup-signal', int)

    def handle_input(self, input_event):
        if input_event.action == EventAction.GO_LEFT:
            self.left = 1
        elif input_event.action == EventAction.GO_RIGHT:
            self.right = 1
        elif input_event.action == EventAction.OK:
            self.enter = 1
        return False

