# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import unittest
import sys
import gobject

from pkg_resources import resource_filename

from elisa.plugins.pigment.widgets.style import Style
import pgm

class TestStyle(unittest.TestCase):

    def test_init(self):
        style = Style()

    def test_simple(self):
        style = Style()
        self.assertEquals(len(style.get_properties()), 0)

        style = Style(ciao="ciao", hola="hola")
        self.assertEquals(len(style.get_properties()), 2)
        self.assertEquals(tuple(style.get_properties()), ('ciao', 'hola'))
        self.assertEquals(style.ciao, 'ciao')
        self.assertEquals(style.hola, 'hola')

        other = Style(hello='hello', hola='hello')
        new = style.merge(other)
        self.assertEquals(len(new.get_properties()), 3)
        self.assertEquals(tuple(new.get_properties()), ('ciao', 'hello', 'hola'))
        self.assertEquals(new.ciao, 'ciao')
        self.assertEquals(new.hello, 'hello')
        self.assertEquals(new.hola, 'hello')

        for key, value in new:
            if key == 'ciao':
                self.assertEquals(value, 'ciao')
            elif key == 'hello':
                self.assertEquals(value, 'hello')
            elif key == 'hola':
                self.assertEquals(value, 'hello')
            else:
                self.assertFalse(True)

    def test_property_changed(self):
        style = Style()

        def on_property_changed(style, key, value):
            self.assertEquals(key, 'ciao')
            self.assertEquals(value, 'ciao')

        handler_id = style.connect('property-changed', on_property_changed)
        style.ciao = "ciao"

        def on_property_changed(style, key, value):
            self.assertEquals(key, 'ciao')
            self.assertEquals(value, 'hello')

        style.disconnect(handler_id)
        style.connect('property-changed', on_property_changed)
        style.ciao = "hello"


