# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.utils import defer

class CancelledTransition(Exception):
    pass

class Transition(object):
    def apply(self, controller):
        return defer.succeed(controller)

    def _stop(self, dfr, controller):
        dfr.errback(CancelledTransition())
        controller.widget_animated.update_animation_settings(end_callback=None)
        controller.widget_animated.stop_animations()

class FadeIn(Transition):
    def apply(self, controller):
        def cancel(dfr):
            self._stop(dfr, controller)
        dfr = defer.Deferred(canceller=cancel)

        if not controller.widget.visible:
            controller.widget.opacity = 0
            controller.widget.visible = True

        def end_animation(timer):
            if not dfr.called:
                dfr.callback(controller)

        controller.widget_animated.update_animation_settings(duration=600,
                                                    end_callback=end_animation)

        if controller.widget_animated.opacity == 255:
            end_animation(None)
        else:
            controller.widget_animated.opacity = 255

        return dfr

class FadeOut(Transition):
    def apply(self, controller):
        def cancel(dfr):
            self._stop(dfr, controller)
        dfr = defer.Deferred(canceller=cancel)

        def end_animation(timer):
            if not dfr.called:
                dfr.callback(controller)

        controller.widget_animated.update_animation_settings(duration=400,
                                                    end_callback=end_animation)
        controller.widget_animated.opacity = 0

        return dfr

class SlideLeftIn(Transition):
    def apply(self, controller):
        def cancel(dfr):
            self._stop(dfr, controller)
        dfr = defer.Deferred(canceller=cancel)

        if not controller.widget.visible:
            controller.widget.opacity = 255
            controller.widget.x = -controller.widget.width
            controller.widget.visible = True

        if controller.widget.x == 0.0:
            dfr.callback(controller)
        else:
            controller.widget_animated.update_animation_settings(duration=400,
                                end_callback=lambda x: dfr.callback(controller))
            controller.widget_animated.x = 0.0

        return dfr

class SlideRightIn(Transition):
    def apply(self, controller):
        def cancel(dfr):
            self._stop(dfr, controller)
        dfr = defer.Deferred(canceller=cancel)

        if not controller.widget.visible:
            controller.widget.opacity = 255
            controller.widget.x = 1.0
            controller.widget.visible = True

        if controller.widget.x == 0.0:
            dfr.callback(controller)
        else:
            controller.widget_animated.update_animation_settings(duration=400,
                                end_callback=lambda x: dfr.callback(controller))
            controller.widget_animated.x = 0.0

        return dfr

class SlideLeftOut(Transition):
    def apply(self, controller):
        def cancel(dfr):
            self._stop(dfr, controller)
        dfr = defer.Deferred(canceller=cancel)

        controller.widget_animated.update_animation_settings(duration=400,
                                end_callback=lambda x: dfr.callback(controller))
        controller.widget_animated.x = -controller.widget.width

        return dfr

class SlideRightOut(Transition):
    def apply(self, controller):
        def cancel(dfr):
            self._stop(dfr, controller)
        dfr = defer.Deferred(canceller=cancel)

        controller.widget_animated.update_animation_settings(duration=400,
                                end_callback=lambda x: dfr.callback(controller))
        controller.widget_animated.x = 1.0

        return dfr


class SoftFadeFrontIn(Transition):
    def apply(self, controller):
        def cancel(dfr):
            self._stop(dfr, controller)
        dfr = defer.Deferred(canceller=cancel)

        if not controller.widget.visible:
            controller.widget.opacity = 0
            controller.widget.z = 100.0
            controller.widget.visible = True

        if controller.widget.z == 0.0:
            dfr.callback(controller)
        else:
            controller.widget_animated.update_animation_settings(duration=350,
                                end_callback=lambda x: dfr.callback(controller))
            controller.widget_animated.z = 0.0
            controller.widget_animated.update_animation_settings(attribute='opacity',
                                                                 end_callback=None)
            controller.widget_animated.opacity = 255

        return dfr

class SoftFadeBackIn(Transition):
    def apply(self, controller):
        def cancel(dfr):
            self._stop(dfr, controller)
        dfr = defer.Deferred(canceller=cancel)

        if not controller.widget.visible:
            controller.widget.opacity = 0
            controller.widget.z = -100.0
            controller.widget.visible = True

        if controller.widget.z == 0.0:
            dfr.callback(controller)
        else:
            controller.widget_animated.update_animation_settings(duration=350,
                                end_callback=lambda x: dfr.callback(controller))
            controller.widget_animated.z = 0.0
            controller.widget_animated.update_animation_settings(attribute='opacity',
                                                                 end_callback=None)
            controller.widget_animated.opacity = 255

        return dfr

class SoftFadeFrontOut(Transition):
    def apply(self, controller):
        def cancel(dfr):
            self._stop(dfr, controller)
        dfr = defer.Deferred(canceller=cancel)

        controller.widget_animated.update_animation_settings(duration=250,
                                end_callback=lambda x: dfr.callback(controller))
        controller.widget_animated.z = 100.0
        controller.widget_animated.update_animation_settings(attribute='opacity',
                                                             end_callback=None)
        controller.widget_animated.opacity = 0

        return dfr

class SoftFadeBackOut(Transition):
    def apply(self, controller):
        def cancel(dfr):
            self._stop(dfr, controller)
        dfr = defer.Deferred(canceller=cancel)

        controller.widget_animated.update_animation_settings(duration=250,
                                end_callback=lambda x: dfr.callback(controller))
        controller.widget_animated.z = -100.0
        controller.widget_animated.update_animation_settings(attribute='opacity',
                                                             end_callback=None)
        controller.widget_animated.opacity = 0

        return dfr
